package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 修改快递
 */
@ApiModel(description = "修改快递")

@JsonInclude(NON_NULL)
public class GetLogisticsInfoRequest extends BaseRequest {
  @JsonProperty("expressCode")
  private String expressCode = null;

  @JsonProperty("waybillNo")
  private String waybillNo = null;

  @JsonIgnore
  public GetLogisticsInfoRequest expressCode(String expressCode) {
    this.expressCode = expressCode;
    return this;
  }

   /**
   * 快递公司代码
   * @return expressCode
  **/
  @ApiModelProperty(value = "快递公司代码")
  public String getExpressCode() {
    return expressCode;
  }

  public void setExpressCode(String expressCode) {
    this.expressCode = expressCode;
  }

  @JsonIgnore
  public GetLogisticsInfoRequest waybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
    return this;
  }

   /**
   * 运单号
   * @return waybillNo
  **/
  @ApiModelProperty(value = "运单号")
  public String getWaybillNo() {
    return waybillNo;
  }

  public void setWaybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLogisticsInfoRequest getLogisticsInfoRequest = (GetLogisticsInfoRequest) o;
    return Objects.equals(this.expressCode, getLogisticsInfoRequest.expressCode) &&
        Objects.equals(this.waybillNo, getLogisticsInfoRequest.waybillNo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expressCode, waybillNo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLogisticsInfoRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    expressCode: ").append(toIndentedString(expressCode)).append("\n");
    sb.append("    waybillNo: ").append(toIndentedString(waybillNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
