package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取业务单明细Request
 */
@ApiModel(description = "获取业务单明细Request")

@JsonInclude(NON_NULL)
public class GetOrdersDetailRequest extends BaseRequest {
  @JsonProperty("hasInvoice")
  private Boolean hasInvoice = null;

  @JsonProperty("hasInvoiceDetail")
  private Boolean hasInvoiceDetail = null;

  @JsonIgnore
  public GetOrdersDetailRequest hasInvoice(Boolean hasInvoice) {
    this.hasInvoice = hasInvoice;
    return this;
  }

   /**
   * 是否包含发票
   * @return hasInvoice
  **/
  @ApiModelProperty(value = "是否包含发票")
  public Boolean getHasInvoice() {
    return hasInvoice;
  }

  public void setHasInvoice(Boolean hasInvoice) {
    this.hasInvoice = hasInvoice;
  }

  @JsonIgnore
  public GetOrdersDetailRequest hasInvoiceDetail(Boolean hasInvoiceDetail) {
    this.hasInvoiceDetail = hasInvoiceDetail;
    return this;
  }

   /**
   * 是否包含发票明细
   * @return hasInvoiceDetail
  **/
  @ApiModelProperty(value = "是否包含发票明细")
  public Boolean getHasInvoiceDetail() {
    return hasInvoiceDetail;
  }

  public void setHasInvoiceDetail(Boolean hasInvoiceDetail) {
    this.hasInvoiceDetail = hasInvoiceDetail;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetOrdersDetailRequest getOrdersDetailRequest = (GetOrdersDetailRequest) o;
    return Objects.equals(this.hasInvoice, getOrdersDetailRequest.hasInvoice) &&
        Objects.equals(this.hasInvoiceDetail, getOrdersDetailRequest.hasInvoiceDetail) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hasInvoice, hasInvoiceDetail, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetOrdersDetailRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    hasInvoice: ").append(toIndentedString(hasInvoice)).append("\n");
    sb.append("    hasInvoiceDetail: ").append(toIndentedString(hasInvoiceDetail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
