package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 月末核对Request
 */
@ApiModel(description = "月末核对Request")

@JsonInclude(NON_NULL)
public class GetOrdersEndcheckListRequest extends PageRequest {
  @JsonProperty("systemOrig")
  private List<String> systemOrig = new ArrayList<String>();

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("authUpdateTime")
  private List<Long> authUpdateTime = new ArrayList<Long>();

  @JsonProperty("authCheckTime")
  private List<Long> authCheckTime = new ArrayList<Long>();

  @JsonProperty("createTime")
  private List<Long> createTime = new ArrayList<Long>();

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("compareStatus")
  private Integer compareStatus = null;

  @JsonIgnore
  public GetOrdersEndcheckListRequest systemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

  public GetOrdersEndcheckListRequest addSystemOrigItem(String systemOrigItem) {
    this.systemOrig.add(systemOrigItem);
    return this;
  }

   /**
   * 系统来源(所属业务系统)
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源(所属业务系统)")
  public List<String> getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public GetOrdersEndcheckListRequest cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 购销协同标识： 1-协同； 0-非协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "购销协同标识： 1-协同； 0-非协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public GetOrdersEndcheckListRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public GetOrdersEndcheckListRequest authUpdateTime(List<Long> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
    return this;
  }

  public GetOrdersEndcheckListRequest addAuthUpdateTimeItem(Long authUpdateTimeItem) {
    this.authUpdateTime.add(authUpdateTimeItem);
    return this;
  }

   /**
   * 抵扣时间
   * @return authUpdateTime
  **/
  @ApiModelProperty(value = "抵扣时间")
  public List<Long> getAuthUpdateTime() {
    return authUpdateTime;
  }

  public void setAuthUpdateTime(List<Long> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
  }

  @JsonIgnore
  public GetOrdersEndcheckListRequest authCheckTime(List<Long> authCheckTime) {
    this.authCheckTime = authCheckTime;
    return this;
  }

  public GetOrdersEndcheckListRequest addAuthCheckTimeItem(Long authCheckTimeItem) {
    this.authCheckTime.add(authCheckTimeItem);
    return this;
  }

   /**
   * 勾选时间
   * @return authCheckTime
  **/
  @ApiModelProperty(value = "勾选时间")
  public List<Long> getAuthCheckTime() {
    return authCheckTime;
  }

  public void setAuthCheckTime(List<Long> authCheckTime) {
    this.authCheckTime = authCheckTime;
  }

  @JsonIgnore
  public GetOrdersEndcheckListRequest createTime(List<Long> createTime) {
    this.createTime = createTime;
    return this;
  }

  public GetOrdersEndcheckListRequest addCreateTimeItem(Long createTimeItem) {
    this.createTime.add(createTimeItem);
    return this;
  }

   /**
   * 同步时间
   * @return createTime
  **/
  @ApiModelProperty(value = "同步时间")
  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public GetOrdersEndcheckListRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public GetOrdersEndcheckListRequest compareStatus(Integer compareStatus) {
    this.compareStatus = compareStatus;
    return this;
  }

   /**
   * 比对状态：0-异常，1-一致
   * @return compareStatus
  **/
  @ApiModelProperty(value = "比对状态：0-异常，1-一致")
  public Integer getCompareStatus() {
    return compareStatus;
  }

  public void setCompareStatus(Integer compareStatus) {
    this.compareStatus = compareStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetOrdersEndcheckListRequest getOrdersEndcheckListRequest = (GetOrdersEndcheckListRequest) o;
    return Objects.equals(this.systemOrig, getOrdersEndcheckListRequest.systemOrig) &&
        Objects.equals(this.cooperateFlag, getOrdersEndcheckListRequest.cooperateFlag) &&
        Objects.equals(this.purchaserName, getOrdersEndcheckListRequest.purchaserName) &&
        Objects.equals(this.authUpdateTime, getOrdersEndcheckListRequest.authUpdateTime) &&
        Objects.equals(this.authCheckTime, getOrdersEndcheckListRequest.authCheckTime) &&
        Objects.equals(this.createTime, getOrdersEndcheckListRequest.createTime) &&
        Objects.equals(this.salesbillNo, getOrdersEndcheckListRequest.salesbillNo) &&
        Objects.equals(this.compareStatus, getOrdersEndcheckListRequest.compareStatus) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(systemOrig, cooperateFlag, purchaserName, authUpdateTime, authCheckTime, createTime, salesbillNo, compareStatus, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetOrdersEndcheckListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    authUpdateTime: ").append(toIndentedString(authUpdateTime)).append("\n");
    sb.append("    authCheckTime: ").append(toIndentedString(authCheckTime)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    compareStatus: ").append(toIndentedString(compareStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
