package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单据表Request
 */
@ApiModel(description = "业务单据表Request")

@JsonInclude(NON_NULL)
public class GetOrdersListRequest extends PageRequest {
  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("agreementCode")
  private String agreementCode = null;

  @JsonProperty("syncTime")
  private List<Long> syncTime = new ArrayList<Long>();

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("smSyncTime")
  private List<Long> smSyncTime = new ArrayList<Long>();

  @JsonProperty("auditUpdateTime")
  private List<Long> auditUpdateTime = new ArrayList<Long>();

  @JsonProperty("authUpdateTime")
  private List<Long> authUpdateTime = new ArrayList<Long>();

  @JsonProperty("ifAuthFlag")
  private Integer ifAuthFlag = null;

  @JsonProperty("auditStatus")
  private List<Integer> auditStatus = new ArrayList<Integer>();

  @JsonProperty("authStatus")
  private List<Integer> authStatus = new ArrayList<Integer>();

  @JsonProperty("systemOrig")
  private List<String> systemOrig = new ArrayList<String>();

  @JsonProperty("status")
  private List<String> status = new ArrayList<String>();

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonProperty("isLegalSynergetics")
  private Integer isLegalSynergetics = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("hasInvoice")
  private Boolean hasInvoice = null;

  @JsonProperty("hasInvoiceDetail")
  private Boolean hasInvoiceDetail = null;

  @JsonProperty("signStatus")
  private List<Integer> signStatus = new ArrayList<Integer>();

  @JsonProperty("signTime")
  private List<Long> signTime = new ArrayList<Long>();

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("errorType")
  private List<Integer> errorType = new ArrayList<Integer>();

  @JsonProperty("createTime")
  private List<Long> createTime = new ArrayList<Long>();

  @JsonProperty("autoCheckStatus")
  private List<Integer> autoCheckStatus = new ArrayList<Integer>();

  @JsonProperty("signPerson")
  private List<String> signPerson = new ArrayList<String>();

  @JsonIgnore
  public GetOrdersListRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public GetOrdersListRequest agreementCode(String agreementCode) {
    this.agreementCode = agreementCode;
    return this;
  }

   /**
   * 合同号
   * @return agreementCode
  **/
  @ApiModelProperty(value = "合同号")
  public String getAgreementCode() {
    return agreementCode;
  }

  public void setAgreementCode(String agreementCode) {
    this.agreementCode = agreementCode;
  }

  @JsonIgnore
  public GetOrdersListRequest syncTime(List<Long> syncTime) {
    this.syncTime = syncTime;
    return this;
  }

  public GetOrdersListRequest addSyncTimeItem(Long syncTimeItem) {
    this.syncTime.add(syncTimeItem);
    return this;
  }

   /**
   * 同步时间
   * @return syncTime
  **/
  @ApiModelProperty(value = "同步时间")
  public List<Long> getSyncTime() {
    return syncTime;
  }

  public void setSyncTime(List<Long> syncTime) {
    this.syncTime = syncTime;
  }

  @JsonIgnore
  public GetOrdersListRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public GetOrdersListRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public GetOrdersListRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public GetOrdersListRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public GetOrdersListRequest smSyncTime(List<Long> smSyncTime) {
    this.smSyncTime = smSyncTime;
    return this;
  }

  public GetOrdersListRequest addSmSyncTimeItem(Long smSyncTimeItem) {
    this.smSyncTime.add(smSyncTimeItem);
    return this;
  }

   /**
   * 影像上传识别完成时间
   * @return smSyncTime
  **/
  @ApiModelProperty(value = "影像上传识别完成时间")
  public List<Long> getSmSyncTime() {
    return smSyncTime;
  }

  public void setSmSyncTime(List<Long> smSyncTime) {
    this.smSyncTime = smSyncTime;
  }

  @JsonIgnore
  public GetOrdersListRequest auditUpdateTime(List<Long> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
    return this;
  }

  public GetOrdersListRequest addAuditUpdateTimeItem(Long auditUpdateTimeItem) {
    this.auditUpdateTime.add(auditUpdateTimeItem);
    return this;
  }

   /**
   * 审核时间
   * @return auditUpdateTime
  **/
  @ApiModelProperty(value = "审核时间")
  public List<Long> getAuditUpdateTime() {
    return auditUpdateTime;
  }

  public void setAuditUpdateTime(List<Long> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
  }

  @JsonIgnore
  public GetOrdersListRequest authUpdateTime(List<Long> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
    return this;
  }

  public GetOrdersListRequest addAuthUpdateTimeItem(Long authUpdateTimeItem) {
    this.authUpdateTime.add(authUpdateTimeItem);
    return this;
  }

   /**
   * 认证时间
   * @return authUpdateTime
  **/
  @ApiModelProperty(value = "认证时间")
  public List<Long> getAuthUpdateTime() {
    return authUpdateTime;
  }

  public void setAuthUpdateTime(List<Long> authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
  }

  @JsonIgnore
  public GetOrdersListRequest ifAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

   /**
   * 是否需要认证状态 1：是  0：否
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否需要认证状态 1：是  0：否")
  public Integer getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }

  @JsonIgnore
  public GetOrdersListRequest auditStatus(List<Integer> auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

  public GetOrdersListRequest addAuditStatusItem(Integer auditStatusItem) {
    this.auditStatus.add(auditStatusItem);
    return this;
  }

   /**
   * 业务单审核状态 0：未审核  1：审核成功 2：审核不通过 审核状态（0. 待审核 1.审核成功 -1.审核失败）
   * @return auditStatus
  **/
  @ApiModelProperty(value = "业务单审核状态 0：未审核  1：审核成功 2：审核不通过 审核状态（0. 待审核 1.审核成功 -1.审核失败）")
  public List<Integer> getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(List<Integer> auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public GetOrdersListRequest authStatus(List<Integer> authStatus) {
    this.authStatus = authStatus;
    return this;
  }

  public GetOrdersListRequest addAuthStatusItem(Integer authStatusItem) {
    this.authStatus.add(authStatusItem);
    return this;
  }

   /**
   * 业务单认证状态 0：未认证  1：认证成功 2：部分认证
   * @return authStatus
  **/
  @ApiModelProperty(value = "业务单认证状态 0：未认证  1：认证成功 2：部分认证")
  public List<Integer> getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(List<Integer> authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public GetOrdersListRequest systemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

  public GetOrdersListRequest addSystemOrigItem(String systemOrigItem) {
    this.systemOrig.add(systemOrigItem);
    return this;
  }

   /**
   * 系统来源(所属业务系统)
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源(所属业务系统)")
  public List<String> getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public GetOrdersListRequest status(List<String> status) {
    this.status = status;
    return this;
  }

  public GetOrdersListRequest addStatusItem(String statusItem) {
    this.status.add(statusItem);
    return this;
  }

   /**
   * C-作废；D-删除；W-撤回
   * @return status
  **/
  @ApiModelProperty(value = "C-作废；D-删除；W-撤回")
  public List<String> getStatus() {
    return status;
  }

  public void setStatus(List<String> status) {
    this.status = status;
  }

  @JsonIgnore
  public GetOrdersListRequest cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 购销协同标识： 1-协同； 0-非协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "购销协同标识： 1-协同； 0-非协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public GetOrdersListRequest isLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
    return this;
  }

   /**
   * 法人协同标识： 1-协同； 0-非协同
   * @return isLegalSynergetics
  **/
  @ApiModelProperty(value = "法人协同标识： 1-协同； 0-非协同")
  public Integer getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }

  @JsonIgnore
  public GetOrdersListRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public GetOrdersListRequest hasInvoice(Boolean hasInvoice) {
    this.hasInvoice = hasInvoice;
    return this;
  }

   /**
   * 是否包含发票
   * @return hasInvoice
  **/
  @ApiModelProperty(value = "是否包含发票")
  public Boolean getHasInvoice() {
    return hasInvoice;
  }

  public void setHasInvoice(Boolean hasInvoice) {
    this.hasInvoice = hasInvoice;
  }

  @JsonIgnore
  public GetOrdersListRequest hasInvoiceDetail(Boolean hasInvoiceDetail) {
    this.hasInvoiceDetail = hasInvoiceDetail;
    return this;
  }

   /**
   * 是否包含发票明细
   * @return hasInvoiceDetail
  **/
  @ApiModelProperty(value = "是否包含发票明细")
  public Boolean getHasInvoiceDetail() {
    return hasInvoiceDetail;
  }

  public void setHasInvoiceDetail(Boolean hasInvoiceDetail) {
    this.hasInvoiceDetail = hasInvoiceDetail;
  }

  @JsonIgnore
  public GetOrdersListRequest signStatus(List<Integer> signStatus) {
    this.signStatus = signStatus;
    return this;
  }

  public GetOrdersListRequest addSignStatusItem(Integer signStatusItem) {
    this.signStatus.add(signStatusItem);
    return this;
  }

   /**
   * 签收状态 ：0-默认 10-成功 20-失败
   * @return signStatus
  **/
  @ApiModelProperty(value = "签收状态 ：0-默认 10-成功 20-失败")
  public List<Integer> getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(List<Integer> signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public GetOrdersListRequest signTime(List<Long> signTime) {
    this.signTime = signTime;
    return this;
  }

  public GetOrdersListRequest addSignTimeItem(Long signTimeItem) {
    this.signTime.add(signTimeItem);
    return this;
  }

   /**
   * 签收时间
   * @return signTime
  **/
  @ApiModelProperty(value = "签收时间")
  public List<Long> getSignTime() {
    return signTime;
  }

  public void setSignTime(List<Long> signTime) {
    this.signTime = signTime;
  }

  @JsonIgnore
  public GetOrdersListRequest packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public GetOrdersListRequest errorType(List<Integer> errorType) {
    this.errorType = errorType;
    return this;
  }

  public GetOrdersListRequest addErrorTypeItem(Integer errorTypeItem) {
    this.errorType.add(errorTypeItem);
    return this;
  }

   /**
   * 签收状态 ：异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无结算单，5-其他
   * @return errorType
  **/
  @ApiModelProperty(value = "签收状态 ：异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无结算单，5-其他")
  public List<Integer> getErrorType() {
    return errorType;
  }

  public void setErrorType(List<Integer> errorType) {
    this.errorType = errorType;
  }

  @JsonIgnore
  public GetOrdersListRequest createTime(List<Long> createTime) {
    this.createTime = createTime;
    return this;
  }

  public GetOrdersListRequest addCreateTimeItem(Long createTimeItem) {
    this.createTime.add(createTimeItem);
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public GetOrdersListRequest autoCheckStatus(List<Integer> autoCheckStatus) {
    this.autoCheckStatus = autoCheckStatus;
    return this;
  }

  public GetOrdersListRequest addAutoCheckStatusItem(Integer autoCheckStatusItem) {
    this.autoCheckStatus.add(autoCheckStatusItem);
    return this;
  }

   /**
   * 自校验状态
   * @return autoCheckStatus
  **/
  @ApiModelProperty(value = "自校验状态")
  public List<Integer> getAutoCheckStatus() {
    return autoCheckStatus;
  }

  public void setAutoCheckStatus(List<Integer> autoCheckStatus) {
    this.autoCheckStatus = autoCheckStatus;
  }

  @JsonIgnore
  public GetOrdersListRequest signPerson(List<String> signPerson) {
    this.signPerson = signPerson;
    return this;
  }

  public GetOrdersListRequest addSignPersonItem(String signPersonItem) {
    this.signPerson.add(signPersonItem);
    return this;
  }

   /**
   * 签收人
   * @return signPerson
  **/
  @ApiModelProperty(value = "签收人")
  public List<String> getSignPerson() {
    return signPerson;
  }

  public void setSignPerson(List<String> signPerson) {
    this.signPerson = signPerson;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetOrdersListRequest getOrdersListRequest = (GetOrdersListRequest) o;
    return Objects.equals(this.salesbillNo, getOrdersListRequest.salesbillNo) &&
        Objects.equals(this.agreementCode, getOrdersListRequest.agreementCode) &&
        Objects.equals(this.syncTime, getOrdersListRequest.syncTime) &&
        Objects.equals(this.sellerName, getOrdersListRequest.sellerName) &&
        Objects.equals(this.purchaserName, getOrdersListRequest.purchaserName) &&
        Objects.equals(this.sellerTaxNo, getOrdersListRequest.sellerTaxNo) &&
        Objects.equals(this.purchaserTaxNo, getOrdersListRequest.purchaserTaxNo) &&
        Objects.equals(this.smSyncTime, getOrdersListRequest.smSyncTime) &&
        Objects.equals(this.auditUpdateTime, getOrdersListRequest.auditUpdateTime) &&
        Objects.equals(this.authUpdateTime, getOrdersListRequest.authUpdateTime) &&
        Objects.equals(this.ifAuthFlag, getOrdersListRequest.ifAuthFlag) &&
        Objects.equals(this.auditStatus, getOrdersListRequest.auditStatus) &&
        Objects.equals(this.authStatus, getOrdersListRequest.authStatus) &&
        Objects.equals(this.systemOrig, getOrdersListRequest.systemOrig) &&
        Objects.equals(this.status, getOrdersListRequest.status) &&
        Objects.equals(this.cooperateFlag, getOrdersListRequest.cooperateFlag) &&
        Objects.equals(this.isLegalSynergetics, getOrdersListRequest.isLegalSynergetics) &&
        Objects.equals(this.invoiceNo, getOrdersListRequest.invoiceNo) &&
        Objects.equals(this.hasInvoice, getOrdersListRequest.hasInvoice) &&
        Objects.equals(this.hasInvoiceDetail, getOrdersListRequest.hasInvoiceDetail) &&
        Objects.equals(this.signStatus, getOrdersListRequest.signStatus) &&
        Objects.equals(this.signTime, getOrdersListRequest.signTime) &&
        Objects.equals(this.packageCode, getOrdersListRequest.packageCode) &&
        Objects.equals(this.errorType, getOrdersListRequest.errorType) &&
        Objects.equals(this.createTime, getOrdersListRequest.createTime) &&
        Objects.equals(this.autoCheckStatus, getOrdersListRequest.autoCheckStatus) &&
        Objects.equals(this.signPerson, getOrdersListRequest.signPerson) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillNo, agreementCode, syncTime, sellerName, purchaserName, sellerTaxNo, purchaserTaxNo, smSyncTime, auditUpdateTime, authUpdateTime, ifAuthFlag, auditStatus, authStatus, systemOrig, status, cooperateFlag, isLegalSynergetics, invoiceNo, hasInvoice, hasInvoiceDetail, signStatus, signTime, packageCode, errorType, createTime, autoCheckStatus, signPerson, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetOrdersListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    agreementCode: ").append(toIndentedString(agreementCode)).append("\n");
    sb.append("    syncTime: ").append(toIndentedString(syncTime)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    smSyncTime: ").append(toIndentedString(smSyncTime)).append("\n");
    sb.append("    auditUpdateTime: ").append(toIndentedString(auditUpdateTime)).append("\n");
    sb.append("    authUpdateTime: ").append(toIndentedString(authUpdateTime)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    isLegalSynergetics: ").append(toIndentedString(isLegalSynergetics)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    hasInvoice: ").append(toIndentedString(hasInvoice)).append("\n");
    sb.append("    hasInvoiceDetail: ").append(toIndentedString(hasInvoiceDetail)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    autoCheckStatus: ").append(toIndentedString(autoCheckStatus)).append("\n");
    sb.append("    signPerson: ").append(toIndentedString(signPerson)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
