package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 寄送中，异常，签收Request
 */
@ApiModel(description = "寄送中，异常，签收Request")

@JsonInclude(NON_NULL)
public class GetParcelListRequest extends PageRequest {
  @JsonProperty("waybillNo")
  private String waybillNo = null;

  @JsonProperty("senderName")
  private String senderName = null;

  @JsonProperty("senderTel")
  private String senderTel = null;

  @JsonProperty("receiverName")
  private String receiverName = null;

  @JsonProperty("receiverTel")
  private String receiverTel = null;

  @JsonProperty("createTime")
  private List<Long> createTime = new ArrayList<Long>();

  @JsonProperty("businessLgtStatus")
  private Integer businessLgtStatus = null;

  @JsonProperty("senderRole")
  private Integer senderRole = null;

  @JsonProperty("orderNum")
  private Integer orderNum = null;

  @JsonIgnore
  public GetParcelListRequest waybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
    return this;
  }

   /**
   * 运单号
   * @return waybillNo
  **/
  @ApiModelProperty(value = "运单号")
  public String getWaybillNo() {
    return waybillNo;
  }

  public void setWaybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
  }

  @JsonIgnore
  public GetParcelListRequest senderName(String senderName) {
    this.senderName = senderName;
    return this;
  }

   /**
   * 寄件方
   * @return senderName
  **/
  @ApiModelProperty(value = "寄件方")
  public String getSenderName() {
    return senderName;
  }

  public void setSenderName(String senderName) {
    this.senderName = senderName;
  }

  @JsonIgnore
  public GetParcelListRequest senderTel(String senderTel) {
    this.senderTel = senderTel;
    return this;
  }

   /**
   * 寄件方电话
   * @return senderTel
  **/
  @ApiModelProperty(value = "寄件方电话")
  public String getSenderTel() {
    return senderTel;
  }

  public void setSenderTel(String senderTel) {
    this.senderTel = senderTel;
  }

  @JsonIgnore
  public GetParcelListRequest receiverName(String receiverName) {
    this.receiverName = receiverName;
    return this;
  }

   /**
   * 收件方
   * @return receiverName
  **/
  @ApiModelProperty(value = "收件方")
  public String getReceiverName() {
    return receiverName;
  }

  public void setReceiverName(String receiverName) {
    this.receiverName = receiverName;
  }

  @JsonIgnore
  public GetParcelListRequest receiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
    return this;
  }

   /**
   * 收件方电话
   * @return receiverTel
  **/
  @ApiModelProperty(value = "收件方电话")
  public String getReceiverTel() {
    return receiverTel;
  }

  public void setReceiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
  }

  @JsonIgnore
  public GetParcelListRequest createTime(List<Long> createTime) {
    this.createTime = createTime;
    return this;
  }

  public GetParcelListRequest addCreateTimeItem(Long createTimeItem) {
    this.createTime.add(createTimeItem);
    return this;
  }

   /**
   * 发件时间(秒)
   * @return createTime
  **/
  @ApiModelProperty(value = "发件时间(秒)")
  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public GetParcelListRequest businessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
    return this;
  }

   /**
   * 包裹状态(3-寄送中，4-异常，5-已签收)
   * @return businessLgtStatus
  **/
  @ApiModelProperty(value = "包裹状态(3-寄送中，4-异常，5-已签收)")
  public Integer getBusinessLgtStatus() {
    return businessLgtStatus;
  }

  public void setBusinessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
  }

  @JsonIgnore
  public GetParcelListRequest senderRole(Integer senderRole) {
    this.senderRole = senderRole;
    return this;
  }

   /**
   * 寄件角色 1-寄件方，2-收件方
   * @return senderRole
  **/
  @ApiModelProperty(value = "寄件角色 1-寄件方，2-收件方")
  public Integer getSenderRole() {
    return senderRole;
  }

  public void setSenderRole(Integer senderRole) {
    this.senderRole = senderRole;
  }

  @JsonIgnore
  public GetParcelListRequest orderNum(Integer orderNum) {
    this.orderNum = orderNum;
    return this;
  }

   /**
   * 排序 0-下单时间升序，1-下单时间降序
   * @return orderNum
  **/
  @ApiModelProperty(value = "排序 0-下单时间升序，1-下单时间降序")
  public Integer getOrderNum() {
    return orderNum;
  }

  public void setOrderNum(Integer orderNum) {
    this.orderNum = orderNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetParcelListRequest getParcelListRequest = (GetParcelListRequest) o;
    return Objects.equals(this.waybillNo, getParcelListRequest.waybillNo) &&
        Objects.equals(this.senderName, getParcelListRequest.senderName) &&
        Objects.equals(this.senderTel, getParcelListRequest.senderTel) &&
        Objects.equals(this.receiverName, getParcelListRequest.receiverName) &&
        Objects.equals(this.receiverTel, getParcelListRequest.receiverTel) &&
        Objects.equals(this.createTime, getParcelListRequest.createTime) &&
        Objects.equals(this.businessLgtStatus, getParcelListRequest.businessLgtStatus) &&
        Objects.equals(this.senderRole, getParcelListRequest.senderRole) &&
        Objects.equals(this.orderNum, getParcelListRequest.orderNum) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(waybillNo, senderName, senderTel, receiverName, receiverTel, createTime, businessLgtStatus, senderRole, orderNum, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetParcelListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    waybillNo: ").append(toIndentedString(waybillNo)).append("\n");
    sb.append("    senderName: ").append(toIndentedString(senderName)).append("\n");
    sb.append("    senderTel: ").append(toIndentedString(senderTel)).append("\n");
    sb.append("    receiverName: ").append(toIndentedString(receiverName)).append("\n");
    sb.append("    receiverTel: ").append(toIndentedString(receiverTel)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    businessLgtStatus: ").append(toIndentedString(businessLgtStatus)).append("\n");
    sb.append("    senderRole: ").append(toIndentedString(senderRole)).append("\n");
    sb.append("    orderNum: ").append(toIndentedString(orderNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
