package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 影像文件表Request
 */
@ApiModel(description = "影像文件表Request")

@JsonInclude(NON_NULL)
public class GetSmFileListRequest extends PageRequest {
  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("isException")
  private Boolean isException = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonIgnore
  public GetSmFileListRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public GetSmFileListRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型：1-增值税专票发票联,2-增值税专票抵扣联,3-增值税普票发票联,9-增值税商品明细
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型：1-增值税专票发票联,2-增值税专票抵扣联,3-增值税普票发票联,9-增值税商品明细")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public GetSmFileListRequest isException(Boolean isException) {
    this.isException = isException;
    return this;
  }

   /**
   * 是否异常
   * @return isException
  **/
  @ApiModelProperty(value = "是否异常")
  public Boolean getIsException() {
    return isException;
  }

  public void setIsException(Boolean isException) {
    this.isException = isException;
  }

  @JsonIgnore
  public GetSmFileListRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 操作人ID
   * @return userId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public GetSmFileListRequest orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单据编码
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单据编码")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetSmFileListRequest getSmFileListRequest = (GetSmFileListRequest) o;
    return Objects.equals(this.invoiceNo, getSmFileListRequest.invoiceNo) &&
        Objects.equals(this.invoiceType, getSmFileListRequest.invoiceType) &&
        Objects.equals(this.isException, getSmFileListRequest.isException) &&
        Objects.equals(this.userId, getSmFileListRequest.userId) &&
        Objects.equals(this.orderCode, getSmFileListRequest.orderCode) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceNo, invoiceType, isException, userId, orderCode, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetSmFileListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    isException: ").append(toIndentedString(isException)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
