package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 员工绩效请求
 */
@ApiModel(description = "员工绩效请求")

@JsonInclude(NON_NULL)
public class GetUserPerfRequest extends PageRequest {
  @JsonProperty("userName")
  private List<String> userName = new ArrayList<String>();

  @JsonProperty("roleType")
  private List<Integer> roleType = new ArrayList<Integer>();

  @JsonProperty("workTime")
  private List<Long> workTime = new ArrayList<Long>();

  @JsonProperty("subDay")
  private Integer subDay = null;

  @JsonProperty("workStartTime")
  private String workStartTime = null;

  @JsonProperty("workEndTime")
  private String workEndTime = null;

  @JsonIgnore
  public GetUserPerfRequest userName(List<String> userName) {
    this.userName = userName;
    return this;
  }

  public GetUserPerfRequest addUserNameItem(String userNameItem) {
    this.userName.add(userNameItem);
    return this;
  }

   /**
   * userName
   * @return userName
  **/
  @ApiModelProperty(value = "userName")
  public List<String> getUserName() {
    return userName;
  }

  public void setUserName(List<String> userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public GetUserPerfRequest roleType(List<Integer> roleType) {
    this.roleType = roleType;
    return this;
  }

  public GetUserPerfRequest addRoleTypeItem(Integer roleTypeItem) {
    this.roleType.add(roleTypeItem);
    return this;
  }

   /**
   * 类型
   * @return roleType
  **/
  @ApiModelProperty(value = "类型")
  public List<Integer> getRoleType() {
    return roleType;
  }

  public void setRoleType(List<Integer> roleType) {
    this.roleType = roleType;
  }

  @JsonIgnore
  public GetUserPerfRequest workTime(List<Long> workTime) {
    this.workTime = workTime;
    return this;
  }

  public GetUserPerfRequest addWorkTimeItem(Long workTimeItem) {
    this.workTime.add(workTimeItem);
    return this;
  }

   /**
   * 工作时间
   * @return workTime
  **/
  @ApiModelProperty(value = "工作时间")
  public List<Long> getWorkTime() {
    return workTime;
  }

  public void setWorkTime(List<Long> workTime) {
    this.workTime = workTime;
  }

  @JsonIgnore
  public GetUserPerfRequest subDay(Integer subDay) {
    this.subDay = subDay;
    return this;
  }

   /**
   * 时间差
   * @return subDay
  **/
  @ApiModelProperty(value = "时间差")
  public Integer getSubDay() {
    return subDay;
  }

  public void setSubDay(Integer subDay) {
    this.subDay = subDay;
  }

  @JsonIgnore
  public GetUserPerfRequest workStartTime(String workStartTime) {
    this.workStartTime = workStartTime;
    return this;
  }

   /**
   * 工作开始时间
   * @return workStartTime
  **/
  @ApiModelProperty(value = "工作开始时间")
  public String getWorkStartTime() {
    return workStartTime;
  }

  public void setWorkStartTime(String workStartTime) {
    this.workStartTime = workStartTime;
  }

  @JsonIgnore
  public GetUserPerfRequest workEndTime(String workEndTime) {
    this.workEndTime = workEndTime;
    return this;
  }

   /**
   * 工作结束时间
   * @return workEndTime
  **/
  @ApiModelProperty(value = "工作结束时间")
  public String getWorkEndTime() {
    return workEndTime;
  }

  public void setWorkEndTime(String workEndTime) {
    this.workEndTime = workEndTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetUserPerfRequest getUserPerfRequest = (GetUserPerfRequest) o;
    return Objects.equals(this.userName, getUserPerfRequest.userName) &&
        Objects.equals(this.roleType, getUserPerfRequest.roleType) &&
        Objects.equals(this.workTime, getUserPerfRequest.workTime) &&
        Objects.equals(this.subDay, getUserPerfRequest.subDay) &&
        Objects.equals(this.workStartTime, getUserPerfRequest.workStartTime) &&
        Objects.equals(this.workEndTime, getUserPerfRequest.workEndTime) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userName, roleType, workTime, subDay, workStartTime, workEndTime, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetUserPerfRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    roleType: ").append(toIndentedString(roleType)).append("\n");
    sb.append("    workTime: ").append(toIndentedString(workTime)).append("\n");
    sb.append("    subDay: ").append(toIndentedString(subDay)).append("\n");
    sb.append("    workStartTime: ").append(toIndentedString(workStartTime)).append("\n");
    sb.append("    workEndTime: ").append(toIndentedString(workEndTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
