package com.xforceplus.vanke.in.client.model;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Description 发票认证页面金额统计
 * @Date 2019年07月03日 11:10
 * @Author rongying
 * @Version 1.0
 */
public class InvoiceAmountBean implements Serializable {

  @ApiModelProperty("总价税合计")
  private BigDecimal amountWithTax = BigDecimal.ZERO;

  @ApiModelProperty("总金额")
  private BigDecimal amountWithoutTax = BigDecimal.ZERO;

  @ApiModelProperty("总税额")
  private BigDecimal taxAmount = BigDecimal.ZERO;

  @ApiModelProperty("普票总价税合计")
  private BigDecimal invoiceNormalAmountWithTax = BigDecimal.ZERO;

  @ApiModelProperty("专票总价税合计")
  private BigDecimal invoiceSpecialAmountWithTax = BigDecimal.ZERO;

  @ApiModelProperty("专票总税额")
  private BigDecimal invoiceSpecialTaxAmount = BigDecimal.ZERO;

  @ApiModelProperty("业务单号集合")
  private List<String> salesbillList;

  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  public BigDecimal getInvoiceNormalAmountWithTax() {
    return invoiceNormalAmountWithTax;
  }

  public void setInvoiceNormalAmountWithTax(BigDecimal invoiceNormalAmountWithTax) {
    this.invoiceNormalAmountWithTax = invoiceNormalAmountWithTax;
  }

  public BigDecimal getInvoiceSpecialAmountWithTax() {
    return invoiceSpecialAmountWithTax;
  }

  public void setInvoiceSpecialAmountWithTax(BigDecimal invoiceSpecialAmountWithTax) {
    this.invoiceSpecialAmountWithTax = invoiceSpecialAmountWithTax;
  }

  public BigDecimal getInvoiceSpecialTaxAmount() {
    return invoiceSpecialTaxAmount;
  }

  public void setInvoiceSpecialTaxAmount(BigDecimal invoiceSpecialTaxAmount) {
    this.invoiceSpecialTaxAmount = invoiceSpecialTaxAmount;
  }

  public List<String> getSalesbillList() {
    return salesbillList;
  }

  public void setSalesbillList(List<String> salesbillList) {
    this.salesbillList = salesbillList;
  }
}
