package com.xforceplus.vanke.in.client.model;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Description 发票审核返回数据
 * @Date 2019年07月01日 11:46
 * @Author rongying
 * @Version 1.0
 */
public class InvoiceAuditBean implements Serializable {

  @ApiModelProperty("业务单号")
  private String orderCode;

  @ApiModelProperty("普票含税总价税合计")
  private BigDecimal orderNormalAmountWithTax;

  @ApiModelProperty("专票含税总价税合计")
  private BigDecimal orderSpecialAmountWithTax;

  @ApiModelProperty("专票总税额")
  private BigDecimal orderSpecialTaxAmount;

  @ApiModelProperty("购方税号")
  private String purchaserTaxNo;

  @ApiModelProperty("购方名称")
  private String purchaserName;

  @ApiModelProperty("是否法人协同")
  private Integer isLegalSynergetics;

  @ApiModelProperty("发票合计（份数）")
  private Integer invoiceNum;

  @ApiModelProperty("普票总价税合计")
  private BigDecimal invoiceNormalAmountWithTax;

  @ApiModelProperty("专票总价税合计")
  private BigDecimal invoiceSpecialAmountWithTax;

  @ApiModelProperty("专票总税额")
  private BigDecimal invoiceSpecialTaxAmount;

  @ApiModelProperty("协同标识： 1-协同； 0-不协同")
  private Integer cooperateFlag;

  @ApiModelProperty("新增按钮影像地址")
  private String addImageUrl;

  @ApiModelProperty("查看按钮影像地址")
  private String queryImageUrl;

  @ApiModelProperty("审核状态：0-未审核  1-审核成功 2-审核不通过")
  private Integer auditStatus;

  @ApiModelProperty("发票自动校验结果状态：0-待校验 -10-异常，10-正常")
  private Integer autoCheckStatus;

  @ApiModelProperty("自校验原因")
  private String autoCheckNote;

  @ApiModelProperty("发票集合")
  private List<InvoiceAuditDtoBean> detailsBeanList;

  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  public BigDecimal getOrderNormalAmountWithTax() {
    return orderNormalAmountWithTax;
  }

  public void setOrderNormalAmountWithTax(BigDecimal orderNormalAmountWithTax) {
    this.orderNormalAmountWithTax = orderNormalAmountWithTax;
  }

  public BigDecimal getOrderSpecialAmountWithTax() {
    return orderSpecialAmountWithTax;
  }

  public void setOrderSpecialAmountWithTax(BigDecimal orderSpecialAmountWithTax) {
    this.orderSpecialAmountWithTax = orderSpecialAmountWithTax;
  }

  public BigDecimal getOrderSpecialTaxAmount() {
    return orderSpecialTaxAmount;
  }

  public void setOrderSpecialTaxAmount(BigDecimal orderSpecialTaxAmount) {
    this.orderSpecialTaxAmount = orderSpecialTaxAmount;
  }

  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  public Integer getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }

  public Integer getInvoiceNum() {
    return invoiceNum;
  }

  public void setInvoiceNum(Integer invoiceNum) {
    this.invoiceNum = invoiceNum;
  }

  public BigDecimal getInvoiceNormalAmountWithTax() {
    return invoiceNormalAmountWithTax;
  }

  public void setInvoiceNormalAmountWithTax(BigDecimal invoiceNormalAmountWithTax) {
    this.invoiceNormalAmountWithTax = invoiceNormalAmountWithTax;
  }

  public BigDecimal getInvoiceSpecialAmountWithTax() {
    return invoiceSpecialAmountWithTax;
  }

  public void setInvoiceSpecialAmountWithTax(BigDecimal invoiceSpecialAmountWithTax) {
    this.invoiceSpecialAmountWithTax = invoiceSpecialAmountWithTax;
  }

  public BigDecimal getInvoiceSpecialTaxAmount() {
    return invoiceSpecialTaxAmount;
  }

  public void setInvoiceSpecialTaxAmount(BigDecimal invoiceSpecialTaxAmount) {
    this.invoiceSpecialTaxAmount = invoiceSpecialTaxAmount;
  }

  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  public String getAddImageUrl() {
    return addImageUrl;
  }

  public void setAddImageUrl(String addImageUrl) {
    this.addImageUrl = addImageUrl;
  }

  public String getQueryImageUrl() {
    return queryImageUrl;
  }

  public void setQueryImageUrl(String queryImageUrl) {
    this.queryImageUrl = queryImageUrl;
  }

  public Integer getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
  }

  public Integer getAutoCheckStatus() {
    return autoCheckStatus;
  }

  public void setAutoCheckStatus(Integer autoCheckStatus) {
    this.autoCheckStatus = autoCheckStatus;
  }

  public String getAutoCheckNote() {
    return autoCheckNote;
  }

  public void setAutoCheckNote(String autoCheckNote) {
    this.autoCheckNote = autoCheckNote;
  }

  public List<InvoiceAuditDtoBean> getDetailsBeanList() {
    return detailsBeanList;
  }

  public void setDetailsBeanList(List<InvoiceAuditDtoBean> detailsBeanList) {
    this.detailsBeanList = detailsBeanList;
  }
}
