package com.xforceplus.vanke.in.client.model;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;
import java.math.BigDecimal;

/**
 * @Description 发票导出
 * @Date 2019年07月19日 16:05
 * @Author rongying
 * @Version 1.0
 */
public class InvoiceDetailsExportBean extends BaseRowModel {

  @ExcelProperty("发票号码")
  private String invoiceNo;

  @ExcelProperty("发票代码")
  private String invoiceCode;

  @ExcelProperty("货物及服务名称")
  private String cargoName;

  @ExcelProperty("货物及服务代码")
  private String cargoCode;

  @ExcelProperty("型号规格")
  private String itemSpec;

  @ExcelProperty("数量单位")
  private String quantityUnit;

  @ExcelProperty("数量")
  private BigDecimal quantity;

  @ExcelProperty("税率")
  private String taxRate;

  @ExcelProperty("单价")
  private BigDecimal unitPrice;

  @ExcelProperty("不含税金额")
  private BigDecimal amountWithoutTax;

  @ExcelProperty("税额")
  private BigDecimal taxAmount;

  @ExcelProperty("含税金额")
  private BigDecimal amountWithTax;

  @ExcelProperty("不含税折扣金额")
  private BigDecimal discountWithoutTax;

  @ExcelProperty("折扣税率")
  private String discountRate;

  @ExcelProperty("折扣税额")
  private BigDecimal discountTax;

  @ExcelProperty("含税折扣金额")
  private BigDecimal discountWithTax;

  @ExcelProperty("商品税目")
  private String taxItem;

  @ExcelProperty("税收分类编码")
  private String goodsTaxNo;

  @ExcelProperty("商品编号(ERP)")
  private String goodsErpNo;

  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  public String getCargoCode() {
    return cargoCode;
  }

  public void setCargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
  }

  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  public BigDecimal getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  public BigDecimal getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  public String getDiscountRate() {
    return discountRate;
  }

  public void setDiscountRate(String discountRate) {
    this.discountRate = discountRate;
  }

  public BigDecimal getDiscountTax() {
    return discountTax;
  }

  public void setDiscountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
  }

  public BigDecimal getDiscountWithTax() {
    return discountWithTax;
  }

  public void setDiscountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
  }

  public String getTaxItem() {
    return taxItem;
  }

  public void setTaxItem(String taxItem) {
    this.taxItem = taxItem;
  }

  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  public String getGoodsErpNo() {
    return goodsErpNo;
  }

  public void setGoodsErpNo(String goodsErpNo) {
    this.goodsErpNo = goodsErpNo;
  }
}
