package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票重复统计
 */
@ApiModel(description = "发票重复统计")

@JsonInclude(NON_NULL)
public class InvoiceRepeatCountRequest extends PageRequest {
  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("paperDrewDate")
  private List<String> paperDrewDate = new ArrayList<String>();

  @JsonProperty("amountWithTax")
  private List<BigDecimal> amountWithTax = new ArrayList<BigDecimal>();

  @JsonIgnore
  public InvoiceRepeatCountRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoiceRepeatCountRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvoiceRepeatCountRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public InvoiceRepeatCountRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public InvoiceRepeatCountRequest paperDrewDate(List<String> paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

  public InvoiceRepeatCountRequest addPaperDrewDateItem(String paperDrewDateItem) {
    this.paperDrewDate.add(paperDrewDateItem);
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public List<String> getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(List<String> paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public InvoiceRepeatCountRequest amountWithTax(List<BigDecimal> amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

  public InvoiceRepeatCountRequest addAmountWithTaxItem(BigDecimal amountWithTaxItem) {
    this.amountWithTax.add(amountWithTaxItem);
    return this;
  }

   /**
   * 价税合计(取A、B区间)
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "价税合计(取A、B区间)")
  public List<BigDecimal> getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(List<BigDecimal> amountWithTax) {
    this.amountWithTax = amountWithTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceRepeatCountRequest invoiceRepeatCountRequest = (InvoiceRepeatCountRequest) o;
    return Objects.equals(this.invoiceCode, invoiceRepeatCountRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoiceRepeatCountRequest.invoiceNo) &&
        Objects.equals(this.purchaserName, invoiceRepeatCountRequest.purchaserName) &&
        Objects.equals(this.sellerName, invoiceRepeatCountRequest.sellerName) &&
        Objects.equals(this.paperDrewDate, invoiceRepeatCountRequest.paperDrewDate) &&
        Objects.equals(this.amountWithTax, invoiceRepeatCountRequest.amountWithTax) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceCode, invoiceNo, purchaserName, sellerName, paperDrewDate, amountWithTax, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceRepeatCountRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
