package com.xforceplus.vanke.in.client.model;

import java.io.Serializable;

/**
 * @描述 发票状态生命周期实体类
 * @时间 2019年6月21日 20:02
 * @author by - ry
 */
public class InvoiceStatusLifeCycleBean implements Serializable {

    /**
     * 销方开具状态：0-默认；1-无销方信息（非协同）；2-销方信息未 到（协同）；3-销方信息已到（协同）
     */
    private Integer sellerSyncStatus;

    /**
     * 销方协同时间
     */
    private Long sellerSyncTime;

    /**
     * 销方开具操作人
     */
    private String sellerSyncName;

    /**
     * 销方开具时间间隔
     */
    private String sellerDateStr;

    /**
     * 邮包签收状态：10-成功，20-失败
     */
    private Integer packageSignStatus;

    /**
     * 邮包签收时间
     */
    private Long packageSignTime;

    /**
     * 邮包签收人
     */
    private String packageSignName;

    /**
     * 邮包签收时间间隔
     */
    private String packageSignDateStr;

    /**
     * 发票签收状态：10-成功 20-失败
     */
    private Integer invoiceSignStatus;

    /**
     * 发票签收时间
     */
    private Long invoiceSignTime;

    /**
     * 发票签收人
     */
    private String invoiceSignName;

    /**
     * 发票签收时间间隔
     */
    private String invoiceSignDateStr;

    /**
     * 影像识别状态：0-未识别（默认）；1-已识别
     */
    private Integer recogStatus;

    /**
     * 影像识别时间
     */
    private Long recogTime;

    /**
     * 影像识别人
     */
    private String recogName;

    /**
     * 影像识别时间间隔
     */
    private String recogDateStr;

    /**
     * 审核状态：0：未审核  1：审核成功 2：审核不通过
     */
    private Integer auditStatus;

    /**
     * 审核时间
     */
    private long auditTime;

    /**
     * 审核人
     */
    private String auditName;

    /**
     * 审核时间间隔
     */
    private String auditDateStr;

    /**
     * 认证状态：0-默认；1-不可认证；2-未认证；3-认证中；4-认证成功；5-认证失败；6-抵扣异常；7-已转出
     */
    private Integer authStatus;

    /**
     * 认证时间
     */
    private Long authTime;

    /**
     * 认证人
     */
    private String authName;

    /**
     * 认证备注
     */
    private String authRemark;

    /**
     * 是否可认证
     */
    private Boolean showAuthFlag;

    /**
     * 是否可修改认证
     */
    private Boolean modifyAuthFlag;

    /**
     * 认证所属期
     */
    private String authTaxPeriod;

    /**
     * 认证方式
     */
    private Integer authStyle;

    public Integer getSellerSyncStatus() {
        return sellerSyncStatus;
    }

    public void setSellerSyncStatus(Integer sellerSyncStatus) {
        this.sellerSyncStatus = sellerSyncStatus;
    }

    public Long getSellerSyncTime() {
        return sellerSyncTime;
    }

    public void setSellerSyncTime(Long sellerSyncTime) {
        this.sellerSyncTime = sellerSyncTime;
    }

    public String getSellerSyncName() {
        return sellerSyncName;
    }

    public void setSellerSyncName(String sellerSyncName) {
        this.sellerSyncName = sellerSyncName;
    }

    public String getSellerDateStr() {
        return sellerDateStr;
    }

    public void setSellerDateStr(String sellerDateStr) {
        this.sellerDateStr = sellerDateStr;
    }

    public Integer getPackageSignStatus() {
        return packageSignStatus;
    }

    public void setPackageSignStatus(Integer packageSignStatus) {
        this.packageSignStatus = packageSignStatus;
    }

    public Long getPackageSignTime() {
        return packageSignTime;
    }

    public void setPackageSignTime(Long packageSignTime) {
        this.packageSignTime = packageSignTime;
    }

    public String getPackageSignName() {
        return packageSignName;
    }

    public void setPackageSignName(String packageSignName) {
        this.packageSignName = packageSignName;
    }

    public String getPackageSignDateStr() {
        return packageSignDateStr;
    }

    public void setPackageSignDateStr(String packageSignDateStr) {
        this.packageSignDateStr = packageSignDateStr;
    }

    public Integer getInvoiceSignStatus() {
        return invoiceSignStatus;
    }

    public void setInvoiceSignStatus(Integer invoiceSignStatus) {
        this.invoiceSignStatus = invoiceSignStatus;
    }

    public Long getInvoiceSignTime() {
        return invoiceSignTime;
    }

    public void setInvoiceSignTime(Long invoiceSignTime) {
        this.invoiceSignTime = invoiceSignTime;
    }

    public String getInvoiceSignName() {
        return invoiceSignName;
    }

    public void setInvoiceSignName(String invoiceSignName) {
        this.invoiceSignName = invoiceSignName;
    }

    public String getInvoiceSignDateStr() {
        return invoiceSignDateStr;
    }

    public void setInvoiceSignDateStr(String invoiceSignDateStr) {
        this.invoiceSignDateStr = invoiceSignDateStr;
    }

    public Integer getRecogStatus() {
        return recogStatus;
    }

    public void setRecogStatus(Integer recogStatus) {
        this.recogStatus = recogStatus;
    }

    public Long getRecogTime() {
        return recogTime;
    }

    public void setRecogTime(Long recogTime) {
        this.recogTime = recogTime;
    }

    public String getRecogName() {
        return recogName;
    }

    public void setRecogName(String recogName) {
        this.recogName = recogName;
    }

    public String getRecogDateStr() {
        return recogDateStr;
    }

    public void setRecogDateStr(String recogDateStr) {
        this.recogDateStr = recogDateStr;
    }

    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public long getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(long auditTime) {
        this.auditTime = auditTime;
    }

    public String getAuditName() {
        return auditName;
    }

    public void setAuditName(String auditName) {
        this.auditName = auditName;
    }

    public String getAuditDateStr() {
        return auditDateStr;
    }

    public void setAuditDateStr(String auditDateStr) {
        this.auditDateStr = auditDateStr;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    public Long getAuthTime() {
        return authTime;
    }

    public void setAuthTime(Long authTime) {
        this.authTime = authTime;
    }

    public String getAuthName() {
        return authName;
    }

    public void setAuthName(String authName) {
        this.authName = authName;
    }

    public String getAuthRemark() {
        return authRemark;
    }

    public void setAuthRemark(String authRemark) {
        this.authRemark = authRemark;
    }

    public Boolean getShowAuthFlag() {
        return showAuthFlag;
    }

    public void setShowAuthFlag(Boolean showAuthFlag) {
        this.showAuthFlag = showAuthFlag;
    }

    public Boolean getModifyAuthFlag() {
        return modifyAuthFlag;
    }

    public void setModifyAuthFlag(Boolean modifyAuthFlag) {
        this.modifyAuthFlag = modifyAuthFlag;
    }

    public String getAuthTaxPeriod() {
        return authTaxPeriod;
    }

    public void setAuthTaxPeriod(String authTaxPeriod) {
        this.authTaxPeriod = authTaxPeriod;
    }

    public Integer getAuthStyle() {
        return authStyle;
    }

    public void setAuthStyle(Integer authStyle) {
        this.authStyle = authStyle;
    }

    @Override
    public String toString() {
        return "InvoiceStatusLifeCycleBean{" +
                "sellerSyncStatus=" + sellerSyncStatus +
                ", sellerSyncTime=" + sellerSyncTime +
                ", sellerSyncName='" + sellerSyncName + '\'' +
                ", sellerDateStr='" + sellerDateStr + '\'' +
                ", packageSignStatus=" + packageSignStatus +
                ", packageSignTime=" + packageSignTime +
                ", packageSignName='" + packageSignName + '\'' +
                ", packageSignDateStr='" + packageSignDateStr + '\'' +
                ", invoiceSignStatus=" + invoiceSignStatus +
                ", invoiceSignTime=" + invoiceSignTime +
                ", invoiceSignName='" + invoiceSignName + '\'' +
                ", invoiceSignDateStr='" + invoiceSignDateStr + '\'' +
                ", recogStatus=" + recogStatus +
                ", recogTime=" + recogTime +
                ", recogName='" + recogName + '\'' +
                ", recogDateStr='" + recogDateStr + '\'' +
                ", auditStatus=" + auditStatus +
                ", auditTime=" + auditTime +
                ", auditName='" + auditName + '\'' +
                ", auditDateStr='" + auditDateStr + '\'' +
                ", authStatus=" + authStatus +
                ", authTime=" + authTime +
                ", authName='" + authName + '\'' +
                ", authRemark='" + authRemark + '\'' +
                ", showAuthFlag=" + showAuthFlag +
                ", modifyAuthFlag=" + modifyAuthFlag +
                ", authTaxPeriod='" + authTaxPeriod + '\'' +
                ", authStyle='" + authStyle + '\'' +
                '}';
    }
}
