package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 根据运单号匹配物流公司Request
 */
@ApiModel(description = "根据运单号匹配物流公司Request")

@JsonInclude(NON_NULL)
public class MatchLogisticsRequest extends BaseRequest {
  @JsonProperty("trackingNo")
  private String trackingNo = null;

  @JsonIgnore
  public MatchLogisticsRequest trackingNo(String trackingNo) {
    this.trackingNo = trackingNo;
    return this;
  }

   /**
   * 运单号
   * @return trackingNo
  **/
  @ApiModelProperty(value = "运单号")
  public String getTrackingNo() {
    return trackingNo;
  }

  public void setTrackingNo(String trackingNo) {
    this.trackingNo = trackingNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MatchLogisticsRequest matchLogisticsRequest = (MatchLogisticsRequest) o;
    return Objects.equals(this.trackingNo, matchLogisticsRequest.trackingNo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(trackingNo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MatchLogisticsRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    trackingNo: ").append(toIndentedString(trackingNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
