package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * ModifyAuditStatusRequest
 */
@ApiModel(description = "ModifyAuditStatusRequest")

@JsonInclude(NON_NULL)
public class ModifyAuditStatusRequest extends BaseRequest {
  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("auditStatus")
  private Integer auditStatus = null;

  @JsonIgnore
  public ModifyAuditStatusRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public ModifyAuditStatusRequest auditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

   /**
   * 审核状态
   * @return auditStatus
  **/
  @ApiModelProperty(value = "审核状态")
  public Integer getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyAuditStatusRequest modifyAuditStatusRequest = (ModifyAuditStatusRequest) o;
    return Objects.equals(this.salesbillNo, modifyAuditStatusRequest.salesbillNo) &&
        Objects.equals(this.auditStatus, modifyAuditStatusRequest.auditStatus) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillNo, auditStatus, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyAuditStatusRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
