package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * modifyIfAuthFlagRequest
 */
@ApiModel(description = "modifyIfAuthFlagRequest")

@JsonInclude(NON_NULL)
public class ModifyIfAuthFlagRequest extends BaseRequest {
  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("ifAuthFlag")
  private Integer ifAuthFlag = null;

  @JsonIgnore
  public ModifyIfAuthFlagRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public ModifyIfAuthFlagRequest ifAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

   /**
   * 是否可抵扣标识
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否可抵扣标识")
  public Integer getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyIfAuthFlagRequest modifyIfAuthFlagRequest = (ModifyIfAuthFlagRequest) o;
    return Objects.equals(this.salesbillNo, modifyIfAuthFlagRequest.salesbillNo) &&
        Objects.equals(this.ifAuthFlag, modifyIfAuthFlagRequest.ifAuthFlag) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillNo, ifAuthFlag, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyIfAuthFlagRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
