package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 修改影像信息入参
 */
@ApiModel(description = "修改影像信息入参")

@JsonInclude(NON_NULL)
public class ModifyRecogRequest extends BaseRequest {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("imageUrl")
  private String imageUrl = null;

  @JsonProperty("doIfAuthedForA")
  private String doIfAuthedForA = null;

  @JsonProperty("doIfAuthedForB")
  private String doIfAuthedForB = null;

  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("originInvoiceType")
  private Integer originInvoiceType = null;

  @JsonIgnore
  public ModifyRecogRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public ModifyRecogRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public ModifyRecogRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public ModifyRecogRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public ModifyRecogRequest paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期 yyyyMMdd
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期 yyyyMMdd")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public ModifyRecogRequest amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public ModifyRecogRequest taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public ModifyRecogRequest amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 价税合计
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "价税合计")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public ModifyRecogRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public ModifyRecogRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public ModifyRecogRequest machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public ModifyRecogRequest checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public ModifyRecogRequest cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public ModifyRecogRequest imageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
    return this;
  }

   /**
   * 影像地址
   * @return imageUrl
  **/
  @ApiModelProperty(value = "影像地址")
  public String getImageUrl() {
    return imageUrl;
  }

  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  @JsonIgnore
  public ModifyRecogRequest doIfAuthedForA(String doIfAuthedForA) {
    this.doIfAuthedForA = doIfAuthedForA;
    return this;
  }

   /**
   * 发票A已认证是否继续执行   Y-继续执行  N-不执行  W-提醒用户选择
   * @return doIfAuthedForA
  **/
  @ApiModelProperty(value = "发票A已认证是否继续执行   Y-继续执行  N-不执行  W-提醒用户选择")
  public String getDoIfAuthedForA() {
    return doIfAuthedForA;
  }

  public void setDoIfAuthedForA(String doIfAuthedForA) {
    this.doIfAuthedForA = doIfAuthedForA;
  }

  @JsonIgnore
  public ModifyRecogRequest doIfAuthedForB(String doIfAuthedForB) {
    this.doIfAuthedForB = doIfAuthedForB;
    return this;
  }

   /**
   * 发票B已认证是否继续执行   Y-继续执行  N-不执行  W-提醒用户选择
   * @return doIfAuthedForB
  **/
  @ApiModelProperty(value = "发票B已认证是否继续执行   Y-继续执行  N-不执行  W-提醒用户选择")
  public String getDoIfAuthedForB() {
    return doIfAuthedForB;
  }

  public void setDoIfAuthedForB(String doIfAuthedForB) {
    this.doIfAuthedForB = doIfAuthedForB;
  }

  @JsonIgnore
  public ModifyRecogRequest orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单号
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单号")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public ModifyRecogRequest originInvoiceType(Integer originInvoiceType) {
    this.originInvoiceType = originInvoiceType;
    return this;
  }

   /**
   * 源发票联次:1-发票联，2-抵扣联
   * @return originInvoiceType
  **/
  @ApiModelProperty(value = "源发票联次:1-发票联，2-抵扣联")
  public Integer getOriginInvoiceType() {
    return originInvoiceType;
  }

  public void setOriginInvoiceType(Integer originInvoiceType) {
    this.originInvoiceType = originInvoiceType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyRecogRequest modifyRecogRequest = (ModifyRecogRequest) o;
    return Objects.equals(this.invoiceId, modifyRecogRequest.invoiceId) &&
        Objects.equals(this.invoiceCode, modifyRecogRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, modifyRecogRequest.invoiceNo) &&
        Objects.equals(this.invoiceType, modifyRecogRequest.invoiceType) &&
        Objects.equals(this.paperDrewDate, modifyRecogRequest.paperDrewDate) &&
        Objects.equals(this.amountWithoutTax, modifyRecogRequest.amountWithoutTax) &&
        Objects.equals(this.taxAmount, modifyRecogRequest.taxAmount) &&
        Objects.equals(this.amountWithTax, modifyRecogRequest.amountWithTax) &&
        Objects.equals(this.purchaserTaxNo, modifyRecogRequest.purchaserTaxNo) &&
        Objects.equals(this.sellerTaxNo, modifyRecogRequest.sellerTaxNo) &&
        Objects.equals(this.machineCode, modifyRecogRequest.machineCode) &&
        Objects.equals(this.checkCode, modifyRecogRequest.checkCode) &&
        Objects.equals(this.cipherText, modifyRecogRequest.cipherText) &&
        Objects.equals(this.imageUrl, modifyRecogRequest.imageUrl) &&
        Objects.equals(this.doIfAuthedForA, modifyRecogRequest.doIfAuthedForA) &&
        Objects.equals(this.doIfAuthedForB, modifyRecogRequest.doIfAuthedForB) &&
        Objects.equals(this.orderCode, modifyRecogRequest.orderCode) &&
        Objects.equals(this.originInvoiceType, modifyRecogRequest.originInvoiceType) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, invoiceCode, invoiceNo, invoiceType, paperDrewDate, amountWithoutTax, taxAmount, amountWithTax, purchaserTaxNo, sellerTaxNo, machineCode, checkCode, cipherText, imageUrl, doIfAuthedForA, doIfAuthedForB, orderCode, originInvoiceType, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyRecogRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    imageUrl: ").append(toIndentedString(imageUrl)).append("\n");
    sb.append("    doIfAuthedForA: ").append(toIndentedString(doIfAuthedForA)).append("\n");
    sb.append("    doIfAuthedForB: ").append(toIndentedString(doIfAuthedForB)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    originInvoiceType: ").append(toIndentedString(originInvoiceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
