package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 修改快递
 */
@ApiModel(description = "修改快递")

@JsonInclude(NON_NULL)
public class ModifyWaybillNoRequest extends BaseRequest {
  @JsonProperty("parcelId")
  private Long parcelId = null;

  @JsonProperty("goodsIds")
  private List<Long> goodsIds = new ArrayList<Long>();

  @JsonProperty("expressName")
  private String expressName = null;

  @JsonProperty("expressCode")
  private String expressCode = null;

  @JsonProperty("waybillNo")
  private String waybillNo = null;

  @JsonIgnore
  public ModifyWaybillNoRequest parcelId(Long parcelId) {
    this.parcelId = parcelId;
    return this;
  }

   /**
   * 包裹ID
   * @return parcelId
  **/
  @ApiModelProperty(value = "包裹ID")
  public Long getParcelId() {
    return parcelId;
  }

  public void setParcelId(Long parcelId) {
    this.parcelId = parcelId;
  }

  @JsonIgnore
  public ModifyWaybillNoRequest goodsIds(List<Long> goodsIds) {
    this.goodsIds = goodsIds;
    return this;
  }

  public ModifyWaybillNoRequest addGoodsIdsItem(Long goodsIdsItem) {
    this.goodsIds.add(goodsIdsItem);
    return this;
  }

   /**
   * 修改运单号的物品Id
   * @return goodsIds
  **/
  @ApiModelProperty(value = "修改运单号的物品Id")
  public List<Long> getGoodsIds() {
    return goodsIds;
  }

  public void setGoodsIds(List<Long> goodsIds) {
    this.goodsIds = goodsIds;
  }

  @JsonIgnore
  public ModifyWaybillNoRequest expressName(String expressName) {
    this.expressName = expressName;
    return this;
  }

   /**
   * 快递公司名称
   * @return expressName
  **/
  @ApiModelProperty(value = "快递公司名称")
  public String getExpressName() {
    return expressName;
  }

  public void setExpressName(String expressName) {
    this.expressName = expressName;
  }

  @JsonIgnore
  public ModifyWaybillNoRequest expressCode(String expressCode) {
    this.expressCode = expressCode;
    return this;
  }

   /**
   * 快递公司代码
   * @return expressCode
  **/
  @ApiModelProperty(value = "快递公司代码")
  public String getExpressCode() {
    return expressCode;
  }

  public void setExpressCode(String expressCode) {
    this.expressCode = expressCode;
  }

  @JsonIgnore
  public ModifyWaybillNoRequest waybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
    return this;
  }

   /**
   * 运单号
   * @return waybillNo
  **/
  @ApiModelProperty(value = "运单号")
  public String getWaybillNo() {
    return waybillNo;
  }

  public void setWaybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModifyWaybillNoRequest modifyWaybillNoRequest = (ModifyWaybillNoRequest) o;
    return Objects.equals(this.parcelId, modifyWaybillNoRequest.parcelId) &&
        Objects.equals(this.goodsIds, modifyWaybillNoRequest.goodsIds) &&
        Objects.equals(this.expressName, modifyWaybillNoRequest.expressName) &&
        Objects.equals(this.expressCode, modifyWaybillNoRequest.expressCode) &&
        Objects.equals(this.waybillNo, modifyWaybillNoRequest.waybillNo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parcelId, goodsIds, expressName, expressCode, waybillNo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModifyWaybillNoRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    parcelId: ").append(toIndentedString(parcelId)).append("\n");
    sb.append("    goodsIds: ").append(toIndentedString(goodsIds)).append("\n");
    sb.append("    expressName: ").append(toIndentedString(expressName)).append("\n");
    sb.append("    expressCode: ").append(toIndentedString(expressCode)).append("\n");
    sb.append("    waybillNo: ").append(toIndentedString(waybillNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
