package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 影像文件表Request
 */
@ApiModel(description = "影像文件表Request")

@JsonInclude(NON_NULL)
public class MovieSmFileRequest extends BaseRequest {
  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("keys")
  private List<Long> keys = new ArrayList<Long>();

  @JsonIgnore
  public MovieSmFileRequest parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父文件id
   * @return parentId
  **/
  @ApiModelProperty(value = "父文件id")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public MovieSmFileRequest keys(List<Long> keys) {
    this.keys = keys;
    return this;
  }

  public MovieSmFileRequest addKeysItem(Long keysItem) {
    this.keys.add(keysItem);
    return this;
  }

   /**
   * 移动的id列表
   * @return keys
  **/
  @ApiModelProperty(value = "移动的id列表")
  public List<Long> getKeys() {
    return keys;
  }

  public void setKeys(List<Long> keys) {
    this.keys = keys;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MovieSmFileRequest movieSmFileRequest = (MovieSmFileRequest) o;
    return Objects.equals(this.parentId, movieSmFileRequest.parentId) &&
        Objects.equals(this.keys, movieSmFileRequest.keys) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parentId, keys, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MovieSmFileRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    keys: ").append(toIndentedString(keys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
