package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 寄送请求
 */
@ApiModel(description = "寄送请求")

@JsonInclude(NON_NULL)
public class ParcelDetailsSendRequest extends BaseRequest {
  @JsonProperty("idList")
  private List<Long> idList = new ArrayList<Long>();

  @JsonIgnore
  public ParcelDetailsSendRequest idList(List<Long> idList) {
    this.idList = idList;
    return this;
  }

  public ParcelDetailsSendRequest addIdListItem(Long idListItem) {
    this.idList.add(idListItem);
    return this;
  }

   /**
   * 发票id集合
   * @return idList
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getIdList() {
    return idList;
  }

  public void setIdList(List<Long> idList) {
    this.idList = idList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ParcelDetailsSendRequest parcelDetailsSendRequest = (ParcelDetailsSendRequest) o;
    return Objects.equals(this.idList, parcelDetailsSendRequest.idList) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(idList, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ParcelDetailsSendRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    idList: ").append(toIndentedString(idList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
