package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.WkParcelDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 退票包裹表Request
 */
@ApiModel(description = "退票包裹表Request")

@JsonInclude(NON_NULL)
public class SaveParcelRequest extends BaseRequest {
  @JsonProperty("entities")
  private List<WkParcelDTO> entities = new ArrayList<WkParcelDTO>();

  @JsonIgnore
  public SaveParcelRequest entities(List<WkParcelDTO> entities) {
    this.entities = entities;
    return this;
  }

  public SaveParcelRequest addEntitiesItem(WkParcelDTO entitiesItem) {
    this.entities.add(entitiesItem);
    return this;
  }

   /**
   * Get entities
   * @return entities
  **/
  @ApiModelProperty(value = "")
  public List<WkParcelDTO> getEntities() {
    return entities;
  }

  public void setEntities(List<WkParcelDTO> entities) {
    this.entities = entities;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SaveParcelRequest saveParcelRequest = (SaveParcelRequest) o;
    return Objects.equals(this.entities, saveParcelRequest.entities) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entities, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SaveParcelRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
