package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.SmFileInvoiceDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 影像文件表Request
 */
@ApiModel(description = "影像文件表Request")

@JsonInclude(NON_NULL)
public class SaveSmFileRequest extends BaseRequest {
  @JsonProperty("parentId")
  private Long parentId = null;

  @JsonProperty("entities")
  private List<SmFileInvoiceDTO> entities = new ArrayList<SmFileInvoiceDTO>();

  @JsonIgnore
  public SaveSmFileRequest parentId(Long parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * 父文件id
   * @return parentId
  **/
  @ApiModelProperty(value = "父文件id")
  public Long getParentId() {
    return parentId;
  }

  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  @JsonIgnore
  public SaveSmFileRequest entities(List<SmFileInvoiceDTO> entities) {
    this.entities = entities;
    return this;
  }

  public SaveSmFileRequest addEntitiesItem(SmFileInvoiceDTO entitiesItem) {
    this.entities.add(entitiesItem);
    return this;
  }

   /**
   * Get entities
   * @return entities
  **/
  @ApiModelProperty(value = "")
  public List<SmFileInvoiceDTO> getEntities() {
    return entities;
  }

  public void setEntities(List<SmFileInvoiceDTO> entities) {
    this.entities = entities;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SaveSmFileRequest saveSmFileRequest = (SaveSmFileRequest) o;
    return Objects.equals(this.parentId, saveSmFileRequest.parentId) &&
        Objects.equals(this.entities, saveSmFileRequest.entities) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parentId, entities, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SaveSmFileRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
