package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 签收管理表Request
 */
@ApiModel(description = "签收管理表Request")

@JsonInclude(NON_NULL)
public class SignOrdersRequest extends BaseRequest {
  @JsonProperty("processStatus")
  private Integer processStatus = null;

  @JsonProperty("errorType")
  private String errorType = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("orderIds")
  private List<Long> orderIds = new ArrayList<Long>();

  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("confirmCoverage")
  private Boolean confirmCoverage = null;

  @JsonIgnore
  public SignOrdersRequest processStatus(Integer processStatus) {
    this.processStatus = processStatus;
    return this;
  }

   /**
   * 邮包状态：1-合格，2-不合格
   * @return processStatus
  **/
  @ApiModelProperty(value = "邮包状态：1-合格，2-不合格")
  public Integer getProcessStatus() {
    return processStatus;
  }

  public void setProcessStatus(Integer processStatus) {
    this.processStatus = processStatus;
  }

  @JsonIgnore
  public SignOrdersRequest errorType(String errorType) {
    this.errorType = errorType;
    return this;
  }

   /**
   * 异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无結算单，5-其他，6-审核异常，7-抵扣异常，8-发票转异常
   * @return errorType
  **/
  @ApiModelProperty(value = "异常原因分类：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无結算单，5-其他，6-审核异常，7-抵扣异常，8-发票转异常")
  public String getErrorType() {
    return errorType;
  }

  public void setErrorType(String errorType) {
    this.errorType = errorType;
  }

  @JsonIgnore
  public SignOrdersRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 异常备注
   * @return remark
  **/
  @ApiModelProperty(value = "异常备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public SignOrdersRequest packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包的快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包的快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public SignOrdersRequest orderIds(List<Long> orderIds) {
    this.orderIds = orderIds;
    return this;
  }

  public SignOrdersRequest addOrderIdsItem(Long orderIdsItem) {
    this.orderIds.add(orderIdsItem);
    return this;
  }

   /**
   * 业务单ID
   * @return orderIds
  **/
  @ApiModelProperty(value = "业务单ID")
  public List<Long> getOrderIds() {
    return orderIds;
  }

  public void setOrderIds(List<Long> orderIds) {
    this.orderIds = orderIds;
  }

  @JsonIgnore
  public SignOrdersRequest orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单号
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单号")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public SignOrdersRequest confirmCoverage(Boolean confirmCoverage) {
    this.confirmCoverage = confirmCoverage;
    return this;
  }

   /**
   * 确认覆盖
   * @return confirmCoverage
  **/
  @ApiModelProperty(value = "确认覆盖")
  public Boolean getConfirmCoverage() {
    return confirmCoverage;
  }

  public void setConfirmCoverage(Boolean confirmCoverage) {
    this.confirmCoverage = confirmCoverage;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignOrdersRequest signOrdersRequest = (SignOrdersRequest) o;
    return Objects.equals(this.processStatus, signOrdersRequest.processStatus) &&
        Objects.equals(this.errorType, signOrdersRequest.errorType) &&
        Objects.equals(this.remark, signOrdersRequest.remark) &&
        Objects.equals(this.packageCode, signOrdersRequest.packageCode) &&
        Objects.equals(this.orderIds, signOrdersRequest.orderIds) &&
        Objects.equals(this.orderCode, signOrdersRequest.orderCode) &&
        Objects.equals(this.confirmCoverage, signOrdersRequest.confirmCoverage) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processStatus, errorType, remark, packageCode, orderIds, orderCode, confirmCoverage, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignOrdersRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    processStatus: ").append(toIndentedString(processStatus)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    orderIds: ").append(toIndentedString(orderIds)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    confirmCoverage: ").append(toIndentedString(confirmCoverage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
