package com.xforceplus.vanke.in.client.model;


import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 扫描文件数据模型（包含文件和发票结构化数据）
 */
public class SmFileBean extends SmFileInvoiceDTO implements java.io.Serializable {
    @ApiModelProperty("影像总张数")
    private Integer fileCount = 0;
    @ApiModelProperty("发票份数（已扫描份数）")
    private Integer invoiceCount = 0;
    @ApiModelProperty("发票联张数（已扫描张数）")
    private Integer invoiceSheetCount = 0;
    @ApiModelProperty("抵扣联张数（已扫描张数）")
    private Integer deductionSheetCount = 0;
    @ApiModelProperty("发票份数（业务单应开具数-不包含作废/红冲）")
    private Integer needInvoiceCount = 0;
    @ApiModelProperty("发票联张数（业务单应开具张数-不包含作废/红冲）")
    private Integer needInvoiceSheetCount = 0;
    @ApiModelProperty("抵扣联张数（业务单应开具张数-不包含作废/红冲）")
    private Integer needDeductionSheetCount = 0;
    @ApiModelProperty("父文件id：0-代表空，1-顶级parentId")
    private Long parentId;
    @ApiModelProperty("子文件")
    private List<SmFileBean> subFiles = new ArrayList<>();

    @ApiModelProperty(value = "同步时间")
    private Long syncTime;
    @ApiModelProperty(value = "null")
    private String invoiceId;
    @ApiModelProperty(value = "来源系统：GX|XYJ")
    private String sourceSystem;
    @ApiModelProperty(value = "扫描协同序列号")
    private String cooperationSerialNo;
    @ApiModelProperty(value = "影像删除是否推送至喜盈佳：0-未推送,1-已推送")
    private Integer isPushImgDelXYJ;
    @ApiModelProperty(value = "null")
    private String originInvoiceId;
    @ApiModelProperty(value = "影像更新是否推送至喜盈佳 0 未推送 1 已推送")
    private Integer isPushImgUpdateXYJ;
    @ApiModelProperty(value = "更新推送时间")
    private Long isPushImgUpdateDate;
    @ApiModelProperty(value = "验真状态：1-失败，0-成功")
    private String checkStatus;
    @ApiModelProperty(value = "发票扫描来源：1-手机拍照，2-扫描仪，3-单多啦，4-其他")
    private String invoiceSource;
    @ApiModelProperty(value = "来源id")
    private String sourceId;
    @ApiModelProperty(value = "是否退扫：0-否，1-是")
    private Integer isBackScan;

    public Integer getFileCount() {
        return fileCount;
    }

    public void setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
    }

    public Integer getInvoiceCount() {
        return invoiceCount;
    }

    public void setInvoiceCount(Integer invoiceCount) {
        this.invoiceCount = invoiceCount;
    }

    public Integer getInvoiceSheetCount() {
        return invoiceSheetCount;
    }

    public void setInvoiceSheetCount(Integer invoiceSheetCount) {
        this.invoiceSheetCount = invoiceSheetCount;
    }

    public Integer getDeductionSheetCount() {
        return deductionSheetCount;
    }

    public void setDeductionSheetCount(Integer deductionSheetCount) {
        this.deductionSheetCount = deductionSheetCount;
    }

    public Integer getNeedInvoiceCount() {
        return needInvoiceCount;
    }

    public void setNeedInvoiceCount(Integer needInvoiceCount) {
        this.needInvoiceCount = needInvoiceCount;
    }

    public Integer getNeedInvoiceSheetCount() {
        return needInvoiceSheetCount;
    }

    public void setNeedInvoiceSheetCount(Integer needInvoiceSheetCount) {
        this.needInvoiceSheetCount = needInvoiceSheetCount;
    }

    public Integer getNeedDeductionSheetCount() {
        return needDeductionSheetCount;
    }

    public void setNeedDeductionSheetCount(Integer needDeductionSheetCount) {
        this.needDeductionSheetCount = needDeductionSheetCount;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }


    public List<SmFileBean> getSubFiles() {
        return subFiles;
    }

    public void setSubFiles(List<SmFileBean> subFiles) {
        this.subFiles = subFiles;
    }

    public Long getSyncTime() {
        return syncTime;
    }

    public void setSyncTime(Long syncTime) {
        this.syncTime = syncTime;
    }

    public String getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getSourceSystem() {
        return sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public String getCooperationSerialNo() {
        return cooperationSerialNo;
    }

    public void setCooperationSerialNo(String cooperationSerialNo) {
        this.cooperationSerialNo = cooperationSerialNo;
    }

    public Integer getIsPushImgDelXYJ() {
        return isPushImgDelXYJ;
    }

    public void setIsPushImgDelXYJ(Integer isPushImgDelXYJ) {
        this.isPushImgDelXYJ = isPushImgDelXYJ;
    }

    public String getOriginInvoiceId() {
        return originInvoiceId;
    }

    public void setOriginInvoiceId(String originInvoiceId) {
        this.originInvoiceId = originInvoiceId;
    }

    public Integer getIsPushImgUpdateXYJ() {
        return isPushImgUpdateXYJ;
    }

    public void setIsPushImgUpdateXYJ(Integer isPushImgUpdateXYJ) {
        this.isPushImgUpdateXYJ = isPushImgUpdateXYJ;
    }

    public Long getIsPushImgUpdateDate() {
        return isPushImgUpdateDate;
    }

    public void setIsPushImgUpdateDate(Long isPushImgUpdateDate) {
        this.isPushImgUpdateDate = isPushImgUpdateDate;
    }

    public String getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(String checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getInvoiceSource() {
        return invoiceSource;
    }

    public void setInvoiceSource(String invoiceSource) {
        this.invoiceSource = invoiceSource;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getIsBackScan() {
        return isBackScan;
    }

    public void setIsBackScan(Integer isBackScan) {
        this.isBackScan = isBackScan;
    }
}
