package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 扫描发票表
 */
@ApiModel(description = "扫描发票表")

@JsonInclude(NON_NULL)
public class SmInvoiceDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("fileId")
  private Long fileId = null;

  @JsonProperty("orderCode")
  private String orderCode = null;

  @JsonProperty("billCode")
  private String billCode = null;

  @JsonProperty("billCodePrn")
  private String billCodePrn = null;

  @JsonProperty("billNumber")
  private String billNumber = null;

  @JsonProperty("billNumberPrn")
  private String billNumberPrn = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("createBillTime")
  private Long createBillTime = null;

  @JsonProperty("notContainTaxAmount")
  private BigDecimal notContainTaxAmount = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("containTaxAmount")
  private BigDecimal containTaxAmount = null;

  @JsonProperty("invoiceScanId")
  private String invoiceScanId = null;

  @JsonProperty("invoiceScanTime")
  private Long invoiceScanTime = null;

  @JsonProperty("fpzt")
  private Integer fpzt = null;

  @JsonProperty("syncTime")
  private Long syncTime = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceQrcode")
  private String invoiceQrcode = null;

  @JsonProperty("passArea")
  private String passArea = null;

  @JsonProperty("invoiceId")
  private String invoiceId = null;

  @JsonProperty("createBillTimestr")
  private String createBillTimestr = null;

  @JsonProperty("scanBatchNo")
  private String scanBatchNo = null;

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("chargeTaxUnitCode")
  private String chargeTaxUnitCode = null;

  @JsonProperty("twoCodeFlag")
  private String twoCodeFlag = null;

  @JsonProperty("chargeTaxUnitName")
  private String chargeTaxUnitName = null;

  @JsonProperty("cloudIdentifyFlag")
  private Integer cloudIdentifyFlag = null;

  @JsonProperty("cloudIdentifyRemark")
  private String cloudIdentifyRemark = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("sourceSystem")
  private String sourceSystem = null;

  @JsonProperty("purchaseName")
  private String purchaseName = null;

  @JsonProperty("sellerTaxName")
  private String sellerTaxName = null;

  @JsonProperty("cooperationSerialNo")
  private String cooperationSerialNo = null;

  @JsonProperty("isPushImgDelXYJ")
  private Integer isPushImgDelXYJ = null;

  @JsonProperty("originInvoiceId")
  private String originInvoiceId = null;

  @JsonProperty("isPushImgUpdateXYJ")
  private Integer isPushImgUpdateXYJ = null;

  @JsonProperty("isPushImgUpdateDate")
  private Long isPushImgUpdateDate = null;

  @JsonProperty("checkStatus")
  private String checkStatus = null;

  @JsonProperty("invoiceSource")
  private String invoiceSource = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("containTaxAmountChn")
  private String containTaxAmountChn = null;

  @JsonProperty("submitStatus")
  private Integer submitStatus = null;

  @JsonProperty("submitInfo")
  private String submitInfo = null;

  @JsonProperty("specialInvoiceFlag")
  private Integer specialInvoiceFlag = null;

  @JsonProperty("payee")
  private String payee = null;

  @JsonProperty("reviewer")
  private String reviewer = null;

  @JsonProperty("drawer")
  private String drawer = null;

  @JsonProperty("sourceId")
  private String sourceId = null;

  @JsonProperty("isBackScan")
  private Integer isBackScan = null;

  @JsonProperty("warningInfo")
  private String warningInfo = null;

  @JsonProperty("invoiceSheet")
  private Integer invoiceSheet = null;

  @JsonProperty("createUser")
  private String createUser = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("billSeq")
  private Long billSeq = null;

  @JsonProperty("deleteUserId")
  private Long deleteUserId = null;

  @JsonProperty("deleteUser")
  private String deleteUser = null;

  @JsonProperty("deleteTime")
  private Long deleteTime = null;

  @JsonProperty("deleteType")
  private Integer deleteType = null;

  @JsonProperty("deleteMessage")
  private String deleteMessage = null;

  @JsonIgnore
  public SmInvoiceDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public SmInvoiceDTO fileId(Long fileId) {
    this.fileId = fileId;
    return this;
  }

   /**
   * rec_file表id
   * @return fileId
  **/
  @ApiModelProperty(value = "rec_file表id")
  public Long getFileId() {
    return fileId;
  }

  public void setFileId(Long fileId) {
    this.fileId = fileId;
  }

  @JsonIgnore
  public SmInvoiceDTO orderCode(String orderCode) {
    this.orderCode = orderCode;
    return this;
  }

   /**
   * 业务单据编码
   * @return orderCode
  **/
  @ApiModelProperty(value = "业务单据编码")
  public String getOrderCode() {
    return orderCode;
  }

  public void setOrderCode(String orderCode) {
    this.orderCode = orderCode;
  }

  @JsonIgnore
  public SmInvoiceDTO billCode(String billCode) {
    this.billCode = billCode;
    return this;
  }

   /**
   * 发票代码
   * @return billCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getBillCode() {
    return billCode;
  }

  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }

  @JsonIgnore
  public SmInvoiceDTO billCodePrn(String billCodePrn) {
    this.billCodePrn = billCodePrn;
    return this;
  }

   /**
   * 印刷发票代码
   * @return billCodePrn
  **/
  @ApiModelProperty(value = "印刷发票代码")
  public String getBillCodePrn() {
    return billCodePrn;
  }

  public void setBillCodePrn(String billCodePrn) {
    this.billCodePrn = billCodePrn;
  }

  @JsonIgnore
  public SmInvoiceDTO billNumber(String billNumber) {
    this.billNumber = billNumber;
    return this;
  }

   /**
   * 发票号码
   * @return billNumber
  **/
  @ApiModelProperty(value = "发票号码")
  public String getBillNumber() {
    return billNumber;
  }

  public void setBillNumber(String billNumber) {
    this.billNumber = billNumber;
  }

  @JsonIgnore
  public SmInvoiceDTO billNumberPrn(String billNumberPrn) {
    this.billNumberPrn = billNumberPrn;
    return this;
  }

   /**
   * 印刷发票号码
   * @return billNumberPrn
  **/
  @ApiModelProperty(value = "印刷发票号码")
  public String getBillNumberPrn() {
    return billNumberPrn;
  }

  public void setBillNumberPrn(String billNumberPrn) {
    this.billNumberPrn = billNumberPrn;
  }

  @JsonIgnore
  public SmInvoiceDTO purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public SmInvoiceDTO sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public SmInvoiceDTO createBillTime(Long createBillTime) {
    this.createBillTime = createBillTime;
    return this;
  }

   /**
   * 开票日期
   * @return createBillTime
  **/
  @ApiModelProperty(value = "开票日期")
  public Long getCreateBillTime() {
    return createBillTime;
  }

  public void setCreateBillTime(Long createBillTime) {
    this.createBillTime = createBillTime;
  }

  @JsonIgnore
  public SmInvoiceDTO notContainTaxAmount(BigDecimal notContainTaxAmount) {
    this.notContainTaxAmount = notContainTaxAmount;
    return this;
  }

   /**
   * 不含税金额
   * @return notContainTaxAmount
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getNotContainTaxAmount() {
    return notContainTaxAmount;
  }

  public void setNotContainTaxAmount(BigDecimal notContainTaxAmount) {
    this.notContainTaxAmount = notContainTaxAmount;
  }

  @JsonIgnore
  public SmInvoiceDTO taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public SmInvoiceDTO containTaxAmount(BigDecimal containTaxAmount) {
    this.containTaxAmount = containTaxAmount;
    return this;
  }

   /**
   * 含税金额
   * @return containTaxAmount
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getContainTaxAmount() {
    return containTaxAmount;
  }

  public void setContainTaxAmount(BigDecimal containTaxAmount) {
    this.containTaxAmount = containTaxAmount;
  }

  @JsonIgnore
  public SmInvoiceDTO invoiceScanId(String invoiceScanId) {
    this.invoiceScanId = invoiceScanId;
    return this;
  }

   /**
   * 扫描id
   * @return invoiceScanId
  **/
  @ApiModelProperty(value = "扫描id")
  public String getInvoiceScanId() {
    return invoiceScanId;
  }

  public void setInvoiceScanId(String invoiceScanId) {
    this.invoiceScanId = invoiceScanId;
  }

  @JsonIgnore
  public SmInvoiceDTO invoiceScanTime(Long invoiceScanTime) {
    this.invoiceScanTime = invoiceScanTime;
    return this;
  }

   /**
   * 发票扫描时间
   * @return invoiceScanTime
  **/
  @ApiModelProperty(value = "发票扫描时间")
  public Long getInvoiceScanTime() {
    return invoiceScanTime;
  }

  public void setInvoiceScanTime(Long invoiceScanTime) {
    this.invoiceScanTime = invoiceScanTime;
  }

  @JsonIgnore
  public SmInvoiceDTO fpzt(Integer fpzt) {
    this.fpzt = fpzt;
    return this;
  }

   /**
   * 发票状态：1-正常，2-删除，3-作废
   * @return fpzt
  **/
  @ApiModelProperty(value = "发票状态：1-正常，2-删除，3-作废")
  public Integer getFpzt() {
    return fpzt;
  }

  public void setFpzt(Integer fpzt) {
    this.fpzt = fpzt;
  }

  @JsonIgnore
  public SmInvoiceDTO syncTime(Long syncTime) {
    this.syncTime = syncTime;
    return this;
  }

   /**
   * 同步时间
   * @return syncTime
  **/
  @ApiModelProperty(value = "同步时间")
  public Long getSyncTime() {
    return syncTime;
  }

  public void setSyncTime(Long syncTime) {
    this.syncTime = syncTime;
  }

  @JsonIgnore
  public SmInvoiceDTO invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型：s-增值税专用发票，c-增值税普通发票，ce-增值税电子普通发票，ju-增值税普通发票（卷票），ct-通行费增值税电子普通发票，v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型：s-增值税专用发票，c-增值税普通发票，ce-增值税电子普通发票，ju-增值税普通发票（卷票），ct-通行费增值税电子普通发票，v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public SmInvoiceDTO invoiceQrcode(String invoiceQrcode) {
    this.invoiceQrcode = invoiceQrcode;
    return this;
  }

   /**
   * null
   * @return invoiceQrcode
  **/
  @ApiModelProperty(value = "null")
  public String getInvoiceQrcode() {
    return invoiceQrcode;
  }

  public void setInvoiceQrcode(String invoiceQrcode) {
    this.invoiceQrcode = invoiceQrcode;
  }

  @JsonIgnore
  public SmInvoiceDTO passArea(String passArea) {
    this.passArea = passArea;
    return this;
  }

   /**
   * 发票密文
   * @return passArea
  **/
  @ApiModelProperty(value = "发票密文")
  public String getPassArea() {
    return passArea;
  }

  public void setPassArea(String passArea) {
    this.passArea = passArea;
  }

  @JsonIgnore
  public SmInvoiceDTO invoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * null
   * @return invoiceId
  **/
  @ApiModelProperty(value = "null")
  public String getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public SmInvoiceDTO createBillTimestr(String createBillTimestr) {
    this.createBillTimestr = createBillTimestr;
    return this;
  }

   /**
   * 开票日期字符串
   * @return createBillTimestr
  **/
  @ApiModelProperty(value = "开票日期字符串")
  public String getCreateBillTimestr() {
    return createBillTimestr;
  }

  public void setCreateBillTimestr(String createBillTimestr) {
    this.createBillTimestr = createBillTimestr;
  }

  @JsonIgnore
  public SmInvoiceDTO scanBatchNo(String scanBatchNo) {
    this.scanBatchNo = scanBatchNo;
    return this;
  }

   /**
   * 扫描批次号
   * @return scanBatchNo
  **/
  @ApiModelProperty(value = "扫描批次号")
  public String getScanBatchNo() {
    return scanBatchNo;
  }

  public void setScanBatchNo(String scanBatchNo) {
    this.scanBatchNo = scanBatchNo;
  }

  @JsonIgnore
  public SmInvoiceDTO cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 是否协同：0-非协同，1-协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "是否协同：0-非协同，1-协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public SmInvoiceDTO sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public SmInvoiceDTO sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public SmInvoiceDTO sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public SmInvoiceDTO sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行卡号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行卡号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public SmInvoiceDTO purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public SmInvoiceDTO purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public SmInvoiceDTO purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public SmInvoiceDTO purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行卡号
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行卡号")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public SmInvoiceDTO taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public SmInvoiceDTO remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public SmInvoiceDTO chargeTaxUnitCode(String chargeTaxUnitCode) {
    this.chargeTaxUnitCode = chargeTaxUnitCode;
    return this;
  }

   /**
   * null
   * @return chargeTaxUnitCode
  **/
  @ApiModelProperty(value = "null")
  public String getChargeTaxUnitCode() {
    return chargeTaxUnitCode;
  }

  public void setChargeTaxUnitCode(String chargeTaxUnitCode) {
    this.chargeTaxUnitCode = chargeTaxUnitCode;
  }

  @JsonIgnore
  public SmInvoiceDTO twoCodeFlag(String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
    return this;
  }

   /**
   * null
   * @return twoCodeFlag
  **/
  @ApiModelProperty(value = "null")
  public String getTwoCodeFlag() {
    return twoCodeFlag;
  }

  public void setTwoCodeFlag(String twoCodeFlag) {
    this.twoCodeFlag = twoCodeFlag;
  }

  @JsonIgnore
  public SmInvoiceDTO chargeTaxUnitName(String chargeTaxUnitName) {
    this.chargeTaxUnitName = chargeTaxUnitName;
    return this;
  }

   /**
   * null
   * @return chargeTaxUnitName
  **/
  @ApiModelProperty(value = "null")
  public String getChargeTaxUnitName() {
    return chargeTaxUnitName;
  }

  public void setChargeTaxUnitName(String chargeTaxUnitName) {
    this.chargeTaxUnitName = chargeTaxUnitName;
  }

  @JsonIgnore
  public SmInvoiceDTO cloudIdentifyFlag(Integer cloudIdentifyFlag) {
    this.cloudIdentifyFlag = cloudIdentifyFlag;
    return this;
  }

   /**
   * null
   * @return cloudIdentifyFlag
  **/
  @ApiModelProperty(value = "null")
  public Integer getCloudIdentifyFlag() {
    return cloudIdentifyFlag;
  }

  public void setCloudIdentifyFlag(Integer cloudIdentifyFlag) {
    this.cloudIdentifyFlag = cloudIdentifyFlag;
  }

  @JsonIgnore
  public SmInvoiceDTO cloudIdentifyRemark(String cloudIdentifyRemark) {
    this.cloudIdentifyRemark = cloudIdentifyRemark;
    return this;
  }

   /**
   * null
   * @return cloudIdentifyRemark
  **/
  @ApiModelProperty(value = "null")
  public String getCloudIdentifyRemark() {
    return cloudIdentifyRemark;
  }

  public void setCloudIdentifyRemark(String cloudIdentifyRemark) {
    this.cloudIdentifyRemark = cloudIdentifyRemark;
  }

  @JsonIgnore
  public SmInvoiceDTO machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public SmInvoiceDTO sourceSystem(String sourceSystem) {
    this.sourceSystem = sourceSystem;
    return this;
  }

   /**
   * 来源系统：GX|XYJ
   * @return sourceSystem
  **/
  @ApiModelProperty(value = "来源系统：GX|XYJ")
  public String getSourceSystem() {
    return sourceSystem;
  }

  public void setSourceSystem(String sourceSystem) {
    this.sourceSystem = sourceSystem;
  }

  @JsonIgnore
  public SmInvoiceDTO purchaseName(String purchaseName) {
    this.purchaseName = purchaseName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaseName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaseName() {
    return purchaseName;
  }

  public void setPurchaseName(String purchaseName) {
    this.purchaseName = purchaseName;
  }

  @JsonIgnore
  public SmInvoiceDTO sellerTaxName(String sellerTaxName) {
    this.sellerTaxName = sellerTaxName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerTaxName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerTaxName() {
    return sellerTaxName;
  }

  public void setSellerTaxName(String sellerTaxName) {
    this.sellerTaxName = sellerTaxName;
  }

  @JsonIgnore
  public SmInvoiceDTO cooperationSerialNo(String cooperationSerialNo) {
    this.cooperationSerialNo = cooperationSerialNo;
    return this;
  }

   /**
   * 扫描协同序列号
   * @return cooperationSerialNo
  **/
  @ApiModelProperty(value = "扫描协同序列号")
  public String getCooperationSerialNo() {
    return cooperationSerialNo;
  }

  public void setCooperationSerialNo(String cooperationSerialNo) {
    this.cooperationSerialNo = cooperationSerialNo;
  }

  @JsonIgnore
  public SmInvoiceDTO isPushImgDelXYJ(Integer isPushImgDelXYJ) {
    this.isPushImgDelXYJ = isPushImgDelXYJ;
    return this;
  }

   /**
   * 影像删除是否推送至喜盈佳：0-未推送,1-已推送
   * @return isPushImgDelXYJ
  **/
  @ApiModelProperty(value = "影像删除是否推送至喜盈佳：0-未推送,1-已推送")
  public Integer getIsPushImgDelXYJ() {
    return isPushImgDelXYJ;
  }

  public void setIsPushImgDelXYJ(Integer isPushImgDelXYJ) {
    this.isPushImgDelXYJ = isPushImgDelXYJ;
  }

  @JsonIgnore
  public SmInvoiceDTO originInvoiceId(String originInvoiceId) {
    this.originInvoiceId = originInvoiceId;
    return this;
  }

   /**
   * null
   * @return originInvoiceId
  **/
  @ApiModelProperty(value = "null")
  public String getOriginInvoiceId() {
    return originInvoiceId;
  }

  public void setOriginInvoiceId(String originInvoiceId) {
    this.originInvoiceId = originInvoiceId;
  }

  @JsonIgnore
  public SmInvoiceDTO isPushImgUpdateXYJ(Integer isPushImgUpdateXYJ) {
    this.isPushImgUpdateXYJ = isPushImgUpdateXYJ;
    return this;
  }

   /**
   * 影像更新是否推送至喜盈佳 0 未推送 1 已推送
   * @return isPushImgUpdateXYJ
  **/
  @ApiModelProperty(value = "影像更新是否推送至喜盈佳 0 未推送 1 已推送")
  public Integer getIsPushImgUpdateXYJ() {
    return isPushImgUpdateXYJ;
  }

  public void setIsPushImgUpdateXYJ(Integer isPushImgUpdateXYJ) {
    this.isPushImgUpdateXYJ = isPushImgUpdateXYJ;
  }

  @JsonIgnore
  public SmInvoiceDTO isPushImgUpdateDate(Long isPushImgUpdateDate) {
    this.isPushImgUpdateDate = isPushImgUpdateDate;
    return this;
  }

   /**
   * 更新推送时间
   * @return isPushImgUpdateDate
  **/
  @ApiModelProperty(value = "更新推送时间")
  public Long getIsPushImgUpdateDate() {
    return isPushImgUpdateDate;
  }

  public void setIsPushImgUpdateDate(Long isPushImgUpdateDate) {
    this.isPushImgUpdateDate = isPushImgUpdateDate;
  }

  @JsonIgnore
  public SmInvoiceDTO checkStatus(String checkStatus) {
    this.checkStatus = checkStatus;
    return this;
  }

   /**
   * 验真状态：1-失败，0-成功
   * @return checkStatus
  **/
  @ApiModelProperty(value = "验真状态：1-失败，0-成功")
  public String getCheckStatus() {
    return checkStatus;
  }

  public void setCheckStatus(String checkStatus) {
    this.checkStatus = checkStatus;
  }

  @JsonIgnore
  public SmInvoiceDTO invoiceSource(String invoiceSource) {
    this.invoiceSource = invoiceSource;
    return this;
  }

   /**
   * 发票扫描来源：1-手机拍照，2-扫描仪，3-单多啦，4-其他
   * @return invoiceSource
  **/
  @ApiModelProperty(value = "发票扫描来源：1-手机拍照，2-扫描仪，3-单多啦，4-其他")
  public String getInvoiceSource() {
    return invoiceSource;
  }

  public void setInvoiceSource(String invoiceSource) {
    this.invoiceSource = invoiceSource;
  }

  @JsonIgnore
  public SmInvoiceDTO checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public SmInvoiceDTO containTaxAmountChn(String containTaxAmountChn) {
    this.containTaxAmountChn = containTaxAmountChn;
    return this;
  }

   /**
   * 含税金额大写
   * @return containTaxAmountChn
  **/
  @ApiModelProperty(value = "含税金额大写")
  public String getContainTaxAmountChn() {
    return containTaxAmountChn;
  }

  public void setContainTaxAmountChn(String containTaxAmountChn) {
    this.containTaxAmountChn = containTaxAmountChn;
  }

  @JsonIgnore
  public SmInvoiceDTO submitStatus(Integer submitStatus) {
    this.submitStatus = submitStatus;
    return this;
  }

   /**
   * 发票提交返回状态1-成功，2-失败，3-提交中，0-空/提交准备中
   * @return submitStatus
  **/
  @ApiModelProperty(value = "发票提交返回状态1-成功，2-失败，3-提交中，0-空/提交准备中")
  public Integer getSubmitStatus() {
    return submitStatus;
  }

  public void setSubmitStatus(Integer submitStatus) {
    this.submitStatus = submitStatus;
  }

  @JsonIgnore
  public SmInvoiceDTO submitInfo(String submitInfo) {
    this.submitInfo = submitInfo;
    return this;
  }

   /**
   * 发票提交返回信息
   * @return submitInfo
  **/
  @ApiModelProperty(value = "发票提交返回信息")
  public String getSubmitInfo() {
    return submitInfo;
  }

  public void setSubmitInfo(String submitInfo) {
    this.submitInfo = submitInfo;
  }

  @JsonIgnore
  public SmInvoiceDTO specialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
    return this;
  }

   /**
   * 特殊发票标记：0-默认，1-通行费，2-成品油
   * @return specialInvoiceFlag
  **/
  @ApiModelProperty(value = "特殊发票标记：0-默认，1-通行费，2-成品油")
  public Integer getSpecialInvoiceFlag() {
    return specialInvoiceFlag;
  }

  public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
  }

  @JsonIgnore
  public SmInvoiceDTO payee(String payee) {
    this.payee = payee;
    return this;
  }

   /**
   * 收款人
   * @return payee
  **/
  @ApiModelProperty(value = "收款人")
  public String getPayee() {
    return payee;
  }

  public void setPayee(String payee) {
    this.payee = payee;
  }

  @JsonIgnore
  public SmInvoiceDTO reviewer(String reviewer) {
    this.reviewer = reviewer;
    return this;
  }

   /**
   * 复核人
   * @return reviewer
  **/
  @ApiModelProperty(value = "复核人")
  public String getReviewer() {
    return reviewer;
  }

  public void setReviewer(String reviewer) {
    this.reviewer = reviewer;
  }

  @JsonIgnore
  public SmInvoiceDTO drawer(String drawer) {
    this.drawer = drawer;
    return this;
  }

   /**
   * 开票人
   * @return drawer
  **/
  @ApiModelProperty(value = "开票人")
  public String getDrawer() {
    return drawer;
  }

  public void setDrawer(String drawer) {
    this.drawer = drawer;
  }

  @JsonIgnore
  public SmInvoiceDTO sourceId(String sourceId) {
    this.sourceId = sourceId;
    return this;
  }

   /**
   * 来源id
   * @return sourceId
  **/
  @ApiModelProperty(value = "来源id")
  public String getSourceId() {
    return sourceId;
  }

  public void setSourceId(String sourceId) {
    this.sourceId = sourceId;
  }

  @JsonIgnore
  public SmInvoiceDTO isBackScan(Integer isBackScan) {
    this.isBackScan = isBackScan;
    return this;
  }

   /**
   * 是否退扫：0-否，1-是
   * @return isBackScan
  **/
  @ApiModelProperty(value = "是否退扫：0-否，1-是")
  public Integer getIsBackScan() {
    return isBackScan;
  }

  public void setIsBackScan(Integer isBackScan) {
    this.isBackScan = isBackScan;
  }

  @JsonIgnore
  public SmInvoiceDTO warningInfo(String warningInfo) {
    this.warningInfo = warningInfo;
    return this;
  }

   /**
   * 预警信息
   * @return warningInfo
  **/
  @ApiModelProperty(value = "预警信息")
  public String getWarningInfo() {
    return warningInfo;
  }

  public void setWarningInfo(String warningInfo) {
    this.warningInfo = warningInfo;
  }

  @JsonIgnore
  public SmInvoiceDTO invoiceSheet(Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
    return this;
  }

   /**
   * 发票联次：1-发票联，2-抵扣联
   * @return invoiceSheet
  **/
  @ApiModelProperty(value = "发票联次：1-发票联，2-抵扣联")
  public Integer getInvoiceSheet() {
    return invoiceSheet;
  }

  public void setInvoiceSheet(Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
  }

  @JsonIgnore
  public SmInvoiceDTO createUser(String createUser) {
    this.createUser = createUser;
    return this;
  }

   /**
   * 创建用户名
   * @return createUser
  **/
  @ApiModelProperty(value = "创建用户名")
  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  @JsonIgnore
  public SmInvoiceDTO createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建账号
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建账号")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public SmInvoiceDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public SmInvoiceDTO billSeq(Long billSeq) {
    this.billSeq = billSeq;
    return this;
  }

   /**
   * 单据序列，0代表空
   * @return billSeq
  **/
  @ApiModelProperty(value = "单据序列，0代表空")
  public Long getBillSeq() {
    return billSeq;
  }

  public void setBillSeq(Long billSeq) {
    this.billSeq = billSeq;
  }

  @JsonIgnore
  public SmInvoiceDTO deleteUserId(Long deleteUserId) {
    this.deleteUserId = deleteUserId;
    return this;
  }

   /**
   * 删除操作人id
   * @return deleteUserId
  **/
  @ApiModelProperty(value = "删除操作人id")
  public Long getDeleteUserId() {
    return deleteUserId;
  }

  public void setDeleteUserId(Long deleteUserId) {
    this.deleteUserId = deleteUserId;
  }

  @JsonIgnore
  public SmInvoiceDTO deleteUser(String deleteUser) {
    this.deleteUser = deleteUser;
    return this;
  }

   /**
   * 删除操作人
   * @return deleteUser
  **/
  @ApiModelProperty(value = "删除操作人")
  public String getDeleteUser() {
    return deleteUser;
  }

  public void setDeleteUser(String deleteUser) {
    this.deleteUser = deleteUser;
  }

  @JsonIgnore
  public SmInvoiceDTO deleteTime(Long deleteTime) {
    this.deleteTime = deleteTime;
    return this;
  }

   /**
   * 删除时间
   * @return deleteTime
  **/
  @ApiModelProperty(value = "删除时间")
  public Long getDeleteTime() {
    return deleteTime;
  }

  public void setDeleteTime(Long deleteTime) {
    this.deleteTime = deleteTime;
  }

  @JsonIgnore
  public SmInvoiceDTO deleteType(Integer deleteType) {
    this.deleteType = deleteType;
    return this;
  }

   /**
   * 1、发票类型开错2、无纸化附件里含有敏感内容，需作废3、公司名称开错4、产值被驳回5、产值单缺少附件6、产值单含敏感信息需作废7、与预制发票不一致8、其他
   * @return deleteType
  **/
  @ApiModelProperty(value = "1、发票类型开错2、无纸化附件里含有敏感内容，需作废3、公司名称开错4、产值被驳回5、产值单缺少附件6、产值单含敏感信息需作废7、与预制发票不一致8、其他")
  public Integer getDeleteType() {
    return deleteType;
  }

  public void setDeleteType(Integer deleteType) {
    this.deleteType = deleteType;
  }

  @JsonIgnore
  public SmInvoiceDTO deleteMessage(String deleteMessage) {
    this.deleteMessage = deleteMessage;
    return this;
  }

   /**
   * 其他-删除原因
   * @return deleteMessage
  **/
  @ApiModelProperty(value = "其他-删除原因")
  public String getDeleteMessage() {
    return deleteMessage;
  }

  public void setDeleteMessage(String deleteMessage) {
    this.deleteMessage = deleteMessage;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmInvoiceDTO smInvoiceDTO = (SmInvoiceDTO) o;
    return Objects.equals(this.id, smInvoiceDTO.id) &&
        Objects.equals(this.fileId, smInvoiceDTO.fileId) &&
        Objects.equals(this.orderCode, smInvoiceDTO.orderCode) &&
        Objects.equals(this.billCode, smInvoiceDTO.billCode) &&
        Objects.equals(this.billCodePrn, smInvoiceDTO.billCodePrn) &&
        Objects.equals(this.billNumber, smInvoiceDTO.billNumber) &&
        Objects.equals(this.billNumberPrn, smInvoiceDTO.billNumberPrn) &&
        Objects.equals(this.purchaserTaxNo, smInvoiceDTO.purchaserTaxNo) &&
        Objects.equals(this.sellerTaxNo, smInvoiceDTO.sellerTaxNo) &&
        Objects.equals(this.createBillTime, smInvoiceDTO.createBillTime) &&
        Objects.equals(this.notContainTaxAmount, smInvoiceDTO.notContainTaxAmount) &&
        Objects.equals(this.taxAmount, smInvoiceDTO.taxAmount) &&
        Objects.equals(this.containTaxAmount, smInvoiceDTO.containTaxAmount) &&
        Objects.equals(this.invoiceScanId, smInvoiceDTO.invoiceScanId) &&
        Objects.equals(this.invoiceScanTime, smInvoiceDTO.invoiceScanTime) &&
        Objects.equals(this.fpzt, smInvoiceDTO.fpzt) &&
        Objects.equals(this.syncTime, smInvoiceDTO.syncTime) &&
        Objects.equals(this.invoiceType, smInvoiceDTO.invoiceType) &&
        Objects.equals(this.invoiceQrcode, smInvoiceDTO.invoiceQrcode) &&
        Objects.equals(this.passArea, smInvoiceDTO.passArea) &&
        Objects.equals(this.invoiceId, smInvoiceDTO.invoiceId) &&
        Objects.equals(this.createBillTimestr, smInvoiceDTO.createBillTimestr) &&
        Objects.equals(this.scanBatchNo, smInvoiceDTO.scanBatchNo) &&
        Objects.equals(this.cooperateFlag, smInvoiceDTO.cooperateFlag) &&
        Objects.equals(this.sellerTel, smInvoiceDTO.sellerTel) &&
        Objects.equals(this.sellerAddress, smInvoiceDTO.sellerAddress) &&
        Objects.equals(this.sellerBankName, smInvoiceDTO.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, smInvoiceDTO.sellerBankAccount) &&
        Objects.equals(this.purchaserTel, smInvoiceDTO.purchaserTel) &&
        Objects.equals(this.purchaserAddress, smInvoiceDTO.purchaserAddress) &&
        Objects.equals(this.purchaserBankAccount, smInvoiceDTO.purchaserBankAccount) &&
        Objects.equals(this.purchaserBankName, smInvoiceDTO.purchaserBankName) &&
        Objects.equals(this.taxRate, smInvoiceDTO.taxRate) &&
        Objects.equals(this.remark, smInvoiceDTO.remark) &&
        Objects.equals(this.chargeTaxUnitCode, smInvoiceDTO.chargeTaxUnitCode) &&
        Objects.equals(this.twoCodeFlag, smInvoiceDTO.twoCodeFlag) &&
        Objects.equals(this.chargeTaxUnitName, smInvoiceDTO.chargeTaxUnitName) &&
        Objects.equals(this.cloudIdentifyFlag, smInvoiceDTO.cloudIdentifyFlag) &&
        Objects.equals(this.cloudIdentifyRemark, smInvoiceDTO.cloudIdentifyRemark) &&
        Objects.equals(this.machineCode, smInvoiceDTO.machineCode) &&
        Objects.equals(this.sourceSystem, smInvoiceDTO.sourceSystem) &&
        Objects.equals(this.purchaseName, smInvoiceDTO.purchaseName) &&
        Objects.equals(this.sellerTaxName, smInvoiceDTO.sellerTaxName) &&
        Objects.equals(this.cooperationSerialNo, smInvoiceDTO.cooperationSerialNo) &&
        Objects.equals(this.isPushImgDelXYJ, smInvoiceDTO.isPushImgDelXYJ) &&
        Objects.equals(this.originInvoiceId, smInvoiceDTO.originInvoiceId) &&
        Objects.equals(this.isPushImgUpdateXYJ, smInvoiceDTO.isPushImgUpdateXYJ) &&
        Objects.equals(this.isPushImgUpdateDate, smInvoiceDTO.isPushImgUpdateDate) &&
        Objects.equals(this.checkStatus, smInvoiceDTO.checkStatus) &&
        Objects.equals(this.invoiceSource, smInvoiceDTO.invoiceSource) &&
        Objects.equals(this.checkCode, smInvoiceDTO.checkCode) &&
        Objects.equals(this.containTaxAmountChn, smInvoiceDTO.containTaxAmountChn) &&
        Objects.equals(this.submitStatus, smInvoiceDTO.submitStatus) &&
        Objects.equals(this.submitInfo, smInvoiceDTO.submitInfo) &&
        Objects.equals(this.specialInvoiceFlag, smInvoiceDTO.specialInvoiceFlag) &&
        Objects.equals(this.payee, smInvoiceDTO.payee) &&
        Objects.equals(this.reviewer, smInvoiceDTO.reviewer) &&
        Objects.equals(this.drawer, smInvoiceDTO.drawer) &&
        Objects.equals(this.sourceId, smInvoiceDTO.sourceId) &&
        Objects.equals(this.isBackScan, smInvoiceDTO.isBackScan) &&
        Objects.equals(this.warningInfo, smInvoiceDTO.warningInfo) &&
        Objects.equals(this.invoiceSheet, smInvoiceDTO.invoiceSheet) &&
        Objects.equals(this.createUser, smInvoiceDTO.createUser) &&
        Objects.equals(this.createUserId, smInvoiceDTO.createUserId) &&
        Objects.equals(this.createTime, smInvoiceDTO.createTime) &&
        Objects.equals(this.billSeq, smInvoiceDTO.billSeq) &&
        Objects.equals(this.deleteUserId, smInvoiceDTO.deleteUserId) &&
        Objects.equals(this.deleteUser, smInvoiceDTO.deleteUser) &&
        Objects.equals(this.deleteTime, smInvoiceDTO.deleteTime) &&
        Objects.equals(this.deleteType, smInvoiceDTO.deleteType) &&
        Objects.equals(this.deleteMessage, smInvoiceDTO.deleteMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, fileId, orderCode, billCode, billCodePrn, billNumber, billNumberPrn, purchaserTaxNo, sellerTaxNo, createBillTime, notContainTaxAmount, taxAmount, containTaxAmount, invoiceScanId, invoiceScanTime, fpzt, syncTime, invoiceType, invoiceQrcode, passArea, invoiceId, createBillTimestr, scanBatchNo, cooperateFlag, sellerTel, sellerAddress, sellerBankName, sellerBankAccount, purchaserTel, purchaserAddress, purchaserBankAccount, purchaserBankName, taxRate, remark, chargeTaxUnitCode, twoCodeFlag, chargeTaxUnitName, cloudIdentifyFlag, cloudIdentifyRemark, machineCode, sourceSystem, purchaseName, sellerTaxName, cooperationSerialNo, isPushImgDelXYJ, originInvoiceId, isPushImgUpdateXYJ, isPushImgUpdateDate, checkStatus, invoiceSource, checkCode, containTaxAmountChn, submitStatus, submitInfo, specialInvoiceFlag, payee, reviewer, drawer, sourceId, isBackScan, warningInfo, invoiceSheet, createUser, createUserId, createTime, billSeq, deleteUserId, deleteUser, deleteTime, deleteType, deleteMessage);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmInvoiceDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    fileId: ").append(toIndentedString(fileId)).append("\n");
    sb.append("    orderCode: ").append(toIndentedString(orderCode)).append("\n");
    sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
    sb.append("    billCodePrn: ").append(toIndentedString(billCodePrn)).append("\n");
    sb.append("    billNumber: ").append(toIndentedString(billNumber)).append("\n");
    sb.append("    billNumberPrn: ").append(toIndentedString(billNumberPrn)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    createBillTime: ").append(toIndentedString(createBillTime)).append("\n");
    sb.append("    notContainTaxAmount: ").append(toIndentedString(notContainTaxAmount)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    containTaxAmount: ").append(toIndentedString(containTaxAmount)).append("\n");
    sb.append("    invoiceScanId: ").append(toIndentedString(invoiceScanId)).append("\n");
    sb.append("    invoiceScanTime: ").append(toIndentedString(invoiceScanTime)).append("\n");
    sb.append("    fpzt: ").append(toIndentedString(fpzt)).append("\n");
    sb.append("    syncTime: ").append(toIndentedString(syncTime)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceQrcode: ").append(toIndentedString(invoiceQrcode)).append("\n");
    sb.append("    passArea: ").append(toIndentedString(passArea)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    createBillTimestr: ").append(toIndentedString(createBillTimestr)).append("\n");
    sb.append("    scanBatchNo: ").append(toIndentedString(scanBatchNo)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    chargeTaxUnitCode: ").append(toIndentedString(chargeTaxUnitCode)).append("\n");
    sb.append("    twoCodeFlag: ").append(toIndentedString(twoCodeFlag)).append("\n");
    sb.append("    chargeTaxUnitName: ").append(toIndentedString(chargeTaxUnitName)).append("\n");
    sb.append("    cloudIdentifyFlag: ").append(toIndentedString(cloudIdentifyFlag)).append("\n");
    sb.append("    cloudIdentifyRemark: ").append(toIndentedString(cloudIdentifyRemark)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    sourceSystem: ").append(toIndentedString(sourceSystem)).append("\n");
    sb.append("    purchaseName: ").append(toIndentedString(purchaseName)).append("\n");
    sb.append("    sellerTaxName: ").append(toIndentedString(sellerTaxName)).append("\n");
    sb.append("    cooperationSerialNo: ").append(toIndentedString(cooperationSerialNo)).append("\n");
    sb.append("    isPushImgDelXYJ: ").append(toIndentedString(isPushImgDelXYJ)).append("\n");
    sb.append("    originInvoiceId: ").append(toIndentedString(originInvoiceId)).append("\n");
    sb.append("    isPushImgUpdateXYJ: ").append(toIndentedString(isPushImgUpdateXYJ)).append("\n");
    sb.append("    isPushImgUpdateDate: ").append(toIndentedString(isPushImgUpdateDate)).append("\n");
    sb.append("    checkStatus: ").append(toIndentedString(checkStatus)).append("\n");
    sb.append("    invoiceSource: ").append(toIndentedString(invoiceSource)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    containTaxAmountChn: ").append(toIndentedString(containTaxAmountChn)).append("\n");
    sb.append("    submitStatus: ").append(toIndentedString(submitStatus)).append("\n");
    sb.append("    submitInfo: ").append(toIndentedString(submitInfo)).append("\n");
    sb.append("    specialInvoiceFlag: ").append(toIndentedString(specialInvoiceFlag)).append("\n");
    sb.append("    payee: ").append(toIndentedString(payee)).append("\n");
    sb.append("    reviewer: ").append(toIndentedString(reviewer)).append("\n");
    sb.append("    drawer: ").append(toIndentedString(drawer)).append("\n");
    sb.append("    sourceId: ").append(toIndentedString(sourceId)).append("\n");
    sb.append("    isBackScan: ").append(toIndentedString(isBackScan)).append("\n");
    sb.append("    warningInfo: ").append(toIndentedString(warningInfo)).append("\n");
    sb.append("    invoiceSheet: ").append(toIndentedString(invoiceSheet)).append("\n");
    sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    billSeq: ").append(toIndentedString(billSeq)).append("\n");
    sb.append("    deleteUserId: ").append(toIndentedString(deleteUserId)).append("\n");
    sb.append("    deleteUser: ").append(toIndentedString(deleteUser)).append("\n");
    sb.append("    deleteTime: ").append(toIndentedString(deleteTime)).append("\n");
    sb.append("    deleteType: ").append(toIndentedString(deleteType)).append("\n");
    sb.append("    deleteMessage: ").append(toIndentedString(deleteMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
