package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 提交包裹明细
 */
@ApiModel(description = "提交包裹明细")

@JsonInclude(NON_NULL)
public class SubmitParcelsItem {
  @JsonProperty("goodsKey")
  private List<Long> goodsKey = new ArrayList<Long>();

  @JsonProperty("expressName")
  private String expressName = null;

  @JsonProperty("expressCode")
  private String expressCode = null;

  @JsonProperty("waybillNo")
  private String waybillNo = null;

  @JsonProperty("expressType")
  private Integer expressType = null;

  @JsonProperty("receiverName")
  private String receiverName = null;

  @JsonProperty("receiverTel")
  private String receiverTel = null;

  @JsonProperty("receiverAddr")
  private String receiverAddr = null;

  @JsonIgnore
  public SubmitParcelsItem goodsKey(List<Long> goodsKey) {
    this.goodsKey = goodsKey;
    return this;
  }

  public SubmitParcelsItem addGoodsKeyItem(Long goodsKeyItem) {
    this.goodsKey.add(goodsKeyItem);
    return this;
  }

   /**
   * 每个物品的主键
   * @return goodsKey
  **/
  @ApiModelProperty(value = "每个物品的主键")
  public List<Long> getGoodsKey() {
    return goodsKey;
  }

  public void setGoodsKey(List<Long> goodsKey) {
    this.goodsKey = goodsKey;
  }

  @JsonIgnore
  public SubmitParcelsItem expressName(String expressName) {
    this.expressName = expressName;
    return this;
  }

   /**
   * 快递公司名称
   * @return expressName
  **/
  @ApiModelProperty(value = "快递公司名称")
  public String getExpressName() {
    return expressName;
  }

  public void setExpressName(String expressName) {
    this.expressName = expressName;
  }

  @JsonIgnore
  public SubmitParcelsItem expressCode(String expressCode) {
    this.expressCode = expressCode;
    return this;
  }

   /**
   * 快递公司代码
   * @return expressCode
  **/
  @ApiModelProperty(value = "快递公司代码")
  public String getExpressCode() {
    return expressCode;
  }

  public void setExpressCode(String expressCode) {
    this.expressCode = expressCode;
  }

  @JsonIgnore
  public SubmitParcelsItem waybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
    return this;
  }

   /**
   * 运单号
   * @return waybillNo
  **/
  @ApiModelProperty(value = "运单号")
  public String getWaybillNo() {
    return waybillNo;
  }

  public void setWaybillNo(String waybillNo) {
    this.waybillNo = waybillNo;
  }

  @JsonIgnore
  public SubmitParcelsItem expressType(Integer expressType) {
    this.expressType = expressType;
    return this;
  }

   /**
   * 寄送方式(1-在线下单，2-自己联系物流)
   * @return expressType
  **/
  @ApiModelProperty(value = "寄送方式(1-在线下单，2-自己联系物流)")
  public Integer getExpressType() {
    return expressType;
  }

  public void setExpressType(Integer expressType) {
    this.expressType = expressType;
  }

  @JsonIgnore
  public SubmitParcelsItem receiverName(String receiverName) {
    this.receiverName = receiverName;
    return this;
  }

   /**
   * 收件方名称
   * @return receiverName
  **/
  @ApiModelProperty(value = "收件方名称")
  public String getReceiverName() {
    return receiverName;
  }

  public void setReceiverName(String receiverName) {
    this.receiverName = receiverName;
  }

  @JsonIgnore
  public SubmitParcelsItem receiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
    return this;
  }

   /**
   * 收件方联系电话
   * @return receiverTel
  **/
  @ApiModelProperty(value = "收件方联系电话")
  public String getReceiverTel() {
    return receiverTel;
  }

  public void setReceiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
  }

  @JsonIgnore
  public SubmitParcelsItem receiverAddr(String receiverAddr) {
    this.receiverAddr = receiverAddr;
    return this;
  }

   /**
   * 收件地址
   * @return receiverAddr
  **/
  @ApiModelProperty(value = "收件地址")
  public String getReceiverAddr() {
    return receiverAddr;
  }

  public void setReceiverAddr(String receiverAddr) {
    this.receiverAddr = receiverAddr;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubmitParcelsItem submitParcelsItem = (SubmitParcelsItem) o;
    return Objects.equals(this.goodsKey, submitParcelsItem.goodsKey) &&
        Objects.equals(this.expressName, submitParcelsItem.expressName) &&
        Objects.equals(this.expressCode, submitParcelsItem.expressCode) &&
        Objects.equals(this.waybillNo, submitParcelsItem.waybillNo) &&
        Objects.equals(this.expressType, submitParcelsItem.expressType) &&
        Objects.equals(this.receiverName, submitParcelsItem.receiverName) &&
        Objects.equals(this.receiverTel, submitParcelsItem.receiverTel) &&
        Objects.equals(this.receiverAddr, submitParcelsItem.receiverAddr);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsKey, expressName, expressCode, waybillNo, expressType, receiverName, receiverTel, receiverAddr);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubmitParcelsItem {\n");
    
    sb.append("    goodsKey: ").append(toIndentedString(goodsKey)).append("\n");
    sb.append("    expressName: ").append(toIndentedString(expressName)).append("\n");
    sb.append("    expressCode: ").append(toIndentedString(expressCode)).append("\n");
    sb.append("    waybillNo: ").append(toIndentedString(waybillNo)).append("\n");
    sb.append("    expressType: ").append(toIndentedString(expressType)).append("\n");
    sb.append("    receiverName: ").append(toIndentedString(receiverName)).append("\n");
    sb.append("    receiverTel: ").append(toIndentedString(receiverTel)).append("\n");
    sb.append("    receiverAddr: ").append(toIndentedString(receiverAddr)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
