package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.WkInvoiceDetailsDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票明细表Request
 */
@ApiModel(description = "发票明细表Request")

@JsonInclude(NON_NULL)
public class UpdateInvoiceDetailsRequest extends BaseRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("cargoCode")
  private String cargoCode = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("quantity")
  private BigDecimal quantity = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("unitPrice")
  private BigDecimal unitPrice = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("discountWithoutTax")
  private BigDecimal discountWithoutTax = null;

  @JsonProperty("discountRate")
  private String discountRate = null;

  @JsonProperty("discountTax")
  private BigDecimal discountTax = null;

  @JsonProperty("discountWithTax")
  private BigDecimal discountWithTax = null;

  @JsonProperty("taxItem")
  private String taxItem = null;

  @JsonProperty("goodsNoVer")
  private String goodsNoVer = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("goodsErpNo")
  private String goodsErpNo = null;

  @JsonProperty("plateNumber")
  private String plateNumber = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonProperty("tollStartDate")
  private String tollStartDate = null;

  @JsonProperty("tollEndDate")
  private String tollEndDate = null;

  @JsonProperty("taxPreFlag")
  private Integer taxPreFlag = null;

  @JsonProperty("taxPreContent")
  private String taxPreContent = null;

  @JsonProperty("taxRateType")
  private Integer taxRateType = null;

  @JsonProperty("taxDedunction")
  private BigDecimal taxDedunction = null;

  @JsonProperty("discountFlag")
  private Integer discountFlag = null;

  @JsonProperty("priceMethod")
  private Integer priceMethod = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonIgnore
  public UpdateInvoiceDetailsRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票主表ID
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票主表ID")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物及服务名称
   * @return cargoName
  **/
  @ApiModelProperty(value = "货物及服务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest cargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
    return this;
  }

   /**
   * 货物及服务代码
   * @return cargoCode
  **/
  @ApiModelProperty(value = "货物及服务代码")
  public String getCargoCode() {
    return cargoCode;
  }

  public void setCargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 型号规格
   * @return itemSpec
  **/
  @ApiModelProperty(value = "型号规格")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 数量单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "数量单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest quantity(BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest unitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "单价")
  public BigDecimal getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest discountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
    return this;
  }

   /**
   * 不含税折扣金额
   * @return discountWithoutTax
  **/
  @ApiModelProperty(value = "不含税折扣金额")
  public BigDecimal getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest discountRate(String discountRate) {
    this.discountRate = discountRate;
    return this;
  }

   /**
   * 折扣税率
   * @return discountRate
  **/
  @ApiModelProperty(value = "折扣税率")
  public String getDiscountRate() {
    return discountRate;
  }

  public void setDiscountRate(String discountRate) {
    this.discountRate = discountRate;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest discountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
    return this;
  }

   /**
   * 折扣税额
   * @return discountTax
  **/
  @ApiModelProperty(value = "折扣税额")
  public BigDecimal getDiscountTax() {
    return discountTax;
  }

  public void setDiscountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest discountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
    return this;
  }

   /**
   * 含税折扣金额
   * @return discountWithTax
  **/
  @ApiModelProperty(value = "含税折扣金额")
  public BigDecimal getDiscountWithTax() {
    return discountWithTax;
  }

  public void setDiscountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest taxItem(String taxItem) {
    this.taxItem = taxItem;
    return this;
  }

   /**
   * 商品税目
   * @return taxItem
  **/
  @ApiModelProperty(value = "商品税目")
  public String getTaxItem() {
    return taxItem;
  }

  public void setTaxItem(String taxItem) {
    this.taxItem = taxItem;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest goodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
    return this;
  }

   /**
   * 税编版本号
   * @return goodsNoVer
  **/
  @ApiModelProperty(value = "税编版本号")
  public String getGoodsNoVer() {
    return goodsNoVer;
  }

  public void setGoodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest goodsErpNo(String goodsErpNo) {
    this.goodsErpNo = goodsErpNo;
    return this;
  }

   /**
   * 商品编号(ERP)   根据税编+品规去匹配，默认取第一个
   * @return goodsErpNo
  **/
  @ApiModelProperty(value = "商品编号(ERP)   根据税编+品规去匹配，默认取第一个")
  public String getGoodsErpNo() {
    return goodsErpNo;
  }

  public void setGoodsErpNo(String goodsErpNo) {
    this.goodsErpNo = goodsErpNo;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest plateNumber(String plateNumber) {
    this.plateNumber = plateNumber;
    return this;
  }

   /**
   * 车牌号
   * @return plateNumber
  **/
  @ApiModelProperty(value = "车牌号")
  public String getPlateNumber() {
    return plateNumber;
  }

  public void setPlateNumber(String plateNumber) {
    this.plateNumber = plateNumber;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest vehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest tollStartDate(String tollStartDate) {
    this.tollStartDate = tollStartDate;
    return this;
  }

   /**
   * 通行日期起
   * @return tollStartDate
  **/
  @ApiModelProperty(value = "通行日期起")
  public String getTollStartDate() {
    return tollStartDate;
  }

  public void setTollStartDate(String tollStartDate) {
    this.tollStartDate = tollStartDate;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest tollEndDate(String tollEndDate) {
    this.tollEndDate = tollEndDate;
    return this;
  }

   /**
   * 通行日期止
   * @return tollEndDate
  **/
  @ApiModelProperty(value = "通行日期止")
  public String getTollEndDate() {
    return tollEndDate;
  }

  public void setTollEndDate(String tollEndDate) {
    this.tollEndDate = tollEndDate;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest taxPreFlag(Integer taxPreFlag) {
    this.taxPreFlag = taxPreFlag;
    return this;
  }

   /**
   * 税收优惠政策  0-不1-享受
   * @return taxPreFlag
  **/
  @ApiModelProperty(value = "税收优惠政策  0-不1-享受")
  public Integer getTaxPreFlag() {
    return taxPreFlag;
  }

  public void setTaxPreFlag(Integer taxPreFlag) {
    this.taxPreFlag = taxPreFlag;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest taxPreContent(String taxPreContent) {
    this.taxPreContent = taxPreContent;
    return this;
  }

   /**
   * 享受税收优惠政策内容
   * @return taxPreContent
  **/
  @ApiModelProperty(value = "享受税收优惠政策内容")
  public String getTaxPreContent() {
    return taxPreContent;
  }

  public void setTaxPreContent(String taxPreContent) {
    this.taxPreContent = taxPreContent;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest taxRateType(Integer taxRateType) {
    this.taxRateType = taxRateType;
    return this;
  }

   /**
   * 零税率标志  0-非0税率（默认） 1-出口退税  2-免税  3-不征税   4- 普通0税率
   * @return taxRateType
  **/
  @ApiModelProperty(value = "零税率标志  0-非0税率（默认） 1-出口退税  2-免税  3-不征税   4- 普通0税率")
  public Integer getTaxRateType() {
    return taxRateType;
  }

  public void setTaxRateType(Integer taxRateType) {
    this.taxRateType = taxRateType;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest taxDedunction(BigDecimal taxDedunction) {
    this.taxDedunction = taxDedunction;
    return this;
  }

   /**
   * 扣除额
   * @return taxDedunction
  **/
  @ApiModelProperty(value = "扣除额")
  public BigDecimal getTaxDedunction() {
    return taxDedunction;
  }

  public void setTaxDedunction(BigDecimal taxDedunction) {
    this.taxDedunction = taxDedunction;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest discountFlag(Integer discountFlag) {
    this.discountFlag = discountFlag;
    return this;
  }

   /**
   * 折扣行标志  0-默认  1-有折扣
   * @return discountFlag
  **/
  @ApiModelProperty(value = "折扣行标志  0-默认  1-有折扣")
  public Integer getDiscountFlag() {
    return discountFlag;
  }

  public void setDiscountFlag(Integer discountFlag) {
    this.discountFlag = discountFlag;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest priceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 价格方式  0-默认
   * @return priceMethod
  **/
  @ApiModelProperty(value = "价格方式  0-默认")
  public Integer getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public UpdateInvoiceDetailsRequest createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateInvoiceDetailsRequest updateInvoiceDetailsRequest = (UpdateInvoiceDetailsRequest) o;
    return Objects.equals(this.id, updateInvoiceDetailsRequest.id) &&
        Objects.equals(this.invoiceId, updateInvoiceDetailsRequest.invoiceId) &&
        Objects.equals(this.invoiceCode, updateInvoiceDetailsRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, updateInvoiceDetailsRequest.invoiceNo) &&
        Objects.equals(this.cargoName, updateInvoiceDetailsRequest.cargoName) &&
        Objects.equals(this.cargoCode, updateInvoiceDetailsRequest.cargoCode) &&
        Objects.equals(this.itemSpec, updateInvoiceDetailsRequest.itemSpec) &&
        Objects.equals(this.quantityUnit, updateInvoiceDetailsRequest.quantityUnit) &&
        Objects.equals(this.quantity, updateInvoiceDetailsRequest.quantity) &&
        Objects.equals(this.taxRate, updateInvoiceDetailsRequest.taxRate) &&
        Objects.equals(this.unitPrice, updateInvoiceDetailsRequest.unitPrice) &&
        Objects.equals(this.amountWithoutTax, updateInvoiceDetailsRequest.amountWithoutTax) &&
        Objects.equals(this.taxAmount, updateInvoiceDetailsRequest.taxAmount) &&
        Objects.equals(this.amountWithTax, updateInvoiceDetailsRequest.amountWithTax) &&
        Objects.equals(this.discountWithoutTax, updateInvoiceDetailsRequest.discountWithoutTax) &&
        Objects.equals(this.discountRate, updateInvoiceDetailsRequest.discountRate) &&
        Objects.equals(this.discountTax, updateInvoiceDetailsRequest.discountTax) &&
        Objects.equals(this.discountWithTax, updateInvoiceDetailsRequest.discountWithTax) &&
        Objects.equals(this.taxItem, updateInvoiceDetailsRequest.taxItem) &&
        Objects.equals(this.goodsNoVer, updateInvoiceDetailsRequest.goodsNoVer) &&
        Objects.equals(this.goodsTaxNo, updateInvoiceDetailsRequest.goodsTaxNo) &&
        Objects.equals(this.goodsErpNo, updateInvoiceDetailsRequest.goodsErpNo) &&
        Objects.equals(this.plateNumber, updateInvoiceDetailsRequest.plateNumber) &&
        Objects.equals(this.vehicleType, updateInvoiceDetailsRequest.vehicleType) &&
        Objects.equals(this.tollStartDate, updateInvoiceDetailsRequest.tollStartDate) &&
        Objects.equals(this.tollEndDate, updateInvoiceDetailsRequest.tollEndDate) &&
        Objects.equals(this.taxPreFlag, updateInvoiceDetailsRequest.taxPreFlag) &&
        Objects.equals(this.taxPreContent, updateInvoiceDetailsRequest.taxPreContent) &&
        Objects.equals(this.taxRateType, updateInvoiceDetailsRequest.taxRateType) &&
        Objects.equals(this.taxDedunction, updateInvoiceDetailsRequest.taxDedunction) &&
        Objects.equals(this.discountFlag, updateInvoiceDetailsRequest.discountFlag) &&
        Objects.equals(this.priceMethod, updateInvoiceDetailsRequest.priceMethod) &&
        Objects.equals(this.createTime, updateInvoiceDetailsRequest.createTime) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, invoiceId, invoiceCode, invoiceNo, cargoName, cargoCode, itemSpec, quantityUnit, quantity, taxRate, unitPrice, amountWithoutTax, taxAmount, amountWithTax, discountWithoutTax, discountRate, discountTax, discountWithTax, taxItem, goodsNoVer, goodsTaxNo, goodsErpNo, plateNumber, vehicleType, tollStartDate, tollEndDate, taxPreFlag, taxPreContent, taxRateType, taxDedunction, discountFlag, priceMethod, createTime, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateInvoiceDetailsRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    cargoCode: ").append(toIndentedString(cargoCode)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    discountWithoutTax: ").append(toIndentedString(discountWithoutTax)).append("\n");
    sb.append("    discountRate: ").append(toIndentedString(discountRate)).append("\n");
    sb.append("    discountTax: ").append(toIndentedString(discountTax)).append("\n");
    sb.append("    discountWithTax: ").append(toIndentedString(discountWithTax)).append("\n");
    sb.append("    taxItem: ").append(toIndentedString(taxItem)).append("\n");
    sb.append("    goodsNoVer: ").append(toIndentedString(goodsNoVer)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    goodsErpNo: ").append(toIndentedString(goodsErpNo)).append("\n");
    sb.append("    plateNumber: ").append(toIndentedString(plateNumber)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("    tollStartDate: ").append(toIndentedString(tollStartDate)).append("\n");
    sb.append("    tollEndDate: ").append(toIndentedString(tollEndDate)).append("\n");
    sb.append("    taxPreFlag: ").append(toIndentedString(taxPreFlag)).append("\n");
    sb.append("    taxPreContent: ").append(toIndentedString(taxPreContent)).append("\n");
    sb.append("    taxRateType: ").append(toIndentedString(taxRateType)).append("\n");
    sb.append("    taxDedunction: ").append(toIndentedString(taxDedunction)).append("\n");
    sb.append("    discountFlag: ").append(toIndentedString(discountFlag)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
