package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.vanke.in.client.model.WkParcelDetailsDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 退票包裹明细表Request
 */
@ApiModel(description = "退票包裹明细表Request")

@JsonInclude(NON_NULL)
public class UpdateParcelDetailsRequest extends BaseRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonProperty("parcelId")
  private Long parcelId = null;

  @JsonProperty("superType")
  private Integer superType = null;

  @JsonProperty("superId")
  private Long superId = null;

  @JsonProperty("interfaceType")
  private Integer interfaceType = null;

  @JsonProperty("goodsUrl")
  private String goodsUrl = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceSheet")
  private Integer invoiceSheet = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("detailNum")
  private Integer detailNum = null;

  @JsonProperty("batchNo")
  private String batchNo = null;

  @JsonProperty("bussinessNo")
  private String bussinessNo = null;

  @JsonProperty("bussinessType")
  private String bussinessType = null;

  @JsonProperty("attachmentName")
  private String attachmentName = null;

  @JsonProperty("businessLgtStatus")
  private Integer businessLgtStatus = null;

  @JsonProperty("businessSignTime")
  private Long businessSignTime = null;

  @JsonProperty("senderRole")
  private Integer senderRole = null;

  @JsonProperty("senderCompanyName")
  private String senderCompanyName = null;

  @JsonProperty("senderTaxNo")
  private String senderTaxNo = null;

  @JsonProperty("receiverCompanyName")
  private String receiverCompanyName = null;

  @JsonProperty("receiverTaxNo")
  private String receiverTaxNo = null;

  @JsonProperty("goodsOrig")
  private Integer goodsOrig = null;

  @JsonProperty("principalId")
  private Long principalId = null;

  @JsonProperty("principalName")
  private String principalName = null;

  @JsonProperty("redirectId")
  private Long redirectId = null;

  @JsonProperty("redirectName")
  private String redirectName = null;

  @JsonProperty("redirectTime")
  private Long redirectTime = null;

  @JsonProperty("redirectRemark")
  private String redirectRemark = null;

  @JsonProperty("receiverName")
  private String receiverName = null;

  @JsonProperty("receiverTel")
  private String receiverTel = null;

  @JsonProperty("receiverProvince")
  private String receiverProvince = null;

  @JsonProperty("receiverCity")
  private String receiverCity = null;

  @JsonProperty("receiverDistrict")
  private String receiverDistrict = null;

  @JsonProperty("receiverAddr")
  private String receiverAddr = null;

  @JsonProperty("receiverRemark")
  private String receiverRemark = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonIgnore
  public UpdateParcelDetailsRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest goodsId(Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 物品ID
   * @return goodsId
  **/
  @ApiModelProperty(value = "物品ID")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest parcelId(Long parcelId) {
    this.parcelId = parcelId;
    return this;
  }

   /**
   * 包裹ID
   * @return parcelId
  **/
  @ApiModelProperty(value = "包裹ID")
  public Long getParcelId() {
    return parcelId;
  }

  public void setParcelId(Long parcelId) {
    this.parcelId = parcelId;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest superType(Integer superType) {
    this.superType = superType;
    return this;
  }

   /**
   * 上级类型：0-无上级，1-封面，2-发票，3-附件，4-销货清单
   * @return superType
  **/
  @ApiModelProperty(value = "上级类型：0-无上级，1-封面，2-发票，3-附件，4-销货清单")
  public Integer getSuperType() {
    return superType;
  }

  public void setSuperType(Integer superType) {
    this.superType = superType;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest superId(Long superId) {
    this.superId = superId;
    return this;
  }

   /**
   * 上级ID
   * @return superId
  **/
  @ApiModelProperty(value = "上级ID")
  public Long getSuperId() {
    return superId;
  }

  public void setSuperId(Long superId) {
    this.superId = superId;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest interfaceType(Integer interfaceType) {
    this.interfaceType = interfaceType;
    return this;
  }

   /**
   * 接口类型：0-空，1-封面数据接口，2-发票数据接口，3-附件数据接口 ，4-销货清单数据接口
   * @return interfaceType
  **/
  @ApiModelProperty(value = "接口类型：0-空，1-封面数据接口，2-发票数据接口，3-附件数据接口 ，4-销货清单数据接口")
  public Integer getInterfaceType() {
    return interfaceType;
  }

  public void setInterfaceType(Integer interfaceType) {
    this.interfaceType = interfaceType;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest goodsUrl(String goodsUrl) {
    this.goodsUrl = goodsUrl;
    return this;
  }

   /**
   * 物品影像URL
   * @return goodsUrl
  **/
  @ApiModelProperty(value = "物品影像URL")
  public String getGoodsUrl() {
    return goodsUrl;
  }

  public void setGoodsUrl(String goodsUrl) {
    this.goodsUrl = goodsUrl;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型 s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型 s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest invoiceSheet(Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
    return this;
  }

   /**
   * 发票联次：0-空，1-发票联，2-抵扣联
   * @return invoiceSheet
  **/
  @ApiModelProperty(value = "发票联次：0-空，1-发票联，2-抵扣联")
  public Integer getInvoiceSheet() {
    return invoiceSheet;
  }

  public void setInvoiceSheet(Integer invoiceSheet) {
    this.invoiceSheet = invoiceSheet;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 价税合计
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "价税合计")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest detailNum(Integer detailNum) {
    this.detailNum = detailNum;
    return this;
  }

   /**
   * 明细数
   * @return detailNum
  **/
  @ApiModelProperty(value = "明细数")
  public Integer getDetailNum() {
    return detailNum;
  }

  public void setDetailNum(Integer detailNum) {
    this.detailNum = detailNum;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest batchNo(String batchNo) {
    this.batchNo = batchNo;
    return this;
  }

   /**
   * 批次封面
   * @return batchNo
  **/
  @ApiModelProperty(value = "批次封面")
  public String getBatchNo() {
    return batchNo;
  }

  public void setBatchNo(String batchNo) {
    this.batchNo = batchNo;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest bussinessNo(String bussinessNo) {
    this.bussinessNo = bussinessNo;
    return this;
  }

   /**
   * 业务单号
   * @return bussinessNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBussinessNo() {
    return bussinessNo;
  }

  public void setBussinessNo(String bussinessNo) {
    this.bussinessNo = bussinessNo;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest bussinessType(String bussinessType) {
    this.bussinessType = bussinessType;
    return this;
  }

   /**
   * 业务类型
   * @return bussinessType
  **/
  @ApiModelProperty(value = "业务类型")
  public String getBussinessType() {
    return bussinessType;
  }

  public void setBussinessType(String bussinessType) {
    this.bussinessType = bussinessType;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest attachmentName(String attachmentName) {
    this.attachmentName = attachmentName;
    return this;
  }

   /**
   * 附件名
   * @return attachmentName
  **/
  @ApiModelProperty(value = "附件名")
  public String getAttachmentName() {
    return attachmentName;
  }

  public void setAttachmentName(String attachmentName) {
    this.attachmentName = attachmentName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest businessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
    return this;
  }

   /**
   * 业务物流状态1-待寄送，2-无需寄送，3-寄送中，4-异常，5-已签收
   * @return businessLgtStatus
  **/
  @ApiModelProperty(value = "业务物流状态1-待寄送，2-无需寄送，3-寄送中，4-异常，5-已签收")
  public Integer getBusinessLgtStatus() {
    return businessLgtStatus;
  }

  public void setBusinessLgtStatus(Integer businessLgtStatus) {
    this.businessLgtStatus = businessLgtStatus;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest businessSignTime(Long businessSignTime) {
    this.businessSignTime = businessSignTime;
    return this;
  }

   /**
   * 业务物流签收时间
   * @return businessSignTime
  **/
  @ApiModelProperty(value = "业务物流签收时间")
  public Long getBusinessSignTime() {
    return businessSignTime;
  }

  public void setBusinessSignTime(Long businessSignTime) {
    this.businessSignTime = businessSignTime;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest senderRole(Integer senderRole) {
    this.senderRole = senderRole;
    return this;
  }

   /**
   * 寄件角色：1-销方寄件，2-购方寄件
   * @return senderRole
  **/
  @ApiModelProperty(value = "寄件角色：1-销方寄件，2-购方寄件")
  public Integer getSenderRole() {
    return senderRole;
  }

  public void setSenderRole(Integer senderRole) {
    this.senderRole = senderRole;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest senderCompanyName(String senderCompanyName) {
    this.senderCompanyName = senderCompanyName;
    return this;
  }

   /**
   * 寄件方公司名称
   * @return senderCompanyName
  **/
  @ApiModelProperty(value = "寄件方公司名称")
  public String getSenderCompanyName() {
    return senderCompanyName;
  }

  public void setSenderCompanyName(String senderCompanyName) {
    this.senderCompanyName = senderCompanyName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest senderTaxNo(String senderTaxNo) {
    this.senderTaxNo = senderTaxNo;
    return this;
  }

   /**
   * 寄件方纳税人识别号
   * @return senderTaxNo
  **/
  @ApiModelProperty(value = "寄件方纳税人识别号")
  public String getSenderTaxNo() {
    return senderTaxNo;
  }

  public void setSenderTaxNo(String senderTaxNo) {
    this.senderTaxNo = senderTaxNo;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverCompanyName(String receiverCompanyName) {
    this.receiverCompanyName = receiverCompanyName;
    return this;
  }

   /**
   * 收件方公司名称
   * @return receiverCompanyName
  **/
  @ApiModelProperty(value = "收件方公司名称")
  public String getReceiverCompanyName() {
    return receiverCompanyName;
  }

  public void setReceiverCompanyName(String receiverCompanyName) {
    this.receiverCompanyName = receiverCompanyName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverTaxNo(String receiverTaxNo) {
    this.receiverTaxNo = receiverTaxNo;
    return this;
  }

   /**
   * 收件方纳税人识别号
   * @return receiverTaxNo
  **/
  @ApiModelProperty(value = "收件方纳税人识别号")
  public String getReceiverTaxNo() {
    return receiverTaxNo;
  }

  public void setReceiverTaxNo(String receiverTaxNo) {
    this.receiverTaxNo = receiverTaxNo;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest goodsOrig(Integer goodsOrig) {
    this.goodsOrig = goodsOrig;
    return this;
  }

   /**
   * 物品来源：1-销项业务单，2-开票，3-退票，4-物流退件,5-补发件
   * @return goodsOrig
  **/
  @ApiModelProperty(value = "物品来源：1-销项业务单，2-开票，3-退票，4-物流退件,5-补发件")
  public Integer getGoodsOrig() {
    return goodsOrig;
  }

  public void setGoodsOrig(Integer goodsOrig) {
    this.goodsOrig = goodsOrig;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest principalId(Long principalId) {
    this.principalId = principalId;
    return this;
  }

   /**
   * 负责人ID
   * @return principalId
  **/
  @ApiModelProperty(value = "负责人ID")
  public Long getPrincipalId() {
    return principalId;
  }

  public void setPrincipalId(Long principalId) {
    this.principalId = principalId;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest principalName(String principalName) {
    this.principalName = principalName;
    return this;
  }

   /**
   * 负责人姓名
   * @return principalName
  **/
  @ApiModelProperty(value = "负责人姓名")
  public String getPrincipalName() {
    return principalName;
  }

  public void setPrincipalName(String principalName) {
    this.principalName = principalName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest redirectId(Long redirectId) {
    this.redirectId = redirectId;
    return this;
  }

   /**
   * 转寄人ID
   * @return redirectId
  **/
  @ApiModelProperty(value = "转寄人ID")
  public Long getRedirectId() {
    return redirectId;
  }

  public void setRedirectId(Long redirectId) {
    this.redirectId = redirectId;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest redirectName(String redirectName) {
    this.redirectName = redirectName;
    return this;
  }

   /**
   * 转寄人姓名
   * @return redirectName
  **/
  @ApiModelProperty(value = "转寄人姓名")
  public String getRedirectName() {
    return redirectName;
  }

  public void setRedirectName(String redirectName) {
    this.redirectName = redirectName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest redirectTime(Long redirectTime) {
    this.redirectTime = redirectTime;
    return this;
  }

   /**
   * 转寄时间
   * @return redirectTime
  **/
  @ApiModelProperty(value = "转寄时间")
  public Long getRedirectTime() {
    return redirectTime;
  }

  public void setRedirectTime(Long redirectTime) {
    this.redirectTime = redirectTime;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest redirectRemark(String redirectRemark) {
    this.redirectRemark = redirectRemark;
    return this;
  }

   /**
   * 转寄备注
   * @return redirectRemark
  **/
  @ApiModelProperty(value = "转寄备注")
  public String getRedirectRemark() {
    return redirectRemark;
  }

  public void setRedirectRemark(String redirectRemark) {
    this.redirectRemark = redirectRemark;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverName(String receiverName) {
    this.receiverName = receiverName;
    return this;
  }

   /**
   * 收件方名称
   * @return receiverName
  **/
  @ApiModelProperty(value = "收件方名称")
  public String getReceiverName() {
    return receiverName;
  }

  public void setReceiverName(String receiverName) {
    this.receiverName = receiverName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
    return this;
  }

   /**
   * 收件方联系电话
   * @return receiverTel
  **/
  @ApiModelProperty(value = "收件方联系电话")
  public String getReceiverTel() {
    return receiverTel;
  }

  public void setReceiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverProvince(String receiverProvince) {
    this.receiverProvince = receiverProvince;
    return this;
  }

   /**
   * 收件方所在省/市
   * @return receiverProvince
  **/
  @ApiModelProperty(value = "收件方所在省/市")
  public String getReceiverProvince() {
    return receiverProvince;
  }

  public void setReceiverProvince(String receiverProvince) {
    this.receiverProvince = receiverProvince;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverCity(String receiverCity) {
    this.receiverCity = receiverCity;
    return this;
  }

   /**
   * 收件方所在城市
   * @return receiverCity
  **/
  @ApiModelProperty(value = "收件方所在城市")
  public String getReceiverCity() {
    return receiverCity;
  }

  public void setReceiverCity(String receiverCity) {
    this.receiverCity = receiverCity;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverDistrict(String receiverDistrict) {
    this.receiverDistrict = receiverDistrict;
    return this;
  }

   /**
   * 收件方所在城区
   * @return receiverDistrict
  **/
  @ApiModelProperty(value = "收件方所在城区")
  public String getReceiverDistrict() {
    return receiverDistrict;
  }

  public void setReceiverDistrict(String receiverDistrict) {
    this.receiverDistrict = receiverDistrict;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverAddr(String receiverAddr) {
    this.receiverAddr = receiverAddr;
    return this;
  }

   /**
   * 收件方详细地址
   * @return receiverAddr
  **/
  @ApiModelProperty(value = "收件方详细地址")
  public String getReceiverAddr() {
    return receiverAddr;
  }

  public void setReceiverAddr(String receiverAddr) {
    this.receiverAddr = receiverAddr;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest receiverRemark(String receiverRemark) {
    this.receiverRemark = receiverRemark;
    return this;
  }

   /**
   * 收件备注
   * @return receiverRemark
  **/
  @ApiModelProperty(value = "收件备注")
  public String getReceiverRemark() {
    return receiverRemark;
  }

  public void setReceiverRemark(String receiverRemark) {
    this.receiverRemark = receiverRemark;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建人ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建人ID")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人姓名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人姓名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新人ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新人ID")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新人姓名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新人姓名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public UpdateParcelDetailsRequest updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateParcelDetailsRequest updateParcelDetailsRequest = (UpdateParcelDetailsRequest) o;
    return Objects.equals(this.id, updateParcelDetailsRequest.id) &&
        Objects.equals(this.goodsId, updateParcelDetailsRequest.goodsId) &&
        Objects.equals(this.parcelId, updateParcelDetailsRequest.parcelId) &&
        Objects.equals(this.superType, updateParcelDetailsRequest.superType) &&
        Objects.equals(this.superId, updateParcelDetailsRequest.superId) &&
        Objects.equals(this.interfaceType, updateParcelDetailsRequest.interfaceType) &&
        Objects.equals(this.goodsUrl, updateParcelDetailsRequest.goodsUrl) &&
        Objects.equals(this.invoiceNo, updateParcelDetailsRequest.invoiceNo) &&
        Objects.equals(this.invoiceCode, updateParcelDetailsRequest.invoiceCode) &&
        Objects.equals(this.invoiceType, updateParcelDetailsRequest.invoiceType) &&
        Objects.equals(this.invoiceSheet, updateParcelDetailsRequest.invoiceSheet) &&
        Objects.equals(this.paperDrewDate, updateParcelDetailsRequest.paperDrewDate) &&
        Objects.equals(this.taxAmount, updateParcelDetailsRequest.taxAmount) &&
        Objects.equals(this.amountWithoutTax, updateParcelDetailsRequest.amountWithoutTax) &&
        Objects.equals(this.amountWithTax, updateParcelDetailsRequest.amountWithTax) &&
        Objects.equals(this.detailNum, updateParcelDetailsRequest.detailNum) &&
        Objects.equals(this.batchNo, updateParcelDetailsRequest.batchNo) &&
        Objects.equals(this.bussinessNo, updateParcelDetailsRequest.bussinessNo) &&
        Objects.equals(this.bussinessType, updateParcelDetailsRequest.bussinessType) &&
        Objects.equals(this.attachmentName, updateParcelDetailsRequest.attachmentName) &&
        Objects.equals(this.businessLgtStatus, updateParcelDetailsRequest.businessLgtStatus) &&
        Objects.equals(this.businessSignTime, updateParcelDetailsRequest.businessSignTime) &&
        Objects.equals(this.senderRole, updateParcelDetailsRequest.senderRole) &&
        Objects.equals(this.senderCompanyName, updateParcelDetailsRequest.senderCompanyName) &&
        Objects.equals(this.senderTaxNo, updateParcelDetailsRequest.senderTaxNo) &&
        Objects.equals(this.receiverCompanyName, updateParcelDetailsRequest.receiverCompanyName) &&
        Objects.equals(this.receiverTaxNo, updateParcelDetailsRequest.receiverTaxNo) &&
        Objects.equals(this.goodsOrig, updateParcelDetailsRequest.goodsOrig) &&
        Objects.equals(this.principalId, updateParcelDetailsRequest.principalId) &&
        Objects.equals(this.principalName, updateParcelDetailsRequest.principalName) &&
        Objects.equals(this.redirectId, updateParcelDetailsRequest.redirectId) &&
        Objects.equals(this.redirectName, updateParcelDetailsRequest.redirectName) &&
        Objects.equals(this.redirectTime, updateParcelDetailsRequest.redirectTime) &&
        Objects.equals(this.redirectRemark, updateParcelDetailsRequest.redirectRemark) &&
        Objects.equals(this.receiverName, updateParcelDetailsRequest.receiverName) &&
        Objects.equals(this.receiverTel, updateParcelDetailsRequest.receiverTel) &&
        Objects.equals(this.receiverProvince, updateParcelDetailsRequest.receiverProvince) &&
        Objects.equals(this.receiverCity, updateParcelDetailsRequest.receiverCity) &&
        Objects.equals(this.receiverDistrict, updateParcelDetailsRequest.receiverDistrict) &&
        Objects.equals(this.receiverAddr, updateParcelDetailsRequest.receiverAddr) &&
        Objects.equals(this.receiverRemark, updateParcelDetailsRequest.receiverRemark) &&
        Objects.equals(this.remark, updateParcelDetailsRequest.remark) &&
        Objects.equals(this.createUserId, updateParcelDetailsRequest.createUserId) &&
        Objects.equals(this.createUserName, updateParcelDetailsRequest.createUserName) &&
        Objects.equals(this.createTime, updateParcelDetailsRequest.createTime) &&
        Objects.equals(this.updateUserId, updateParcelDetailsRequest.updateUserId) &&
        Objects.equals(this.updateUserName, updateParcelDetailsRequest.updateUserName) &&
        Objects.equals(this.updateTime, updateParcelDetailsRequest.updateTime) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, goodsId, parcelId, superType, superId, interfaceType, goodsUrl, invoiceNo, invoiceCode, invoiceType, invoiceSheet, paperDrewDate, taxAmount, amountWithoutTax, amountWithTax, detailNum, batchNo, bussinessNo, bussinessType, attachmentName, businessLgtStatus, businessSignTime, senderRole, senderCompanyName, senderTaxNo, receiverCompanyName, receiverTaxNo, goodsOrig, principalId, principalName, redirectId, redirectName, redirectTime, redirectRemark, receiverName, receiverTel, receiverProvince, receiverCity, receiverDistrict, receiverAddr, receiverRemark, remark, createUserId, createUserName, createTime, updateUserId, updateUserName, updateTime, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateParcelDetailsRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("    parcelId: ").append(toIndentedString(parcelId)).append("\n");
    sb.append("    superType: ").append(toIndentedString(superType)).append("\n");
    sb.append("    superId: ").append(toIndentedString(superId)).append("\n");
    sb.append("    interfaceType: ").append(toIndentedString(interfaceType)).append("\n");
    sb.append("    goodsUrl: ").append(toIndentedString(goodsUrl)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceSheet: ").append(toIndentedString(invoiceSheet)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    detailNum: ").append(toIndentedString(detailNum)).append("\n");
    sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
    sb.append("    bussinessNo: ").append(toIndentedString(bussinessNo)).append("\n");
    sb.append("    bussinessType: ").append(toIndentedString(bussinessType)).append("\n");
    sb.append("    attachmentName: ").append(toIndentedString(attachmentName)).append("\n");
    sb.append("    businessLgtStatus: ").append(toIndentedString(businessLgtStatus)).append("\n");
    sb.append("    businessSignTime: ").append(toIndentedString(businessSignTime)).append("\n");
    sb.append("    senderRole: ").append(toIndentedString(senderRole)).append("\n");
    sb.append("    senderCompanyName: ").append(toIndentedString(senderCompanyName)).append("\n");
    sb.append("    senderTaxNo: ").append(toIndentedString(senderTaxNo)).append("\n");
    sb.append("    receiverCompanyName: ").append(toIndentedString(receiverCompanyName)).append("\n");
    sb.append("    receiverTaxNo: ").append(toIndentedString(receiverTaxNo)).append("\n");
    sb.append("    goodsOrig: ").append(toIndentedString(goodsOrig)).append("\n");
    sb.append("    principalId: ").append(toIndentedString(principalId)).append("\n");
    sb.append("    principalName: ").append(toIndentedString(principalName)).append("\n");
    sb.append("    redirectId: ").append(toIndentedString(redirectId)).append("\n");
    sb.append("    redirectName: ").append(toIndentedString(redirectName)).append("\n");
    sb.append("    redirectTime: ").append(toIndentedString(redirectTime)).append("\n");
    sb.append("    redirectRemark: ").append(toIndentedString(redirectRemark)).append("\n");
    sb.append("    receiverName: ").append(toIndentedString(receiverName)).append("\n");
    sb.append("    receiverTel: ").append(toIndentedString(receiverTel)).append("\n");
    sb.append("    receiverProvince: ").append(toIndentedString(receiverProvince)).append("\n");
    sb.append("    receiverCity: ").append(toIndentedString(receiverCity)).append("\n");
    sb.append("    receiverDistrict: ").append(toIndentedString(receiverDistrict)).append("\n");
    sb.append("    receiverAddr: ").append(toIndentedString(receiverAddr)).append("\n");
    sb.append("    receiverRemark: ").append(toIndentedString(receiverRemark)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
