package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票主表
 */
@ApiModel(description = "发票主表")

@JsonInclude(NON_NULL)
public class WkInvoiceDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("updateTime")
  private Long updateTime = null;

  @JsonProperty("salesbillId")
  private Long salesbillId = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddrTel")
  private String purchaserAddrTel = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserBankNameAccount")
  private String purchaserBankNameAccount = null;

  @JsonProperty("purchaserExternalCode")
  private String purchaserExternalCode = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddrTel")
  private String sellerAddrTel = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("sellerBankNameAccount")
  private String sellerBankNameAccount = null;

  @JsonProperty("sellerExternalCode")
  private String sellerExternalCode = null;

  @JsonProperty("sellerInvoiceId")
  private Long sellerInvoiceId = null;

  @JsonProperty("sellerUserName")
  private String sellerUserName = null;

  @JsonProperty("sellerViewImageFlag")
  private Integer sellerViewImageFlag = null;

  @JsonProperty("sellerSyncStatus")
  private Integer sellerSyncStatus = null;

  @JsonProperty("sellerSyncTime")
  private Long sellerSyncTime = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithTaxCapital")
  private String amountWithTaxCapital = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("invoiceOrig")
  private Integer invoiceOrig = null;

  @JsonProperty("dataFromSystem")
  private String dataFromSystem = null;

  @JsonProperty("specialInvoiceFlag")
  private Integer specialInvoiceFlag = null;

  @JsonProperty("titleOkFlag")
  private Integer titleOkFlag = null;

  @JsonProperty("saleListFlag")
  private Integer saleListFlag = null;

  @JsonProperty("dataOkFlag")
  private Integer dataOkFlag = null;

  @JsonProperty("recogStatus")
  private Integer recogStatus = null;

  @JsonProperty("recogImageStatus")
  private Integer recogImageStatus = null;

  @JsonProperty("recogInvoiceId")
  private Long recogInvoiceId = null;

  @JsonProperty("recogResponseTime")
  private Long recogResponseTime = null;

  @JsonProperty("recogUserName")
  private String recogUserName = null;

  @JsonProperty("recogUploadNum")
  private Integer recogUploadNum = null;

  @JsonProperty("veriInvoiceId")
  private Long veriInvoiceId = null;

  @JsonProperty("veriStatus")
  private Integer veriStatus = null;

  @JsonProperty("veriRequestTime")
  private Long veriRequestTime = null;

  @JsonProperty("veriResponseTime")
  private Long veriResponseTime = null;

  @JsonProperty("veriUserId")
  private Long veriUserId = null;

  @JsonProperty("veriUserName")
  private String veriUserName = null;

  @JsonProperty("veriRemark")
  private String veriRemark = null;

  @JsonProperty("taxInvoiceId")
  private String taxInvoiceId = null;

  @JsonProperty("authSyncStatus")
  private Integer authSyncStatus = null;

  @JsonProperty("authSyncTime")
  private Long authSyncTime = null;

  @JsonProperty("authStatus")
  private Integer authStatus = null;

  @JsonProperty("authStyle")
  private Integer authStyle = null;

  @JsonProperty("authBussiDate")
  private String authBussiDate = null;

  @JsonProperty("authTaxPeriod")
  private String authTaxPeriod = null;

  @JsonProperty("authRequestTime")
  private Long authRequestTime = null;

  @JsonProperty("authResponseTime")
  private Long authResponseTime = null;

  @JsonProperty("authRequestUserId")
  private Long authRequestUserId = null;

  @JsonProperty("authRequestUserName")
  private String authRequestUserName = null;

  @JsonProperty("authRequestSerialNo")
  private String authRequestSerialNo = null;

  @JsonProperty("authRemark")
  private String authRemark = null;

  @JsonProperty("authValidTime")
  private Long authValidTime = null;

  @JsonProperty("authValidResult")
  private Integer authValidResult = null;

  @JsonProperty("authValidRemark")
  private String authValidRemark = null;

  @JsonProperty("authAmountWithoutTax")
  private BigDecimal authAmountWithoutTax = null;

  @JsonProperty("authTaxAmount")
  private BigDecimal authTaxAmount = null;

  @JsonProperty("authCount")
  private Integer authCount = null;

  @JsonProperty("authReturnTime")
  private Long authReturnTime = null;

  @JsonProperty("actualAuthWay")
  private Integer actualAuthWay = null;

  @JsonProperty("redStatus")
  private Integer redStatus = null;

  @JsonProperty("redTime")
  private Long redTime = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("redUserId")
  private Long redUserId = null;

  @JsonProperty("redUserName")
  private String redUserName = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("redRemark")
  private String redRemark = null;

  @JsonProperty("retreatStatus")
  private Integer retreatStatus = null;

  @JsonProperty("retreatTime")
  private Long retreatTime = null;

  @JsonProperty("retreatUserId")
  private Long retreatUserId = null;

  @JsonProperty("retreatUserName")
  private String retreatUserName = null;

  @JsonProperty("retreatRemark")
  private String retreatRemark = null;

  @JsonProperty("originSalesbillId")
  private Long originSalesbillId = null;

  @JsonProperty("originSalesbillNo")
  private String originSalesbillNo = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("provinceCode")
  private Integer provinceCode = null;

  @JsonProperty("provinceName")
  private String provinceName = null;

  @JsonProperty("recogUserId")
  private Long recogUserId = null;

  @JsonProperty("recogDeductionImageUrl")
  private String recogDeductionImageUrl = null;

  @JsonProperty("recogInvoiceImageUrl")
  private String recogInvoiceImageUrl = null;

  @JsonProperty("pdfUrl")
  private String pdfUrl = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonProperty("vehicleBrand")
  private String vehicleBrand = null;

  @JsonProperty("productionArea")
  private String productionArea = null;

  @JsonProperty("certNo")
  private String certNo = null;

  @JsonProperty("importCertNo")
  private String importCertNo = null;

  @JsonProperty("inspectionNo")
  private String inspectionNo = null;

  @JsonProperty("engineNo")
  private String engineNo = null;

  @JsonProperty("organizationCode")
  private String organizationCode = null;

  @JsonProperty("vin")
  private String vin = null;

  @JsonProperty("tonnage")
  private String tonnage = null;

  @JsonProperty("taxPaidProof")
  private String taxPaidProof = null;

  @JsonProperty("maxCapacity")
  private String maxCapacity = null;

  @JsonProperty("taxAuthName")
  private String taxAuthName = null;

  @JsonProperty("taxAuthCode")
  private String taxAuthCode = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("invoiceCheckStatus")
  private Integer invoiceCheckStatus = null;

  @JsonProperty("invoiceCheckNote")
  private String invoiceCheckNote = null;

  @JsonProperty("invoiceCheckPerson")
  private String invoiceCheckPerson = null;

  @JsonProperty("invoiceCheckTime")
  private Long invoiceCheckTime = null;

  @JsonProperty("smInvoiceCode")
  private String smInvoiceCode = null;

  @JsonProperty("smInvoiceNo")
  private String smInvoiceNo = null;

  @JsonProperty("smPurchaserTaxNo")
  private String smPurchaserTaxNo = null;

  @JsonProperty("smSellerTaxNo")
  private String smSellerTaxNo = null;

  @JsonProperty("smPaperDrewDate")
  private String smPaperDrewDate = null;

  @JsonProperty("smAmountWithoutTax")
  private String smAmountWithoutTax = null;

  @JsonProperty("smTaxAmount")
  private String smTaxAmount = null;

  @JsonProperty("smAmountWithTax")
  private String smAmountWithTax = null;

  @JsonProperty("smUpdator")
  private String smUpdator = null;

  @JsonProperty("smBarcode")
  private String smBarcode = null;

  @JsonProperty("smImgUrl")
  private String smImgUrl = null;

  @JsonProperty("smInvoiceId")
  private String smInvoiceId = null;

  @JsonProperty("smInvoiceSource")
  private Integer smInvoiceSource = null;

  @JsonProperty("xtInvoiceCode")
  private String xtInvoiceCode = null;

  @JsonProperty("xtInvoiceNo")
  private String xtInvoiceNo = null;

  @JsonProperty("xtPurchaserTaxNo")
  private String xtPurchaserTaxNo = null;

  @JsonProperty("xtSellerTaxNo")
  private String xtSellerTaxNo = null;

  @JsonProperty("xtPaperDrewDate")
  private String xtPaperDrewDate = null;

  @JsonProperty("xtAmountWithoutTax")
  private String xtAmountWithoutTax = null;

  @JsonProperty("xtTaxAmount")
  private String xtTaxAmount = null;

  @JsonProperty("xtAmountWithTax")
  private String xtAmountWithTax = null;

  @JsonProperty("xtTaxRate")
  private BigDecimal xtTaxRate = null;

  @JsonProperty("isPushTask")
  private Integer isPushTask = null;

  @JsonProperty("isObsolete")
  private Integer isObsolete = null;

  @JsonProperty("isResult")
  private Integer isResult = null;

  @JsonProperty("ifRepeat")
  private Integer ifRepeat = null;

  @JsonProperty("ifAuthFlag")
  private Integer ifAuthFlag = null;

  @JsonProperty("isLegalSynergetics")
  private Integer isLegalSynergetics = null;

  @JsonProperty("signStatus")
  private Integer signStatus = null;

  @JsonProperty("auditStatus")
  private Integer auditStatus = null;

  @JsonProperty("auditUpdateTime")
  private Long auditUpdateTime = null;

  @JsonProperty("auditUser")
  private String auditUser = null;

  @JsonProperty("ifSendException")
  private Integer ifSendException = null;

  @JsonProperty("smMachineCode")
  private String smMachineCode = null;

  @JsonProperty("smCheckCode")
  private String smCheckCode = null;

  @JsonProperty("smCipherText")
  private String smCipherText = null;

  @JsonProperty("xtMachineCode")
  private String xtMachineCode = null;

  @JsonProperty("xtCheckCode")
  private String xtCheckCode = null;

  @JsonProperty("xtCipherText")
  private String xtCipherText = null;

  @JsonProperty("taxInvoiceCode")
  private String taxInvoiceCode = null;

  @JsonProperty("taxInvoiceNo")
  private String taxInvoiceNo = null;

  @JsonProperty("taxPurchaserTaxNo")
  private String taxPurchaserTaxNo = null;

  @JsonProperty("taxSellerTaxNo")
  private String taxSellerTaxNo = null;

  @JsonProperty("taxPaperDrewDate")
  private String taxPaperDrewDate = null;

  @JsonProperty("taxAmountWithoutTax")
  private String taxAmountWithoutTax = null;

  @JsonProperty("taxTaxAmount")
  private String taxTaxAmount = null;

  @JsonProperty("taxAmountWithTax")
  private String taxAmountWithTax = null;

  @JsonProperty("taxMachineCode")
  private String taxMachineCode = null;

  @JsonProperty("taxCheckCode")
  private String taxCheckCode = null;

  @JsonProperty("taxCipherText")
  private String taxCipherText = null;

  @JsonProperty("pushAuthStatus")
  private Integer pushAuthStatus = null;

  @JsonProperty("pushAuthTime")
  private Long pushAuthTime = null;

  @JsonProperty("authNoOverdueDate")
  private String authNoOverdueDate = null;

  @JsonProperty("authWarnDays")
  private Integer authWarnDays = null;

  @JsonProperty("signTime")
  private Long signTime = null;

  @JsonProperty("sendExceptionRemark")
  private String sendExceptionRemark = null;

  @JsonProperty("authPurposes")
  private Integer authPurposes = null;

  @JsonProperty("authValidTaxAmount")
  private BigDecimal authValidTaxAmount = null;

  @JsonProperty("authCheckRequestTime")
  private Long authCheckRequestTime = null;

  @JsonProperty("authCheckUserId")
  private Long authCheckUserId = null;

  @JsonProperty("authCheckUserName")
  private String authCheckUserName = null;

  @JsonProperty("authCheckResponseTime")
  private Long authCheckResponseTime = null;

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonProperty("authExceType")
  private Integer authExceType = null;

  @JsonProperty("xtOperateTime")
  private Long xtOperateTime = null;

  @JsonIgnore
  public WkInvoiceDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型：s-增值税专用发票 c-增值税普通发票ce-增值税电子普通发票ju-增值税普通发票（卷票）ct-通行费增值税电子普通发票v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型：s-增值税专用发票 c-增值税普通发票ce-增值税电子普通发票ju-增值税普通发票（卷票）ct-通行费增值税电子普通发票v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public WkInvoiceDTO status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 发票状态0-默认；1-正常；2-作废；3-被红冲；7-异常；8-失控；9-删除
   * @return status
  **/
  @ApiModelProperty(value = "发票状态0-默认；1-正常；2-作废；3-被红冲；7-异常；8-失控；9-删除")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public WkInvoiceDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 数据创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "数据创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public WkInvoiceDTO updateTime(Long updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public Long getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Long updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public WkInvoiceDTO salesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
    return this;
  }

   /**
   * 业务单ID
   * @return salesbillId
  **/
  @ApiModelProperty(value = "业务单ID")
  public Long getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
  }

  @JsonIgnore
  public WkInvoiceDTO salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public WkInvoiceDTO packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
    return this;
  }

   /**
   * 购方地址电话
   * @return purchaserAddrTel
  **/
  @ApiModelProperty(value = "购方地址电话")
  public String getPurchaserAddrTel() {
    return purchaserAddrTel;
  }

  public void setPurchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行账号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
    return this;
  }

   /**
   * 购方银行名称账号
   * @return purchaserBankNameAccount
  **/
  @ApiModelProperty(value = "购方银行名称账号")
  public String getPurchaserBankNameAccount() {
    return purchaserBankNameAccount;
  }

  public void setPurchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
  }

  @JsonIgnore
  public WkInvoiceDTO purchaserExternalCode(String purchaserExternalCode) {
    this.purchaserExternalCode = purchaserExternalCode;
    return this;
  }

   /**
   * 购方公司编号（外部系统）
   * @return purchaserExternalCode
  **/
  @ApiModelProperty(value = "购方公司编号（外部系统）")
  public String getPurchaserExternalCode() {
    return purchaserExternalCode;
  }

  public void setPurchaserExternalCode(String purchaserExternalCode) {
    this.purchaserExternalCode = purchaserExternalCode;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
    return this;
  }

   /**
   * 销方地址电话
   * @return sellerAddrTel
  **/
  @ApiModelProperty(value = "销方地址电话")
  public String getSellerAddrTel() {
    return sellerAddrTel;
  }

  public void setSellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行账号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
    return this;
  }

   /**
   * 销方银行名称账号
   * @return sellerBankNameAccount
  **/
  @ApiModelProperty(value = "销方银行名称账号")
  public String getSellerBankNameAccount() {
    return sellerBankNameAccount;
  }

  public void setSellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerExternalCode(String sellerExternalCode) {
    this.sellerExternalCode = sellerExternalCode;
    return this;
  }

   /**
   * 销方公司编号（外部系统）
   * @return sellerExternalCode
  **/
  @ApiModelProperty(value = "销方公司编号（外部系统）")
  public String getSellerExternalCode() {
    return sellerExternalCode;
  }

  public void setSellerExternalCode(String sellerExternalCode) {
    this.sellerExternalCode = sellerExternalCode;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerInvoiceId(Long sellerInvoiceId) {
    this.sellerInvoiceId = sellerInvoiceId;
    return this;
  }

   /**
   * 销方发票主表ID
   * @return sellerInvoiceId
  **/
  @ApiModelProperty(value = "销方发票主表ID")
  public Long getSellerInvoiceId() {
    return sellerInvoiceId;
  }

  public void setSellerInvoiceId(Long sellerInvoiceId) {
    this.sellerInvoiceId = sellerInvoiceId;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerUserName(String sellerUserName) {
    this.sellerUserName = sellerUserName;
    return this;
  }

   /**
   * 销方开票操作人姓名
   * @return sellerUserName
  **/
  @ApiModelProperty(value = "销方开票操作人姓名")
  public String getSellerUserName() {
    return sellerUserName;
  }

  public void setSellerUserName(String sellerUserName) {
    this.sellerUserName = sellerUserName;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
    return this;
  }

   /**
   * 销方查看影像标志：0-默认；1-允许销方查看影像
   * @return sellerViewImageFlag
  **/
  @ApiModelProperty(value = "销方查看影像标志：0-默认；1-允许销方查看影像")
  public Integer getSellerViewImageFlag() {
    return sellerViewImageFlag;
  }

  public void setSellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerSyncStatus(Integer sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
    return this;
  }

   /**
   * 销方开具状态：0-默认；1-无销方信息（非协同）；2-销方信息未 到（协同）；3-销方信息已到（协同）
   * @return sellerSyncStatus
  **/
  @ApiModelProperty(value = "销方开具状态：0-默认；1-无销方信息（非协同）；2-销方信息未 到（协同）；3-销方信息已到（协同）")
  public Integer getSellerSyncStatus() {
    return sellerSyncStatus;
  }

  public void setSellerSyncStatus(Integer sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO sellerSyncTime(Long sellerSyncTime) {
    this.sellerSyncTime = sellerSyncTime;
    return this;
  }

   /**
   * 销方信息获取时间
   * @return sellerSyncTime
  **/
  @ApiModelProperty(value = "销方信息获取时间")
  public Long getSellerSyncTime() {
    return sellerSyncTime;
  }

  public void setSellerSyncTime(Long sellerSyncTime) {
    this.sellerSyncTime = sellerSyncTime;
  }

  @JsonIgnore
  public WkInvoiceDTO taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 多税率以逗号隔开，如16%,11%,3%
   * @return taxRate
  **/
  @ApiModelProperty(value = "多税率以逗号隔开，如16%,11%,3%")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public WkInvoiceDTO amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public WkInvoiceDTO taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public WkInvoiceDTO amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public WkInvoiceDTO amountWithTaxCapital(String amountWithTaxCapital) {
    this.amountWithTaxCapital = amountWithTaxCapital;
    return this;
  }

   /**
   * 含税金额(大写)
   * @return amountWithTaxCapital
  **/
  @ApiModelProperty(value = "含税金额(大写)")
  public String getAmountWithTaxCapital() {
    return amountWithTaxCapital;
  }

  public void setAmountWithTaxCapital(String amountWithTaxCapital) {
    this.amountWithTaxCapital = amountWithTaxCapital;
  }

  @JsonIgnore
  public WkInvoiceDTO paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 发票开票日期（例：20161027）
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期（例：20161027）")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public WkInvoiceDTO machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public WkInvoiceDTO checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public WkInvoiceDTO cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceOrig(Integer invoiceOrig) {
    this.invoiceOrig = invoiceOrig;
    return this;
  }

   /**
   * 发票来源：0-默认；1,抽取,y;2,扫描,y;3,导入,y;4,税局下载,y;5,直连开票生成,y;6,金税回传生成,y;7,手工回填生成,y;8,电子发票生成,y;9,电子底账,y;71,非直连接口生成,y;
   * @return invoiceOrig
  **/
  @ApiModelProperty(value = "发票来源：0-默认；1,抽取,y;2,扫描,y;3,导入,y;4,税局下载,y;5,直连开票生成,y;6,金税回传生成,y;7,手工回填生成,y;8,电子发票生成,y;9,电子底账,y;71,非直连接口生成,y;")
  public Integer getInvoiceOrig() {
    return invoiceOrig;
  }

  public void setInvoiceOrig(Integer invoiceOrig) {
    this.invoiceOrig = invoiceOrig;
  }

  @JsonIgnore
  public WkInvoiceDTO dataFromSystem(String dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
    return this;
  }

   /**
   * 数据来源
   * @return dataFromSystem
  **/
  @ApiModelProperty(value = "数据来源")
  public String getDataFromSystem() {
    return dataFromSystem;
  }

  public void setDataFromSystem(String dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
  }

  @JsonIgnore
  public WkInvoiceDTO specialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
    return this;
  }

   /**
   * 特殊发票标记：0-默认；1-通行费；2-成品油
   * @return specialInvoiceFlag
  **/
  @ApiModelProperty(value = "特殊发票标记：0-默认；1-通行费；2-成品油")
  public Integer getSpecialInvoiceFlag() {
    return specialInvoiceFlag;
  }

  public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
  }

  @JsonIgnore
  public WkInvoiceDTO titleOkFlag(Integer titleOkFlag) {
    this.titleOkFlag = titleOkFlag;
    return this;
  }

   /**
   * 抬头是否有误：0-默认；1-无误；2-有误
   * @return titleOkFlag
  **/
  @ApiModelProperty(value = "抬头是否有误：0-默认；1-无误；2-有误")
  public Integer getTitleOkFlag() {
    return titleOkFlag;
  }

  public void setTitleOkFlag(Integer titleOkFlag) {
    this.titleOkFlag = titleOkFlag;
  }

  @JsonIgnore
  public WkInvoiceDTO saleListFlag(Integer saleListFlag) {
    this.saleListFlag = saleListFlag;
    return this;
  }

   /**
   * 是否有销货清单：0-未知（默认）；1-有；2-无
   * @return saleListFlag
  **/
  @ApiModelProperty(value = "是否有销货清单：0-未知（默认）；1-有；2-无")
  public Integer getSaleListFlag() {
    return saleListFlag;
  }

  public void setSaleListFlag(Integer saleListFlag) {
    this.saleListFlag = saleListFlag;
  }

  @JsonIgnore
  public WkInvoiceDTO dataOkFlag(Integer dataOkFlag) {
    this.dataOkFlag = dataOkFlag;
    return this;
  }

   /**
   * 数据源比对是否一致：0-未知（默认）；1 - 一致；2 - 不一致
   * @return dataOkFlag
  **/
  @ApiModelProperty(value = "数据源比对是否一致：0-未知（默认）；1 - 一致；2 - 不一致")
  public Integer getDataOkFlag() {
    return dataOkFlag;
  }

  public void setDataOkFlag(Integer dataOkFlag) {
    this.dataOkFlag = dataOkFlag;
  }

  @JsonIgnore
  public WkInvoiceDTO recogStatus(Integer recogStatus) {
    this.recogStatus = recogStatus;
    return this;
  }

   /**
   * 识别状态：0-未识别（默认）；1-已识别
   * @return recogStatus
  **/
  @ApiModelProperty(value = "识别状态：0-未识别（默认）；1-已识别")
  public Integer getRecogStatus() {
    return recogStatus;
  }

  public void setRecogStatus(Integer recogStatus) {
    this.recogStatus = recogStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO recogImageStatus(Integer recogImageStatus) {
    this.recogImageStatus = recogImageStatus;
    return this;
  }

   /**
   * 识别影像状态：0-无影像(默认)；1-仅有抵扣联；2-仅有发票联；3-两联均有
   * @return recogImageStatus
  **/
  @ApiModelProperty(value = "识别影像状态：0-无影像(默认)；1-仅有抵扣联；2-仅有发票联；3-两联均有")
  public Integer getRecogImageStatus() {
    return recogImageStatus;
  }

  public void setRecogImageStatus(Integer recogImageStatus) {
    this.recogImageStatus = recogImageStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO recogInvoiceId(Long recogInvoiceId) {
    this.recogInvoiceId = recogInvoiceId;
    return this;
  }

   /**
   * 识别发票主表ID
   * @return recogInvoiceId
  **/
  @ApiModelProperty(value = "识别发票主表ID")
  public Long getRecogInvoiceId() {
    return recogInvoiceId;
  }

  public void setRecogInvoiceId(Long recogInvoiceId) {
    this.recogInvoiceId = recogInvoiceId;
  }

  @JsonIgnore
  public WkInvoiceDTO recogResponseTime(Long recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
    return this;
  }

   /**
   * 识别完成时间
   * @return recogResponseTime
  **/
  @ApiModelProperty(value = "识别完成时间")
  public Long getRecogResponseTime() {
    return recogResponseTime;
  }

  public void setRecogResponseTime(Long recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
  }

  @JsonIgnore
  public WkInvoiceDTO recogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
    return this;
  }

   /**
   * 识别操作人姓名
   * @return recogUserName
  **/
  @ApiModelProperty(value = "识别操作人姓名")
  public String getRecogUserName() {
    return recogUserName;
  }

  public void setRecogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
  }

  @JsonIgnore
  public WkInvoiceDTO recogUploadNum(Integer recogUploadNum) {
    this.recogUploadNum = recogUploadNum;
    return this;
  }

   /**
   * 识别上传次数
   * @return recogUploadNum
  **/
  @ApiModelProperty(value = "识别上传次数")
  public Integer getRecogUploadNum() {
    return recogUploadNum;
  }

  public void setRecogUploadNum(Integer recogUploadNum) {
    this.recogUploadNum = recogUploadNum;
  }

  @JsonIgnore
  public WkInvoiceDTO veriInvoiceId(Long veriInvoiceId) {
    this.veriInvoiceId = veriInvoiceId;
    return this;
  }

   /**
   * 国税验真主表ID
   * @return veriInvoiceId
  **/
  @ApiModelProperty(value = "国税验真主表ID")
  public Long getVeriInvoiceId() {
    return veriInvoiceId;
  }

  public void setVeriInvoiceId(Long veriInvoiceId) {
    this.veriInvoiceId = veriInvoiceId;
  }

  @JsonIgnore
  public WkInvoiceDTO veriStatus(Integer veriStatus) {
    this.veriStatus = veriStatus;
    return this;
  }

   /**
   * 查验状态：0-未查验(默认)；1-待查验；2-查验中；3-查验成功；4-查验失败
   * @return veriStatus
  **/
  @ApiModelProperty(value = "查验状态：0-未查验(默认)；1-待查验；2-查验中；3-查验成功；4-查验失败")
  public Integer getVeriStatus() {
    return veriStatus;
  }

  public void setVeriStatus(Integer veriStatus) {
    this.veriStatus = veriStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO veriRequestTime(Long veriRequestTime) {
    this.veriRequestTime = veriRequestTime;
    return this;
  }

   /**
   * 查验发送时间
   * @return veriRequestTime
  **/
  @ApiModelProperty(value = "查验发送时间")
  public Long getVeriRequestTime() {
    return veriRequestTime;
  }

  public void setVeriRequestTime(Long veriRequestTime) {
    this.veriRequestTime = veriRequestTime;
  }

  @JsonIgnore
  public WkInvoiceDTO veriResponseTime(Long veriResponseTime) {
    this.veriResponseTime = veriResponseTime;
    return this;
  }

   /**
   * 查验完成时间
   * @return veriResponseTime
  **/
  @ApiModelProperty(value = "查验完成时间")
  public Long getVeriResponseTime() {
    return veriResponseTime;
  }

  public void setVeriResponseTime(Long veriResponseTime) {
    this.veriResponseTime = veriResponseTime;
  }

  @JsonIgnore
  public WkInvoiceDTO veriUserId(Long veriUserId) {
    this.veriUserId = veriUserId;
    return this;
  }

   /**
   * 查验操作人ID
   * @return veriUserId
  **/
  @ApiModelProperty(value = "查验操作人ID")
  public Long getVeriUserId() {
    return veriUserId;
  }

  public void setVeriUserId(Long veriUserId) {
    this.veriUserId = veriUserId;
  }

  @JsonIgnore
  public WkInvoiceDTO veriUserName(String veriUserName) {
    this.veriUserName = veriUserName;
    return this;
  }

   /**
   * 查验操作人姓名
   * @return veriUserName
  **/
  @ApiModelProperty(value = "查验操作人姓名")
  public String getVeriUserName() {
    return veriUserName;
  }

  public void setVeriUserName(String veriUserName) {
    this.veriUserName = veriUserName;
  }

  @JsonIgnore
  public WkInvoiceDTO veriRemark(String veriRemark) {
    this.veriRemark = veriRemark;
    return this;
  }

   /**
   * 查验备注
   * @return veriRemark
  **/
  @ApiModelProperty(value = "查验备注")
  public String getVeriRemark() {
    return veriRemark;
  }

  public void setVeriRemark(String veriRemark) {
    this.veriRemark = veriRemark;
  }

  @JsonIgnore
  public WkInvoiceDTO taxInvoiceId(String taxInvoiceId) {
    this.taxInvoiceId = taxInvoiceId;
    return this;
  }

   /**
   * 国税底账主表ID
   * @return taxInvoiceId
  **/
  @ApiModelProperty(value = "国税底账主表ID")
  public String getTaxInvoiceId() {
    return taxInvoiceId;
  }

  public void setTaxInvoiceId(String taxInvoiceId) {
    this.taxInvoiceId = taxInvoiceId;
  }

  @JsonIgnore
  public WkInvoiceDTO authSyncStatus(Integer authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
    return this;
  }

   /**
   * 电子底账状态：0-未获取(默认)；1-已获取
   * @return authSyncStatus
  **/
  @ApiModelProperty(value = "电子底账状态：0-未获取(默认)；1-已获取")
  public Integer getAuthSyncStatus() {
    return authSyncStatus;
  }

  public void setAuthSyncStatus(Integer authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO authSyncTime(Long authSyncTime) {
    this.authSyncTime = authSyncTime;
    return this;
  }

   /**
   * 电子底帐获取时间
   * @return authSyncTime
  **/
  @ApiModelProperty(value = "电子底帐获取时间")
  public Long getAuthSyncTime() {
    return authSyncTime;
  }

  public void setAuthSyncTime(Long authSyncTime) {
    this.authSyncTime = authSyncTime;
  }

  @JsonIgnore
  public WkInvoiceDTO authStatus(Integer authStatus) {
    this.authStatus = authStatus;
    return this;
  }

   /**
   * 抵扣状态：0-默认；1-不可勾选；2-未勾选；3-勾选中；4-已确认抵扣；5-勾选失败；6-抵扣异常；7-已勾选；8-撤销勾选中；9-勾选异常
   * @return authStatus
  **/
  @ApiModelProperty(value = "抵扣状态：0-默认；1-不可勾选；2-未勾选；3-勾选中；4-已确认抵扣；5-勾选失败；6-抵扣异常；7-已勾选；8-撤销勾选中；9-勾选异常")
  public Integer getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(Integer authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO authStyle(Integer authStyle) {
    this.authStyle = authStyle;
    return this;
  }

   /**
   * 抵扣方式：0-默认;10-底账抵扣；20-扫描抵扣;11-底账抵扣导入；21-扫描抵扣导入;12-国税底账抵扣；22-国税扫描抵扣
   * @return authStyle
  **/
  @ApiModelProperty(value = "抵扣方式：0-默认;10-底账抵扣；20-扫描抵扣;11-底账抵扣导入；21-扫描抵扣导入;12-国税底账抵扣；22-国税扫描抵扣")
  public Integer getAuthStyle() {
    return authStyle;
  }

  public void setAuthStyle(Integer authStyle) {
    this.authStyle = authStyle;
  }

  @JsonIgnore
  public WkInvoiceDTO authBussiDate(String authBussiDate) {
    this.authBussiDate = authBussiDate;
    return this;
  }

   /**
   * 抵扣业务日期
   * @return authBussiDate
  **/
  @ApiModelProperty(value = "抵扣业务日期")
  public String getAuthBussiDate() {
    return authBussiDate;
  }

  public void setAuthBussiDate(String authBussiDate) {
    this.authBussiDate = authBussiDate;
  }

  @JsonIgnore
  public WkInvoiceDTO authTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
    return this;
  }

   /**
   * 抵扣所属期
   * @return authTaxPeriod
  **/
  @ApiModelProperty(value = "抵扣所属期")
  public String getAuthTaxPeriod() {
    return authTaxPeriod;
  }

  public void setAuthTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
  }

  @JsonIgnore
  public WkInvoiceDTO authRequestTime(Long authRequestTime) {
    this.authRequestTime = authRequestTime;
    return this;
  }

   /**
   * 抵扣发送时间
   * @return authRequestTime
  **/
  @ApiModelProperty(value = "抵扣发送时间")
  public Long getAuthRequestTime() {
    return authRequestTime;
  }

  public void setAuthRequestTime(Long authRequestTime) {
    this.authRequestTime = authRequestTime;
  }

  @JsonIgnore
  public WkInvoiceDTO authResponseTime(Long authResponseTime) {
    this.authResponseTime = authResponseTime;
    return this;
  }

   /**
   * 抵扣完成时间
   * @return authResponseTime
  **/
  @ApiModelProperty(value = "抵扣完成时间")
  public Long getAuthResponseTime() {
    return authResponseTime;
  }

  public void setAuthResponseTime(Long authResponseTime) {
    this.authResponseTime = authResponseTime;
  }

  @JsonIgnore
  public WkInvoiceDTO authRequestUserId(Long authRequestUserId) {
    this.authRequestUserId = authRequestUserId;
    return this;
  }

   /**
   * 抵扣操作员ID
   * @return authRequestUserId
  **/
  @ApiModelProperty(value = "抵扣操作员ID")
  public Long getAuthRequestUserId() {
    return authRequestUserId;
  }

  public void setAuthRequestUserId(Long authRequestUserId) {
    this.authRequestUserId = authRequestUserId;
  }

  @JsonIgnore
  public WkInvoiceDTO authRequestUserName(String authRequestUserName) {
    this.authRequestUserName = authRequestUserName;
    return this;
  }

   /**
   * 抵扣操作人姓名
   * @return authRequestUserName
  **/
  @ApiModelProperty(value = "抵扣操作人姓名")
  public String getAuthRequestUserName() {
    return authRequestUserName;
  }

  public void setAuthRequestUserName(String authRequestUserName) {
    this.authRequestUserName = authRequestUserName;
  }

  @JsonIgnore
  public WkInvoiceDTO authRequestSerialNo(String authRequestSerialNo) {
    this.authRequestSerialNo = authRequestSerialNo;
    return this;
  }

   /**
   * 勾选请求流水号
   * @return authRequestSerialNo
  **/
  @ApiModelProperty(value = "勾选请求流水号")
  public String getAuthRequestSerialNo() {
    return authRequestSerialNo;
  }

  public void setAuthRequestSerialNo(String authRequestSerialNo) {
    this.authRequestSerialNo = authRequestSerialNo;
  }

  @JsonIgnore
  public WkInvoiceDTO authRemark(String authRemark) {
    this.authRemark = authRemark;
    return this;
  }

   /**
   * 抵扣备注
   * @return authRemark
  **/
  @ApiModelProperty(value = "抵扣备注")
  public String getAuthRemark() {
    return authRemark;
  }

  public void setAuthRemark(String authRemark) {
    this.authRemark = authRemark;
  }

  @JsonIgnore
  public WkInvoiceDTO authValidTime(Long authValidTime) {
    this.authValidTime = authValidTime;
    return this;
  }

   /**
   * 认证验证时间
   * @return authValidTime
  **/
  @ApiModelProperty(value = "认证验证时间")
  public Long getAuthValidTime() {
    return authValidTime;
  }

  public void setAuthValidTime(Long authValidTime) {
    this.authValidTime = authValidTime;
  }

  @JsonIgnore
  public WkInvoiceDTO authValidResult(Integer authValidResult) {
    this.authValidResult = authValidResult;
    return this;
  }

   /**
   * 认证验证结果 -1校验不通过,1校验通过,0已推送校验2-无
   * @return authValidResult
  **/
  @ApiModelProperty(value = "认证验证结果 -1校验不通过,1校验通过,0已推送校验2-无")
  public Integer getAuthValidResult() {
    return authValidResult;
  }

  public void setAuthValidResult(Integer authValidResult) {
    this.authValidResult = authValidResult;
  }

  @JsonIgnore
  public WkInvoiceDTO authValidRemark(String authValidRemark) {
    this.authValidRemark = authValidRemark;
    return this;
  }

   /**
   * 认证验证描述
   * @return authValidRemark
  **/
  @ApiModelProperty(value = "认证验证描述")
  public String getAuthValidRemark() {
    return authValidRemark;
  }

  public void setAuthValidRemark(String authValidRemark) {
    this.authValidRemark = authValidRemark;
  }

  @JsonIgnore
  public WkInvoiceDTO authAmountWithoutTax(BigDecimal authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
    return this;
  }

   /**
   * 抵扣不含税总金额
   * @return authAmountWithoutTax
  **/
  @ApiModelProperty(value = "抵扣不含税总金额")
  public BigDecimal getAuthAmountWithoutTax() {
    return authAmountWithoutTax;
  }

  public void setAuthAmountWithoutTax(BigDecimal authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
  }

  @JsonIgnore
  public WkInvoiceDTO authTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
    return this;
  }

   /**
   * 抵扣总税额
   * @return authTaxAmount
  **/
  @ApiModelProperty(value = "抵扣总税额")
  public BigDecimal getAuthTaxAmount() {
    return authTaxAmount;
  }

  public void setAuthTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
  }

  @JsonIgnore
  public WkInvoiceDTO authCount(Integer authCount) {
    this.authCount = authCount;
    return this;
  }

   /**
   * 勾选次数
   * @return authCount
  **/
  @ApiModelProperty(value = "勾选次数")
  public Integer getAuthCount() {
    return authCount;
  }

  public void setAuthCount(Integer authCount) {
    this.authCount = authCount;
  }

  @JsonIgnore
  public WkInvoiceDTO authReturnTime(Long authReturnTime) {
    this.authReturnTime = authReturnTime;
    return this;
  }

   /**
   * 接收到抵扣反馈的时间
   * @return authReturnTime
  **/
  @ApiModelProperty(value = "接收到抵扣反馈的时间")
  public Long getAuthReturnTime() {
    return authReturnTime;
  }

  public void setAuthReturnTime(Long authReturnTime) {
    this.authReturnTime = authReturnTime;
  }

  @JsonIgnore
  public WkInvoiceDTO actualAuthWay(Integer actualAuthWay) {
    this.actualAuthWay = actualAuthWay;
    return this;
  }

   /**
   * 实际认证方式 0非手工调整 1手工调整2-无
   * @return actualAuthWay
  **/
  @ApiModelProperty(value = "实际认证方式 0非手工调整 1手工调整2-无")
  public Integer getActualAuthWay() {
    return actualAuthWay;
  }

  public void setActualAuthWay(Integer actualAuthWay) {
    this.actualAuthWay = actualAuthWay;
  }

  @JsonIgnore
  public WkInvoiceDTO redStatus(Integer redStatus) {
    this.redStatus = redStatus;
    return this;
  }

   /**
   * 红冲状态：0-默认；1-待红冲；2-待部分红冲；3-红冲；4-部分红冲, 5-红字发票
   * @return redStatus
  **/
  @ApiModelProperty(value = "红冲状态：0-默认；1-待红冲；2-待部分红冲；3-红冲；4-部分红冲, 5-红字发票")
  public Integer getRedStatus() {
    return redStatus;
  }

  public void setRedStatus(Integer redStatus) {
    this.redStatus = redStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO redTime(Long redTime) {
    this.redTime = redTime;
    return this;
  }

   /**
   * 红冲时间
   * @return redTime
  **/
  @ApiModelProperty(value = "红冲时间")
  public Long getRedTime() {
    return redTime;
  }

  public void setRedTime(Long redTime) {
    this.redTime = redTime;
  }

  @JsonIgnore
  public WkInvoiceDTO redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return redNotificationNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public WkInvoiceDTO redUserId(Long redUserId) {
    this.redUserId = redUserId;
    return this;
  }

   /**
   * 红冲人ID
   * @return redUserId
  **/
  @ApiModelProperty(value = "红冲人ID")
  public Long getRedUserId() {
    return redUserId;
  }

  public void setRedUserId(Long redUserId) {
    this.redUserId = redUserId;
  }

  @JsonIgnore
  public WkInvoiceDTO redUserName(String redUserName) {
    this.redUserName = redUserName;
    return this;
  }

   /**
   * 红冲人姓名
   * @return redUserName
  **/
  @ApiModelProperty(value = "红冲人姓名")
  public String getRedUserName() {
    return redUserName;
  }

  public void setRedUserName(String redUserName) {
    this.redUserName = redUserName;
  }

  @JsonIgnore
  public WkInvoiceDTO originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

   /**
   * 红冲发票号码
   * @return originInvoiceNo
  **/
  @ApiModelProperty(value = "红冲发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public WkInvoiceDTO originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

   /**
   * 红冲发票代码
   * @return originInvoiceCode
  **/
  @ApiModelProperty(value = "红冲发票代码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public WkInvoiceDTO redRemark(String redRemark) {
    this.redRemark = redRemark;
    return this;
  }

   /**
   * 红冲备注
   * @return redRemark
  **/
  @ApiModelProperty(value = "红冲备注")
  public String getRedRemark() {
    return redRemark;
  }

  public void setRedRemark(String redRemark) {
    this.redRemark = redRemark;
  }

  @JsonIgnore
  public WkInvoiceDTO retreatStatus(Integer retreatStatus) {
    this.retreatStatus = retreatStatus;
    return this;
  }

   /**
   * 退票状态：0-未退(默认)；1-已退
   * @return retreatStatus
  **/
  @ApiModelProperty(value = "退票状态：0-未退(默认)；1-已退")
  public Integer getRetreatStatus() {
    return retreatStatus;
  }

  public void setRetreatStatus(Integer retreatStatus) {
    this.retreatStatus = retreatStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO retreatTime(Long retreatTime) {
    this.retreatTime = retreatTime;
    return this;
  }

   /**
   * 退票操作时间
   * @return retreatTime
  **/
  @ApiModelProperty(value = "退票操作时间")
  public Long getRetreatTime() {
    return retreatTime;
  }

  public void setRetreatTime(Long retreatTime) {
    this.retreatTime = retreatTime;
  }

  @JsonIgnore
  public WkInvoiceDTO retreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
    return this;
  }

   /**
   * 退票操作人ID
   * @return retreatUserId
  **/
  @ApiModelProperty(value = "退票操作人ID")
  public Long getRetreatUserId() {
    return retreatUserId;
  }

  public void setRetreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
  }

  @JsonIgnore
  public WkInvoiceDTO retreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
    return this;
  }

   /**
   * 退票操作人姓名
   * @return retreatUserName
  **/
  @ApiModelProperty(value = "退票操作人姓名")
  public String getRetreatUserName() {
    return retreatUserName;
  }

  public void setRetreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
  }

  @JsonIgnore
  public WkInvoiceDTO retreatRemark(String retreatRemark) {
    this.retreatRemark = retreatRemark;
    return this;
  }

   /**
   * 退票备注
   * @return retreatRemark
  **/
  @ApiModelProperty(value = "退票备注")
  public String getRetreatRemark() {
    return retreatRemark;
  }

  public void setRetreatRemark(String retreatRemark) {
    this.retreatRemark = retreatRemark;
  }

  @JsonIgnore
  public WkInvoiceDTO originSalesbillId(Long originSalesbillId) {
    this.originSalesbillId = originSalesbillId;
    return this;
  }

   /**
   * 原业务单ID
   * @return originSalesbillId
  **/
  @ApiModelProperty(value = "原业务单ID")
  public Long getOriginSalesbillId() {
    return originSalesbillId;
  }

  public void setOriginSalesbillId(Long originSalesbillId) {
    this.originSalesbillId = originSalesbillId;
  }

  @JsonIgnore
  public WkInvoiceDTO originSalesbillNo(String originSalesbillNo) {
    this.originSalesbillNo = originSalesbillNo;
    return this;
  }

   /**
   * 原业务单号
   * @return originSalesbillNo
  **/
  @ApiModelProperty(value = "原业务单号")
  public String getOriginSalesbillNo() {
    return originSalesbillNo;
  }

  public void setOriginSalesbillNo(String originSalesbillNo) {
    this.originSalesbillNo = originSalesbillNo;
  }

  @JsonIgnore
  public WkInvoiceDTO cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人姓名
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人姓名")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public WkInvoiceDTO checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人姓名
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人姓名")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public WkInvoiceDTO invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人姓名
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人姓名")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public WkInvoiceDTO provinceCode(Integer provinceCode) {
    this.provinceCode = provinceCode;
    return this;
  }

   /**
   * null
   * @return provinceCode
  **/
  @ApiModelProperty(value = "null")
  public Integer getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(Integer provinceCode) {
    this.provinceCode = provinceCode;
  }

  @JsonIgnore
  public WkInvoiceDTO provinceName(String provinceName) {
    this.provinceName = provinceName;
    return this;
  }

   /**
   * 省份名称
   * @return provinceName
  **/
  @ApiModelProperty(value = "省份名称")
  public String getProvinceName() {
    return provinceName;
  }

  public void setProvinceName(String provinceName) {
    this.provinceName = provinceName;
  }

  @JsonIgnore
  public WkInvoiceDTO recogUserId(Long recogUserId) {
    this.recogUserId = recogUserId;
    return this;
  }

   /**
   * 识别操作人ID
   * @return recogUserId
  **/
  @ApiModelProperty(value = "识别操作人ID")
  public Long getRecogUserId() {
    return recogUserId;
  }

  public void setRecogUserId(Long recogUserId) {
    this.recogUserId = recogUserId;
  }

  @JsonIgnore
  public WkInvoiceDTO recogDeductionImageUrl(String recogDeductionImageUrl) {
    this.recogDeductionImageUrl = recogDeductionImageUrl;
    return this;
  }

   /**
   * 识别影像抵扣联路径
   * @return recogDeductionImageUrl
  **/
  @ApiModelProperty(value = "识别影像抵扣联路径")
  public String getRecogDeductionImageUrl() {
    return recogDeductionImageUrl;
  }

  public void setRecogDeductionImageUrl(String recogDeductionImageUrl) {
    this.recogDeductionImageUrl = recogDeductionImageUrl;
  }

  @JsonIgnore
  public WkInvoiceDTO recogInvoiceImageUrl(String recogInvoiceImageUrl) {
    this.recogInvoiceImageUrl = recogInvoiceImageUrl;
    return this;
  }

   /**
   * 识别影像发票联路径
   * @return recogInvoiceImageUrl
  **/
  @ApiModelProperty(value = "识别影像发票联路径")
  public String getRecogInvoiceImageUrl() {
    return recogInvoiceImageUrl;
  }

  public void setRecogInvoiceImageUrl(String recogInvoiceImageUrl) {
    this.recogInvoiceImageUrl = recogInvoiceImageUrl;
  }

  @JsonIgnore
  public WkInvoiceDTO pdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
    return this;
  }

   /**
   * PDF文件地址
   * @return pdfUrl
  **/
  @ApiModelProperty(value = "PDF文件地址")
  public String getPdfUrl() {
    return pdfUrl;
  }

  public void setPdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
  }

  @JsonIgnore
  public WkInvoiceDTO vehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }

  @JsonIgnore
  public WkInvoiceDTO vehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
    return this;
  }

   /**
   * 厂牌型号
   * @return vehicleBrand
  **/
  @ApiModelProperty(value = "厂牌型号")
  public String getVehicleBrand() {
    return vehicleBrand;
  }

  public void setVehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
  }

  @JsonIgnore
  public WkInvoiceDTO productionArea(String productionArea) {
    this.productionArea = productionArea;
    return this;
  }

   /**
   * 产地
   * @return productionArea
  **/
  @ApiModelProperty(value = "产地")
  public String getProductionArea() {
    return productionArea;
  }

  public void setProductionArea(String productionArea) {
    this.productionArea = productionArea;
  }

  @JsonIgnore
  public WkInvoiceDTO certNo(String certNo) {
    this.certNo = certNo;
    return this;
  }

   /**
   * 合格证号
   * @return certNo
  **/
  @ApiModelProperty(value = "合格证号")
  public String getCertNo() {
    return certNo;
  }

  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  @JsonIgnore
  public WkInvoiceDTO importCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
    return this;
  }

   /**
   * 进口证明书编号
   * @return importCertNo
  **/
  @ApiModelProperty(value = "进口证明书编号")
  public String getImportCertNo() {
    return importCertNo;
  }

  public void setImportCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
  }

  @JsonIgnore
  public WkInvoiceDTO inspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
    return this;
  }

   /**
   * 商检单号
   * @return inspectionNo
  **/
  @ApiModelProperty(value = "商检单号")
  public String getInspectionNo() {
    return inspectionNo;
  }

  public void setInspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
  }

  @JsonIgnore
  public WkInvoiceDTO engineNo(String engineNo) {
    this.engineNo = engineNo;
    return this;
  }

   /**
   * 发动机号码
   * @return engineNo
  **/
  @ApiModelProperty(value = "发动机号码")
  public String getEngineNo() {
    return engineNo;
  }

  public void setEngineNo(String engineNo) {
    this.engineNo = engineNo;
  }

  @JsonIgnore
  public WkInvoiceDTO organizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
    return this;
  }

   /**
   * 身份证号码/组织机构码
   * @return organizationCode
  **/
  @ApiModelProperty(value = "身份证号码/组织机构码")
  public String getOrganizationCode() {
    return organizationCode;
  }

  public void setOrganizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
  }

  @JsonIgnore
  public WkInvoiceDTO vin(String vin) {
    this.vin = vin;
    return this;
  }

   /**
   * 车辆识别代号/车架号码
   * @return vin
  **/
  @ApiModelProperty(value = "车辆识别代号/车架号码")
  public String getVin() {
    return vin;
  }

  public void setVin(String vin) {
    this.vin = vin;
  }

  @JsonIgnore
  public WkInvoiceDTO tonnage(String tonnage) {
    this.tonnage = tonnage;
    return this;
  }

   /**
   * 吨位
   * @return tonnage
  **/
  @ApiModelProperty(value = "吨位")
  public String getTonnage() {
    return tonnage;
  }

  public void setTonnage(String tonnage) {
    this.tonnage = tonnage;
  }

  @JsonIgnore
  public WkInvoiceDTO taxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
    return this;
  }

   /**
   * 完税凭证号
   * @return taxPaidProof
  **/
  @ApiModelProperty(value = "完税凭证号")
  public String getTaxPaidProof() {
    return taxPaidProof;
  }

  public void setTaxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
  }

  @JsonIgnore
  public WkInvoiceDTO maxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
    return this;
  }

   /**
   * 限乘人数
   * @return maxCapacity
  **/
  @ApiModelProperty(value = "限乘人数")
  public String getMaxCapacity() {
    return maxCapacity;
  }

  public void setMaxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
  }

  @JsonIgnore
  public WkInvoiceDTO taxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
    return this;
  }

   /**
   * 主管税务机关名称
   * @return taxAuthName
  **/
  @ApiModelProperty(value = "主管税务机关名称")
  public String getTaxAuthName() {
    return taxAuthName;
  }

  public void setTaxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
  }

  @JsonIgnore
  public WkInvoiceDTO taxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
    return this;
  }

   /**
   * 主管税务机关代码
   * @return taxAuthCode
  **/
  @ApiModelProperty(value = "主管税务机关代码")
  public String getTaxAuthCode() {
    return taxAuthCode;
  }

  public void setTaxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
  }

  @JsonIgnore
  public WkInvoiceDTO remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 发票备注
   * @return remark
  **/
  @ApiModelProperty(value = "发票备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceCheckStatus(Integer invoiceCheckStatus) {
    this.invoiceCheckStatus = invoiceCheckStatus;
    return this;
  }

   /**
   * 发票审核状态：0-待审核，20-审核成功，30-审核不通过,40-打回
   * @return invoiceCheckStatus
  **/
  @ApiModelProperty(value = "发票审核状态：0-待审核，20-审核成功，30-审核不通过,40-打回")
  public Integer getInvoiceCheckStatus() {
    return invoiceCheckStatus;
  }

  public void setInvoiceCheckStatus(Integer invoiceCheckStatus) {
    this.invoiceCheckStatus = invoiceCheckStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceCheckNote(String invoiceCheckNote) {
    this.invoiceCheckNote = invoiceCheckNote;
    return this;
  }

   /**
   * 结算单发票审核说明
   * @return invoiceCheckNote
  **/
  @ApiModelProperty(value = "结算单发票审核说明")
  public String getInvoiceCheckNote() {
    return invoiceCheckNote;
  }

  public void setInvoiceCheckNote(String invoiceCheckNote) {
    this.invoiceCheckNote = invoiceCheckNote;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceCheckPerson(String invoiceCheckPerson) {
    this.invoiceCheckPerson = invoiceCheckPerson;
    return this;
  }

   /**
   * 结算单发票审核人
   * @return invoiceCheckPerson
  **/
  @ApiModelProperty(value = "结算单发票审核人")
  public String getInvoiceCheckPerson() {
    return invoiceCheckPerson;
  }

  public void setInvoiceCheckPerson(String invoiceCheckPerson) {
    this.invoiceCheckPerson = invoiceCheckPerson;
  }

  @JsonIgnore
  public WkInvoiceDTO invoiceCheckTime(Long invoiceCheckTime) {
    this.invoiceCheckTime = invoiceCheckTime;
    return this;
  }

   /**
   * 发票审核时间
   * @return invoiceCheckTime
  **/
  @ApiModelProperty(value = "发票审核时间")
  public Long getInvoiceCheckTime() {
    return invoiceCheckTime;
  }

  public void setInvoiceCheckTime(Long invoiceCheckTime) {
    this.invoiceCheckTime = invoiceCheckTime;
  }

  @JsonIgnore
  public WkInvoiceDTO smInvoiceCode(String smInvoiceCode) {
    this.smInvoiceCode = smInvoiceCode;
    return this;
  }

   /**
   * 扫描发票代码
   * @return smInvoiceCode
  **/
  @ApiModelProperty(value = "扫描发票代码")
  public String getSmInvoiceCode() {
    return smInvoiceCode;
  }

  public void setSmInvoiceCode(String smInvoiceCode) {
    this.smInvoiceCode = smInvoiceCode;
  }

  @JsonIgnore
  public WkInvoiceDTO smInvoiceNo(String smInvoiceNo) {
    this.smInvoiceNo = smInvoiceNo;
    return this;
  }

   /**
   * 扫描发票号码
   * @return smInvoiceNo
  **/
  @ApiModelProperty(value = "扫描发票号码")
  public String getSmInvoiceNo() {
    return smInvoiceNo;
  }

  public void setSmInvoiceNo(String smInvoiceNo) {
    this.smInvoiceNo = smInvoiceNo;
  }

  @JsonIgnore
  public WkInvoiceDTO smPurchaserTaxNo(String smPurchaserTaxNo) {
    this.smPurchaserTaxNo = smPurchaserTaxNo;
    return this;
  }

   /**
   * 扫描购方纳税人识别号
   * @return smPurchaserTaxNo
  **/
  @ApiModelProperty(value = "扫描购方纳税人识别号")
  public String getSmPurchaserTaxNo() {
    return smPurchaserTaxNo;
  }

  public void setSmPurchaserTaxNo(String smPurchaserTaxNo) {
    this.smPurchaserTaxNo = smPurchaserTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO smSellerTaxNo(String smSellerTaxNo) {
    this.smSellerTaxNo = smSellerTaxNo;
    return this;
  }

   /**
   * 扫描销方纳税人识别号
   * @return smSellerTaxNo
  **/
  @ApiModelProperty(value = "扫描销方纳税人识别号")
  public String getSmSellerTaxNo() {
    return smSellerTaxNo;
  }

  public void setSmSellerTaxNo(String smSellerTaxNo) {
    this.smSellerTaxNo = smSellerTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO smPaperDrewDate(String smPaperDrewDate) {
    this.smPaperDrewDate = smPaperDrewDate;
    return this;
  }

   /**
   * 扫描过来开票日期
   * @return smPaperDrewDate
  **/
  @ApiModelProperty(value = "扫描过来开票日期")
  public String getSmPaperDrewDate() {
    return smPaperDrewDate;
  }

  public void setSmPaperDrewDate(String smPaperDrewDate) {
    this.smPaperDrewDate = smPaperDrewDate;
  }

  @JsonIgnore
  public WkInvoiceDTO smAmountWithoutTax(String smAmountWithoutTax) {
    this.smAmountWithoutTax = smAmountWithoutTax;
    return this;
  }

   /**
   * 不含税金额 - 扫描
   * @return smAmountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额 - 扫描")
  public String getSmAmountWithoutTax() {
    return smAmountWithoutTax;
  }

  public void setSmAmountWithoutTax(String smAmountWithoutTax) {
    this.smAmountWithoutTax = smAmountWithoutTax;
  }

  @JsonIgnore
  public WkInvoiceDTO smTaxAmount(String smTaxAmount) {
    this.smTaxAmount = smTaxAmount;
    return this;
  }

   /**
   * 税额 - 扫描
   * @return smTaxAmount
  **/
  @ApiModelProperty(value = "税额 - 扫描")
  public String getSmTaxAmount() {
    return smTaxAmount;
  }

  public void setSmTaxAmount(String smTaxAmount) {
    this.smTaxAmount = smTaxAmount;
  }

  @JsonIgnore
  public WkInvoiceDTO smAmountWithTax(String smAmountWithTax) {
    this.smAmountWithTax = smAmountWithTax;
    return this;
  }

   /**
   * 含税金额 - 扫描
   * @return smAmountWithTax
  **/
  @ApiModelProperty(value = "含税金额 - 扫描")
  public String getSmAmountWithTax() {
    return smAmountWithTax;
  }

  public void setSmAmountWithTax(String smAmountWithTax) {
    this.smAmountWithTax = smAmountWithTax;
  }

  @JsonIgnore
  public WkInvoiceDTO smUpdator(String smUpdator) {
    this.smUpdator = smUpdator;
    return this;
  }

   /**
   * 修改人-扫描过来
   * @return smUpdator
  **/
  @ApiModelProperty(value = "修改人-扫描过来")
  public String getSmUpdator() {
    return smUpdator;
  }

  public void setSmUpdator(String smUpdator) {
    this.smUpdator = smUpdator;
  }

  @JsonIgnore
  public WkInvoiceDTO smBarcode(String smBarcode) {
    this.smBarcode = smBarcode;
    return this;
  }

   /**
   * 国信接口的发票图片编号
   * @return smBarcode
  **/
  @ApiModelProperty(value = "国信接口的发票图片编号")
  public String getSmBarcode() {
    return smBarcode;
  }

  public void setSmBarcode(String smBarcode) {
    this.smBarcode = smBarcode;
  }

  @JsonIgnore
  public WkInvoiceDTO smImgUrl(String smImgUrl) {
    this.smImgUrl = smImgUrl;
    return this;
  }

   /**
   * 发票影像地址
   * @return smImgUrl
  **/
  @ApiModelProperty(value = "发票影像地址")
  public String getSmImgUrl() {
    return smImgUrl;
  }

  public void setSmImgUrl(String smImgUrl) {
    this.smImgUrl = smImgUrl;
  }

  @JsonIgnore
  public WkInvoiceDTO smInvoiceId(String smInvoiceId) {
    this.smInvoiceId = smInvoiceId;
    return this;
  }

   /**
   * 扫描id
   * @return smInvoiceId
  **/
  @ApiModelProperty(value = "扫描id")
  public String getSmInvoiceId() {
    return smInvoiceId;
  }

  public void setSmInvoiceId(String smInvoiceId) {
    this.smInvoiceId = smInvoiceId;
  }

  @JsonIgnore
  public WkInvoiceDTO smInvoiceSource(Integer smInvoiceSource) {
    this.smInvoiceSource = smInvoiceSource;
    return this;
  }

   /**
   * 1扫描仪2单多啦3手机拍照4其他
   * @return smInvoiceSource
  **/
  @ApiModelProperty(value = "1扫描仪2单多啦3手机拍照4其他")
  public Integer getSmInvoiceSource() {
    return smInvoiceSource;
  }

  public void setSmInvoiceSource(Integer smInvoiceSource) {
    this.smInvoiceSource = smInvoiceSource;
  }

  @JsonIgnore
  public WkInvoiceDTO xtInvoiceCode(String xtInvoiceCode) {
    this.xtInvoiceCode = xtInvoiceCode;
    return this;
  }

   /**
   * 发票代码-来自于业务系统或者喜盈佳
   * @return xtInvoiceCode
  **/
  @ApiModelProperty(value = "发票代码-来自于业务系统或者喜盈佳")
  public String getXtInvoiceCode() {
    return xtInvoiceCode;
  }

  public void setXtInvoiceCode(String xtInvoiceCode) {
    this.xtInvoiceCode = xtInvoiceCode;
  }

  @JsonIgnore
  public WkInvoiceDTO xtInvoiceNo(String xtInvoiceNo) {
    this.xtInvoiceNo = xtInvoiceNo;
    return this;
  }

   /**
   * 发票号码-来自于业务系统或者喜盈佳
   * @return xtInvoiceNo
  **/
  @ApiModelProperty(value = "发票号码-来自于业务系统或者喜盈佳")
  public String getXtInvoiceNo() {
    return xtInvoiceNo;
  }

  public void setXtInvoiceNo(String xtInvoiceNo) {
    this.xtInvoiceNo = xtInvoiceNo;
  }

  @JsonIgnore
  public WkInvoiceDTO xtPurchaserTaxNo(String xtPurchaserTaxNo) {
    this.xtPurchaserTaxNo = xtPurchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号-来自于业务系统或者喜盈佳
   * @return xtPurchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号-来自于业务系统或者喜盈佳")
  public String getXtPurchaserTaxNo() {
    return xtPurchaserTaxNo;
  }

  public void setXtPurchaserTaxNo(String xtPurchaserTaxNo) {
    this.xtPurchaserTaxNo = xtPurchaserTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO xtSellerTaxNo(String xtSellerTaxNo) {
    this.xtSellerTaxNo = xtSellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号-来自于业务系统或者喜盈佳
   * @return xtSellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号-来自于业务系统或者喜盈佳")
  public String getXtSellerTaxNo() {
    return xtSellerTaxNo;
  }

  public void setXtSellerTaxNo(String xtSellerTaxNo) {
    this.xtSellerTaxNo = xtSellerTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO xtPaperDrewDate(String xtPaperDrewDate) {
    this.xtPaperDrewDate = xtPaperDrewDate;
    return this;
  }

   /**
   * 开票日期-来自于业务系统或者喜盈佳
   * @return xtPaperDrewDate
  **/
  @ApiModelProperty(value = "开票日期-来自于业务系统或者喜盈佳")
  public String getXtPaperDrewDate() {
    return xtPaperDrewDate;
  }

  public void setXtPaperDrewDate(String xtPaperDrewDate) {
    this.xtPaperDrewDate = xtPaperDrewDate;
  }

  @JsonIgnore
  public WkInvoiceDTO xtAmountWithoutTax(String xtAmountWithoutTax) {
    this.xtAmountWithoutTax = xtAmountWithoutTax;
    return this;
  }

   /**
   * 不含税金额-来自于authTime业务系统或者喜盈佳
   * @return xtAmountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额-来自于authTime业务系统或者喜盈佳")
  public String getXtAmountWithoutTax() {
    return xtAmountWithoutTax;
  }

  public void setXtAmountWithoutTax(String xtAmountWithoutTax) {
    this.xtAmountWithoutTax = xtAmountWithoutTax;
  }

  @JsonIgnore
  public WkInvoiceDTO xtTaxAmount(String xtTaxAmount) {
    this.xtTaxAmount = xtTaxAmount;
    return this;
  }

   /**
   * 税额-来自于业务系统或者喜盈佳
   * @return xtTaxAmount
  **/
  @ApiModelProperty(value = "税额-来自于业务系统或者喜盈佳")
  public String getXtTaxAmount() {
    return xtTaxAmount;
  }

  public void setXtTaxAmount(String xtTaxAmount) {
    this.xtTaxAmount = xtTaxAmount;
  }

  @JsonIgnore
  public WkInvoiceDTO xtAmountWithTax(String xtAmountWithTax) {
    this.xtAmountWithTax = xtAmountWithTax;
    return this;
  }

   /**
   * 含税金额-来自于业务系统或者喜盈佳
   * @return xtAmountWithTax
  **/
  @ApiModelProperty(value = "含税金额-来自于业务系统或者喜盈佳")
  public String getXtAmountWithTax() {
    return xtAmountWithTax;
  }

  public void setXtAmountWithTax(String xtAmountWithTax) {
    this.xtAmountWithTax = xtAmountWithTax;
  }

  @JsonIgnore
  public WkInvoiceDTO xtTaxRate(BigDecimal xtTaxRate) {
    this.xtTaxRate = xtTaxRate;
    return this;
  }

   /**
   * 税率
   * @return xtTaxRate
  **/
  @ApiModelProperty(value = "税率")
  public BigDecimal getXtTaxRate() {
    return xtTaxRate;
  }

  public void setXtTaxRate(BigDecimal xtTaxRate) {
    this.xtTaxRate = xtTaxRate;
  }

  @JsonIgnore
  public WkInvoiceDTO isPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
    return this;
  }

   /**
   * 是否推送任务1-是
   * @return isPushTask
  **/
  @ApiModelProperty(value = "是否推送任务1-是")
  public Integer getIsPushTask() {
    return isPushTask;
  }

  public void setIsPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
  }

  @JsonIgnore
  public WkInvoiceDTO isObsolete(Integer isObsolete) {
    this.isObsolete = isObsolete;
    return this;
  }

   /**
   * 是否作废，0否，1是(协同就是从喜盈佳发起作废，非协同就是发票平台自 己作废的)
   * @return isObsolete
  **/
  @ApiModelProperty(value = "是否作废，0否，1是(协同就是从喜盈佳发起作废，非协同就是发票平台自 己作废的)")
  public Integer getIsObsolete() {
    return isObsolete;
  }

  public void setIsObsolete(Integer isObsolete) {
    this.isObsolete = isObsolete;
  }

  @JsonIgnore
  public WkInvoiceDTO isResult(Integer isResult) {
    this.isResult = isResult;
    return this;
  }

   /**
   * 临时方案针对勾选确认二合一异常的处理1已反馈，0未反馈
   * @return isResult
  **/
  @ApiModelProperty(value = "临时方案针对勾选确认二合一异常的处理1已反馈，0未反馈")
  public Integer getIsResult() {
    return isResult;
  }

  public void setIsResult(Integer isResult) {
    this.isResult = isResult;
  }

  @JsonIgnore
  public WkInvoiceDTO ifRepeat(Integer ifRepeat) {
    this.ifRepeat = ifRepeat;
    return this;
  }

   /**
   * 是否重复发票1是，0否
   * @return ifRepeat
  **/
  @ApiModelProperty(value = "是否重复发票1是，0否")
  public Integer getIfRepeat() {
    return ifRepeat;
  }

  public void setIfRepeat(Integer ifRepeat) {
    this.ifRepeat = ifRepeat;
  }

  @JsonIgnore
  public WkInvoiceDTO ifAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

   /**
   * 是否需要认证状态 1：是  0：否
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否需要认证状态 1：是  0：否")
  public Integer getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }

  @JsonIgnore
  public WkInvoiceDTO isLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
    return this;
  }

   /**
   * 是否法人协同 1.是 0.否
   * @return isLegalSynergetics
  **/
  @ApiModelProperty(value = "是否法人协同 1.是 0.否")
  public Integer getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }

  @JsonIgnore
  public WkInvoiceDTO signStatus(Integer signStatus) {
    this.signStatus = signStatus;
    return this;
  }

   /**
   * 签收状态 ：10-成功 20-失败
   * @return signStatus
  **/
  @ApiModelProperty(value = "签收状态 ：10-成功 20-失败")
  public Integer getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(Integer signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO auditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

   /**
   * 审核状态：0-未审核  1-审核成功 2-审核不通过
   * @return auditStatus
  **/
  @ApiModelProperty(value = "审核状态：0-未审核  1-审核成功 2-审核不通过")
  public Integer getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO auditUpdateTime(Long auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
    return this;
  }

   /**
   * 审核状态更新时间
   * @return auditUpdateTime
  **/
  @ApiModelProperty(value = "审核状态更新时间")
  public Long getAuditUpdateTime() {
    return auditUpdateTime;
  }

  public void setAuditUpdateTime(Long auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
  }

  @JsonIgnore
  public WkInvoiceDTO auditUser(String auditUser) {
    this.auditUser = auditUser;
    return this;
  }

   /**
   * 审核人（审核岗）
   * @return auditUser
  **/
  @ApiModelProperty(value = "审核人（审核岗）")
  public String getAuditUser() {
    return auditUser;
  }

  public void setAuditUser(String auditUser) {
    this.auditUser = auditUser;
  }

  @JsonIgnore
  public WkInvoiceDTO ifSendException(Integer ifSendException) {
    this.ifSendException = ifSendException;
    return this;
  }

   /**
   * 是否转交异常1是，0否
   * @return ifSendException
  **/
  @ApiModelProperty(value = "是否转交异常1是，0否")
  public Integer getIfSendException() {
    return ifSendException;
  }

  public void setIfSendException(Integer ifSendException) {
    this.ifSendException = ifSendException;
  }

  @JsonIgnore
  public WkInvoiceDTO smMachineCode(String smMachineCode) {
    this.smMachineCode = smMachineCode;
    return this;
  }

   /**
   * 扫描-机器编码
   * @return smMachineCode
  **/
  @ApiModelProperty(value = "扫描-机器编码")
  public String getSmMachineCode() {
    return smMachineCode;
  }

  public void setSmMachineCode(String smMachineCode) {
    this.smMachineCode = smMachineCode;
  }

  @JsonIgnore
  public WkInvoiceDTO smCheckCode(String smCheckCode) {
    this.smCheckCode = smCheckCode;
    return this;
  }

   /**
   * 扫描-校验码
   * @return smCheckCode
  **/
  @ApiModelProperty(value = "扫描-校验码")
  public String getSmCheckCode() {
    return smCheckCode;
  }

  public void setSmCheckCode(String smCheckCode) {
    this.smCheckCode = smCheckCode;
  }

  @JsonIgnore
  public WkInvoiceDTO smCipherText(String smCipherText) {
    this.smCipherText = smCipherText;
    return this;
  }

   /**
   * 扫描-密文
   * @return smCipherText
  **/
  @ApiModelProperty(value = "扫描-密文")
  public String getSmCipherText() {
    return smCipherText;
  }

  public void setSmCipherText(String smCipherText) {
    this.smCipherText = smCipherText;
  }

  @JsonIgnore
  public WkInvoiceDTO xtMachineCode(String xtMachineCode) {
    this.xtMachineCode = xtMachineCode;
    return this;
  }

   /**
   * 协同-机器编码
   * @return xtMachineCode
  **/
  @ApiModelProperty(value = "协同-机器编码")
  public String getXtMachineCode() {
    return xtMachineCode;
  }

  public void setXtMachineCode(String xtMachineCode) {
    this.xtMachineCode = xtMachineCode;
  }

  @JsonIgnore
  public WkInvoiceDTO xtCheckCode(String xtCheckCode) {
    this.xtCheckCode = xtCheckCode;
    return this;
  }

   /**
   * 协同-校验码
   * @return xtCheckCode
  **/
  @ApiModelProperty(value = "协同-校验码")
  public String getXtCheckCode() {
    return xtCheckCode;
  }

  public void setXtCheckCode(String xtCheckCode) {
    this.xtCheckCode = xtCheckCode;
  }

  @JsonIgnore
  public WkInvoiceDTO xtCipherText(String xtCipherText) {
    this.xtCipherText = xtCipherText;
    return this;
  }

   /**
   * 协同-密文
   * @return xtCipherText
  **/
  @ApiModelProperty(value = "协同-密文")
  public String getXtCipherText() {
    return xtCipherText;
  }

  public void setXtCipherText(String xtCipherText) {
    this.xtCipherText = xtCipherText;
  }

  @JsonIgnore
  public WkInvoiceDTO taxInvoiceCode(String taxInvoiceCode) {
    this.taxInvoiceCode = taxInvoiceCode;
    return this;
  }

   /**
   * 国税 - 发票代码
   * @return taxInvoiceCode
  **/
  @ApiModelProperty(value = "国税 - 发票代码")
  public String getTaxInvoiceCode() {
    return taxInvoiceCode;
  }

  public void setTaxInvoiceCode(String taxInvoiceCode) {
    this.taxInvoiceCode = taxInvoiceCode;
  }

  @JsonIgnore
  public WkInvoiceDTO taxInvoiceNo(String taxInvoiceNo) {
    this.taxInvoiceNo = taxInvoiceNo;
    return this;
  }

   /**
   * 国税 - 发票号码
   * @return taxInvoiceNo
  **/
  @ApiModelProperty(value = "国税 - 发票号码")
  public String getTaxInvoiceNo() {
    return taxInvoiceNo;
  }

  public void setTaxInvoiceNo(String taxInvoiceNo) {
    this.taxInvoiceNo = taxInvoiceNo;
  }

  @JsonIgnore
  public WkInvoiceDTO taxPurchaserTaxNo(String taxPurchaserTaxNo) {
    this.taxPurchaserTaxNo = taxPurchaserTaxNo;
    return this;
  }

   /**
   * 国税 - 购方税号
   * @return taxPurchaserTaxNo
  **/
  @ApiModelProperty(value = "国税 - 购方税号")
  public String getTaxPurchaserTaxNo() {
    return taxPurchaserTaxNo;
  }

  public void setTaxPurchaserTaxNo(String taxPurchaserTaxNo) {
    this.taxPurchaserTaxNo = taxPurchaserTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO taxSellerTaxNo(String taxSellerTaxNo) {
    this.taxSellerTaxNo = taxSellerTaxNo;
    return this;
  }

   /**
   * 国税 - 销方税号
   * @return taxSellerTaxNo
  **/
  @ApiModelProperty(value = "国税 - 销方税号")
  public String getTaxSellerTaxNo() {
    return taxSellerTaxNo;
  }

  public void setTaxSellerTaxNo(String taxSellerTaxNo) {
    this.taxSellerTaxNo = taxSellerTaxNo;
  }

  @JsonIgnore
  public WkInvoiceDTO taxPaperDrewDate(String taxPaperDrewDate) {
    this.taxPaperDrewDate = taxPaperDrewDate;
    return this;
  }

   /**
   * 国税 - 开票日期
   * @return taxPaperDrewDate
  **/
  @ApiModelProperty(value = "国税 - 开票日期")
  public String getTaxPaperDrewDate() {
    return taxPaperDrewDate;
  }

  public void setTaxPaperDrewDate(String taxPaperDrewDate) {
    this.taxPaperDrewDate = taxPaperDrewDate;
  }

  @JsonIgnore
  public WkInvoiceDTO taxAmountWithoutTax(String taxAmountWithoutTax) {
    this.taxAmountWithoutTax = taxAmountWithoutTax;
    return this;
  }

   /**
   * 国税 - 不含税金额
   * @return taxAmountWithoutTax
  **/
  @ApiModelProperty(value = "国税 - 不含税金额")
  public String getTaxAmountWithoutTax() {
    return taxAmountWithoutTax;
  }

  public void setTaxAmountWithoutTax(String taxAmountWithoutTax) {
    this.taxAmountWithoutTax = taxAmountWithoutTax;
  }

  @JsonIgnore
  public WkInvoiceDTO taxTaxAmount(String taxTaxAmount) {
    this.taxTaxAmount = taxTaxAmount;
    return this;
  }

   /**
   * 国税 - 税额
   * @return taxTaxAmount
  **/
  @ApiModelProperty(value = "国税 - 税额")
  public String getTaxTaxAmount() {
    return taxTaxAmount;
  }

  public void setTaxTaxAmount(String taxTaxAmount) {
    this.taxTaxAmount = taxTaxAmount;
  }

  @JsonIgnore
  public WkInvoiceDTO taxAmountWithTax(String taxAmountWithTax) {
    this.taxAmountWithTax = taxAmountWithTax;
    return this;
  }

   /**
   * 国税 - 含税金额
   * @return taxAmountWithTax
  **/
  @ApiModelProperty(value = "国税 - 含税金额")
  public String getTaxAmountWithTax() {
    return taxAmountWithTax;
  }

  public void setTaxAmountWithTax(String taxAmountWithTax) {
    this.taxAmountWithTax = taxAmountWithTax;
  }

  @JsonIgnore
  public WkInvoiceDTO taxMachineCode(String taxMachineCode) {
    this.taxMachineCode = taxMachineCode;
    return this;
  }

   /**
   * 国税 - 机器编码
   * @return taxMachineCode
  **/
  @ApiModelProperty(value = "国税 - 机器编码")
  public String getTaxMachineCode() {
    return taxMachineCode;
  }

  public void setTaxMachineCode(String taxMachineCode) {
    this.taxMachineCode = taxMachineCode;
  }

  @JsonIgnore
  public WkInvoiceDTO taxCheckCode(String taxCheckCode) {
    this.taxCheckCode = taxCheckCode;
    return this;
  }

   /**
   * 国税 - 校验码
   * @return taxCheckCode
  **/
  @ApiModelProperty(value = "国税 - 校验码")
  public String getTaxCheckCode() {
    return taxCheckCode;
  }

  public void setTaxCheckCode(String taxCheckCode) {
    this.taxCheckCode = taxCheckCode;
  }

  @JsonIgnore
  public WkInvoiceDTO taxCipherText(String taxCipherText) {
    this.taxCipherText = taxCipherText;
    return this;
  }

   /**
   * 国税 - 密文
   * @return taxCipherText
  **/
  @ApiModelProperty(value = "国税 - 密文")
  public String getTaxCipherText() {
    return taxCipherText;
  }

  public void setTaxCipherText(String taxCipherText) {
    this.taxCipherText = taxCipherText;
  }

  @JsonIgnore
  public WkInvoiceDTO pushAuthStatus(Integer pushAuthStatus) {
    this.pushAuthStatus = pushAuthStatus;
    return this;
  }

   /**
   * 推送认证状态至任务平台，0-默认，1-成功，2-失败
   * @return pushAuthStatus
  **/
  @ApiModelProperty(value = "推送认证状态至任务平台，0-默认，1-成功，2-失败")
  public Integer getPushAuthStatus() {
    return pushAuthStatus;
  }

  public void setPushAuthStatus(Integer pushAuthStatus) {
    this.pushAuthStatus = pushAuthStatus;
  }

  @JsonIgnore
  public WkInvoiceDTO pushAuthTime(Long pushAuthTime) {
    this.pushAuthTime = pushAuthTime;
    return this;
  }

   /**
   * 推送认证状态至任务平台时间
   * @return pushAuthTime
  **/
  @ApiModelProperty(value = "推送认证状态至任务平台时间")
  public Long getPushAuthTime() {
    return pushAuthTime;
  }

  public void setPushAuthTime(Long pushAuthTime) {
    this.pushAuthTime = pushAuthTime;
  }

  @JsonIgnore
  public WkInvoiceDTO authNoOverdueDate(String authNoOverdueDate) {
    this.authNoOverdueDate = authNoOverdueDate;
    return this;
  }

   /**
   * 认证未逾期日期yyyyMMdd
   * @return authNoOverdueDate
  **/
  @ApiModelProperty(value = "认证未逾期日期yyyyMMdd")
  public String getAuthNoOverdueDate() {
    return authNoOverdueDate;
  }

  public void setAuthNoOverdueDate(String authNoOverdueDate) {
    this.authNoOverdueDate = authNoOverdueDate;
  }

  @JsonIgnore
  public WkInvoiceDTO authWarnDays(Integer authWarnDays) {
    this.authWarnDays = authWarnDays;
    return this;
  }

   /**
   * 剩余可认证天数预警
   * @return authWarnDays
  **/
  @ApiModelProperty(value = "剩余可认证天数预警")
  public Integer getAuthWarnDays() {
    return authWarnDays;
  }

  public void setAuthWarnDays(Integer authWarnDays) {
    this.authWarnDays = authWarnDays;
  }

  @JsonIgnore
  public WkInvoiceDTO signTime(Long signTime) {
    this.signTime = signTime;
    return this;
  }

   /**
   * 签收时间
   * @return signTime
  **/
  @ApiModelProperty(value = "签收时间")
  public Long getSignTime() {
    return signTime;
  }

  public void setSignTime(Long signTime) {
    this.signTime = signTime;
  }

  @JsonIgnore
  public WkInvoiceDTO sendExceptionRemark(String sendExceptionRemark) {
    this.sendExceptionRemark = sendExceptionRemark;
    return this;
  }

   /**
   * 转交异常备注
   * @return sendExceptionRemark
  **/
  @ApiModelProperty(value = "转交异常备注")
  public String getSendExceptionRemark() {
    return sendExceptionRemark;
  }

  public void setSendExceptionRemark(String sendExceptionRemark) {
    this.sendExceptionRemark = sendExceptionRemark;
  }

  @JsonIgnore
  public WkInvoiceDTO authPurposes(Integer authPurposes) {
    this.authPurposes = authPurposes;
    return this;
  }

   /**
   * 抵扣用途：1-抵扣，0-不抵扣
   * @return authPurposes
  **/
  @ApiModelProperty(value = "抵扣用途：1-抵扣，0-不抵扣")
  public Integer getAuthPurposes() {
    return authPurposes;
  }

  public void setAuthPurposes(Integer authPurposes) {
    this.authPurposes = authPurposes;
  }

  @JsonIgnore
  public WkInvoiceDTO authValidTaxAmount(BigDecimal authValidTaxAmount) {
    this.authValidTaxAmount = authValidTaxAmount;
    return this;
  }

   /**
   * 有效税额
   * @return authValidTaxAmount
  **/
  @ApiModelProperty(value = "有效税额")
  public BigDecimal getAuthValidTaxAmount() {
    return authValidTaxAmount;
  }

  public void setAuthValidTaxAmount(BigDecimal authValidTaxAmount) {
    this.authValidTaxAmount = authValidTaxAmount;
  }

  @JsonIgnore
  public WkInvoiceDTO authCheckRequestTime(Long authCheckRequestTime) {
    this.authCheckRequestTime = authCheckRequestTime;
    return this;
  }

   /**
   * 勾选请求时间
   * @return authCheckRequestTime
  **/
  @ApiModelProperty(value = "勾选请求时间")
  public Long getAuthCheckRequestTime() {
    return authCheckRequestTime;
  }

  public void setAuthCheckRequestTime(Long authCheckRequestTime) {
    this.authCheckRequestTime = authCheckRequestTime;
  }

  @JsonIgnore
  public WkInvoiceDTO authCheckUserId(Long authCheckUserId) {
    this.authCheckUserId = authCheckUserId;
    return this;
  }

   /**
   * 勾选操作人id
   * @return authCheckUserId
  **/
  @ApiModelProperty(value = "勾选操作人id")
  public Long getAuthCheckUserId() {
    return authCheckUserId;
  }

  public void setAuthCheckUserId(Long authCheckUserId) {
    this.authCheckUserId = authCheckUserId;
  }

  @JsonIgnore
  public WkInvoiceDTO authCheckUserName(String authCheckUserName) {
    this.authCheckUserName = authCheckUserName;
    return this;
  }

   /**
   * 勾选操作人名
   * @return authCheckUserName
  **/
  @ApiModelProperty(value = "勾选操作人名")
  public String getAuthCheckUserName() {
    return authCheckUserName;
  }

  public void setAuthCheckUserName(String authCheckUserName) {
    this.authCheckUserName = authCheckUserName;
  }

  @JsonIgnore
  public WkInvoiceDTO authCheckResponseTime(Long authCheckResponseTime) {
    this.authCheckResponseTime = authCheckResponseTime;
    return this;
  }

   /**
   * 勾选完成时间
   * @return authCheckResponseTime
  **/
  @ApiModelProperty(value = "勾选完成时间")
  public Long getAuthCheckResponseTime() {
    return authCheckResponseTime;
  }

  public void setAuthCheckResponseTime(Long authCheckResponseTime) {
    this.authCheckResponseTime = authCheckResponseTime;
  }

  @JsonIgnore
  public WkInvoiceDTO cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 是否购销协同0-否，1-是
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "是否购销协同0-否，1-是")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public WkInvoiceDTO authExceType(Integer authExceType) {
    this.authExceType = authExceType;
    return this;
  }

   /**
   * 勾选异常类型0-默认，1-网络超时，2-密码错误，3-其他
   * @return authExceType
  **/
  @ApiModelProperty(value = "勾选异常类型0-默认，1-网络超时，2-密码错误，3-其他")
  public Integer getAuthExceType() {
    return authExceType;
  }

  public void setAuthExceType(Integer authExceType) {
    this.authExceType = authExceType;
  }

  @JsonIgnore
  public WkInvoiceDTO xtOperateTime(Long xtOperateTime) {
    this.xtOperateTime = xtOperateTime;
    return this;
  }

   /**
   * 协同发票开票操作时间
   * @return xtOperateTime
  **/
  @ApiModelProperty(value = "协同发票开票操作时间")
  public Long getXtOperateTime() {
    return xtOperateTime;
  }

  public void setXtOperateTime(Long xtOperateTime) {
    this.xtOperateTime = xtOperateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkInvoiceDTO wkInvoiceDTO = (WkInvoiceDTO) o;
    return Objects.equals(this.id, wkInvoiceDTO.id) &&
        Objects.equals(this.invoiceType, wkInvoiceDTO.invoiceType) &&
        Objects.equals(this.invoiceNo, wkInvoiceDTO.invoiceNo) &&
        Objects.equals(this.invoiceCode, wkInvoiceDTO.invoiceCode) &&
        Objects.equals(this.status, wkInvoiceDTO.status) &&
        Objects.equals(this.createTime, wkInvoiceDTO.createTime) &&
        Objects.equals(this.updateTime, wkInvoiceDTO.updateTime) &&
        Objects.equals(this.salesbillId, wkInvoiceDTO.salesbillId) &&
        Objects.equals(this.salesbillNo, wkInvoiceDTO.salesbillNo) &&
        Objects.equals(this.packageCode, wkInvoiceDTO.packageCode) &&
        Objects.equals(this.purchaserName, wkInvoiceDTO.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, wkInvoiceDTO.purchaserTaxNo) &&
        Objects.equals(this.purchaserAddress, wkInvoiceDTO.purchaserAddress) &&
        Objects.equals(this.purchaserTel, wkInvoiceDTO.purchaserTel) &&
        Objects.equals(this.purchaserAddrTel, wkInvoiceDTO.purchaserAddrTel) &&
        Objects.equals(this.purchaserBankName, wkInvoiceDTO.purchaserBankName) &&
        Objects.equals(this.purchaserBankAccount, wkInvoiceDTO.purchaserBankAccount) &&
        Objects.equals(this.purchaserBankNameAccount, wkInvoiceDTO.purchaserBankNameAccount) &&
        Objects.equals(this.purchaserExternalCode, wkInvoiceDTO.purchaserExternalCode) &&
        Objects.equals(this.sellerName, wkInvoiceDTO.sellerName) &&
        Objects.equals(this.sellerTaxNo, wkInvoiceDTO.sellerTaxNo) &&
        Objects.equals(this.sellerAddress, wkInvoiceDTO.sellerAddress) &&
        Objects.equals(this.sellerTel, wkInvoiceDTO.sellerTel) &&
        Objects.equals(this.sellerAddrTel, wkInvoiceDTO.sellerAddrTel) &&
        Objects.equals(this.sellerBankName, wkInvoiceDTO.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, wkInvoiceDTO.sellerBankAccount) &&
        Objects.equals(this.sellerBankNameAccount, wkInvoiceDTO.sellerBankNameAccount) &&
        Objects.equals(this.sellerExternalCode, wkInvoiceDTO.sellerExternalCode) &&
        Objects.equals(this.sellerInvoiceId, wkInvoiceDTO.sellerInvoiceId) &&
        Objects.equals(this.sellerUserName, wkInvoiceDTO.sellerUserName) &&
        Objects.equals(this.sellerViewImageFlag, wkInvoiceDTO.sellerViewImageFlag) &&
        Objects.equals(this.sellerSyncStatus, wkInvoiceDTO.sellerSyncStatus) &&
        Objects.equals(this.sellerSyncTime, wkInvoiceDTO.sellerSyncTime) &&
        Objects.equals(this.taxRate, wkInvoiceDTO.taxRate) &&
        Objects.equals(this.amountWithoutTax, wkInvoiceDTO.amountWithoutTax) &&
        Objects.equals(this.taxAmount, wkInvoiceDTO.taxAmount) &&
        Objects.equals(this.amountWithTax, wkInvoiceDTO.amountWithTax) &&
        Objects.equals(this.amountWithTaxCapital, wkInvoiceDTO.amountWithTaxCapital) &&
        Objects.equals(this.paperDrewDate, wkInvoiceDTO.paperDrewDate) &&
        Objects.equals(this.machineCode, wkInvoiceDTO.machineCode) &&
        Objects.equals(this.checkCode, wkInvoiceDTO.checkCode) &&
        Objects.equals(this.cipherText, wkInvoiceDTO.cipherText) &&
        Objects.equals(this.invoiceOrig, wkInvoiceDTO.invoiceOrig) &&
        Objects.equals(this.dataFromSystem, wkInvoiceDTO.dataFromSystem) &&
        Objects.equals(this.specialInvoiceFlag, wkInvoiceDTO.specialInvoiceFlag) &&
        Objects.equals(this.titleOkFlag, wkInvoiceDTO.titleOkFlag) &&
        Objects.equals(this.saleListFlag, wkInvoiceDTO.saleListFlag) &&
        Objects.equals(this.dataOkFlag, wkInvoiceDTO.dataOkFlag) &&
        Objects.equals(this.recogStatus, wkInvoiceDTO.recogStatus) &&
        Objects.equals(this.recogImageStatus, wkInvoiceDTO.recogImageStatus) &&
        Objects.equals(this.recogInvoiceId, wkInvoiceDTO.recogInvoiceId) &&
        Objects.equals(this.recogResponseTime, wkInvoiceDTO.recogResponseTime) &&
        Objects.equals(this.recogUserName, wkInvoiceDTO.recogUserName) &&
        Objects.equals(this.recogUploadNum, wkInvoiceDTO.recogUploadNum) &&
        Objects.equals(this.veriInvoiceId, wkInvoiceDTO.veriInvoiceId) &&
        Objects.equals(this.veriStatus, wkInvoiceDTO.veriStatus) &&
        Objects.equals(this.veriRequestTime, wkInvoiceDTO.veriRequestTime) &&
        Objects.equals(this.veriResponseTime, wkInvoiceDTO.veriResponseTime) &&
        Objects.equals(this.veriUserId, wkInvoiceDTO.veriUserId) &&
        Objects.equals(this.veriUserName, wkInvoiceDTO.veriUserName) &&
        Objects.equals(this.veriRemark, wkInvoiceDTO.veriRemark) &&
        Objects.equals(this.taxInvoiceId, wkInvoiceDTO.taxInvoiceId) &&
        Objects.equals(this.authSyncStatus, wkInvoiceDTO.authSyncStatus) &&
        Objects.equals(this.authSyncTime, wkInvoiceDTO.authSyncTime) &&
        Objects.equals(this.authStatus, wkInvoiceDTO.authStatus) &&
        Objects.equals(this.authStyle, wkInvoiceDTO.authStyle) &&
        Objects.equals(this.authBussiDate, wkInvoiceDTO.authBussiDate) &&
        Objects.equals(this.authTaxPeriod, wkInvoiceDTO.authTaxPeriod) &&
        Objects.equals(this.authRequestTime, wkInvoiceDTO.authRequestTime) &&
        Objects.equals(this.authResponseTime, wkInvoiceDTO.authResponseTime) &&
        Objects.equals(this.authRequestUserId, wkInvoiceDTO.authRequestUserId) &&
        Objects.equals(this.authRequestUserName, wkInvoiceDTO.authRequestUserName) &&
        Objects.equals(this.authRequestSerialNo, wkInvoiceDTO.authRequestSerialNo) &&
        Objects.equals(this.authRemark, wkInvoiceDTO.authRemark) &&
        Objects.equals(this.authValidTime, wkInvoiceDTO.authValidTime) &&
        Objects.equals(this.authValidResult, wkInvoiceDTO.authValidResult) &&
        Objects.equals(this.authValidRemark, wkInvoiceDTO.authValidRemark) &&
        Objects.equals(this.authAmountWithoutTax, wkInvoiceDTO.authAmountWithoutTax) &&
        Objects.equals(this.authTaxAmount, wkInvoiceDTO.authTaxAmount) &&
        Objects.equals(this.authCount, wkInvoiceDTO.authCount) &&
        Objects.equals(this.authReturnTime, wkInvoiceDTO.authReturnTime) &&
        Objects.equals(this.actualAuthWay, wkInvoiceDTO.actualAuthWay) &&
        Objects.equals(this.redStatus, wkInvoiceDTO.redStatus) &&
        Objects.equals(this.redTime, wkInvoiceDTO.redTime) &&
        Objects.equals(this.redNotificationNo, wkInvoiceDTO.redNotificationNo) &&
        Objects.equals(this.redUserId, wkInvoiceDTO.redUserId) &&
        Objects.equals(this.redUserName, wkInvoiceDTO.redUserName) &&
        Objects.equals(this.originInvoiceNo, wkInvoiceDTO.originInvoiceNo) &&
        Objects.equals(this.originInvoiceCode, wkInvoiceDTO.originInvoiceCode) &&
        Objects.equals(this.redRemark, wkInvoiceDTO.redRemark) &&
        Objects.equals(this.retreatStatus, wkInvoiceDTO.retreatStatus) &&
        Objects.equals(this.retreatTime, wkInvoiceDTO.retreatTime) &&
        Objects.equals(this.retreatUserId, wkInvoiceDTO.retreatUserId) &&
        Objects.equals(this.retreatUserName, wkInvoiceDTO.retreatUserName) &&
        Objects.equals(this.retreatRemark, wkInvoiceDTO.retreatRemark) &&
        Objects.equals(this.originSalesbillId, wkInvoiceDTO.originSalesbillId) &&
        Objects.equals(this.originSalesbillNo, wkInvoiceDTO.originSalesbillNo) &&
        Objects.equals(this.cashierName, wkInvoiceDTO.cashierName) &&
        Objects.equals(this.checkerName, wkInvoiceDTO.checkerName) &&
        Objects.equals(this.invoicerName, wkInvoiceDTO.invoicerName) &&
        Objects.equals(this.provinceCode, wkInvoiceDTO.provinceCode) &&
        Objects.equals(this.provinceName, wkInvoiceDTO.provinceName) &&
        Objects.equals(this.recogUserId, wkInvoiceDTO.recogUserId) &&
        Objects.equals(this.recogDeductionImageUrl, wkInvoiceDTO.recogDeductionImageUrl) &&
        Objects.equals(this.recogInvoiceImageUrl, wkInvoiceDTO.recogInvoiceImageUrl) &&
        Objects.equals(this.pdfUrl, wkInvoiceDTO.pdfUrl) &&
        Objects.equals(this.vehicleType, wkInvoiceDTO.vehicleType) &&
        Objects.equals(this.vehicleBrand, wkInvoiceDTO.vehicleBrand) &&
        Objects.equals(this.productionArea, wkInvoiceDTO.productionArea) &&
        Objects.equals(this.certNo, wkInvoiceDTO.certNo) &&
        Objects.equals(this.importCertNo, wkInvoiceDTO.importCertNo) &&
        Objects.equals(this.inspectionNo, wkInvoiceDTO.inspectionNo) &&
        Objects.equals(this.engineNo, wkInvoiceDTO.engineNo) &&
        Objects.equals(this.organizationCode, wkInvoiceDTO.organizationCode) &&
        Objects.equals(this.vin, wkInvoiceDTO.vin) &&
        Objects.equals(this.tonnage, wkInvoiceDTO.tonnage) &&
        Objects.equals(this.taxPaidProof, wkInvoiceDTO.taxPaidProof) &&
        Objects.equals(this.maxCapacity, wkInvoiceDTO.maxCapacity) &&
        Objects.equals(this.taxAuthName, wkInvoiceDTO.taxAuthName) &&
        Objects.equals(this.taxAuthCode, wkInvoiceDTO.taxAuthCode) &&
        Objects.equals(this.remark, wkInvoiceDTO.remark) &&
        Objects.equals(this.invoiceCheckStatus, wkInvoiceDTO.invoiceCheckStatus) &&
        Objects.equals(this.invoiceCheckNote, wkInvoiceDTO.invoiceCheckNote) &&
        Objects.equals(this.invoiceCheckPerson, wkInvoiceDTO.invoiceCheckPerson) &&
        Objects.equals(this.invoiceCheckTime, wkInvoiceDTO.invoiceCheckTime) &&
        Objects.equals(this.smInvoiceCode, wkInvoiceDTO.smInvoiceCode) &&
        Objects.equals(this.smInvoiceNo, wkInvoiceDTO.smInvoiceNo) &&
        Objects.equals(this.smPurchaserTaxNo, wkInvoiceDTO.smPurchaserTaxNo) &&
        Objects.equals(this.smSellerTaxNo, wkInvoiceDTO.smSellerTaxNo) &&
        Objects.equals(this.smPaperDrewDate, wkInvoiceDTO.smPaperDrewDate) &&
        Objects.equals(this.smAmountWithoutTax, wkInvoiceDTO.smAmountWithoutTax) &&
        Objects.equals(this.smTaxAmount, wkInvoiceDTO.smTaxAmount) &&
        Objects.equals(this.smAmountWithTax, wkInvoiceDTO.smAmountWithTax) &&
        Objects.equals(this.smUpdator, wkInvoiceDTO.smUpdator) &&
        Objects.equals(this.smBarcode, wkInvoiceDTO.smBarcode) &&
        Objects.equals(this.smImgUrl, wkInvoiceDTO.smImgUrl) &&
        Objects.equals(this.smInvoiceId, wkInvoiceDTO.smInvoiceId) &&
        Objects.equals(this.smInvoiceSource, wkInvoiceDTO.smInvoiceSource) &&
        Objects.equals(this.xtInvoiceCode, wkInvoiceDTO.xtInvoiceCode) &&
        Objects.equals(this.xtInvoiceNo, wkInvoiceDTO.xtInvoiceNo) &&
        Objects.equals(this.xtPurchaserTaxNo, wkInvoiceDTO.xtPurchaserTaxNo) &&
        Objects.equals(this.xtSellerTaxNo, wkInvoiceDTO.xtSellerTaxNo) &&
        Objects.equals(this.xtPaperDrewDate, wkInvoiceDTO.xtPaperDrewDate) &&
        Objects.equals(this.xtAmountWithoutTax, wkInvoiceDTO.xtAmountWithoutTax) &&
        Objects.equals(this.xtTaxAmount, wkInvoiceDTO.xtTaxAmount) &&
        Objects.equals(this.xtAmountWithTax, wkInvoiceDTO.xtAmountWithTax) &&
        Objects.equals(this.xtTaxRate, wkInvoiceDTO.xtTaxRate) &&
        Objects.equals(this.isPushTask, wkInvoiceDTO.isPushTask) &&
        Objects.equals(this.isObsolete, wkInvoiceDTO.isObsolete) &&
        Objects.equals(this.isResult, wkInvoiceDTO.isResult) &&
        Objects.equals(this.ifRepeat, wkInvoiceDTO.ifRepeat) &&
        Objects.equals(this.ifAuthFlag, wkInvoiceDTO.ifAuthFlag) &&
        Objects.equals(this.isLegalSynergetics, wkInvoiceDTO.isLegalSynergetics) &&
        Objects.equals(this.signStatus, wkInvoiceDTO.signStatus) &&
        Objects.equals(this.auditStatus, wkInvoiceDTO.auditStatus) &&
        Objects.equals(this.auditUpdateTime, wkInvoiceDTO.auditUpdateTime) &&
        Objects.equals(this.auditUser, wkInvoiceDTO.auditUser) &&
        Objects.equals(this.ifSendException, wkInvoiceDTO.ifSendException) &&
        Objects.equals(this.smMachineCode, wkInvoiceDTO.smMachineCode) &&
        Objects.equals(this.smCheckCode, wkInvoiceDTO.smCheckCode) &&
        Objects.equals(this.smCipherText, wkInvoiceDTO.smCipherText) &&
        Objects.equals(this.xtMachineCode, wkInvoiceDTO.xtMachineCode) &&
        Objects.equals(this.xtCheckCode, wkInvoiceDTO.xtCheckCode) &&
        Objects.equals(this.xtCipherText, wkInvoiceDTO.xtCipherText) &&
        Objects.equals(this.taxInvoiceCode, wkInvoiceDTO.taxInvoiceCode) &&
        Objects.equals(this.taxInvoiceNo, wkInvoiceDTO.taxInvoiceNo) &&
        Objects.equals(this.taxPurchaserTaxNo, wkInvoiceDTO.taxPurchaserTaxNo) &&
        Objects.equals(this.taxSellerTaxNo, wkInvoiceDTO.taxSellerTaxNo) &&
        Objects.equals(this.taxPaperDrewDate, wkInvoiceDTO.taxPaperDrewDate) &&
        Objects.equals(this.taxAmountWithoutTax, wkInvoiceDTO.taxAmountWithoutTax) &&
        Objects.equals(this.taxTaxAmount, wkInvoiceDTO.taxTaxAmount) &&
        Objects.equals(this.taxAmountWithTax, wkInvoiceDTO.taxAmountWithTax) &&
        Objects.equals(this.taxMachineCode, wkInvoiceDTO.taxMachineCode) &&
        Objects.equals(this.taxCheckCode, wkInvoiceDTO.taxCheckCode) &&
        Objects.equals(this.taxCipherText, wkInvoiceDTO.taxCipherText) &&
        Objects.equals(this.pushAuthStatus, wkInvoiceDTO.pushAuthStatus) &&
        Objects.equals(this.pushAuthTime, wkInvoiceDTO.pushAuthTime) &&
        Objects.equals(this.authNoOverdueDate, wkInvoiceDTO.authNoOverdueDate) &&
        Objects.equals(this.authWarnDays, wkInvoiceDTO.authWarnDays) &&
        Objects.equals(this.signTime, wkInvoiceDTO.signTime) &&
        Objects.equals(this.sendExceptionRemark, wkInvoiceDTO.sendExceptionRemark) &&
        Objects.equals(this.authPurposes, wkInvoiceDTO.authPurposes) &&
        Objects.equals(this.authValidTaxAmount, wkInvoiceDTO.authValidTaxAmount) &&
        Objects.equals(this.authCheckRequestTime, wkInvoiceDTO.authCheckRequestTime) &&
        Objects.equals(this.authCheckUserId, wkInvoiceDTO.authCheckUserId) &&
        Objects.equals(this.authCheckUserName, wkInvoiceDTO.authCheckUserName) &&
        Objects.equals(this.authCheckResponseTime, wkInvoiceDTO.authCheckResponseTime) &&
        Objects.equals(this.cooperateFlag, wkInvoiceDTO.cooperateFlag) &&
        Objects.equals(this.authExceType, wkInvoiceDTO.authExceType) &&
        Objects.equals(this.xtOperateTime, wkInvoiceDTO.xtOperateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, invoiceType, invoiceNo, invoiceCode, status, createTime, updateTime, salesbillId, salesbillNo, packageCode, purchaserName, purchaserTaxNo, purchaserAddress, purchaserTel, purchaserAddrTel, purchaserBankName, purchaserBankAccount, purchaserBankNameAccount, purchaserExternalCode, sellerName, sellerTaxNo, sellerAddress, sellerTel, sellerAddrTel, sellerBankName, sellerBankAccount, sellerBankNameAccount, sellerExternalCode, sellerInvoiceId, sellerUserName, sellerViewImageFlag, sellerSyncStatus, sellerSyncTime, taxRate, amountWithoutTax, taxAmount, amountWithTax, amountWithTaxCapital, paperDrewDate, machineCode, checkCode, cipherText, invoiceOrig, dataFromSystem, specialInvoiceFlag, titleOkFlag, saleListFlag, dataOkFlag, recogStatus, recogImageStatus, recogInvoiceId, recogResponseTime, recogUserName, recogUploadNum, veriInvoiceId, veriStatus, veriRequestTime, veriResponseTime, veriUserId, veriUserName, veriRemark, taxInvoiceId, authSyncStatus, authSyncTime, authStatus, authStyle, authBussiDate, authTaxPeriod, authRequestTime, authResponseTime, authRequestUserId, authRequestUserName, authRequestSerialNo, authRemark, authValidTime, authValidResult, authValidRemark, authAmountWithoutTax, authTaxAmount, authCount, authReturnTime, actualAuthWay, redStatus, redTime, redNotificationNo, redUserId, redUserName, originInvoiceNo, originInvoiceCode, redRemark, retreatStatus, retreatTime, retreatUserId, retreatUserName, retreatRemark, originSalesbillId, originSalesbillNo, cashierName, checkerName, invoicerName, provinceCode, provinceName, recogUserId, recogDeductionImageUrl, recogInvoiceImageUrl, pdfUrl, vehicleType, vehicleBrand, productionArea, certNo, importCertNo, inspectionNo, engineNo, organizationCode, vin, tonnage, taxPaidProof, maxCapacity, taxAuthName, taxAuthCode, remark, invoiceCheckStatus, invoiceCheckNote, invoiceCheckPerson, invoiceCheckTime, smInvoiceCode, smInvoiceNo, smPurchaserTaxNo, smSellerTaxNo, smPaperDrewDate, smAmountWithoutTax, smTaxAmount, smAmountWithTax, smUpdator, smBarcode, smImgUrl, smInvoiceId, smInvoiceSource, xtInvoiceCode, xtInvoiceNo, xtPurchaserTaxNo, xtSellerTaxNo, xtPaperDrewDate, xtAmountWithoutTax, xtTaxAmount, xtAmountWithTax, xtTaxRate, isPushTask, isObsolete, isResult, ifRepeat, ifAuthFlag, isLegalSynergetics, signStatus, auditStatus, auditUpdateTime, auditUser, ifSendException, smMachineCode, smCheckCode, smCipherText, xtMachineCode, xtCheckCode, xtCipherText, taxInvoiceCode, taxInvoiceNo, taxPurchaserTaxNo, taxSellerTaxNo, taxPaperDrewDate, taxAmountWithoutTax, taxTaxAmount, taxAmountWithTax, taxMachineCode, taxCheckCode, taxCipherText, pushAuthStatus, pushAuthTime, authNoOverdueDate, authWarnDays, signTime, sendExceptionRemark, authPurposes, authValidTaxAmount, authCheckRequestTime, authCheckUserId, authCheckUserName, authCheckResponseTime, cooperateFlag, authExceType, xtOperateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkInvoiceDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    salesbillId: ").append(toIndentedString(salesbillId)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddrTel: ").append(toIndentedString(purchaserAddrTel)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    purchaserBankNameAccount: ").append(toIndentedString(purchaserBankNameAccount)).append("\n");
    sb.append("    purchaserExternalCode: ").append(toIndentedString(purchaserExternalCode)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddrTel: ").append(toIndentedString(sellerAddrTel)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    sellerBankNameAccount: ").append(toIndentedString(sellerBankNameAccount)).append("\n");
    sb.append("    sellerExternalCode: ").append(toIndentedString(sellerExternalCode)).append("\n");
    sb.append("    sellerInvoiceId: ").append(toIndentedString(sellerInvoiceId)).append("\n");
    sb.append("    sellerUserName: ").append(toIndentedString(sellerUserName)).append("\n");
    sb.append("    sellerViewImageFlag: ").append(toIndentedString(sellerViewImageFlag)).append("\n");
    sb.append("    sellerSyncStatus: ").append(toIndentedString(sellerSyncStatus)).append("\n");
    sb.append("    sellerSyncTime: ").append(toIndentedString(sellerSyncTime)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithTaxCapital: ").append(toIndentedString(amountWithTaxCapital)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    invoiceOrig: ").append(toIndentedString(invoiceOrig)).append("\n");
    sb.append("    dataFromSystem: ").append(toIndentedString(dataFromSystem)).append("\n");
    sb.append("    specialInvoiceFlag: ").append(toIndentedString(specialInvoiceFlag)).append("\n");
    sb.append("    titleOkFlag: ").append(toIndentedString(titleOkFlag)).append("\n");
    sb.append("    saleListFlag: ").append(toIndentedString(saleListFlag)).append("\n");
    sb.append("    dataOkFlag: ").append(toIndentedString(dataOkFlag)).append("\n");
    sb.append("    recogStatus: ").append(toIndentedString(recogStatus)).append("\n");
    sb.append("    recogImageStatus: ").append(toIndentedString(recogImageStatus)).append("\n");
    sb.append("    recogInvoiceId: ").append(toIndentedString(recogInvoiceId)).append("\n");
    sb.append("    recogResponseTime: ").append(toIndentedString(recogResponseTime)).append("\n");
    sb.append("    recogUserName: ").append(toIndentedString(recogUserName)).append("\n");
    sb.append("    recogUploadNum: ").append(toIndentedString(recogUploadNum)).append("\n");
    sb.append("    veriInvoiceId: ").append(toIndentedString(veriInvoiceId)).append("\n");
    sb.append("    veriStatus: ").append(toIndentedString(veriStatus)).append("\n");
    sb.append("    veriRequestTime: ").append(toIndentedString(veriRequestTime)).append("\n");
    sb.append("    veriResponseTime: ").append(toIndentedString(veriResponseTime)).append("\n");
    sb.append("    veriUserId: ").append(toIndentedString(veriUserId)).append("\n");
    sb.append("    veriUserName: ").append(toIndentedString(veriUserName)).append("\n");
    sb.append("    veriRemark: ").append(toIndentedString(veriRemark)).append("\n");
    sb.append("    taxInvoiceId: ").append(toIndentedString(taxInvoiceId)).append("\n");
    sb.append("    authSyncStatus: ").append(toIndentedString(authSyncStatus)).append("\n");
    sb.append("    authSyncTime: ").append(toIndentedString(authSyncTime)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    authStyle: ").append(toIndentedString(authStyle)).append("\n");
    sb.append("    authBussiDate: ").append(toIndentedString(authBussiDate)).append("\n");
    sb.append("    authTaxPeriod: ").append(toIndentedString(authTaxPeriod)).append("\n");
    sb.append("    authRequestTime: ").append(toIndentedString(authRequestTime)).append("\n");
    sb.append("    authResponseTime: ").append(toIndentedString(authResponseTime)).append("\n");
    sb.append("    authRequestUserId: ").append(toIndentedString(authRequestUserId)).append("\n");
    sb.append("    authRequestUserName: ").append(toIndentedString(authRequestUserName)).append("\n");
    sb.append("    authRequestSerialNo: ").append(toIndentedString(authRequestSerialNo)).append("\n");
    sb.append("    authRemark: ").append(toIndentedString(authRemark)).append("\n");
    sb.append("    authValidTime: ").append(toIndentedString(authValidTime)).append("\n");
    sb.append("    authValidResult: ").append(toIndentedString(authValidResult)).append("\n");
    sb.append("    authValidRemark: ").append(toIndentedString(authValidRemark)).append("\n");
    sb.append("    authAmountWithoutTax: ").append(toIndentedString(authAmountWithoutTax)).append("\n");
    sb.append("    authTaxAmount: ").append(toIndentedString(authTaxAmount)).append("\n");
    sb.append("    authCount: ").append(toIndentedString(authCount)).append("\n");
    sb.append("    authReturnTime: ").append(toIndentedString(authReturnTime)).append("\n");
    sb.append("    actualAuthWay: ").append(toIndentedString(actualAuthWay)).append("\n");
    sb.append("    redStatus: ").append(toIndentedString(redStatus)).append("\n");
    sb.append("    redTime: ").append(toIndentedString(redTime)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    redUserId: ").append(toIndentedString(redUserId)).append("\n");
    sb.append("    redUserName: ").append(toIndentedString(redUserName)).append("\n");
    sb.append("    originInvoiceNo: ").append(toIndentedString(originInvoiceNo)).append("\n");
    sb.append("    originInvoiceCode: ").append(toIndentedString(originInvoiceCode)).append("\n");
    sb.append("    redRemark: ").append(toIndentedString(redRemark)).append("\n");
    sb.append("    retreatStatus: ").append(toIndentedString(retreatStatus)).append("\n");
    sb.append("    retreatTime: ").append(toIndentedString(retreatTime)).append("\n");
    sb.append("    retreatUserId: ").append(toIndentedString(retreatUserId)).append("\n");
    sb.append("    retreatUserName: ").append(toIndentedString(retreatUserName)).append("\n");
    sb.append("    retreatRemark: ").append(toIndentedString(retreatRemark)).append("\n");
    sb.append("    originSalesbillId: ").append(toIndentedString(originSalesbillId)).append("\n");
    sb.append("    originSalesbillNo: ").append(toIndentedString(originSalesbillNo)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    provinceCode: ").append(toIndentedString(provinceCode)).append("\n");
    sb.append("    provinceName: ").append(toIndentedString(provinceName)).append("\n");
    sb.append("    recogUserId: ").append(toIndentedString(recogUserId)).append("\n");
    sb.append("    recogDeductionImageUrl: ").append(toIndentedString(recogDeductionImageUrl)).append("\n");
    sb.append("    recogInvoiceImageUrl: ").append(toIndentedString(recogInvoiceImageUrl)).append("\n");
    sb.append("    pdfUrl: ").append(toIndentedString(pdfUrl)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("    vehicleBrand: ").append(toIndentedString(vehicleBrand)).append("\n");
    sb.append("    productionArea: ").append(toIndentedString(productionArea)).append("\n");
    sb.append("    certNo: ").append(toIndentedString(certNo)).append("\n");
    sb.append("    importCertNo: ").append(toIndentedString(importCertNo)).append("\n");
    sb.append("    inspectionNo: ").append(toIndentedString(inspectionNo)).append("\n");
    sb.append("    engineNo: ").append(toIndentedString(engineNo)).append("\n");
    sb.append("    organizationCode: ").append(toIndentedString(organizationCode)).append("\n");
    sb.append("    vin: ").append(toIndentedString(vin)).append("\n");
    sb.append("    tonnage: ").append(toIndentedString(tonnage)).append("\n");
    sb.append("    taxPaidProof: ").append(toIndentedString(taxPaidProof)).append("\n");
    sb.append("    maxCapacity: ").append(toIndentedString(maxCapacity)).append("\n");
    sb.append("    taxAuthName: ").append(toIndentedString(taxAuthName)).append("\n");
    sb.append("    taxAuthCode: ").append(toIndentedString(taxAuthCode)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    invoiceCheckStatus: ").append(toIndentedString(invoiceCheckStatus)).append("\n");
    sb.append("    invoiceCheckNote: ").append(toIndentedString(invoiceCheckNote)).append("\n");
    sb.append("    invoiceCheckPerson: ").append(toIndentedString(invoiceCheckPerson)).append("\n");
    sb.append("    invoiceCheckTime: ").append(toIndentedString(invoiceCheckTime)).append("\n");
    sb.append("    smInvoiceCode: ").append(toIndentedString(smInvoiceCode)).append("\n");
    sb.append("    smInvoiceNo: ").append(toIndentedString(smInvoiceNo)).append("\n");
    sb.append("    smPurchaserTaxNo: ").append(toIndentedString(smPurchaserTaxNo)).append("\n");
    sb.append("    smSellerTaxNo: ").append(toIndentedString(smSellerTaxNo)).append("\n");
    sb.append("    smPaperDrewDate: ").append(toIndentedString(smPaperDrewDate)).append("\n");
    sb.append("    smAmountWithoutTax: ").append(toIndentedString(smAmountWithoutTax)).append("\n");
    sb.append("    smTaxAmount: ").append(toIndentedString(smTaxAmount)).append("\n");
    sb.append("    smAmountWithTax: ").append(toIndentedString(smAmountWithTax)).append("\n");
    sb.append("    smUpdator: ").append(toIndentedString(smUpdator)).append("\n");
    sb.append("    smBarcode: ").append(toIndentedString(smBarcode)).append("\n");
    sb.append("    smImgUrl: ").append(toIndentedString(smImgUrl)).append("\n");
    sb.append("    smInvoiceId: ").append(toIndentedString(smInvoiceId)).append("\n");
    sb.append("    smInvoiceSource: ").append(toIndentedString(smInvoiceSource)).append("\n");
    sb.append("    xtInvoiceCode: ").append(toIndentedString(xtInvoiceCode)).append("\n");
    sb.append("    xtInvoiceNo: ").append(toIndentedString(xtInvoiceNo)).append("\n");
    sb.append("    xtPurchaserTaxNo: ").append(toIndentedString(xtPurchaserTaxNo)).append("\n");
    sb.append("    xtSellerTaxNo: ").append(toIndentedString(xtSellerTaxNo)).append("\n");
    sb.append("    xtPaperDrewDate: ").append(toIndentedString(xtPaperDrewDate)).append("\n");
    sb.append("    xtAmountWithoutTax: ").append(toIndentedString(xtAmountWithoutTax)).append("\n");
    sb.append("    xtTaxAmount: ").append(toIndentedString(xtTaxAmount)).append("\n");
    sb.append("    xtAmountWithTax: ").append(toIndentedString(xtAmountWithTax)).append("\n");
    sb.append("    xtTaxRate: ").append(toIndentedString(xtTaxRate)).append("\n");
    sb.append("    isPushTask: ").append(toIndentedString(isPushTask)).append("\n");
    sb.append("    isObsolete: ").append(toIndentedString(isObsolete)).append("\n");
    sb.append("    isResult: ").append(toIndentedString(isResult)).append("\n");
    sb.append("    ifRepeat: ").append(toIndentedString(ifRepeat)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("    isLegalSynergetics: ").append(toIndentedString(isLegalSynergetics)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    auditUpdateTime: ").append(toIndentedString(auditUpdateTime)).append("\n");
    sb.append("    auditUser: ").append(toIndentedString(auditUser)).append("\n");
    sb.append("    ifSendException: ").append(toIndentedString(ifSendException)).append("\n");
    sb.append("    smMachineCode: ").append(toIndentedString(smMachineCode)).append("\n");
    sb.append("    smCheckCode: ").append(toIndentedString(smCheckCode)).append("\n");
    sb.append("    smCipherText: ").append(toIndentedString(smCipherText)).append("\n");
    sb.append("    xtMachineCode: ").append(toIndentedString(xtMachineCode)).append("\n");
    sb.append("    xtCheckCode: ").append(toIndentedString(xtCheckCode)).append("\n");
    sb.append("    xtCipherText: ").append(toIndentedString(xtCipherText)).append("\n");
    sb.append("    taxInvoiceCode: ").append(toIndentedString(taxInvoiceCode)).append("\n");
    sb.append("    taxInvoiceNo: ").append(toIndentedString(taxInvoiceNo)).append("\n");
    sb.append("    taxPurchaserTaxNo: ").append(toIndentedString(taxPurchaserTaxNo)).append("\n");
    sb.append("    taxSellerTaxNo: ").append(toIndentedString(taxSellerTaxNo)).append("\n");
    sb.append("    taxPaperDrewDate: ").append(toIndentedString(taxPaperDrewDate)).append("\n");
    sb.append("    taxAmountWithoutTax: ").append(toIndentedString(taxAmountWithoutTax)).append("\n");
    sb.append("    taxTaxAmount: ").append(toIndentedString(taxTaxAmount)).append("\n");
    sb.append("    taxAmountWithTax: ").append(toIndentedString(taxAmountWithTax)).append("\n");
    sb.append("    taxMachineCode: ").append(toIndentedString(taxMachineCode)).append("\n");
    sb.append("    taxCheckCode: ").append(toIndentedString(taxCheckCode)).append("\n");
    sb.append("    taxCipherText: ").append(toIndentedString(taxCipherText)).append("\n");
    sb.append("    pushAuthStatus: ").append(toIndentedString(pushAuthStatus)).append("\n");
    sb.append("    pushAuthTime: ").append(toIndentedString(pushAuthTime)).append("\n");
    sb.append("    authNoOverdueDate: ").append(toIndentedString(authNoOverdueDate)).append("\n");
    sb.append("    authWarnDays: ").append(toIndentedString(authWarnDays)).append("\n");
    sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
    sb.append("    sendExceptionRemark: ").append(toIndentedString(sendExceptionRemark)).append("\n");
    sb.append("    authPurposes: ").append(toIndentedString(authPurposes)).append("\n");
    sb.append("    authValidTaxAmount: ").append(toIndentedString(authValidTaxAmount)).append("\n");
    sb.append("    authCheckRequestTime: ").append(toIndentedString(authCheckRequestTime)).append("\n");
    sb.append("    authCheckUserId: ").append(toIndentedString(authCheckUserId)).append("\n");
    sb.append("    authCheckUserName: ").append(toIndentedString(authCheckUserName)).append("\n");
    sb.append("    authCheckResponseTime: ").append(toIndentedString(authCheckResponseTime)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    authExceType: ").append(toIndentedString(authExceType)).append("\n");
    sb.append("    xtOperateTime: ").append(toIndentedString(xtOperateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
