package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单据表
 */
@ApiModel(description = "业务单据表")

@JsonInclude(NON_NULL)
public class WkOrdersDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("salesbillType")
  private Integer salesbillType = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("redNotification")
  private String redNotification = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("receiveUserEmail")
  private String receiveUserEmail = null;

  @JsonProperty("receiveUserTel")
  private String receiveUserTel = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("recipient")
  private String recipient = null;

  @JsonProperty("recipientPhone")
  private String recipientPhone = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("businessOrderType")
  private String businessOrderType = null;

  @JsonProperty("specialTicketAmountWithTax")
  private BigDecimal specialTicketAmountWithTax = null;

  @JsonProperty("generalTicketAmountWithTax")
  private BigDecimal generalTicketAmountWithTax = null;

  @JsonProperty("taxRate")
  private BigDecimal taxRate = null;

  @JsonProperty("purchaserCode")
  private String purchaserCode = null;

  @JsonProperty("sellerCode")
  private String sellerCode = null;

  @JsonProperty("mainStatus")
  private Integer mainStatus = null;

  @JsonProperty("signPerson")
  private String signPerson = null;

  @JsonProperty("signTime")
  private Long signTime = null;

  @JsonProperty("signStatus")
  private Integer signStatus = null;

  @JsonProperty("signFailType")
  private Integer signFailType = null;

  @JsonProperty("signFailReason")
  private String signFailReason = null;

  @JsonProperty("postcodeSignTime")
  private Long postcodeSignTime = null;

  @JsonProperty("handleWay")
  private Integer handleWay = null;

  @JsonProperty("backExpressNumber")
  private String backExpressNumber = null;

  @JsonProperty("exceptionNote")
  private String exceptionNote = null;

  @JsonProperty("exceptionHandlePerson")
  private String exceptionHandlePerson = null;

  @JsonProperty("exceptionHandleTime")
  private Long exceptionHandleTime = null;

  @JsonProperty("sendPerson")
  private String sendPerson = null;

  @JsonProperty("sendPersonPhone")
  private String sendPersonPhone = null;

  @JsonProperty("isLock")
  private Integer isLock = null;

  @JsonProperty("autoCheckStatus")
  private Integer autoCheckStatus = null;

  @JsonProperty("autoCheckNote")
  private String autoCheckNote = null;

  @JsonProperty("autoCheckTime")
  private Long autoCheckTime = null;

  @JsonProperty("orderStatus")
  private String orderStatus = null;

  @JsonProperty("ifAuthFlag")
  private Integer ifAuthFlag = null;

  @JsonProperty("authStatus")
  private Integer authStatus = null;

  @JsonProperty("authAmount")
  private BigDecimal authAmount = null;

  @JsonProperty("authNotContaintAmount")
  private BigDecimal authNotContaintAmount = null;

  @JsonProperty("authTaxAmount")
  private BigDecimal authTaxAmount = null;

  @JsonProperty("authUpdateTime")
  private Long authUpdateTime = null;

  @JsonProperty("syncServiceSystemStatus")
  private Integer syncServiceSystemStatus = null;

  @JsonProperty("syncServiceSystemTime")
  private Long syncServiceSystemTime = null;

  @JsonProperty("syncServiceSystemNote")
  private String syncServiceSystemNote = null;

  @JsonProperty("auditStatus")
  private Integer auditStatus = null;

  @JsonProperty("auditUpdateTime")
  private Long auditUpdateTime = null;

  @JsonProperty("synAuditStatus")
  private Integer synAuditStatus = null;

  @JsonProperty("synAuditStatusTime")
  private Long synAuditStatusTime = null;

  @JsonProperty("synAuditStatusNote")
  private String synAuditStatusNote = null;

  @JsonProperty("isPushTask")
  private Integer isPushTask = null;

  @JsonProperty("taxRebateAmount")
  private BigDecimal taxRebateAmount = null;

  @JsonProperty("deductionAmount")
  private BigDecimal deductionAmount = null;

  @JsonProperty("agreementCode")
  private String agreementCode = null;

  @JsonProperty("pushTime")
  private Long pushTime = null;

  @JsonProperty("changeTime")
  private Long changeTime = null;

  @JsonProperty("changeStatus")
  private Integer changeStatus = null;

  @JsonProperty("changeInfo")
  private String changeInfo = null;

  @JsonProperty("isLegalSynergetics")
  private Integer isLegalSynergetics = null;

  @JsonProperty("recipientCompany")
  private String recipientCompany = null;

  @JsonProperty("returnBatch")
  private Integer returnBatch = null;

  @JsonProperty("returnType")
  private Integer returnType = null;

  @JsonProperty("syncTime")
  private Long syncTime = null;

  @JsonProperty("requestSerialNoToXyj")
  private String requestSerialNoToXyj = null;

  @JsonProperty("synTimeToXyj")
  private Long synTimeToXyj = null;

  @JsonProperty("synResultToXyj")
  private String synResultToXyj = null;

  @JsonProperty("infoFromXyj")
  private String infoFromXyj = null;

  @JsonProperty("processTimeFromXyj")
  private Long processTimeFromXyj = null;

  @JsonProperty("cooperateFlagFromXyj")
  private Integer cooperateFlagFromXyj = null;

  @JsonProperty("groupFlagFromXyj")
  private String groupFlagFromXyj = null;

  @JsonProperty("synResultTimeFromXyj")
  private Long synResultTimeFromXyj = null;

  @JsonProperty("operator")
  private String operator = null;

  @JsonProperty("purchaserManageUnit")
  private String purchaserManageUnit = null;

  @JsonProperty("performerFullName")
  private String performerFullName = null;

  @JsonProperty("performerAccount")
  private String performerAccount = null;

  @JsonProperty("orgName")
  private String orgName = null;

  @JsonProperty("billStatus")
  private Integer billStatus = null;

  @JsonProperty("sellerContactNo")
  private String sellerContactNo = null;

  @JsonProperty("sellerExpress")
  private String sellerExpress = null;

  @JsonProperty("outputType")
  private Integer outputType = null;

  @JsonProperty("outputState")
  private Integer outputState = null;

  @JsonProperty("accountSetCode")
  private String accountSetCode = null;

  @JsonProperty("voucherCreated")
  private String voucherCreated = null;

  @JsonProperty("invoiceStatus")
  private String invoiceStatus = null;

  @JsonProperty("expressCode")
  private String expressCode = null;

  @JsonProperty("synXyjAuditStatus")
  private Integer synXyjAuditStatus = null;

  @JsonProperty("synXyjAuditTime")
  private Long synXyjAuditTime = null;

  @JsonProperty("synGxfileStatus")
  private Integer synGxfileStatus = null;

  @JsonProperty("synGxfileTime")
  private Long synGxfileTime = null;

  @JsonProperty("smSyncTime")
  private Long smSyncTime = null;

  @JsonProperty("smStatus")
  private Integer smStatus = null;

  @JsonProperty("auditUser")
  private String auditUser = null;

  @JsonProperty("authType")
  private Integer authType = null;

  @JsonProperty("sellerDrawDate")
  private Long sellerDrawDate = null;

  @JsonProperty("alreadyMakeAmountWithTax")
  private BigDecimal alreadyMakeAmountWithTax = null;

  @JsonProperty("authValidTaxAmount")
  private BigDecimal authValidTaxAmount = null;

  @JsonProperty("authCheckTime")
  private Long authCheckTime = null;

  @JsonProperty("reserve1")
  private String reserve1 = null;

  @JsonIgnore
  public WkOrdersDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkOrdersDTO salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public WkOrdersDTO sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * 销方编号
   * @return sellerNo
  **/
  @ApiModelProperty(value = "销方编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public WkOrdersDTO sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public WkOrdersDTO sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public WkOrdersDTO sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public WkOrdersDTO sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public WkOrdersDTO sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public WkOrdersDTO sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行帐号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行帐号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

   /**
   * 购方公司编号
   * @return purchaserNo
  **/
  @ApiModelProperty(value = "购方公司编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行帐号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行帐号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public WkOrdersDTO systemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

   /**
   * 系统来源(所属业务系统)
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源(所属业务系统)")
  public String getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public WkOrdersDTO salesbillType(Integer salesbillType) {
    this.salesbillType = salesbillType;
    return this;
  }

   /**
   * 业务单据类型，1-合同、2-订单、3-简易合同
   * @return salesbillType
  **/
  @ApiModelProperty(value = "业务单据类型，1-合同、2-订单、3-简易合同")
  public Integer getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(Integer salesbillType) {
    this.salesbillType = salesbillType;
  }

  @JsonIgnore
  public WkOrdersDTO invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型： s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型： s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public WkOrdersDTO amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public WkOrdersDTO amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public WkOrdersDTO taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public WkOrdersDTO cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 协同标识： 1-协同； 0-不协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "协同标识： 1-协同； 0-不协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public WkOrdersDTO status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Y-正常；C-作废；D-删除；W-撤回
   * @return status
  **/
  @ApiModelProperty(value = "Y-正常；C-作废；D-删除；W-撤回")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public WkOrdersDTO originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

   /**
   * 原始发票号码
   * @return originInvoiceNo
  **/
  @ApiModelProperty(value = "原始发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public WkOrdersDTO originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

   /**
   * 原始发票代码
   * @return originInvoiceCode
  **/
  @ApiModelProperty(value = "原始发票代码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public WkOrdersDTO redNotification(String redNotification) {
    this.redNotification = redNotification;
    return this;
  }

   /**
   * 红字信息编号
   * @return redNotification
  **/
  @ApiModelProperty(value = "红字信息编号")
  public String getRedNotification() {
    return redNotification;
  }

  public void setRedNotification(String redNotification) {
    this.redNotification = redNotification;
  }

  @JsonIgnore
  public WkOrdersDTO checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public WkOrdersDTO cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 付款人
   * @return cashierName
  **/
  @ApiModelProperty(value = "付款人")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public WkOrdersDTO invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public WkOrdersDTO receiveUserEmail(String receiveUserEmail) {
    this.receiveUserEmail = receiveUserEmail;
    return this;
  }

   /**
   * 接收方邮箱
   * @return receiveUserEmail
  **/
  @ApiModelProperty(value = "接收方邮箱")
  public String getReceiveUserEmail() {
    return receiveUserEmail;
  }

  public void setReceiveUserEmail(String receiveUserEmail) {
    this.receiveUserEmail = receiveUserEmail;
  }

  @JsonIgnore
  public WkOrdersDTO receiveUserTel(String receiveUserTel) {
    this.receiveUserTel = receiveUserTel;
    return this;
  }

   /**
   * 接收方电话
   * @return receiveUserTel
  **/
  @ApiModelProperty(value = "接收方电话")
  public String getReceiveUserTel() {
    return receiveUserTel;
  }

  public void setReceiveUserTel(String receiveUserTel) {
    this.receiveUserTel = receiveUserTel;
  }

  @JsonIgnore
  public WkOrdersDTO createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public WkOrdersDTO createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建人
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建人")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public WkOrdersDTO recipient(String recipient) {
    this.recipient = recipient;
    return this;
  }

   /**
   * 收件人
   * @return recipient
  **/
  @ApiModelProperty(value = "收件人")
  public String getRecipient() {
    return recipient;
  }

  public void setRecipient(String recipient) {
    this.recipient = recipient;
  }

  @JsonIgnore
  public WkOrdersDTO recipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
    return this;
  }

   /**
   * 收件人联系方式
   * @return recipientPhone
  **/
  @ApiModelProperty(value = "收件人联系方式")
  public String getRecipientPhone() {
    return recipientPhone;
  }

  public void setRecipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
  }

  @JsonIgnore
  public WkOrdersDTO remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public WkOrdersDTO packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包ID，邮包快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包ID，邮包快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public WkOrdersDTO businessOrderType(String businessOrderType) {
    this.businessOrderType = businessOrderType;
    return this;
  }

   /**
   * 业务单据类型：S-专票，C-普票
   * @return businessOrderType
  **/
  @ApiModelProperty(value = "业务单据类型：S-专票，C-普票")
  public String getBusinessOrderType() {
    return businessOrderType;
  }

  public void setBusinessOrderType(String businessOrderType) {
    this.businessOrderType = businessOrderType;
  }

  @JsonIgnore
  public WkOrdersDTO specialTicketAmountWithTax(BigDecimal specialTicketAmountWithTax) {
    this.specialTicketAmountWithTax = specialTicketAmountWithTax;
    return this;
  }

   /**
   * 增值税专票含税金额
   * @return specialTicketAmountWithTax
  **/
  @ApiModelProperty(value = "增值税专票含税金额")
  public BigDecimal getSpecialTicketAmountWithTax() {
    return specialTicketAmountWithTax;
  }

  public void setSpecialTicketAmountWithTax(BigDecimal specialTicketAmountWithTax) {
    this.specialTicketAmountWithTax = specialTicketAmountWithTax;
  }

  @JsonIgnore
  public WkOrdersDTO generalTicketAmountWithTax(BigDecimal generalTicketAmountWithTax) {
    this.generalTicketAmountWithTax = generalTicketAmountWithTax;
    return this;
  }

   /**
   * 增值税普票含税金额
   * @return generalTicketAmountWithTax
  **/
  @ApiModelProperty(value = "增值税普票含税金额")
  public BigDecimal getGeneralTicketAmountWithTax() {
    return generalTicketAmountWithTax;
  }

  public void setGeneralTicketAmountWithTax(BigDecimal generalTicketAmountWithTax) {
    this.generalTicketAmountWithTax = generalTicketAmountWithTax;
  }

  @JsonIgnore
  public WkOrdersDTO taxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public BigDecimal getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserCode(String purchaserCode) {
    this.purchaserCode = purchaserCode;
    return this;
  }

   /**
   * 购方代码
   * @return purchaserCode
  **/
  @ApiModelProperty(value = "购方代码")
  public String getPurchaserCode() {
    return purchaserCode;
  }

  public void setPurchaserCode(String purchaserCode) {
    this.purchaserCode = purchaserCode;
  }

  @JsonIgnore
  public WkOrdersDTO sellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
    return this;
  }

   /**
   * 销方代码
   * @return sellerCode
  **/
  @ApiModelProperty(value = "销方代码")
  public String getSellerCode() {
    return sellerCode;
  }

  public void setSellerCode(String sellerCode) {
    this.sellerCode = sellerCode;
  }

  @JsonIgnore
  public WkOrdersDTO mainStatus(Integer mainStatus) {
    this.mainStatus = mainStatus;
    return this;
  }

   /**
   * 主状态：-1 - 删除，10-成功，20-待处理，30-暂挂，40-退回
   * @return mainStatus
  **/
  @ApiModelProperty(value = "主状态：-1 - 删除，10-成功，20-待处理，30-暂挂，40-退回")
  public Integer getMainStatus() {
    return mainStatus;
  }

  public void setMainStatus(Integer mainStatus) {
    this.mainStatus = mainStatus;
  }

  @JsonIgnore
  public WkOrdersDTO signPerson(String signPerson) {
    this.signPerson = signPerson;
    return this;
  }

   /**
   * 签收人
   * @return signPerson
  **/
  @ApiModelProperty(value = "签收人")
  public String getSignPerson() {
    return signPerson;
  }

  public void setSignPerson(String signPerson) {
    this.signPerson = signPerson;
  }

  @JsonIgnore
  public WkOrdersDTO signTime(Long signTime) {
    this.signTime = signTime;
    return this;
  }

   /**
   * 签收时间
   * @return signTime
  **/
  @ApiModelProperty(value = "签收时间")
  public Long getSignTime() {
    return signTime;
  }

  public void setSignTime(Long signTime) {
    this.signTime = signTime;
  }

  @JsonIgnore
  public WkOrdersDTO signStatus(Integer signStatus) {
    this.signStatus = signStatus;
    return this;
  }

   /**
   * 签收状态 ：0-默认 10-成功 20-失败
   * @return signStatus
  **/
  @ApiModelProperty(value = "签收状态 ：0-默认 10-成功 20-失败")
  public Integer getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(Integer signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public WkOrdersDTO signFailType(Integer signFailType) {
    this.signFailType = signFailType;
    return this;
  }

   /**
   * 签收失败类型：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无結算单，5-报支单，6-其他，7-审核不通过，8-发送认证失败，9-认证不通过
   * @return signFailType
  **/
  @ApiModelProperty(value = "签收失败类型：1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无結算单，5-报支单，6-其他，7-审核不通过，8-发送认证失败，9-认证不通过")
  public Integer getSignFailType() {
    return signFailType;
  }

  public void setSignFailType(Integer signFailType) {
    this.signFailType = signFailType;
  }

  @JsonIgnore
  public WkOrdersDTO signFailReason(String signFailReason) {
    this.signFailReason = signFailReason;
    return this;
  }

   /**
   * 签收失败原因
   * @return signFailReason
  **/
  @ApiModelProperty(value = "签收失败原因")
  public String getSignFailReason() {
    return signFailReason;
  }

  public void setSignFailReason(String signFailReason) {
    this.signFailReason = signFailReason;
  }

  @JsonIgnore
  public WkOrdersDTO postcodeSignTime(Long postcodeSignTime) {
    this.postcodeSignTime = postcodeSignTime;
    return this;
  }

   /**
   * 邮包签收时间
   * @return postcodeSignTime
  **/
  @ApiModelProperty(value = "邮包签收时间")
  public Long getPostcodeSignTime() {
    return postcodeSignTime;
  }

  public void setPostcodeSignTime(Long postcodeSignTime) {
    this.postcodeSignTime = postcodeSignTime;
  }

  @JsonIgnore
  public WkOrdersDTO handleWay(Integer handleWay) {
    this.handleWay = handleWay;
    return this;
  }

   /**
   * 处理方式：20-回寄，40-报支单共享扫描，50-关闭，60-通知一线处理
   * @return handleWay
  **/
  @ApiModelProperty(value = "处理方式：20-回寄，40-报支单共享扫描，50-关闭，60-通知一线处理")
  public Integer getHandleWay() {
    return handleWay;
  }

  public void setHandleWay(Integer handleWay) {
    this.handleWay = handleWay;
  }

  @JsonIgnore
  public WkOrdersDTO backExpressNumber(String backExpressNumber) {
    this.backExpressNumber = backExpressNumber;
    return this;
  }

   /**
   * 回寄快递单号
   * @return backExpressNumber
  **/
  @ApiModelProperty(value = "回寄快递单号")
  public String getBackExpressNumber() {
    return backExpressNumber;
  }

  public void setBackExpressNumber(String backExpressNumber) {
    this.backExpressNumber = backExpressNumber;
  }

  @JsonIgnore
  public WkOrdersDTO exceptionNote(String exceptionNote) {
    this.exceptionNote = exceptionNote;
    return this;
  }

   /**
   * 异常处理备注
   * @return exceptionNote
  **/
  @ApiModelProperty(value = "异常处理备注")
  public String getExceptionNote() {
    return exceptionNote;
  }

  public void setExceptionNote(String exceptionNote) {
    this.exceptionNote = exceptionNote;
  }

  @JsonIgnore
  public WkOrdersDTO exceptionHandlePerson(String exceptionHandlePerson) {
    this.exceptionHandlePerson = exceptionHandlePerson;
    return this;
  }

   /**
   * 异常处理人
   * @return exceptionHandlePerson
  **/
  @ApiModelProperty(value = "异常处理人")
  public String getExceptionHandlePerson() {
    return exceptionHandlePerson;
  }

  public void setExceptionHandlePerson(String exceptionHandlePerson) {
    this.exceptionHandlePerson = exceptionHandlePerson;
  }

  @JsonIgnore
  public WkOrdersDTO exceptionHandleTime(Long exceptionHandleTime) {
    this.exceptionHandleTime = exceptionHandleTime;
    return this;
  }

   /**
   * 异常处理时间
   * @return exceptionHandleTime
  **/
  @ApiModelProperty(value = "异常处理时间")
  public Long getExceptionHandleTime() {
    return exceptionHandleTime;
  }

  public void setExceptionHandleTime(Long exceptionHandleTime) {
    this.exceptionHandleTime = exceptionHandleTime;
  }

  @JsonIgnore
  public WkOrdersDTO sendPerson(String sendPerson) {
    this.sendPerson = sendPerson;
    return this;
  }

   /**
   * 寄件人
   * @return sendPerson
  **/
  @ApiModelProperty(value = "寄件人")
  public String getSendPerson() {
    return sendPerson;
  }

  public void setSendPerson(String sendPerson) {
    this.sendPerson = sendPerson;
  }

  @JsonIgnore
  public WkOrdersDTO sendPersonPhone(String sendPersonPhone) {
    this.sendPersonPhone = sendPersonPhone;
    return this;
  }

   /**
   * 寄件人联系方式
   * @return sendPersonPhone
  **/
  @ApiModelProperty(value = "寄件人联系方式")
  public String getSendPersonPhone() {
    return sendPersonPhone;
  }

  public void setSendPersonPhone(String sendPersonPhone) {
    this.sendPersonPhone = sendPersonPhone;
  }

  @JsonIgnore
  public WkOrdersDTO isLock(Integer isLock) {
    this.isLock = isLock;
    return this;
  }

   /**
   * 结算单锁标志：1- 锁定，0-未锁定
   * @return isLock
  **/
  @ApiModelProperty(value = "结算单锁标志：1- 锁定，0-未锁定")
  public Integer getIsLock() {
    return isLock;
  }

  public void setIsLock(Integer isLock) {
    this.isLock = isLock;
  }

  @JsonIgnore
  public WkOrdersDTO autoCheckStatus(Integer autoCheckStatus) {
    this.autoCheckStatus = autoCheckStatus;
    return this;
  }

   /**
   * 发票自动校验结果状态： -10 - 异常，10 - 正常
   * @return autoCheckStatus
  **/
  @ApiModelProperty(value = "发票自动校验结果状态： -10 - 异常，10 - 正常")
  public Integer getAutoCheckStatus() {
    return autoCheckStatus;
  }

  public void setAutoCheckStatus(Integer autoCheckStatus) {
    this.autoCheckStatus = autoCheckStatus;
  }

  @JsonIgnore
  public WkOrdersDTO autoCheckNote(String autoCheckNote) {
    this.autoCheckNote = autoCheckNote;
    return this;
  }

   /**
   * 发票自动校验结果说明
   * @return autoCheckNote
  **/
  @ApiModelProperty(value = "发票自动校验结果说明")
  public String getAutoCheckNote() {
    return autoCheckNote;
  }

  public void setAutoCheckNote(String autoCheckNote) {
    this.autoCheckNote = autoCheckNote;
  }

  @JsonIgnore
  public WkOrdersDTO autoCheckTime(Long autoCheckTime) {
    this.autoCheckTime = autoCheckTime;
    return this;
  }

   /**
   * 发票自动校验时间
   * @return autoCheckTime
  **/
  @ApiModelProperty(value = "发票自动校验时间")
  public Long getAutoCheckTime() {
    return autoCheckTime;
  }

  public void setAutoCheckTime(Long autoCheckTime) {
    this.autoCheckTime = autoCheckTime;
  }

  @JsonIgnore
  public WkOrdersDTO orderStatus(String orderStatus) {
    this.orderStatus = orderStatus;
    return this;
  }

   /**
   * 业务单状态
   * @return orderStatus
  **/
  @ApiModelProperty(value = "业务单状态")
  public String getOrderStatus() {
    return orderStatus;
  }

  public void setOrderStatus(String orderStatus) {
    this.orderStatus = orderStatus;
  }

  @JsonIgnore
  public WkOrdersDTO ifAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

   /**
   * 是否需要认证状态 1：是  0：否
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否需要认证状态 1：是  0：否")
  public Integer getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(Integer ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }

  @JsonIgnore
  public WkOrdersDTO authStatus(Integer authStatus) {
    this.authStatus = authStatus;
    return this;
  }

   /**
   * 业务单认证状态0：未勾选  1：已勾选 2：部分勾选 3：勾选异常 4：已确认抵扣 5：抵扣异常
   * @return authStatus
  **/
  @ApiModelProperty(value = "业务单认证状态0：未勾选  1：已勾选 2：部分勾选 3：勾选异常 4：已确认抵扣 5：抵扣异常")
  public Integer getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(Integer authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public WkOrdersDTO authAmount(BigDecimal authAmount) {
    this.authAmount = authAmount;
    return this;
  }

   /**
   * 抵扣的含税总金额
   * @return authAmount
  **/
  @ApiModelProperty(value = "抵扣的含税总金额")
  public BigDecimal getAuthAmount() {
    return authAmount;
  }

  public void setAuthAmount(BigDecimal authAmount) {
    this.authAmount = authAmount;
  }

  @JsonIgnore
  public WkOrdersDTO authNotContaintAmount(BigDecimal authNotContaintAmount) {
    this.authNotContaintAmount = authNotContaintAmount;
    return this;
  }

   /**
   * 抵扣不含税总金额
   * @return authNotContaintAmount
  **/
  @ApiModelProperty(value = "抵扣不含税总金额")
  public BigDecimal getAuthNotContaintAmount() {
    return authNotContaintAmount;
  }

  public void setAuthNotContaintAmount(BigDecimal authNotContaintAmount) {
    this.authNotContaintAmount = authNotContaintAmount;
  }

  @JsonIgnore
  public WkOrdersDTO authTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
    return this;
  }

   /**
   * 抵扣总税额
   * @return authTaxAmount
  **/
  @ApiModelProperty(value = "抵扣总税额")
  public BigDecimal getAuthTaxAmount() {
    return authTaxAmount;
  }

  public void setAuthTaxAmount(BigDecimal authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
  }

  @JsonIgnore
  public WkOrdersDTO authUpdateTime(Long authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
    return this;
  }

   /**
   * 抵扣更新时间
   * @return authUpdateTime
  **/
  @ApiModelProperty(value = "抵扣更新时间")
  public Long getAuthUpdateTime() {
    return authUpdateTime;
  }

  public void setAuthUpdateTime(Long authUpdateTime) {
    this.authUpdateTime = authUpdateTime;
  }

  @JsonIgnore
  public WkOrdersDTO syncServiceSystemStatus(Integer syncServiceSystemStatus) {
    this.syncServiceSystemStatus = syncServiceSystemStatus;
    return this;
  }

   /**
   * 同步认证状态至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败
   * @return syncServiceSystemStatus
  **/
  @ApiModelProperty(value = "同步认证状态至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败")
  public Integer getSyncServiceSystemStatus() {
    return syncServiceSystemStatus;
  }

  public void setSyncServiceSystemStatus(Integer syncServiceSystemStatus) {
    this.syncServiceSystemStatus = syncServiceSystemStatus;
  }

  @JsonIgnore
  public WkOrdersDTO syncServiceSystemTime(Long syncServiceSystemTime) {
    this.syncServiceSystemTime = syncServiceSystemTime;
    return this;
  }

   /**
   * 同步至业务系统时间
   * @return syncServiceSystemTime
  **/
  @ApiModelProperty(value = "同步至业务系统时间")
  public Long getSyncServiceSystemTime() {
    return syncServiceSystemTime;
  }

  public void setSyncServiceSystemTime(Long syncServiceSystemTime) {
    this.syncServiceSystemTime = syncServiceSystemTime;
  }

  @JsonIgnore
  public WkOrdersDTO syncServiceSystemNote(String syncServiceSystemNote) {
    this.syncServiceSystemNote = syncServiceSystemNote;
    return this;
  }

   /**
   * 同步返回结果说明
   * @return syncServiceSystemNote
  **/
  @ApiModelProperty(value = "同步返回结果说明")
  public String getSyncServiceSystemNote() {
    return syncServiceSystemNote;
  }

  public void setSyncServiceSystemNote(String syncServiceSystemNote) {
    this.syncServiceSystemNote = syncServiceSystemNote;
  }

  @JsonIgnore
  public WkOrdersDTO auditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

   /**
   * 业务单审核状态 0：未审核  1：审核成功 2：审核不通过 审核状态（0. 待审核 1.审核成功 -1.审核失败）
   * @return auditStatus
  **/
  @ApiModelProperty(value = "业务单审核状态 0：未审核  1：审核成功 2：审核不通过 审核状态（0. 待审核 1.审核成功 -1.审核失败）")
  public Integer getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(Integer auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public WkOrdersDTO auditUpdateTime(Long auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
    return this;
  }

   /**
   * 审核状态更新时间
   * @return auditUpdateTime
  **/
  @ApiModelProperty(value = "审核状态更新时间")
  public Long getAuditUpdateTime() {
    return auditUpdateTime;
  }

  public void setAuditUpdateTime(Long auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
  }

  @JsonIgnore
  public WkOrdersDTO synAuditStatus(Integer synAuditStatus) {
    this.synAuditStatus = synAuditStatus;
    return this;
  }

   /**
   * 审核状态同步至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败
   * @return synAuditStatus
  **/
  @ApiModelProperty(value = "审核状态同步至业务系统状态 0：未同步  1：同步返回处理成功 2：同步返回处理失败")
  public Integer getSynAuditStatus() {
    return synAuditStatus;
  }

  public void setSynAuditStatus(Integer synAuditStatus) {
    this.synAuditStatus = synAuditStatus;
  }

  @JsonIgnore
  public WkOrdersDTO synAuditStatusTime(Long synAuditStatusTime) {
    this.synAuditStatusTime = synAuditStatusTime;
    return this;
  }

   /**
   * 审核状态同步至业务系统时间
   * @return synAuditStatusTime
  **/
  @ApiModelProperty(value = "审核状态同步至业务系统时间")
  public Long getSynAuditStatusTime() {
    return synAuditStatusTime;
  }

  public void setSynAuditStatusTime(Long synAuditStatusTime) {
    this.synAuditStatusTime = synAuditStatusTime;
  }

  @JsonIgnore
  public WkOrdersDTO synAuditStatusNote(String synAuditStatusNote) {
    this.synAuditStatusNote = synAuditStatusNote;
    return this;
  }

   /**
   * 审核状态同步至业务系统返回说明
   * @return synAuditStatusNote
  **/
  @ApiModelProperty(value = "审核状态同步至业务系统返回说明")
  public String getSynAuditStatusNote() {
    return synAuditStatusNote;
  }

  public void setSynAuditStatusNote(String synAuditStatusNote) {
    this.synAuditStatusNote = synAuditStatusNote;
  }

  @JsonIgnore
  public WkOrdersDTO isPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
    return this;
  }

   /**
   * 是否推送任务平台审核1是，0否
   * @return isPushTask
  **/
  @ApiModelProperty(value = "是否推送任务平台审核1是，0否")
  public Integer getIsPushTask() {
    return isPushTask;
  }

  public void setIsPushTask(Integer isPushTask) {
    this.isPushTask = isPushTask;
  }

  @JsonIgnore
  public WkOrdersDTO taxRebateAmount(BigDecimal taxRebateAmount) {
    this.taxRebateAmount = taxRebateAmount;
    return this;
  }

   /**
   * 折扣税额
   * @return taxRebateAmount
  **/
  @ApiModelProperty(value = "折扣税额")
  public BigDecimal getTaxRebateAmount() {
    return taxRebateAmount;
  }

  public void setTaxRebateAmount(BigDecimal taxRebateAmount) {
    this.taxRebateAmount = taxRebateAmount;
  }

  @JsonIgnore
  public WkOrdersDTO deductionAmount(BigDecimal deductionAmount) {
    this.deductionAmount = deductionAmount;
    return this;
  }

   /**
   * 可抵扣金额
   * @return deductionAmount
  **/
  @ApiModelProperty(value = "可抵扣金额")
  public BigDecimal getDeductionAmount() {
    return deductionAmount;
  }

  public void setDeductionAmount(BigDecimal deductionAmount) {
    this.deductionAmount = deductionAmount;
  }

  @JsonIgnore
  public WkOrdersDTO agreementCode(String agreementCode) {
    this.agreementCode = agreementCode;
    return this;
  }

   /**
   * 合同号
   * @return agreementCode
  **/
  @ApiModelProperty(value = "合同号")
  public String getAgreementCode() {
    return agreementCode;
  }

  public void setAgreementCode(String agreementCode) {
    this.agreementCode = agreementCode;
  }

  @JsonIgnore
  public WkOrdersDTO pushTime(Long pushTime) {
    this.pushTime = pushTime;
    return this;
  }

   /**
   * 推送任务平台的时间
   * @return pushTime
  **/
  @ApiModelProperty(value = "推送任务平台的时间")
  public Long getPushTime() {
    return pushTime;
  }

  public void setPushTime(Long pushTime) {
    this.pushTime = pushTime;
  }

  @JsonIgnore
  public WkOrdersDTO changeTime(Long changeTime) {
    this.changeTime = changeTime;
    return this;
  }

   /**
   * 可抵扣变更处理时间
   * @return changeTime
  **/
  @ApiModelProperty(value = "可抵扣变更处理时间")
  public Long getChangeTime() {
    return changeTime;
  }

  public void setChangeTime(Long changeTime) {
    this.changeTime = changeTime;
  }

  @JsonIgnore
  public WkOrdersDTO changeStatus(Integer changeStatus) {
    this.changeStatus = changeStatus;
    return this;
  }

   /**
   * 可抵扣变更处理状态：0-失败，1-成功，2-无
   * @return changeStatus
  **/
  @ApiModelProperty(value = "可抵扣变更处理状态：0-失败，1-成功，2-无")
  public Integer getChangeStatus() {
    return changeStatus;
  }

  public void setChangeStatus(Integer changeStatus) {
    this.changeStatus = changeStatus;
  }

  @JsonIgnore
  public WkOrdersDTO changeInfo(String changeInfo) {
    this.changeInfo = changeInfo;
    return this;
  }

   /**
   * 可抵扣变更处理意见
   * @return changeInfo
  **/
  @ApiModelProperty(value = "可抵扣变更处理意见")
  public String getChangeInfo() {
    return changeInfo;
  }

  public void setChangeInfo(String changeInfo) {
    this.changeInfo = changeInfo;
  }

  @JsonIgnore
  public WkOrdersDTO isLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
    return this;
  }

   /**
   * 是否法人协同 1.是 0.否
   * @return isLegalSynergetics
  **/
  @ApiModelProperty(value = "是否法人协同 1.是 0.否")
  public Integer getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(Integer isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }

  @JsonIgnore
  public WkOrdersDTO recipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
    return this;
  }

   /**
   * 收件公司
   * @return recipientCompany
  **/
  @ApiModelProperty(value = "收件公司")
  public String getRecipientCompany() {
    return recipientCompany;
  }

  public void setRecipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
  }

  @JsonIgnore
  public WkOrdersDTO returnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
    return this;
  }

   /**
   * 退回联次 1 发票联及抵扣联、2 发票联、3 抵扣联
   * @return returnBatch
  **/
  @ApiModelProperty(value = "退回联次 1 发票联及抵扣联、2 发票联、3 抵扣联")
  public Integer getReturnBatch() {
    return returnBatch;
  }

  public void setReturnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
  }

  @JsonIgnore
  public WkOrdersDTO returnType(Integer returnType) {
    this.returnType = returnType;
    return this;
  }

   /**
   * 退回类型 采用枚举值：1、发票票面有误2、发票审核错误3、产值有误4、 产值红冲5、邮寄错误6、其他
   * @return returnType
  **/
  @ApiModelProperty(value = "退回类型 采用枚举值：1、发票票面有误2、发票审核错误3、产值有误4、 产值红冲5、邮寄错误6、其他")
  public Integer getReturnType() {
    return returnType;
  }

  public void setReturnType(Integer returnType) {
    this.returnType = returnType;
  }

  @JsonIgnore
  public WkOrdersDTO syncTime(Long syncTime) {
    this.syncTime = syncTime;
    return this;
  }

   /**
   * 同步时间
   * @return syncTime
  **/
  @ApiModelProperty(value = "同步时间")
  public Long getSyncTime() {
    return syncTime;
  }

  public void setSyncTime(Long syncTime) {
    this.syncTime = syncTime;
  }

  @JsonIgnore
  public WkOrdersDTO requestSerialNoToXyj(String requestSerialNoToXyj) {
    this.requestSerialNoToXyj = requestSerialNoToXyj;
    return this;
  }

   /**
   * 喜盈佳请求序列号
   * @return requestSerialNoToXyj
  **/
  @ApiModelProperty(value = "喜盈佳请求序列号")
  public String getRequestSerialNoToXyj() {
    return requestSerialNoToXyj;
  }

  public void setRequestSerialNoToXyj(String requestSerialNoToXyj) {
    this.requestSerialNoToXyj = requestSerialNoToXyj;
  }

  @JsonIgnore
  public WkOrdersDTO synTimeToXyj(Long synTimeToXyj) {
    this.synTimeToXyj = synTimeToXyj;
    return this;
  }

   /**
   * 喜盈佳同步时间
   * @return synTimeToXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步时间")
  public Long getSynTimeToXyj() {
    return synTimeToXyj;
  }

  public void setSynTimeToXyj(Long synTimeToXyj) {
    this.synTimeToXyj = synTimeToXyj;
  }

  @JsonIgnore
  public WkOrdersDTO synResultToXyj(String synResultToXyj) {
    this.synResultToXyj = synResultToXyj;
    return this;
  }

   /**
   * 喜盈佳同步结果
   * @return synResultToXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步结果")
  public String getSynResultToXyj() {
    return synResultToXyj;
  }

  public void setSynResultToXyj(String synResultToXyj) {
    this.synResultToXyj = synResultToXyj;
  }

  @JsonIgnore
  public WkOrdersDTO infoFromXyj(String infoFromXyj) {
    this.infoFromXyj = infoFromXyj;
    return this;
  }

   /**
   * 喜盈佳同步说明
   * @return infoFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步说明")
  public String getInfoFromXyj() {
    return infoFromXyj;
  }

  public void setInfoFromXyj(String infoFromXyj) {
    this.infoFromXyj = infoFromXyj;
  }

  @JsonIgnore
  public WkOrdersDTO processTimeFromXyj(Long processTimeFromXyj) {
    this.processTimeFromXyj = processTimeFromXyj;
    return this;
  }

   /**
   * 喜盈佳同步时间
   * @return processTimeFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步时间")
  public Long getProcessTimeFromXyj() {
    return processTimeFromXyj;
  }

  public void setProcessTimeFromXyj(Long processTimeFromXyj) {
    this.processTimeFromXyj = processTimeFromXyj;
  }

  @JsonIgnore
  public WkOrdersDTO cooperateFlagFromXyj(Integer cooperateFlagFromXyj) {
    this.cooperateFlagFromXyj = cooperateFlagFromXyj;
    return this;
  }

   /**
   * 喜盈佳协同类型标志 (0-非协同；1-协同）
   * @return cooperateFlagFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳协同类型标志 (0-非协同；1-协同）")
  public Integer getCooperateFlagFromXyj() {
    return cooperateFlagFromXyj;
  }

  public void setCooperateFlagFromXyj(Integer cooperateFlagFromXyj) {
    this.cooperateFlagFromXyj = cooperateFlagFromXyj;
  }

  @JsonIgnore
  public WkOrdersDTO groupFlagFromXyj(String groupFlagFromXyj) {
    this.groupFlagFromXyj = groupFlagFromXyj;
    return this;
  }

   /**
   * 喜盈佳分组标记
   * @return groupFlagFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳分组标记")
  public String getGroupFlagFromXyj() {
    return groupFlagFromXyj;
  }

  public void setGroupFlagFromXyj(String groupFlagFromXyj) {
    this.groupFlagFromXyj = groupFlagFromXyj;
  }

  @JsonIgnore
  public WkOrdersDTO synResultTimeFromXyj(Long synResultTimeFromXyj) {
    this.synResultTimeFromXyj = synResultTimeFromXyj;
    return this;
  }

   /**
   * 喜盈佳同步结果时间
   * @return synResultTimeFromXyj
  **/
  @ApiModelProperty(value = "喜盈佳同步结果时间")
  public Long getSynResultTimeFromXyj() {
    return synResultTimeFromXyj;
  }

  public void setSynResultTimeFromXyj(Long synResultTimeFromXyj) {
    this.synResultTimeFromXyj = synResultTimeFromXyj;
  }

  @JsonIgnore
  public WkOrdersDTO operator(String operator) {
    this.operator = operator;
    return this;
  }

   /**
   * 经办人
   * @return operator
  **/
  @ApiModelProperty(value = "经办人")
  public String getOperator() {
    return operator;
  }

  public void setOperator(String operator) {
    this.operator = operator;
  }

  @JsonIgnore
  public WkOrdersDTO purchaserManageUnit(String purchaserManageUnit) {
    this.purchaserManageUnit = purchaserManageUnit;
    return this;
  }

   /**
   * 购方管理单元/项目分期
   * @return purchaserManageUnit
  **/
  @ApiModelProperty(value = "购方管理单元/项目分期")
  public String getPurchaserManageUnit() {
    return purchaserManageUnit;
  }

  public void setPurchaserManageUnit(String purchaserManageUnit) {
    this.purchaserManageUnit = purchaserManageUnit;
  }

  @JsonIgnore
  public WkOrdersDTO performerFullName(String performerFullName) {
    this.performerFullName = performerFullName;
    return this;
  }

   /**
   * 单据经办人
   * @return performerFullName
  **/
  @ApiModelProperty(value = "单据经办人")
  public String getPerformerFullName() {
    return performerFullName;
  }

  public void setPerformerFullName(String performerFullName) {
    this.performerFullName = performerFullName;
  }

  @JsonIgnore
  public WkOrdersDTO performerAccount(String performerAccount) {
    this.performerAccount = performerAccount;
    return this;
  }

   /**
   * 经办人域账号
   * @return performerAccount
  **/
  @ApiModelProperty(value = "经办人域账号")
  public String getPerformerAccount() {
    return performerAccount;
  }

  public void setPerformerAccount(String performerAccount) {
    this.performerAccount = performerAccount;
  }

  @JsonIgnore
  public WkOrdersDTO orgName(String orgName) {
    this.orgName = orgName;
    return this;
  }

   /**
   * 城市公司
   * @return orgName
  **/
  @ApiModelProperty(value = "城市公司")
  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @JsonIgnore
  public WkOrdersDTO billStatus(Integer billStatus) {
    this.billStatus = billStatus;
    return this;
  }

   /**
   * 开票状态0未开票,1完全开票，2部分开票,
   * @return billStatus
  **/
  @ApiModelProperty(value = "开票状态0未开票,1完全开票，2部分开票,")
  public Integer getBillStatus() {
    return billStatus;
  }

  public void setBillStatus(Integer billStatus) {
    this.billStatus = billStatus;
  }

  @JsonIgnore
  public WkOrdersDTO sellerContactNo(String sellerContactNo) {
    this.sellerContactNo = sellerContactNo;
    return this;
  }

   /**
   * 销方合同编码
   * @return sellerContactNo
  **/
  @ApiModelProperty(value = "销方合同编码")
  public String getSellerContactNo() {
    return sellerContactNo;
  }

  public void setSellerContactNo(String sellerContactNo) {
    this.sellerContactNo = sellerContactNo;
  }

  @JsonIgnore
  public WkOrdersDTO sellerExpress(String sellerExpress) {
    this.sellerExpress = sellerExpress;
    return this;
  }

   /**
   * 销方发运单号
   * @return sellerExpress
  **/
  @ApiModelProperty(value = "销方发运单号")
  public String getSellerExpress() {
    return sellerExpress;
  }

  public void setSellerExpress(String sellerExpress) {
    this.sellerExpress = sellerExpress;
  }

  @JsonIgnore
  public WkOrdersDTO outputType(Integer outputType) {
    this.outputType = outputType;
    return this;
  }

   /**
   * 产值单类型：1-产值确认单、2-结算单、3-红冲产值单
   * @return outputType
  **/
  @ApiModelProperty(value = "产值单类型：1-产值确认单、2-结算单、3-红冲产值单")
  public Integer getOutputType() {
    return outputType;
  }

  public void setOutputType(Integer outputType) {
    this.outputType = outputType;
  }

  @JsonIgnore
  public WkOrdersDTO outputState(Integer outputState) {
    this.outputState = outputState;
    return this;
  }

   /**
   * 产值单状态：3-已审核
   * @return outputState
  **/
  @ApiModelProperty(value = "产值单状态：3-已审核")
  public Integer getOutputState() {
    return outputState;
  }

  public void setOutputState(Integer outputState) {
    this.outputState = outputState;
  }

  @JsonIgnore
  public WkOrdersDTO accountSetCode(String accountSetCode) {
    this.accountSetCode = accountSetCode;
    return this;
  }

   /**
   * 账套编码
   * @return accountSetCode
  **/
  @ApiModelProperty(value = "账套编码")
  public String getAccountSetCode() {
    return accountSetCode;
  }

  public void setAccountSetCode(String accountSetCode) {
    this.accountSetCode = accountSetCode;
  }

  @JsonIgnore
  public WkOrdersDTO voucherCreated(String voucherCreated) {
    this.voucherCreated = voucherCreated;
    return this;
  }

   /**
   * 是否生成凭证（Y/0 - 已生成,N/1 - 未生成）
   * @return voucherCreated
  **/
  @ApiModelProperty(value = "是否生成凭证（Y/0 - 已生成,N/1 - 未生成）")
  public String getVoucherCreated() {
    return voucherCreated;
  }

  public void setVoucherCreated(String voucherCreated) {
    this.voucherCreated = voucherCreated;
  }

  @JsonIgnore
  public WkOrdersDTO invoiceStatus(String invoiceStatus) {
    this.invoiceStatus = invoiceStatus;
    return this;
  }

   /**
   * 单据发票状态：UNINVOICED-未开票，PARTIAL-部分开票，COMPLETED-完全开票，S-已审核，V-已认证，SV-已认证
   * @return invoiceStatus
  **/
  @ApiModelProperty(value = "单据发票状态：UNINVOICED-未开票，PARTIAL-部分开票，COMPLETED-完全开票，S-已审核，V-已认证，SV-已认证")
  public String getInvoiceStatus() {
    return invoiceStatus;
  }

  public void setInvoiceStatus(String invoiceStatus) {
    this.invoiceStatus = invoiceStatus;
  }

  @JsonIgnore
  public WkOrdersDTO expressCode(String expressCode) {
    this.expressCode = expressCode;
    return this;
  }

   /**
   * 快递公司
   * @return expressCode
  **/
  @ApiModelProperty(value = "快递公司")
  public String getExpressCode() {
    return expressCode;
  }

  public void setExpressCode(String expressCode) {
    this.expressCode = expressCode;
  }

  @JsonIgnore
  public WkOrdersDTO synXyjAuditStatus(Integer synXyjAuditStatus) {
    this.synXyjAuditStatus = synXyjAuditStatus;
    return this;
  }

   /**
   * 审核成功同步喜盈佳状态
   * @return synXyjAuditStatus
  **/
  @ApiModelProperty(value = "审核成功同步喜盈佳状态")
  public Integer getSynXyjAuditStatus() {
    return synXyjAuditStatus;
  }

  public void setSynXyjAuditStatus(Integer synXyjAuditStatus) {
    this.synXyjAuditStatus = synXyjAuditStatus;
  }

  @JsonIgnore
  public WkOrdersDTO synXyjAuditTime(Long synXyjAuditTime) {
    this.synXyjAuditTime = synXyjAuditTime;
    return this;
  }

   /**
   * 审核成功同步喜盈佳时间
   * @return synXyjAuditTime
  **/
  @ApiModelProperty(value = "审核成功同步喜盈佳时间")
  public Long getSynXyjAuditTime() {
    return synXyjAuditTime;
  }

  public void setSynXyjAuditTime(Long synXyjAuditTime) {
    this.synXyjAuditTime = synXyjAuditTime;
  }

  @JsonIgnore
  public WkOrdersDTO synGxfileStatus(Integer synGxfileStatus) {
    this.synGxfileStatus = synGxfileStatus;
    return this;
  }

   /**
   * 国信档案归档状态
   * @return synGxfileStatus
  **/
  @ApiModelProperty(value = "国信档案归档状态")
  public Integer getSynGxfileStatus() {
    return synGxfileStatus;
  }

  public void setSynGxfileStatus(Integer synGxfileStatus) {
    this.synGxfileStatus = synGxfileStatus;
  }

  @JsonIgnore
  public WkOrdersDTO synGxfileTime(Long synGxfileTime) {
    this.synGxfileTime = synGxfileTime;
    return this;
  }

   /**
   * 国信档案归档时间
   * @return synGxfileTime
  **/
  @ApiModelProperty(value = "国信档案归档时间")
  public Long getSynGxfileTime() {
    return synGxfileTime;
  }

  public void setSynGxfileTime(Long synGxfileTime) {
    this.synGxfileTime = synGxfileTime;
  }

  @JsonIgnore
  public WkOrdersDTO smSyncTime(Long smSyncTime) {
    this.smSyncTime = smSyncTime;
    return this;
  }

   /**
   * 影像上传时间（最后一张影像上传时间）
   * @return smSyncTime
  **/
  @ApiModelProperty(value = "影像上传时间（最后一张影像上传时间）")
  public Long getSmSyncTime() {
    return smSyncTime;
  }

  public void setSmSyncTime(Long smSyncTime) {
    this.smSyncTime = smSyncTime;
  }

  @JsonIgnore
  public WkOrdersDTO smStatus(Integer smStatus) {
    this.smStatus = smStatus;
    return this;
  }

   /**
   * 业务单扫描状态：0-未扫描，1-已扫描，2-部分扫描
   * @return smStatus
  **/
  @ApiModelProperty(value = "业务单扫描状态：0-未扫描，1-已扫描，2-部分扫描")
  public Integer getSmStatus() {
    return smStatus;
  }

  public void setSmStatus(Integer smStatus) {
    this.smStatus = smStatus;
  }

  @JsonIgnore
  public WkOrdersDTO auditUser(String auditUser) {
    this.auditUser = auditUser;
    return this;
  }

   /**
   * 审核人（审核岗）
   * @return auditUser
  **/
  @ApiModelProperty(value = "审核人（审核岗）")
  public String getAuditUser() {
    return auditUser;
  }

  public void setAuditUser(String auditUser) {
    this.auditUser = auditUser;
  }

  @JsonIgnore
  public WkOrdersDTO authType(Integer authType) {
    this.authType = authType;
    return this;
  }

   /**
   * 认证方式：1-传统认证，2-底账认证
   * @return authType
  **/
  @ApiModelProperty(value = "认证方式：1-传统认证，2-底账认证")
  public Integer getAuthType() {
    return authType;
  }

  public void setAuthType(Integer authType) {
    this.authType = authType;
  }

  @JsonIgnore
  public WkOrdersDTO sellerDrawDate(Long sellerDrawDate) {
    this.sellerDrawDate = sellerDrawDate;
    return this;
  }

   /**
   * 销方开具时间
   * @return sellerDrawDate
  **/
  @ApiModelProperty(value = "销方开具时间")
  public Long getSellerDrawDate() {
    return sellerDrawDate;
  }

  public void setSellerDrawDate(Long sellerDrawDate) {
    this.sellerDrawDate = sellerDrawDate;
  }

  @JsonIgnore
  public WkOrdersDTO alreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
    this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
    return this;
  }

   /**
   * 已开含税金额
   * @return alreadyMakeAmountWithTax
  **/
  @ApiModelProperty(value = "已开含税金额")
  public BigDecimal getAlreadyMakeAmountWithTax() {
    return alreadyMakeAmountWithTax;
  }

  public void setAlreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
    this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
  }

  @JsonIgnore
  public WkOrdersDTO authValidTaxAmount(BigDecimal authValidTaxAmount) {
    this.authValidTaxAmount = authValidTaxAmount;
    return this;
  }

   /**
   * 有效税额
   * @return authValidTaxAmount
  **/
  @ApiModelProperty(value = "有效税额")
  public BigDecimal getAuthValidTaxAmount() {
    return authValidTaxAmount;
  }

  public void setAuthValidTaxAmount(BigDecimal authValidTaxAmount) {
    this.authValidTaxAmount = authValidTaxAmount;
  }

  @JsonIgnore
  public WkOrdersDTO authCheckTime(Long authCheckTime) {
    this.authCheckTime = authCheckTime;
    return this;
  }

   /**
   * 勾选时间
   * @return authCheckTime
  **/
  @ApiModelProperty(value = "勾选时间")
  public Long getAuthCheckTime() {
    return authCheckTime;
  }

  public void setAuthCheckTime(Long authCheckTime) {
    this.authCheckTime = authCheckTime;
  }

  @JsonIgnore
  public WkOrdersDTO reserve1(String reserve1) {
    this.reserve1 = reserve1;
    return this;
  }

   /**
   * 扩展字段-带前缀的业务单号
   * @return reserve1
  **/
  @ApiModelProperty(value = "扩展字段-带前缀的业务单号")
  public String getReserve1() {
    return reserve1;
  }

  public void setReserve1(String reserve1) {
    this.reserve1 = reserve1;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkOrdersDTO wkOrdersDTO = (WkOrdersDTO) o;
    return Objects.equals(this.id, wkOrdersDTO.id) &&
        Objects.equals(this.salesbillNo, wkOrdersDTO.salesbillNo) &&
        Objects.equals(this.sellerNo, wkOrdersDTO.sellerNo) &&
        Objects.equals(this.sellerName, wkOrdersDTO.sellerName) &&
        Objects.equals(this.sellerTaxNo, wkOrdersDTO.sellerTaxNo) &&
        Objects.equals(this.sellerTel, wkOrdersDTO.sellerTel) &&
        Objects.equals(this.sellerAddress, wkOrdersDTO.sellerAddress) &&
        Objects.equals(this.sellerBankName, wkOrdersDTO.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, wkOrdersDTO.sellerBankAccount) &&
        Objects.equals(this.purchaserNo, wkOrdersDTO.purchaserNo) &&
        Objects.equals(this.purchaserName, wkOrdersDTO.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, wkOrdersDTO.purchaserTaxNo) &&
        Objects.equals(this.purchaserTel, wkOrdersDTO.purchaserTel) &&
        Objects.equals(this.purchaserAddress, wkOrdersDTO.purchaserAddress) &&
        Objects.equals(this.purchaserBankName, wkOrdersDTO.purchaserBankName) &&
        Objects.equals(this.purchaserBankAccount, wkOrdersDTO.purchaserBankAccount) &&
        Objects.equals(this.systemOrig, wkOrdersDTO.systemOrig) &&
        Objects.equals(this.salesbillType, wkOrdersDTO.salesbillType) &&
        Objects.equals(this.invoiceType, wkOrdersDTO.invoiceType) &&
        Objects.equals(this.amountWithTax, wkOrdersDTO.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, wkOrdersDTO.amountWithoutTax) &&
        Objects.equals(this.taxAmount, wkOrdersDTO.taxAmount) &&
        Objects.equals(this.cooperateFlag, wkOrdersDTO.cooperateFlag) &&
        Objects.equals(this.status, wkOrdersDTO.status) &&
        Objects.equals(this.originInvoiceNo, wkOrdersDTO.originInvoiceNo) &&
        Objects.equals(this.originInvoiceCode, wkOrdersDTO.originInvoiceCode) &&
        Objects.equals(this.redNotification, wkOrdersDTO.redNotification) &&
        Objects.equals(this.checkerName, wkOrdersDTO.checkerName) &&
        Objects.equals(this.cashierName, wkOrdersDTO.cashierName) &&
        Objects.equals(this.invoicerName, wkOrdersDTO.invoicerName) &&
        Objects.equals(this.receiveUserEmail, wkOrdersDTO.receiveUserEmail) &&
        Objects.equals(this.receiveUserTel, wkOrdersDTO.receiveUserTel) &&
        Objects.equals(this.createTime, wkOrdersDTO.createTime) &&
        Objects.equals(this.createUserName, wkOrdersDTO.createUserName) &&
        Objects.equals(this.recipient, wkOrdersDTO.recipient) &&
        Objects.equals(this.recipientPhone, wkOrdersDTO.recipientPhone) &&
        Objects.equals(this.remark, wkOrdersDTO.remark) &&
        Objects.equals(this.packageCode, wkOrdersDTO.packageCode) &&
        Objects.equals(this.businessOrderType, wkOrdersDTO.businessOrderType) &&
        Objects.equals(this.specialTicketAmountWithTax, wkOrdersDTO.specialTicketAmountWithTax) &&
        Objects.equals(this.generalTicketAmountWithTax, wkOrdersDTO.generalTicketAmountWithTax) &&
        Objects.equals(this.taxRate, wkOrdersDTO.taxRate) &&
        Objects.equals(this.purchaserCode, wkOrdersDTO.purchaserCode) &&
        Objects.equals(this.sellerCode, wkOrdersDTO.sellerCode) &&
        Objects.equals(this.mainStatus, wkOrdersDTO.mainStatus) &&
        Objects.equals(this.signPerson, wkOrdersDTO.signPerson) &&
        Objects.equals(this.signTime, wkOrdersDTO.signTime) &&
        Objects.equals(this.signStatus, wkOrdersDTO.signStatus) &&
        Objects.equals(this.signFailType, wkOrdersDTO.signFailType) &&
        Objects.equals(this.signFailReason, wkOrdersDTO.signFailReason) &&
        Objects.equals(this.postcodeSignTime, wkOrdersDTO.postcodeSignTime) &&
        Objects.equals(this.handleWay, wkOrdersDTO.handleWay) &&
        Objects.equals(this.backExpressNumber, wkOrdersDTO.backExpressNumber) &&
        Objects.equals(this.exceptionNote, wkOrdersDTO.exceptionNote) &&
        Objects.equals(this.exceptionHandlePerson, wkOrdersDTO.exceptionHandlePerson) &&
        Objects.equals(this.exceptionHandleTime, wkOrdersDTO.exceptionHandleTime) &&
        Objects.equals(this.sendPerson, wkOrdersDTO.sendPerson) &&
        Objects.equals(this.sendPersonPhone, wkOrdersDTO.sendPersonPhone) &&
        Objects.equals(this.isLock, wkOrdersDTO.isLock) &&
        Objects.equals(this.autoCheckStatus, wkOrdersDTO.autoCheckStatus) &&
        Objects.equals(this.autoCheckNote, wkOrdersDTO.autoCheckNote) &&
        Objects.equals(this.autoCheckTime, wkOrdersDTO.autoCheckTime) &&
        Objects.equals(this.orderStatus, wkOrdersDTO.orderStatus) &&
        Objects.equals(this.ifAuthFlag, wkOrdersDTO.ifAuthFlag) &&
        Objects.equals(this.authStatus, wkOrdersDTO.authStatus) &&
        Objects.equals(this.authAmount, wkOrdersDTO.authAmount) &&
        Objects.equals(this.authNotContaintAmount, wkOrdersDTO.authNotContaintAmount) &&
        Objects.equals(this.authTaxAmount, wkOrdersDTO.authTaxAmount) &&
        Objects.equals(this.authUpdateTime, wkOrdersDTO.authUpdateTime) &&
        Objects.equals(this.syncServiceSystemStatus, wkOrdersDTO.syncServiceSystemStatus) &&
        Objects.equals(this.syncServiceSystemTime, wkOrdersDTO.syncServiceSystemTime) &&
        Objects.equals(this.syncServiceSystemNote, wkOrdersDTO.syncServiceSystemNote) &&
        Objects.equals(this.auditStatus, wkOrdersDTO.auditStatus) &&
        Objects.equals(this.auditUpdateTime, wkOrdersDTO.auditUpdateTime) &&
        Objects.equals(this.synAuditStatus, wkOrdersDTO.synAuditStatus) &&
        Objects.equals(this.synAuditStatusTime, wkOrdersDTO.synAuditStatusTime) &&
        Objects.equals(this.synAuditStatusNote, wkOrdersDTO.synAuditStatusNote) &&
        Objects.equals(this.isPushTask, wkOrdersDTO.isPushTask) &&
        Objects.equals(this.taxRebateAmount, wkOrdersDTO.taxRebateAmount) &&
        Objects.equals(this.deductionAmount, wkOrdersDTO.deductionAmount) &&
        Objects.equals(this.agreementCode, wkOrdersDTO.agreementCode) &&
        Objects.equals(this.pushTime, wkOrdersDTO.pushTime) &&
        Objects.equals(this.changeTime, wkOrdersDTO.changeTime) &&
        Objects.equals(this.changeStatus, wkOrdersDTO.changeStatus) &&
        Objects.equals(this.changeInfo, wkOrdersDTO.changeInfo) &&
        Objects.equals(this.isLegalSynergetics, wkOrdersDTO.isLegalSynergetics) &&
        Objects.equals(this.recipientCompany, wkOrdersDTO.recipientCompany) &&
        Objects.equals(this.returnBatch, wkOrdersDTO.returnBatch) &&
        Objects.equals(this.returnType, wkOrdersDTO.returnType) &&
        Objects.equals(this.syncTime, wkOrdersDTO.syncTime) &&
        Objects.equals(this.requestSerialNoToXyj, wkOrdersDTO.requestSerialNoToXyj) &&
        Objects.equals(this.synTimeToXyj, wkOrdersDTO.synTimeToXyj) &&
        Objects.equals(this.synResultToXyj, wkOrdersDTO.synResultToXyj) &&
        Objects.equals(this.infoFromXyj, wkOrdersDTO.infoFromXyj) &&
        Objects.equals(this.processTimeFromXyj, wkOrdersDTO.processTimeFromXyj) &&
        Objects.equals(this.cooperateFlagFromXyj, wkOrdersDTO.cooperateFlagFromXyj) &&
        Objects.equals(this.groupFlagFromXyj, wkOrdersDTO.groupFlagFromXyj) &&
        Objects.equals(this.synResultTimeFromXyj, wkOrdersDTO.synResultTimeFromXyj) &&
        Objects.equals(this.operator, wkOrdersDTO.operator) &&
        Objects.equals(this.purchaserManageUnit, wkOrdersDTO.purchaserManageUnit) &&
        Objects.equals(this.performerFullName, wkOrdersDTO.performerFullName) &&
        Objects.equals(this.performerAccount, wkOrdersDTO.performerAccount) &&
        Objects.equals(this.orgName, wkOrdersDTO.orgName) &&
        Objects.equals(this.billStatus, wkOrdersDTO.billStatus) &&
        Objects.equals(this.sellerContactNo, wkOrdersDTO.sellerContactNo) &&
        Objects.equals(this.sellerExpress, wkOrdersDTO.sellerExpress) &&
        Objects.equals(this.outputType, wkOrdersDTO.outputType) &&
        Objects.equals(this.outputState, wkOrdersDTO.outputState) &&
        Objects.equals(this.accountSetCode, wkOrdersDTO.accountSetCode) &&
        Objects.equals(this.voucherCreated, wkOrdersDTO.voucherCreated) &&
        Objects.equals(this.invoiceStatus, wkOrdersDTO.invoiceStatus) &&
        Objects.equals(this.expressCode, wkOrdersDTO.expressCode) &&
        Objects.equals(this.synXyjAuditStatus, wkOrdersDTO.synXyjAuditStatus) &&
        Objects.equals(this.synXyjAuditTime, wkOrdersDTO.synXyjAuditTime) &&
        Objects.equals(this.synGxfileStatus, wkOrdersDTO.synGxfileStatus) &&
        Objects.equals(this.synGxfileTime, wkOrdersDTO.synGxfileTime) &&
        Objects.equals(this.smSyncTime, wkOrdersDTO.smSyncTime) &&
        Objects.equals(this.smStatus, wkOrdersDTO.smStatus) &&
        Objects.equals(this.auditUser, wkOrdersDTO.auditUser) &&
        Objects.equals(this.authType, wkOrdersDTO.authType) &&
        Objects.equals(this.sellerDrawDate, wkOrdersDTO.sellerDrawDate) &&
        Objects.equals(this.alreadyMakeAmountWithTax, wkOrdersDTO.alreadyMakeAmountWithTax) &&
        Objects.equals(this.authValidTaxAmount, wkOrdersDTO.authValidTaxAmount) &&
        Objects.equals(this.authCheckTime, wkOrdersDTO.authCheckTime) &&
        Objects.equals(this.reserve1, wkOrdersDTO.reserve1);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, salesbillNo, sellerNo, sellerName, sellerTaxNo, sellerTel, sellerAddress, sellerBankName, sellerBankAccount, purchaserNo, purchaserName, purchaserTaxNo, purchaserTel, purchaserAddress, purchaserBankName, purchaserBankAccount, systemOrig, salesbillType, invoiceType, amountWithTax, amountWithoutTax, taxAmount, cooperateFlag, status, originInvoiceNo, originInvoiceCode, redNotification, checkerName, cashierName, invoicerName, receiveUserEmail, receiveUserTel, createTime, createUserName, recipient, recipientPhone, remark, packageCode, businessOrderType, specialTicketAmountWithTax, generalTicketAmountWithTax, taxRate, purchaserCode, sellerCode, mainStatus, signPerson, signTime, signStatus, signFailType, signFailReason, postcodeSignTime, handleWay, backExpressNumber, exceptionNote, exceptionHandlePerson, exceptionHandleTime, sendPerson, sendPersonPhone, isLock, autoCheckStatus, autoCheckNote, autoCheckTime, orderStatus, ifAuthFlag, authStatus, authAmount, authNotContaintAmount, authTaxAmount, authUpdateTime, syncServiceSystemStatus, syncServiceSystemTime, syncServiceSystemNote, auditStatus, auditUpdateTime, synAuditStatus, synAuditStatusTime, synAuditStatusNote, isPushTask, taxRebateAmount, deductionAmount, agreementCode, pushTime, changeTime, changeStatus, changeInfo, isLegalSynergetics, recipientCompany, returnBatch, returnType, syncTime, requestSerialNoToXyj, synTimeToXyj, synResultToXyj, infoFromXyj, processTimeFromXyj, cooperateFlagFromXyj, groupFlagFromXyj, synResultTimeFromXyj, operator, purchaserManageUnit, performerFullName, performerAccount, orgName, billStatus, sellerContactNo, sellerExpress, outputType, outputState, accountSetCode, voucherCreated, invoiceStatus, expressCode, synXyjAuditStatus, synXyjAuditTime, synGxfileStatus, synGxfileTime, smSyncTime, smStatus, auditUser, authType, sellerDrawDate, alreadyMakeAmountWithTax, authValidTaxAmount, authCheckTime, reserve1);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkOrdersDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    purchaserNo: ").append(toIndentedString(purchaserNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    salesbillType: ").append(toIndentedString(salesbillType)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    originInvoiceNo: ").append(toIndentedString(originInvoiceNo)).append("\n");
    sb.append("    originInvoiceCode: ").append(toIndentedString(originInvoiceCode)).append("\n");
    sb.append("    redNotification: ").append(toIndentedString(redNotification)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    receiveUserEmail: ").append(toIndentedString(receiveUserEmail)).append("\n");
    sb.append("    receiveUserTel: ").append(toIndentedString(receiveUserTel)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    recipientPhone: ").append(toIndentedString(recipientPhone)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    businessOrderType: ").append(toIndentedString(businessOrderType)).append("\n");
    sb.append("    specialTicketAmountWithTax: ").append(toIndentedString(specialTicketAmountWithTax)).append("\n");
    sb.append("    generalTicketAmountWithTax: ").append(toIndentedString(generalTicketAmountWithTax)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    purchaserCode: ").append(toIndentedString(purchaserCode)).append("\n");
    sb.append("    sellerCode: ").append(toIndentedString(sellerCode)).append("\n");
    sb.append("    mainStatus: ").append(toIndentedString(mainStatus)).append("\n");
    sb.append("    signPerson: ").append(toIndentedString(signPerson)).append("\n");
    sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    signFailType: ").append(toIndentedString(signFailType)).append("\n");
    sb.append("    signFailReason: ").append(toIndentedString(signFailReason)).append("\n");
    sb.append("    postcodeSignTime: ").append(toIndentedString(postcodeSignTime)).append("\n");
    sb.append("    handleWay: ").append(toIndentedString(handleWay)).append("\n");
    sb.append("    backExpressNumber: ").append(toIndentedString(backExpressNumber)).append("\n");
    sb.append("    exceptionNote: ").append(toIndentedString(exceptionNote)).append("\n");
    sb.append("    exceptionHandlePerson: ").append(toIndentedString(exceptionHandlePerson)).append("\n");
    sb.append("    exceptionHandleTime: ").append(toIndentedString(exceptionHandleTime)).append("\n");
    sb.append("    sendPerson: ").append(toIndentedString(sendPerson)).append("\n");
    sb.append("    sendPersonPhone: ").append(toIndentedString(sendPersonPhone)).append("\n");
    sb.append("    isLock: ").append(toIndentedString(isLock)).append("\n");
    sb.append("    autoCheckStatus: ").append(toIndentedString(autoCheckStatus)).append("\n");
    sb.append("    autoCheckNote: ").append(toIndentedString(autoCheckNote)).append("\n");
    sb.append("    autoCheckTime: ").append(toIndentedString(autoCheckTime)).append("\n");
    sb.append("    orderStatus: ").append(toIndentedString(orderStatus)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    authAmount: ").append(toIndentedString(authAmount)).append("\n");
    sb.append("    authNotContaintAmount: ").append(toIndentedString(authNotContaintAmount)).append("\n");
    sb.append("    authTaxAmount: ").append(toIndentedString(authTaxAmount)).append("\n");
    sb.append("    authUpdateTime: ").append(toIndentedString(authUpdateTime)).append("\n");
    sb.append("    syncServiceSystemStatus: ").append(toIndentedString(syncServiceSystemStatus)).append("\n");
    sb.append("    syncServiceSystemTime: ").append(toIndentedString(syncServiceSystemTime)).append("\n");
    sb.append("    syncServiceSystemNote: ").append(toIndentedString(syncServiceSystemNote)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    auditUpdateTime: ").append(toIndentedString(auditUpdateTime)).append("\n");
    sb.append("    synAuditStatus: ").append(toIndentedString(synAuditStatus)).append("\n");
    sb.append("    synAuditStatusTime: ").append(toIndentedString(synAuditStatusTime)).append("\n");
    sb.append("    synAuditStatusNote: ").append(toIndentedString(synAuditStatusNote)).append("\n");
    sb.append("    isPushTask: ").append(toIndentedString(isPushTask)).append("\n");
    sb.append("    taxRebateAmount: ").append(toIndentedString(taxRebateAmount)).append("\n");
    sb.append("    deductionAmount: ").append(toIndentedString(deductionAmount)).append("\n");
    sb.append("    agreementCode: ").append(toIndentedString(agreementCode)).append("\n");
    sb.append("    pushTime: ").append(toIndentedString(pushTime)).append("\n");
    sb.append("    changeTime: ").append(toIndentedString(changeTime)).append("\n");
    sb.append("    changeStatus: ").append(toIndentedString(changeStatus)).append("\n");
    sb.append("    changeInfo: ").append(toIndentedString(changeInfo)).append("\n");
    sb.append("    isLegalSynergetics: ").append(toIndentedString(isLegalSynergetics)).append("\n");
    sb.append("    recipientCompany: ").append(toIndentedString(recipientCompany)).append("\n");
    sb.append("    returnBatch: ").append(toIndentedString(returnBatch)).append("\n");
    sb.append("    returnType: ").append(toIndentedString(returnType)).append("\n");
    sb.append("    syncTime: ").append(toIndentedString(syncTime)).append("\n");
    sb.append("    requestSerialNoToXyj: ").append(toIndentedString(requestSerialNoToXyj)).append("\n");
    sb.append("    synTimeToXyj: ").append(toIndentedString(synTimeToXyj)).append("\n");
    sb.append("    synResultToXyj: ").append(toIndentedString(synResultToXyj)).append("\n");
    sb.append("    infoFromXyj: ").append(toIndentedString(infoFromXyj)).append("\n");
    sb.append("    processTimeFromXyj: ").append(toIndentedString(processTimeFromXyj)).append("\n");
    sb.append("    cooperateFlagFromXyj: ").append(toIndentedString(cooperateFlagFromXyj)).append("\n");
    sb.append("    groupFlagFromXyj: ").append(toIndentedString(groupFlagFromXyj)).append("\n");
    sb.append("    synResultTimeFromXyj: ").append(toIndentedString(synResultTimeFromXyj)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    purchaserManageUnit: ").append(toIndentedString(purchaserManageUnit)).append("\n");
    sb.append("    performerFullName: ").append(toIndentedString(performerFullName)).append("\n");
    sb.append("    performerAccount: ").append(toIndentedString(performerAccount)).append("\n");
    sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
    sb.append("    billStatus: ").append(toIndentedString(billStatus)).append("\n");
    sb.append("    sellerContactNo: ").append(toIndentedString(sellerContactNo)).append("\n");
    sb.append("    sellerExpress: ").append(toIndentedString(sellerExpress)).append("\n");
    sb.append("    outputType: ").append(toIndentedString(outputType)).append("\n");
    sb.append("    outputState: ").append(toIndentedString(outputState)).append("\n");
    sb.append("    accountSetCode: ").append(toIndentedString(accountSetCode)).append("\n");
    sb.append("    voucherCreated: ").append(toIndentedString(voucherCreated)).append("\n");
    sb.append("    invoiceStatus: ").append(toIndentedString(invoiceStatus)).append("\n");
    sb.append("    expressCode: ").append(toIndentedString(expressCode)).append("\n");
    sb.append("    synXyjAuditStatus: ").append(toIndentedString(synXyjAuditStatus)).append("\n");
    sb.append("    synXyjAuditTime: ").append(toIndentedString(synXyjAuditTime)).append("\n");
    sb.append("    synGxfileStatus: ").append(toIndentedString(synGxfileStatus)).append("\n");
    sb.append("    synGxfileTime: ").append(toIndentedString(synGxfileTime)).append("\n");
    sb.append("    smSyncTime: ").append(toIndentedString(smSyncTime)).append("\n");
    sb.append("    smStatus: ").append(toIndentedString(smStatus)).append("\n");
    sb.append("    auditUser: ").append(toIndentedString(auditUser)).append("\n");
    sb.append("    authType: ").append(toIndentedString(authType)).append("\n");
    sb.append("    sellerDrawDate: ").append(toIndentedString(sellerDrawDate)).append("\n");
    sb.append("    alreadyMakeAmountWithTax: ").append(toIndentedString(alreadyMakeAmountWithTax)).append("\n");
    sb.append("    authValidTaxAmount: ").append(toIndentedString(authValidTaxAmount)).append("\n");
    sb.append("    authCheckTime: ").append(toIndentedString(authCheckTime)).append("\n");
    sb.append("    reserve1: ").append(toIndentedString(reserve1)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
