package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单据明细表
 */
@ApiModel(description = "业务单据明细表")

@JsonInclude(NON_NULL)
public class WkOrdersDetailsDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("settlementItemNo")
  private String settlementItemNo = null;

  @JsonProperty("settlementMethod")
  private String settlementMethod = null;

  @JsonProperty("acctPeriod")
  private String acctPeriod = null;

  @JsonProperty("transportMethod")
  private String transportMethod = null;

  @JsonProperty("invoiceGoodsCounterparts")
  private String invoiceGoodsCounterparts = null;

  @JsonProperty("contractNo")
  private String contractNo = null;

  @JsonProperty("orderNo")
  private String orderNo = null;

  @JsonProperty("contractDetailNo")
  private String contractDetailNo = null;

  @JsonProperty("orderDetailNo")
  private String orderDetailNo = null;

  @JsonProperty("commFmlyDesc")
  private String commFmlyDesc = null;

  @JsonProperty("commDesc")
  private String commDesc = null;

  @JsonProperty("categoryDesc")
  private String categoryDesc = null;

  @JsonProperty("itemCode")
  private String itemCode = null;

  @JsonProperty("itemName")
  private String itemName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("quantity")
  private BigDecimal quantity = null;

  @JsonProperty("priceMethod")
  private Integer priceMethod = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("unitPrice")
  private BigDecimal unitPrice = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("discountWithoutTax")
  private BigDecimal discountWithoutTax = null;

  @JsonProperty("discountTax")
  private BigDecimal discountTax = null;

  @JsonProperty("discountWithTax")
  private BigDecimal discountWithTax = null;

  @JsonProperty("deductions")
  private BigDecimal deductions = null;

  @JsonProperty("syncTime")
  private Long syncTime = null;

  @JsonProperty("otherRemark")
  private String otherRemark = null;

  @JsonProperty("sku")
  private String sku = null;

  @JsonProperty("goodsId")
  private String goodsId = null;

  @JsonIgnore
  public WkOrdersDetailsDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * null
   * @return id
  **/
  @ApiModelProperty(value = "null")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO settlementItemNo(String settlementItemNo) {
    this.settlementItemNo = settlementItemNo;
    return this;
  }

   /**
   * 结算单号
   * @return settlementItemNo
  **/
  @ApiModelProperty(value = "结算单号")
  public String getSettlementItemNo() {
    return settlementItemNo;
  }

  public void setSettlementItemNo(String settlementItemNo) {
    this.settlementItemNo = settlementItemNo;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO settlementMethod(String settlementMethod) {
    this.settlementMethod = settlementMethod;
    return this;
  }

   /**
   * 结算方式（中文）
   * @return settlementMethod
  **/
  @ApiModelProperty(value = "结算方式（中文）")
  public String getSettlementMethod() {
    return settlementMethod;
  }

  public void setSettlementMethod(String settlementMethod) {
    this.settlementMethod = settlementMethod;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO acctPeriod(String acctPeriod) {
    this.acctPeriod = acctPeriod;
    return this;
  }

   /**
   * 会计结算期间
   * @return acctPeriod
  **/
  @ApiModelProperty(value = "会计结算期间")
  public String getAcctPeriod() {
    return acctPeriod;
  }

  public void setAcctPeriod(String acctPeriod) {
    this.acctPeriod = acctPeriod;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO transportMethod(String transportMethod) {
    this.transportMethod = transportMethod;
    return this;
  }

   /**
   * 运输方式（中文）
   * @return transportMethod
  **/
  @ApiModelProperty(value = "运输方式（中文）")
  public String getTransportMethod() {
    return transportMethod;
  }

  public void setTransportMethod(String transportMethod) {
    this.transportMethod = transportMethod;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO invoiceGoodsCounterparts(String invoiceGoodsCounterparts) {
    this.invoiceGoodsCounterparts = invoiceGoodsCounterparts;
    return this;
  }

   /**
   * 票货同行
   * @return invoiceGoodsCounterparts
  **/
  @ApiModelProperty(value = "票货同行")
  public String getInvoiceGoodsCounterparts() {
    return invoiceGoodsCounterparts;
  }

  public void setInvoiceGoodsCounterparts(String invoiceGoodsCounterparts) {
    this.invoiceGoodsCounterparts = invoiceGoodsCounterparts;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO contractNo(String contractNo) {
    this.contractNo = contractNo;
    return this;
  }

   /**
   * 合同号
   * @return contractNo
  **/
  @ApiModelProperty(value = "合同号")
  public String getContractNo() {
    return contractNo;
  }

  public void setContractNo(String contractNo) {
    this.contractNo = contractNo;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO orderNo(String orderNo) {
    this.orderNo = orderNo;
    return this;
  }

   /**
   * 订单号
   * @return orderNo
  **/
  @ApiModelProperty(value = "订单号")
  public String getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO contractDetailNo(String contractDetailNo) {
    this.contractDetailNo = contractDetailNo;
    return this;
  }

   /**
   * 合同行号
   * @return contractDetailNo
  **/
  @ApiModelProperty(value = "合同行号")
  public String getContractDetailNo() {
    return contractDetailNo;
  }

  public void setContractDetailNo(String contractDetailNo) {
    this.contractDetailNo = contractDetailNo;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO orderDetailNo(String orderDetailNo) {
    this.orderDetailNo = orderDetailNo;
    return this;
  }

   /**
   * 订单行号
   * @return orderDetailNo
  **/
  @ApiModelProperty(value = "订单行号")
  public String getOrderDetailNo() {
    return orderDetailNo;
  }

  public void setOrderDetailNo(String orderDetailNo) {
    this.orderDetailNo = orderDetailNo;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO commFmlyDesc(String commFmlyDesc) {
    this.commFmlyDesc = commFmlyDesc;
    return this;
  }

   /**
   * 项目大类（中文）
   * @return commFmlyDesc
  **/
  @ApiModelProperty(value = "项目大类（中文）")
  public String getCommFmlyDesc() {
    return commFmlyDesc;
  }

  public void setCommFmlyDesc(String commFmlyDesc) {
    this.commFmlyDesc = commFmlyDesc;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO commDesc(String commDesc) {
    this.commDesc = commDesc;
    return this;
  }

   /**
   * 项目中类（中文）
   * @return commDesc
  **/
  @ApiModelProperty(value = "项目中类（中文）")
  public String getCommDesc() {
    return commDesc;
  }

  public void setCommDesc(String commDesc) {
    this.commDesc = commDesc;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO categoryDesc(String categoryDesc) {
    this.categoryDesc = categoryDesc;
    return this;
  }

   /**
   * 项目细类（中文）
   * @return categoryDesc
  **/
  @ApiModelProperty(value = "项目细类（中文）")
  public String getCategoryDesc() {
    return categoryDesc;
  }

  public void setCategoryDesc(String categoryDesc) {
    this.categoryDesc = categoryDesc;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO itemCode(String itemCode) {
    this.itemCode = itemCode;
    return this;
  }

   /**
   * 税收分类编码
   * @return itemCode
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getItemCode() {
    return itemCode;
  }

  public void setItemCode(String itemCode) {
    this.itemCode = itemCode;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * 货物及服务名称
   * @return itemName
  **/
  @ApiModelProperty(value = "货物及服务名称")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 型号规格
   * @return itemSpec
  **/
  @ApiModelProperty(value = "型号规格")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 数量单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "数量单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO quantity(BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO priceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 价格方式（两种计算方式）0-不含税价1-含税价2-未知
   * @return priceMethod
  **/
  @ApiModelProperty(value = "价格方式（两种计算方式）0-不含税价1-含税价2-未知")
  public Integer getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO unitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价")
  public BigDecimal getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO discountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
    return this;
  }

   /**
   * 不含税折扣金额
   * @return discountWithoutTax
  **/
  @ApiModelProperty(value = "不含税折扣金额")
  public BigDecimal getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO discountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
    return this;
  }

   /**
   * 折扣税额
   * @return discountTax
  **/
  @ApiModelProperty(value = "折扣税额")
  public BigDecimal getDiscountTax() {
    return discountTax;
  }

  public void setDiscountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO discountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
    return this;
  }

   /**
   * 含税折扣金额
   * @return discountWithTax
  **/
  @ApiModelProperty(value = "含税折扣金额")
  public BigDecimal getDiscountWithTax() {
    return discountWithTax;
  }

  public void setDiscountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO deductions(BigDecimal deductions) {
    this.deductions = deductions;
    return this;
  }

   /**
   * 可抵扣金额
   * @return deductions
  **/
  @ApiModelProperty(value = "可抵扣金额")
  public BigDecimal getDeductions() {
    return deductions;
  }

  public void setDeductions(BigDecimal deductions) {
    this.deductions = deductions;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO syncTime(Long syncTime) {
    this.syncTime = syncTime;
    return this;
  }

   /**
   * 同步时间
   * @return syncTime
  **/
  @ApiModelProperty(value = "同步时间")
  public Long getSyncTime() {
    return syncTime;
  }

  public void setSyncTime(Long syncTime) {
    this.syncTime = syncTime;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO otherRemark(String otherRemark) {
    this.otherRemark = otherRemark;
    return this;
  }

   /**
   * 备注
   * @return otherRemark
  **/
  @ApiModelProperty(value = "备注")
  public String getOtherRemark() {
    return otherRemark;
  }

  public void setOtherRemark(String otherRemark) {
    this.otherRemark = otherRemark;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO sku(String sku) {
    this.sku = sku;
    return this;
  }

   /**
   * 商品编码
   * @return sku
  **/
  @ApiModelProperty(value = "商品编码")
  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  @JsonIgnore
  public WkOrdersDetailsDTO goodsId(String goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 商品id
   * @return goodsId
  **/
  @ApiModelProperty(value = "商品id")
  public String getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(String goodsId) {
    this.goodsId = goodsId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkOrdersDetailsDTO wkOrdersDetailsDTO = (WkOrdersDetailsDTO) o;
    return Objects.equals(this.id, wkOrdersDetailsDTO.id) &&
        Objects.equals(this.settlementItemNo, wkOrdersDetailsDTO.settlementItemNo) &&
        Objects.equals(this.settlementMethod, wkOrdersDetailsDTO.settlementMethod) &&
        Objects.equals(this.acctPeriod, wkOrdersDetailsDTO.acctPeriod) &&
        Objects.equals(this.transportMethod, wkOrdersDetailsDTO.transportMethod) &&
        Objects.equals(this.invoiceGoodsCounterparts, wkOrdersDetailsDTO.invoiceGoodsCounterparts) &&
        Objects.equals(this.contractNo, wkOrdersDetailsDTO.contractNo) &&
        Objects.equals(this.orderNo, wkOrdersDetailsDTO.orderNo) &&
        Objects.equals(this.contractDetailNo, wkOrdersDetailsDTO.contractDetailNo) &&
        Objects.equals(this.orderDetailNo, wkOrdersDetailsDTO.orderDetailNo) &&
        Objects.equals(this.commFmlyDesc, wkOrdersDetailsDTO.commFmlyDesc) &&
        Objects.equals(this.commDesc, wkOrdersDetailsDTO.commDesc) &&
        Objects.equals(this.categoryDesc, wkOrdersDetailsDTO.categoryDesc) &&
        Objects.equals(this.itemCode, wkOrdersDetailsDTO.itemCode) &&
        Objects.equals(this.itemName, wkOrdersDetailsDTO.itemName) &&
        Objects.equals(this.itemSpec, wkOrdersDetailsDTO.itemSpec) &&
        Objects.equals(this.quantityUnit, wkOrdersDetailsDTO.quantityUnit) &&
        Objects.equals(this.quantity, wkOrdersDetailsDTO.quantity) &&
        Objects.equals(this.priceMethod, wkOrdersDetailsDTO.priceMethod) &&
        Objects.equals(this.taxRate, wkOrdersDetailsDTO.taxRate) &&
        Objects.equals(this.unitPrice, wkOrdersDetailsDTO.unitPrice) &&
        Objects.equals(this.amountWithTax, wkOrdersDetailsDTO.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, wkOrdersDetailsDTO.amountWithoutTax) &&
        Objects.equals(this.taxAmount, wkOrdersDetailsDTO.taxAmount) &&
        Objects.equals(this.discountWithoutTax, wkOrdersDetailsDTO.discountWithoutTax) &&
        Objects.equals(this.discountTax, wkOrdersDetailsDTO.discountTax) &&
        Objects.equals(this.discountWithTax, wkOrdersDetailsDTO.discountWithTax) &&
        Objects.equals(this.deductions, wkOrdersDetailsDTO.deductions) &&
        Objects.equals(this.syncTime, wkOrdersDetailsDTO.syncTime) &&
        Objects.equals(this.otherRemark, wkOrdersDetailsDTO.otherRemark) &&
        Objects.equals(this.sku, wkOrdersDetailsDTO.sku) &&
        Objects.equals(this.goodsId, wkOrdersDetailsDTO.goodsId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, settlementItemNo, settlementMethod, acctPeriod, transportMethod, invoiceGoodsCounterparts, contractNo, orderNo, contractDetailNo, orderDetailNo, commFmlyDesc, commDesc, categoryDesc, itemCode, itemName, itemSpec, quantityUnit, quantity, priceMethod, taxRate, unitPrice, amountWithTax, amountWithoutTax, taxAmount, discountWithoutTax, discountTax, discountWithTax, deductions, syncTime, otherRemark, sku, goodsId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkOrdersDetailsDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    settlementItemNo: ").append(toIndentedString(settlementItemNo)).append("\n");
    sb.append("    settlementMethod: ").append(toIndentedString(settlementMethod)).append("\n");
    sb.append("    acctPeriod: ").append(toIndentedString(acctPeriod)).append("\n");
    sb.append("    transportMethod: ").append(toIndentedString(transportMethod)).append("\n");
    sb.append("    invoiceGoodsCounterparts: ").append(toIndentedString(invoiceGoodsCounterparts)).append("\n");
    sb.append("    contractNo: ").append(toIndentedString(contractNo)).append("\n");
    sb.append("    orderNo: ").append(toIndentedString(orderNo)).append("\n");
    sb.append("    contractDetailNo: ").append(toIndentedString(contractDetailNo)).append("\n");
    sb.append("    orderDetailNo: ").append(toIndentedString(orderDetailNo)).append("\n");
    sb.append("    commFmlyDesc: ").append(toIndentedString(commFmlyDesc)).append("\n");
    sb.append("    commDesc: ").append(toIndentedString(commDesc)).append("\n");
    sb.append("    categoryDesc: ").append(toIndentedString(categoryDesc)).append("\n");
    sb.append("    itemCode: ").append(toIndentedString(itemCode)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    discountWithoutTax: ").append(toIndentedString(discountWithoutTax)).append("\n");
    sb.append("    discountTax: ").append(toIndentedString(discountTax)).append("\n");
    sb.append("    discountWithTax: ").append(toIndentedString(discountWithTax)).append("\n");
    sb.append("    deductions: ").append(toIndentedString(deductions)).append("\n");
    sb.append("    syncTime: ").append(toIndentedString(syncTime)).append("\n");
    sb.append("    otherRemark: ").append(toIndentedString(otherRemark)).append("\n");
    sb.append("    sku: ").append(toIndentedString(sku)).append("\n");
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
