package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 签收管理表
 */
@ApiModel(description = "签收管理表")

@JsonInclude(NON_NULL)
public class WkPostcodeDTO {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("packageCode")
  private String packageCode = null;

  @JsonProperty("expressCode")
  private String expressCode = null;

  @JsonProperty("recieveStatus")
  private Integer recieveStatus = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("reciever")
  private String reciever = null;

  @JsonProperty("recieveTime")
  private Long recieveTime = null;

  @JsonProperty("recieveMethod")
  private Integer recieveMethod = null;

  @JsonProperty("billNum")
  private Integer billNum = null;

  @JsonProperty("errorType")
  private Integer errorType = null;

  @JsonProperty("errorRemark")
  private String errorRemark = null;

  @JsonProperty("errorer")
  private String errorer = null;

  @JsonProperty("errorProcessTime")
  private Long errorProcessTime = null;

  @JsonProperty("processMethod")
  private String processMethod = null;

  @JsonProperty("backPostCode")
  private String backPostCode = null;

  @JsonProperty("workCodeRemark")
  private String workCodeRemark = null;

  @JsonProperty("processer")
  private String processer = null;

  @JsonProperty("processTime")
  private Long processTime = null;

  @JsonProperty("sender")
  private String sender = null;

  @JsonProperty("senderContactway")
  private String senderContactway = null;

  @JsonProperty("senderCompany")
  private String senderCompany = null;

  @JsonProperty("senderAddr")
  private String senderAddr = null;

  @JsonProperty("sendTime")
  private Long sendTime = null;

  @JsonProperty("isLock")
  private Integer isLock = null;

  @JsonProperty("isReceived")
  private Integer isReceived = null;

  @JsonProperty("processStatus")
  private Integer processStatus = null;

  @JsonProperty("isUnpacking")
  private Integer isUnpacking = null;

  @JsonProperty("recipientPhone")
  private String recipientPhone = null;

  @JsonProperty("recipient")
  private String recipient = null;

  @JsonProperty("recipientContactway")
  private String recipientContactway = null;

  @JsonProperty("recipientCompany")
  private String recipientCompany = null;

  @JsonProperty("recipientAddr")
  private String recipientAddr = null;

  @JsonProperty("returnBatch")
  private Integer returnBatch = null;

  @JsonProperty("returnType")
  private Integer returnType = null;

  @JsonIgnore
  public WkPostcodeDTO id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public WkPostcodeDTO packageCode(String packageCode) {
    this.packageCode = packageCode;
    return this;
  }

   /**
   * 邮包的快递单号
   * @return packageCode
  **/
  @ApiModelProperty(value = "邮包的快递单号")
  public String getPackageCode() {
    return packageCode;
  }

  public void setPackageCode(String packageCode) {
    this.packageCode = packageCode;
  }

  @JsonIgnore
  public WkPostcodeDTO expressCode(String expressCode) {
    this.expressCode = expressCode;
    return this;
  }

   /**
   * 快递公司code
   * @return expressCode
  **/
  @ApiModelProperty(value = "快递公司code")
  public String getExpressCode() {
    return expressCode;
  }

  public void setExpressCode(String expressCode) {
    this.expressCode = expressCode;
  }

  @JsonIgnore
  public WkPostcodeDTO recieveStatus(Integer recieveStatus) {
    this.recieveStatus = recieveStatus;
    return this;
  }

   /**
   * 签收状态：10-成功，20-失败（结算处理成功后要反写过来）
   * @return recieveStatus
  **/
  @ApiModelProperty(value = "签收状态：10-成功，20-失败（结算处理成功后要反写过来）")
  public Integer getRecieveStatus() {
    return recieveStatus;
  }

  public void setRecieveStatus(Integer recieveStatus) {
    this.recieveStatus = recieveStatus;
  }

  @JsonIgnore
  public WkPostcodeDTO remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public WkPostcodeDTO reciever(String reciever) {
    this.reciever = reciever;
    return this;
  }

   /**
   * 签收人
   * @return reciever
  **/
  @ApiModelProperty(value = "签收人")
  public String getReciever() {
    return reciever;
  }

  public void setReciever(String reciever) {
    this.reciever = reciever;
  }

  @JsonIgnore
  public WkPostcodeDTO recieveTime(Long recieveTime) {
    this.recieveTime = recieveTime;
    return this;
  }

   /**
   * 签收时间
   * @return recieveTime
  **/
  @ApiModelProperty(value = "签收时间")
  public Long getRecieveTime() {
    return recieveTime;
  }

  public void setRecieveTime(Long recieveTime) {
    this.recieveTime = recieveTime;
  }

  @JsonIgnore
  public WkPostcodeDTO recieveMethod(Integer recieveMethod) {
    this.recieveMethod = recieveMethod;
    return this;
  }

   /**
   * 签收方式：10-邮包签收，20-结算单签收
   * @return recieveMethod
  **/
  @ApiModelProperty(value = "签收方式：10-邮包签收，20-结算单签收")
  public Integer getRecieveMethod() {
    return recieveMethod;
  }

  public void setRecieveMethod(Integer recieveMethod) {
    this.recieveMethod = recieveMethod;
  }

  @JsonIgnore
  public WkPostcodeDTO billNum(Integer billNum) {
    this.billNum = billNum;
    return this;
  }

   /**
   * 发票张数
   * @return billNum
  **/
  @ApiModelProperty(value = "发票张数")
  public Integer getBillNum() {
    return billNum;
  }

  public void setBillNum(Integer billNum) {
    this.billNum = billNum;
  }

  @JsonIgnore
  public WkPostcodeDTO errorType(Integer errorType) {
    this.errorType = errorType;
    return this;
  }

   /**
   * 异常原因分类：0-无，1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无业务单，5-其他
   * @return errorType
  **/
  @ApiModelProperty(value = "异常原因分类：0-无，1-发票未盖章，2-发票污损，3-发票打印错位，4-发票无业务单，5-其他")
  public Integer getErrorType() {
    return errorType;
  }

  public void setErrorType(Integer errorType) {
    this.errorType = errorType;
  }

  @JsonIgnore
  public WkPostcodeDTO errorRemark(String errorRemark) {
    this.errorRemark = errorRemark;
    return this;
  }

   /**
   * 备注说明
   * @return errorRemark
  **/
  @ApiModelProperty(value = "备注说明")
  public String getErrorRemark() {
    return errorRemark;
  }

  public void setErrorRemark(String errorRemark) {
    this.errorRemark = errorRemark;
  }

  @JsonIgnore
  public WkPostcodeDTO errorer(String errorer) {
    this.errorer = errorer;
    return this;
  }

   /**
   * 异常处理人
   * @return errorer
  **/
  @ApiModelProperty(value = "异常处理人")
  public String getErrorer() {
    return errorer;
  }

  public void setErrorer(String errorer) {
    this.errorer = errorer;
  }

  @JsonIgnore
  public WkPostcodeDTO errorProcessTime(Long errorProcessTime) {
    this.errorProcessTime = errorProcessTime;
    return this;
  }

   /**
   * 异常处理时间
   * @return errorProcessTime
  **/
  @ApiModelProperty(value = "异常处理时间")
  public Long getErrorProcessTime() {
    return errorProcessTime;
  }

  public void setErrorProcessTime(Long errorProcessTime) {
    this.errorProcessTime = errorProcessTime;
  }

  @JsonIgnore
  public WkPostcodeDTO processMethod(String processMethod) {
    this.processMethod = processMethod;
    return this;
  }

   /**
   * 处理方式：10-暂挂，20-退回，30-转交给结算单签收，40-报支单共享扫 描，50-关闭，60-通知一线处理
   * @return processMethod
  **/
  @ApiModelProperty(value = "处理方式：10-暂挂，20-退回，30-转交给结算单签收，40-报支单共享扫 描，50-关闭，60-通知一线处理")
  public String getProcessMethod() {
    return processMethod;
  }

  public void setProcessMethod(String processMethod) {
    this.processMethod = processMethod;
  }

  @JsonIgnore
  public WkPostcodeDTO backPostCode(String backPostCode) {
    this.backPostCode = backPostCode;
    return this;
  }

   /**
   * 回寄快递单号
   * @return backPostCode
  **/
  @ApiModelProperty(value = "回寄快递单号")
  public String getBackPostCode() {
    return backPostCode;
  }

  public void setBackPostCode(String backPostCode) {
    this.backPostCode = backPostCode;
  }

  @JsonIgnore
  public WkPostcodeDTO workCodeRemark(String workCodeRemark) {
    this.workCodeRemark = workCodeRemark;
    return this;
  }

   /**
   * 工单处理说明
   * @return workCodeRemark
  **/
  @ApiModelProperty(value = "工单处理说明")
  public String getWorkCodeRemark() {
    return workCodeRemark;
  }

  public void setWorkCodeRemark(String workCodeRemark) {
    this.workCodeRemark = workCodeRemark;
  }

  @JsonIgnore
  public WkPostcodeDTO processer(String processer) {
    this.processer = processer;
    return this;
  }

   /**
   * 处理人
   * @return processer
  **/
  @ApiModelProperty(value = "处理人")
  public String getProcesser() {
    return processer;
  }

  public void setProcesser(String processer) {
    this.processer = processer;
  }

  @JsonIgnore
  public WkPostcodeDTO processTime(Long processTime) {
    this.processTime = processTime;
    return this;
  }

   /**
   * 处理时间
   * @return processTime
  **/
  @ApiModelProperty(value = "处理时间")
  public Long getProcessTime() {
    return processTime;
  }

  public void setProcessTime(Long processTime) {
    this.processTime = processTime;
  }

  @JsonIgnore
  public WkPostcodeDTO sender(String sender) {
    this.sender = sender;
    return this;
  }

   /**
   * 寄件人
   * @return sender
  **/
  @ApiModelProperty(value = "寄件人")
  public String getSender() {
    return sender;
  }

  public void setSender(String sender) {
    this.sender = sender;
  }

  @JsonIgnore
  public WkPostcodeDTO senderContactway(String senderContactway) {
    this.senderContactway = senderContactway;
    return this;
  }

   /**
   * 寄件人联系方式
   * @return senderContactway
  **/
  @ApiModelProperty(value = "寄件人联系方式")
  public String getSenderContactway() {
    return senderContactway;
  }

  public void setSenderContactway(String senderContactway) {
    this.senderContactway = senderContactway;
  }

  @JsonIgnore
  public WkPostcodeDTO senderCompany(String senderCompany) {
    this.senderCompany = senderCompany;
    return this;
  }

   /**
   * 寄件公司
   * @return senderCompany
  **/
  @ApiModelProperty(value = "寄件公司")
  public String getSenderCompany() {
    return senderCompany;
  }

  public void setSenderCompany(String senderCompany) {
    this.senderCompany = senderCompany;
  }

  @JsonIgnore
  public WkPostcodeDTO senderAddr(String senderAddr) {
    this.senderAddr = senderAddr;
    return this;
  }

   /**
   * 寄件人地址
   * @return senderAddr
  **/
  @ApiModelProperty(value = "寄件人地址")
  public String getSenderAddr() {
    return senderAddr;
  }

  public void setSenderAddr(String senderAddr) {
    this.senderAddr = senderAddr;
  }

  @JsonIgnore
  public WkPostcodeDTO sendTime(Long sendTime) {
    this.sendTime = sendTime;
    return this;
  }

   /**
   * 寄件时间
   * @return sendTime
  **/
  @ApiModelProperty(value = "寄件时间")
  public Long getSendTime() {
    return sendTime;
  }

  public void setSendTime(Long sendTime) {
    this.sendTime = sendTime;
  }

  @JsonIgnore
  public WkPostcodeDTO isLock(Integer isLock) {
    this.isLock = isLock;
    return this;
  }

   /**
   * 是否锁定：0-未锁 1-已锁
   * @return isLock
  **/
  @ApiModelProperty(value = "是否锁定：0-未锁 1-已锁")
  public Integer getIsLock() {
    return isLock;
  }

  public void setIsLock(Integer isLock) {
    this.isLock = isLock;
  }

  @JsonIgnore
  public WkPostcodeDTO isReceived(Integer isReceived) {
    this.isReceived = isReceived;
    return this;
  }

   /**
   * 是否实物确认接收：0-否，1-是
   * @return isReceived
  **/
  @ApiModelProperty(value = "是否实物确认接收：0-否，1-是")
  public Integer getIsReceived() {
    return isReceived;
  }

  public void setIsReceived(Integer isReceived) {
    this.isReceived = isReceived;
  }

  @JsonIgnore
  public WkPostcodeDTO processStatus(Integer processStatus) {
    this.processStatus = processStatus;
    return this;
  }

   /**
   * 邮包所处的状态：0-待处理，1-合格，2-不合格
   * @return processStatus
  **/
  @ApiModelProperty(value = "邮包所处的状态：0-待处理，1-合格，2-不合格")
  public Integer getProcessStatus() {
    return processStatus;
  }

  public void setProcessStatus(Integer processStatus) {
    this.processStatus = processStatus;
  }

  @JsonIgnore
  public WkPostcodeDTO isUnpacking(Integer isUnpacking) {
    this.isUnpacking = isUnpacking;
    return this;
  }

   /**
   * 是否已拆包：0-否，1-是
   * @return isUnpacking
  **/
  @ApiModelProperty(value = "是否已拆包：0-否，1-是")
  public Integer getIsUnpacking() {
    return isUnpacking;
  }

  public void setIsUnpacking(Integer isUnpacking) {
    this.isUnpacking = isUnpacking;
  }

  @JsonIgnore
  public WkPostcodeDTO recipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
    return this;
  }

   /**
   * 收件人联系方式
   * @return recipientPhone
  **/
  @ApiModelProperty(value = "收件人联系方式")
  public String getRecipientPhone() {
    return recipientPhone;
  }

  public void setRecipientPhone(String recipientPhone) {
    this.recipientPhone = recipientPhone;
  }

  @JsonIgnore
  public WkPostcodeDTO recipient(String recipient) {
    this.recipient = recipient;
    return this;
  }

   /**
   * 收件人
   * @return recipient
  **/
  @ApiModelProperty(value = "收件人")
  public String getRecipient() {
    return recipient;
  }

  public void setRecipient(String recipient) {
    this.recipient = recipient;
  }

  @JsonIgnore
  public WkPostcodeDTO recipientContactway(String recipientContactway) {
    this.recipientContactway = recipientContactway;
    return this;
  }

   /**
   * 收件人联系方式
   * @return recipientContactway
  **/
  @ApiModelProperty(value = "收件人联系方式")
  public String getRecipientContactway() {
    return recipientContactway;
  }

  public void setRecipientContactway(String recipientContactway) {
    this.recipientContactway = recipientContactway;
  }

  @JsonIgnore
  public WkPostcodeDTO recipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
    return this;
  }

   /**
   * 收件公司
   * @return recipientCompany
  **/
  @ApiModelProperty(value = "收件公司")
  public String getRecipientCompany() {
    return recipientCompany;
  }

  public void setRecipientCompany(String recipientCompany) {
    this.recipientCompany = recipientCompany;
  }

  @JsonIgnore
  public WkPostcodeDTO recipientAddr(String recipientAddr) {
    this.recipientAddr = recipientAddr;
    return this;
  }

   /**
   * 收件人地址
   * @return recipientAddr
  **/
  @ApiModelProperty(value = "收件人地址")
  public String getRecipientAddr() {
    return recipientAddr;
  }

  public void setRecipientAddr(String recipientAddr) {
    this.recipientAddr = recipientAddr;
  }

  @JsonIgnore
  public WkPostcodeDTO returnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
    return this;
  }

   /**
   * 退回联次：0-无，1-发票联及抵扣联，2-发票联，3-抵扣联
   * @return returnBatch
  **/
  @ApiModelProperty(value = "退回联次：0-无，1-发票联及抵扣联，2-发票联，3-抵扣联")
  public Integer getReturnBatch() {
    return returnBatch;
  }

  public void setReturnBatch(Integer returnBatch) {
    this.returnBatch = returnBatch;
  }

  @JsonIgnore
  public WkPostcodeDTO returnType(Integer returnType) {
    this.returnType = returnType;
    return this;
  }

   /**
   * 退回类型：0-无，1-发票票面有误，2-发票审核错误，3-产值有误，4-产值 红冲，5-邮寄错误，6-其他
   * @return returnType
  **/
  @ApiModelProperty(value = "退回类型：0-无，1-发票票面有误，2-发票审核错误，3-产值有误，4-产值 红冲，5-邮寄错误，6-其他")
  public Integer getReturnType() {
    return returnType;
  }

  public void setReturnType(Integer returnType) {
    this.returnType = returnType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WkPostcodeDTO wkPostcodeDTO = (WkPostcodeDTO) o;
    return Objects.equals(this.id, wkPostcodeDTO.id) &&
        Objects.equals(this.packageCode, wkPostcodeDTO.packageCode) &&
        Objects.equals(this.expressCode, wkPostcodeDTO.expressCode) &&
        Objects.equals(this.recieveStatus, wkPostcodeDTO.recieveStatus) &&
        Objects.equals(this.remark, wkPostcodeDTO.remark) &&
        Objects.equals(this.reciever, wkPostcodeDTO.reciever) &&
        Objects.equals(this.recieveTime, wkPostcodeDTO.recieveTime) &&
        Objects.equals(this.recieveMethod, wkPostcodeDTO.recieveMethod) &&
        Objects.equals(this.billNum, wkPostcodeDTO.billNum) &&
        Objects.equals(this.errorType, wkPostcodeDTO.errorType) &&
        Objects.equals(this.errorRemark, wkPostcodeDTO.errorRemark) &&
        Objects.equals(this.errorer, wkPostcodeDTO.errorer) &&
        Objects.equals(this.errorProcessTime, wkPostcodeDTO.errorProcessTime) &&
        Objects.equals(this.processMethod, wkPostcodeDTO.processMethod) &&
        Objects.equals(this.backPostCode, wkPostcodeDTO.backPostCode) &&
        Objects.equals(this.workCodeRemark, wkPostcodeDTO.workCodeRemark) &&
        Objects.equals(this.processer, wkPostcodeDTO.processer) &&
        Objects.equals(this.processTime, wkPostcodeDTO.processTime) &&
        Objects.equals(this.sender, wkPostcodeDTO.sender) &&
        Objects.equals(this.senderContactway, wkPostcodeDTO.senderContactway) &&
        Objects.equals(this.senderCompany, wkPostcodeDTO.senderCompany) &&
        Objects.equals(this.senderAddr, wkPostcodeDTO.senderAddr) &&
        Objects.equals(this.sendTime, wkPostcodeDTO.sendTime) &&
        Objects.equals(this.isLock, wkPostcodeDTO.isLock) &&
        Objects.equals(this.isReceived, wkPostcodeDTO.isReceived) &&
        Objects.equals(this.processStatus, wkPostcodeDTO.processStatus) &&
        Objects.equals(this.isUnpacking, wkPostcodeDTO.isUnpacking) &&
        Objects.equals(this.recipientPhone, wkPostcodeDTO.recipientPhone) &&
        Objects.equals(this.recipient, wkPostcodeDTO.recipient) &&
        Objects.equals(this.recipientContactway, wkPostcodeDTO.recipientContactway) &&
        Objects.equals(this.recipientCompany, wkPostcodeDTO.recipientCompany) &&
        Objects.equals(this.recipientAddr, wkPostcodeDTO.recipientAddr) &&
        Objects.equals(this.returnBatch, wkPostcodeDTO.returnBatch) &&
        Objects.equals(this.returnType, wkPostcodeDTO.returnType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, packageCode, expressCode, recieveStatus, remark, reciever, recieveTime, recieveMethod, billNum, errorType, errorRemark, errorer, errorProcessTime, processMethod, backPostCode, workCodeRemark, processer, processTime, sender, senderContactway, senderCompany, senderAddr, sendTime, isLock, isReceived, processStatus, isUnpacking, recipientPhone, recipient, recipientContactway, recipientCompany, recipientAddr, returnBatch, returnType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WkPostcodeDTO {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    packageCode: ").append(toIndentedString(packageCode)).append("\n");
    sb.append("    expressCode: ").append(toIndentedString(expressCode)).append("\n");
    sb.append("    recieveStatus: ").append(toIndentedString(recieveStatus)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    reciever: ").append(toIndentedString(reciever)).append("\n");
    sb.append("    recieveTime: ").append(toIndentedString(recieveTime)).append("\n");
    sb.append("    recieveMethod: ").append(toIndentedString(recieveMethod)).append("\n");
    sb.append("    billNum: ").append(toIndentedString(billNum)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    errorRemark: ").append(toIndentedString(errorRemark)).append("\n");
    sb.append("    errorer: ").append(toIndentedString(errorer)).append("\n");
    sb.append("    errorProcessTime: ").append(toIndentedString(errorProcessTime)).append("\n");
    sb.append("    processMethod: ").append(toIndentedString(processMethod)).append("\n");
    sb.append("    backPostCode: ").append(toIndentedString(backPostCode)).append("\n");
    sb.append("    workCodeRemark: ").append(toIndentedString(workCodeRemark)).append("\n");
    sb.append("    processer: ").append(toIndentedString(processer)).append("\n");
    sb.append("    processTime: ").append(toIndentedString(processTime)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    senderContactway: ").append(toIndentedString(senderContactway)).append("\n");
    sb.append("    senderCompany: ").append(toIndentedString(senderCompany)).append("\n");
    sb.append("    senderAddr: ").append(toIndentedString(senderAddr)).append("\n");
    sb.append("    sendTime: ").append(toIndentedString(sendTime)).append("\n");
    sb.append("    isLock: ").append(toIndentedString(isLock)).append("\n");
    sb.append("    isReceived: ").append(toIndentedString(isReceived)).append("\n");
    sb.append("    processStatus: ").append(toIndentedString(processStatus)).append("\n");
    sb.append("    isUnpacking: ").append(toIndentedString(isUnpacking)).append("\n");
    sb.append("    recipientPhone: ").append(toIndentedString(recipientPhone)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    recipientContactway: ").append(toIndentedString(recipientContactway)).append("\n");
    sb.append("    recipientCompany: ").append(toIndentedString(recipientCompany)).append("\n");
    sb.append("    recipientAddr: ").append(toIndentedString(recipientAddr)).append("\n");
    sb.append("    returnBatch: ").append(toIndentedString(returnBatch)).append("\n");
    sb.append("    returnType: ").append(toIndentedString(returnType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
