package com.xforceplus.vanke.in.client.api;

import com.xforceplus.vanke.in.client.model.AdjustInvoiceRelationRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.DeleteInvoiceImagesRequest;
import com.xforceplus.vanke.in.client.model.DownloadInvoiceImagesRequest;
import com.xforceplus.vanke.in.client.model.GetInvoiceDetailRequest;
import com.xforceplus.vanke.in.client.model.GetInvoiceListRequest;
import com.xforceplus.vanke.in.client.model.GetRepeatRequest;
import com.xforceplus.vanke.in.client.model.InvoiceInfoRequest;
import com.xforceplus.vanke.in.client.model.InvoiceRepeatCountRequest;
import com.xforceplus.vanke.in.client.model.InvoiceSendExceptionRequest;
import com.xforceplus.vanke.in.client.model.ModifyRecogRequest;
import com.xforceplus.vanke.in.client.model.PushInvoiceRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoice", description = "the invoice API")
public interface InvoiceApi {

    @ApiOperation(value = "调整业务单发票挂接关系", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/adjustInvoiceRelation",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse adjustInvoiceRelation(@ApiParam(value = "request" ,required=true ) @RequestBody AdjustInvoiceRelationRequest request);


    @ApiOperation(value = "删除影像", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/deleteInvoiceImages",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse deleteInvoiceImages(@ApiParam(value = "request" ,required=true ) @RequestBody DeleteInvoiceImagesRequest request);


    @ApiOperation(value = "下载影像", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/downloadInvoiceImages",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse downloadInvoiceImages(@ApiParam(value = "request" ,required=true ) @RequestBody DownloadInvoiceImagesRequest request);


    @ApiOperation(value = "获取发票主表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoice/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getInvoiceDetail(@ApiParam(value = "",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody GetInvoiceDetailRequest request);


    @ApiOperation(value = "获取发票主表列表", notes = "获取发票主表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoice",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getInvoiceList(@ApiParam(value = "request" ,required=true ) @RequestBody GetInvoiceListRequest request);


    @ApiOperation(value = "获取发票状态生命周期", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/getInvoiceStatusLifeCycle",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getInvoiceStatusLifeCycle(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceInfoRequest request);


    @ApiOperation(value = "导出发票", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoice/invoiceExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse invoiceExport(@ApiParam(value = "request" ,required=true ) @RequestBody GetInvoiceListRequest request);


    @ApiOperation(value = "发票重复统计", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/invoiceRepeatCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse invoiceRepeatCount(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceRepeatCountRequest request);


    @ApiOperation(value = "转交异常/撤销转交异常", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/sendException",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse invoiceSendException(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceSendExceptionRequest request);


    @ApiOperation(value = "修改认证状态", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/modifyAuth",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse modifyAuth(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceInfoRequest request);


    @ApiOperation(value = "修改影像信息", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/modifyRecog",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse modifyRecog(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyRecogRequest request);


    @ApiOperation(value = "推送发票信息", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/pushInvoiceInformation",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse pushInvoiceInformation(@ApiParam(value = "request" ,required=true ) @RequestBody PushInvoiceRequest request);


    @ApiOperation(value = "获取重复发票", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/repeatInvoice",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse repeatInvoice(@ApiParam(value = "",required=true ) @PathVariable("invoiceId") Long invoiceId,@ApiParam(value = "request" ,required=true ) @RequestBody GetRepeatRequest request);


    @ApiOperation(value = "导出发票重复统计", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoice/repeatInvoiceExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse repeatInvoiceExport(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceRepeatCountRequest request);


    @ApiOperation(value = "删除影像同步到2.0和喜盈佳", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/syncDeleteInvoiceImage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse syncDeleteInvoiceImage(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceInfoRequest request);


    @ApiOperation(value = "上传影像到2.0和喜盈佳", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoice/syncUploadInvoiceImage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse syncUploadInvoiceImage(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceInfoRequest request);

}
