package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.InvoiceAuditRequest;
import com.xforceplus.vanke.in.client.model.ModifyRecogRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoiceAudit", description = "the invoiceAudit API")
public interface InvoiceAuditApi {

    @ApiOperation(value = "强制删除影像", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAudit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoiceAudit/coerceDeleteImage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse coerceDeleteImage(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceAuditRequest request);


    @ApiOperation(value = "发票审核信息", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAudit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoiceAudit/coerceGetInvoiceAuditList",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse coerceGetInvoiceAuditList(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceAuditRequest request);


    @ApiOperation(value = "发票审核删除发票影像", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAudit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoiceAudit/deleteImage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse deleteImage(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceAuditRequest request);


    @ApiOperation(value = "发票审核信息", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAudit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoiceAudit/getInvoiceAuditList",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getInvoiceAuditList(@ApiParam(value = "request" ,required=true ) @RequestBody InvoiceAuditRequest request);


    @ApiOperation(value = "发票审核保存发票", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceAudit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/invoiceAudit/saveInvoice",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveInvoice(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyRecogRequest request);

}
