package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetInvoiceDetailsListRequest;
import com.xforceplus.vanke.in.client.model.SaveInvoiceDetailsRequest;
import com.xforceplus.vanke.in.client.model.UpdateInvoiceDetailsRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "invoiceDetails", description = "the invoiceDetails API")
public interface InvoiceDetailsApi {

    @ApiOperation(value = "删除发票明细表信息", notes = "删除发票明细表信息" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "删除结果" ) })
    @RequestMapping(value = "/invoiceDetails/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     CommonResponse deleteInvoiceDetails(@ApiParam(value = "",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取发票明细表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/invoiceDetails/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getInvoiceDetailsDetail(@ApiParam(value = "",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取发票明细表列表", notes = "获取发票明细表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/invoiceDetails",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getInvoiceDetailsList(@ApiParam(value = "request" ,required=true ) @RequestBody GetInvoiceDetailsListRequest request);


    @ApiOperation(value = "新增发票明细表", notes = "新增发票明细表" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "新增结果" ) })
    @RequestMapping(value = "/invoiceDetails",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveInvoiceDetails(@ApiParam(value = "request" ,required=true ) @RequestBody SaveInvoiceDetailsRequest request);


    @ApiOperation(value = "更新发票明细表信息", notes = "更新发票明细表信息" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "invoiceDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "更新结果" ) })
    @RequestMapping(value = "/invoiceDetails/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse updateInvoiceDetails(@ApiParam(value = "",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody UpdateInvoiceDetailsRequest request);

}
