package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetLogInvoiceListRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "logInvoice", description = "the logInvoice API")
public interface LogInvoiceApi {

    @ApiOperation(value = "获取发票操作履历表列表", notes = "获取发票操作履历表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "logInvoice", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/logInvoice",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getLogInvoiceList(@ApiParam(value = "request" ,required=true ) @RequestBody GetLogInvoiceListRequest request);

}
