package com.xforceplus.vanke.in.client.api;

import com.xforceplus.vanke.in.client.model.AddOpsLogRequest;
import com.xforceplus.vanke.in.client.model.AuditDelayCountRequest;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetOrderStatusLifeCycleRequest;
import com.xforceplus.vanke.in.client.model.GetOrdersDetailRequest;
import com.xforceplus.vanke.in.client.model.GetOrdersListRequest;
import com.xforceplus.vanke.in.client.model.GetPostcodeOrdersListRequest;
import com.xforceplus.vanke.in.client.model.ModifyAuditStatusRequest;
import com.xforceplus.vanke.in.client.model.ModifyIfAuthFlagRequest;
import com.xforceplus.vanke.in.client.model.ModifyLegalSynergeticsRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "orders", description = "the orders API")
public interface OrdersApi {

    @ApiOperation(value = "添加运维日志", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/addOpsLog",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse addOpsLog(@ApiParam(value = "request" ,required=true ) @RequestBody AddOpsLogRequest request);


    @ApiOperation(value = "业务单据审核延期统计", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/auditDelayCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse auditDelayCount(@ApiParam(value = "request" ,required=true ) @RequestBody AuditDelayCountRequest request);


    @ApiOperation(value = "审核延期统计-导出", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/auditDelayExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse auditDelayExport(@ApiParam(value = "request" ,required=true ) @RequestBody AuditDelayCountRequest request);


    @ApiOperation(value = "删除业务单据表信息", notes = "删除业务单据表信息" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "删除结果" ) })
    @RequestMapping(value = "/orders/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     CommonResponse deleteOrders(@ApiParam(value = "",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取业务单状态生命周期 新", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/getOrderLifeCycle",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getOrderLifeCycle(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrderStatusLifeCycleRequest request);


    @ApiOperation(value = "获取业务单状态生命周期", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/getOrderStatusLifeCycle",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getOrderStatusLifeCycle(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrderStatusLifeCycleRequest request);


    @ApiOperation(value = "获取业务单据表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/orders/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getOrdersDetail(@ApiParam(value = "",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody GetOrdersDetailRequest request);


    @ApiOperation(value = "获取业务单据表列表", notes = "获取业务单据表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/orders",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getOrdersList(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrdersListRequest request);


    @ApiOperation(value = "修改业务单状态", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/modifyAuditStatus",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse modifyAuditStatus(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyAuditStatusRequest request);


    @ApiOperation(value = "修改业务单标识", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/modifyIfAuthFlag",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse modifyIfAuthFlag(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyIfAuthFlagRequest request);


    @ApiOperation(value = "手动修改业务单和发票的法人协同状态", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/modifyLegalSynergetics",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse modifyLegalSynergetics(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyLegalSynergeticsRequest request);


    @ApiOperation(value = "导出业务单状态生命周期 新", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/OrderLifeCycleExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse orderLifeCycleExport(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrderStatusLifeCycleRequest request);


    @ApiOperation(value = "导出业务单状态生命周期", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/OrderStatusLifeCycleExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse orderStatusLifeCycleExport(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrderStatusLifeCycleRequest request);


    @ApiOperation(value = "邮包签收--业务单->导出", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/ordersExcelExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse ordersExcelExport(@ApiParam(value = "request" ,required=true ) @RequestBody GetPostcodeOrdersListRequest request);


    @ApiOperation(value = "业务单-导出", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/export",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse ordersExport(@ApiParam(value = "request" ,required=true ) @RequestBody GetOrdersListRequest request);


    @ApiOperation(value = "手动推送协同影像", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "orders", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果" ) })
    @RequestMapping(value = "/orders/pushSyncImagesForGX",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse pushSyncImagesForGX(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyLegalSynergeticsRequest request);

}
