package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetLogisticsInfoRequest;
import com.xforceplus.vanke.in.client.model.GetParcelListRequest;
import com.xforceplus.vanke.in.client.model.ModifyWaybillNoRequest;
import com.xforceplus.vanke.in.client.model.SubmitParcelsRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "parcel", description = "the parcel API")
public interface ParcelApi {

    @ApiOperation(value = "取消快递", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回对象" ) })
    @RequestMapping(value = "/parcel/cancelExpress",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse cancelExpress(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyWaybillNoRequest request);


    @ApiOperation(value = "", notes = "获取物流轨迹" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/parcel/getLogisticsInfo",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getLogisticsInfo(@ApiParam(value = "request" ,required=true ) @RequestBody GetLogisticsInfoRequest request);


    @ApiOperation(value = "寄送中，异常，签收列表", notes = "获取退票包裹表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/parcel",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getParcelList(@ApiParam(value = "request" ,required=true ) @RequestBody GetParcelListRequest request);


    @ApiOperation(value = "修改运单号", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回对象" ) })
    @RequestMapping(value = "/parcel/modifyWaybillNo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse modifyWaybillNo(@ApiParam(value = "request" ,required=true ) @RequestBody ModifyWaybillNoRequest request);


    @ApiOperation(value = "提交包裹", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回对象" ) })
    @RequestMapping(value = "/parcel/submitParcels",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse submitParcels(@ApiParam(value = "request" ,required=true ) @RequestBody SubmitParcelsRequest request);

}
