package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetParcelDetailsListRequest;
import com.xforceplus.vanke.in.client.model.ParcelDetailsRequest;
import com.xforceplus.vanke.in.client.model.ParcelDetailsSendRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "parcelDetails", description = "the parcelDetails API")
public interface ParcelDetailsApi {

    @ApiOperation(value = "分开寄送", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcelDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回对象" ) })
    @RequestMapping(value = "/parcelDetails/divideSendGoods",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse divideSendGoods(@ApiParam(value = "request" ,required=true ) @RequestBody ParcelDetailsSendRequest request);


    @ApiOperation(value = "导出退票报表列表", notes = "导出退票报表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcelDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/parcelDetails/backInvoiceExport",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse exportBackInvoice(@ApiParam(value = "request" ,required=true ) @RequestBody GetParcelDetailsListRequest request);


    @ApiOperation(value = "获取包裹下寄送的包裹明细表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcelDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/parcelDetails/getDetailByParcelId",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getDetailByParcelId(@ApiParam(value = "request" ,required=true ) @RequestBody ParcelDetailsRequest request);


    @ApiOperation(value = "待寄送列表", notes = "待寄送列表" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcelDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/parcelDetails",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getParcelDetailsList(@ApiParam(value = "request" ,required=true ) @RequestBody GetParcelDetailsListRequest request);


    @ApiOperation(value = "合并寄送", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcelDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回对象" ) })
    @RequestMapping(value = "/parcelDetails/mergeSendGoods",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse mergeSendGoods(@ApiParam(value = "request" ,required=true ) @RequestBody ParcelDetailsSendRequest request);


    @ApiOperation(value = "无需寄送", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcelDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回对象" ) })
    @RequestMapping(value = "/parcelDetails/noNeedSend",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse noNeedSend(@ApiParam(value = "request" ,required=true ) @RequestBody ParcelDetailsSendRequest request);


    @ApiOperation(value = "点击寄送", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "parcelDetails", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回对象" ) })
    @RequestMapping(value = "/parcelDetails/sendGoods",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse sendGoods(@ApiParam(value = "request" ,required=true ) @RequestBody ParcelDetailsSendRequest request);

}
