package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.request.BatchRequest;
import com.xforceplus.vanke.in.client.model.BatchUpdateSmFileRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.in.client.model.GetSmFileListRequest;
import com.xforceplus.vanke.in.client.model.MovieSmFileRequest;
import com.xforceplus.vanke.in.client.model.SaveSmFileRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "smFile", description = "the smFile API")
public interface SmFileApi {

    @ApiOperation(value = "批量退扫影像文件", notes = "批量退扫影像文件" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "更新结果" ) })
    @RequestMapping(value = "/smFile/history/back",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse batchBackSmFileHistory(@ApiParam(value = "request" ,required=true ) @RequestBody BatchRequest request);


    @ApiOperation(value = "批量更新影像文件", notes = "批量更新影像文件" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "更新结果" ) })
    @RequestMapping(value = "/smFile",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     CommonResponse batchUpdateSmFile(@ApiParam(value = "request" ,required=true ) @RequestBody BatchUpdateSmFileRequest request);


    @ApiOperation(value = "删除影像文件表信息", notes = "删除影像文件表信息" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "删除结果" ) })
    @RequestMapping(value = "/smFile",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     CommonResponse deleteSmFile(@ApiParam(value = "request" ,required=true ) @RequestBody BatchRequest request);


    @ApiOperation(value = "获取影像文件表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/smFile/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getSmFileDetail(@ApiParam(value = "主键",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取影像文件表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/smFile/duplicate/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getSmFileDuplicateList(@ApiParam(value = "主键",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取历史影像文件列表", notes = "获取历史影像文件数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/smFile/history",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getSmFileHistory(@ApiParam(value = "request" ,required=true ) @RequestBody GetSmFileListRequest request);


    @ApiOperation(value = "获取历史影像文件表详情", notes = "" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response" ) })
    @RequestMapping(value = "/smFile/history/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getSmFileHistoryDetail(@ApiParam(value = "主键",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取影像文件表列表", notes = "获取影像文件表数据" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/smFile",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getSmFileList(@ApiParam(value = "request" ,required=true ) @RequestBody GetSmFileListRequest request);


    @ApiOperation(value = "移动影像文件", notes = "移动影像文件" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "新增结果" ) })
    @RequestMapping(value = "/smFile/movie",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse movieSmFileInvoice(@ApiParam(value = "request" ,required=true ) @RequestBody MovieSmFileRequest request);


    @ApiOperation(value = "新增影像文件表", notes = "新增影像文件表" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "新增结果" ) })
    @RequestMapping(value = "/smFile",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse saveSmFile(@ApiParam(value = "request" ,required=true ) @RequestBody SaveSmFileRequest request);


    @ApiOperation(value = "提交影像文件", notes = "提交影像文件" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "smFile", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "新增结果" ) })
    @RequestMapping(value = "/smFile/submit",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     CommonResponse submitSmFileInvoice(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);

}
