package com.xforceplus.vanke.in.client.api;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "workbench", description = "the workbench API")
public interface WorkbenchApi {

    @ApiOperation(value = "待处理异常", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getAbnormalCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getAbnormalCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取统计", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "抵扣快到期", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getElectronicAccountCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getElectronicAccountCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "未开通抵扣通道", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getNoAuthCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getNoAuthCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "底账待勾选", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getPengdingAccountCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getPengdingAccountCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "扫描待勾选", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getPengdingWebCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getPengdingWebCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取待办事项", notes = "获取待办事项" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getPengdingWorks",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getPengdingWorks(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "获取邮包统计", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getPostCodeCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getPostCodeCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);


    @ApiOperation(value = "待扫描发票", notes = "获取统计" , authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "workbench", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "数据列表" ) })
    @RequestMapping(value = "/workbench/getScanCount",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     CommonResponse getScanCount(@ApiParam(value = "request" ,required=true ) @RequestBody BaseRequest request);

}
