package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单据表Request
 */
@ApiModel(description = "业务单据表Request")

@JsonInclude(NON_NULL)
public class AddOpsLogRequest extends BaseRequest {
  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("opsType")
  private Integer opsType = null;

  @JsonIgnore
  public AddOpsLogRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据编号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据编号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public AddOpsLogRequest opsType(Integer opsType) {
    this.opsType = opsType;
    return this;
  }

   /**
   * 1.业务单审核运维2-推送审核结果 3.推送勾选结果 4.推送任务平台 5.推送档案系统 6.修改业务单审核状态
   * @return opsType
  **/
  @ApiModelProperty(value = "1.业务单审核运维2-推送审核结果 3.推送勾选结果 4.推送任务平台 5.推送档案系统 6.修改业务单审核状态")
  public Integer getOpsType() {
    return opsType;
  }

  public void setOpsType(Integer opsType) {
    this.opsType = opsType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddOpsLogRequest addOpsLogRequest = (AddOpsLogRequest) o;
    return Objects.equals(this.salesbillNo, addOpsLogRequest.salesbillNo) &&
        Objects.equals(this.opsType, addOpsLogRequest.opsType) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillNo, opsType, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddOpsLogRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    opsType: ").append(toIndentedString(opsType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
