package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 调整业务单发票挂接关系
 */
@ApiModel(description = "调整业务单发票挂接关系")

@JsonInclude(NON_NULL)
public class AdjustInvoiceRelationRequest extends BaseRequest {
  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("newSalesbillNo")
  private String newSalesbillNo = null;

  @JsonIgnore
  public AdjustInvoiceRelationRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public AdjustInvoiceRelationRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public AdjustInvoiceRelationRequest newSalesbillNo(String newSalesbillNo) {
    this.newSalesbillNo = newSalesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return newSalesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getNewSalesbillNo() {
    return newSalesbillNo;
  }

  public void setNewSalesbillNo(String newSalesbillNo) {
    this.newSalesbillNo = newSalesbillNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdjustInvoiceRelationRequest adjustInvoiceRelationRequest = (AdjustInvoiceRelationRequest) o;
    return Objects.equals(this.invoiceIds, adjustInvoiceRelationRequest.invoiceIds) &&
        Objects.equals(this.newSalesbillNo, adjustInvoiceRelationRequest.newSalesbillNo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, newSalesbillNo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdjustInvoiceRelationRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    newSalesbillNo: ").append(toIndentedString(newSalesbillNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
