package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务单据审核延期统计request
 */
@ApiModel(description = "业务单据审核延期统计request")

@JsonInclude(NON_NULL)
public class AuditDelayCountRequest extends PageRequest {
  @JsonProperty("syncTime")
  private List<Long> syncTime = new ArrayList<Long>();

  @JsonProperty("smSyncTime")
  private List<Long> smSyncTime = new ArrayList<Long>();

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("systemOrig")
  private List<String> systemOrig = new ArrayList<String>();

  @JsonProperty("status")
  private List<String> status = new ArrayList<String>();

  @JsonProperty("cooperateFlag")
  private Integer cooperateFlag = null;

  @JsonIgnore
  public AuditDelayCountRequest syncTime(List<Long> syncTime) {
    this.syncTime = syncTime;
    return this;
  }

  public AuditDelayCountRequest addSyncTimeItem(Long syncTimeItem) {
    this.syncTime.add(syncTimeItem);
    return this;
  }

   /**
   * 同步时间
   * @return syncTime
  **/
  @ApiModelProperty(value = "同步时间")
  public List<Long> getSyncTime() {
    return syncTime;
  }

  public void setSyncTime(List<Long> syncTime) {
    this.syncTime = syncTime;
  }

  @JsonIgnore
  public AuditDelayCountRequest smSyncTime(List<Long> smSyncTime) {
    this.smSyncTime = smSyncTime;
    return this;
  }

  public AuditDelayCountRequest addSmSyncTimeItem(Long smSyncTimeItem) {
    this.smSyncTime.add(smSyncTimeItem);
    return this;
  }

   /**
   * 影像上传时间
   * @return smSyncTime
  **/
  @ApiModelProperty(value = "影像上传时间")
  public List<Long> getSmSyncTime() {
    return smSyncTime;
  }

  public void setSmSyncTime(List<Long> smSyncTime) {
    this.smSyncTime = smSyncTime;
  }

  @JsonIgnore
  public AuditDelayCountRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方公司
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方公司")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public AuditDelayCountRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public AuditDelayCountRequest systemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

  public AuditDelayCountRequest addSystemOrigItem(String systemOrigItem) {
    this.systemOrig.add(systemOrigItem);
    return this;
  }

   /**
   * 系统来源
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源")
  public List<String> getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(List<String> systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public AuditDelayCountRequest status(List<String> status) {
    this.status = status;
    return this;
  }

  public AuditDelayCountRequest addStatusItem(String statusItem) {
    this.status.add(statusItem);
    return this;
  }

   /**
   * 单据状态
   * @return status
  **/
  @ApiModelProperty(value = "单据状态")
  public List<String> getStatus() {
    return status;
  }

  public void setStatus(List<String> status) {
    this.status = status;
  }

  @JsonIgnore
  public AuditDelayCountRequest cooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

   /**
   * 购销协同标识： 1-协同； 0-非协同
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "购销协同标识： 1-协同； 0-非协同")
  public Integer getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(Integer cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuditDelayCountRequest auditDelayCountRequest = (AuditDelayCountRequest) o;
    return Objects.equals(this.syncTime, auditDelayCountRequest.syncTime) &&
        Objects.equals(this.smSyncTime, auditDelayCountRequest.smSyncTime) &&
        Objects.equals(this.purchaserName, auditDelayCountRequest.purchaserName) &&
        Objects.equals(this.salesbillNo, auditDelayCountRequest.salesbillNo) &&
        Objects.equals(this.systemOrig, auditDelayCountRequest.systemOrig) &&
        Objects.equals(this.status, auditDelayCountRequest.status) &&
        Objects.equals(this.cooperateFlag, auditDelayCountRequest.cooperateFlag) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(syncTime, smSyncTime, purchaserName, salesbillNo, systemOrig, status, cooperateFlag, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuditDelayCountRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    syncTime: ").append(toIndentedString(syncTime)).append("\n");
    sb.append("    smSyncTime: ").append(toIndentedString(smSyncTime)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
