package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class AuthSummaryRequest extends BaseRequest {
  @JsonProperty("summaryType")
  private Integer summaryType = 0;

  @JsonProperty("yearTime")
  private String yearTime = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("orderNo")
  private Integer orderNo = 0;

  @JsonIgnore
  public AuthSummaryRequest summaryType(Integer summaryType) {
    this.summaryType = summaryType;
    return this;
  }

   /**
   * 统计类型：0-集团，1-公司
   * @return summaryType
  **/
  @ApiModelProperty(value = "统计类型：0-集团，1-公司")
  public Integer getSummaryType() {
    return summaryType;
  }

  public void setSummaryType(Integer summaryType) {
    this.summaryType = summaryType;
  }

  @JsonIgnore
  public AuthSummaryRequest yearTime(String yearTime) {
    this.yearTime = yearTime;
    return this;
  }

   /**
   * 年度
   * @return yearTime
  **/
  @ApiModelProperty(value = "年度")
  public String getYearTime() {
    return yearTime;
  }

  public void setYearTime(String yearTime) {
    this.yearTime = yearTime;
  }

  @JsonIgnore
  public AuthSummaryRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public AuthSummaryRequest taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public AuthSummaryRequest orderNo(Integer orderNo) {
    this.orderNo = orderNo;
    return this;
  }

   /**
   * 排序默认0：0-公司名称升序，1-公司名降序，2-总税额升序，3-总税额降序
   * @return orderNo
  **/
  @ApiModelProperty(value = "排序默认0：0-公司名称升序，1-公司名降序，2-总税额升序，3-总税额降序")
  public Integer getOrderNo() {
    return orderNo;
  }

  public void setOrderNo(Integer orderNo) {
    this.orderNo = orderNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthSummaryRequest authSummaryRequest = (AuthSummaryRequest) o;
    return Objects.equals(this.summaryType, authSummaryRequest.summaryType) &&
        Objects.equals(this.yearTime, authSummaryRequest.yearTime) &&
        Objects.equals(this.companyTaxNo, authSummaryRequest.companyTaxNo) &&
        Objects.equals(this.taxPeriod, authSummaryRequest.taxPeriod) &&
        Objects.equals(this.orderNo, authSummaryRequest.orderNo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(summaryType, yearTime, companyTaxNo, taxPeriod, orderNo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthSummaryRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    summaryType: ").append(toIndentedString(summaryType)).append("\n");
    sb.append("    yearTime: ").append(toIndentedString(yearTime)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    orderNo: ").append(toIndentedString(orderNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
