package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 删除发票影像Request
 */
@ApiModel(description = "删除发票影像Request")

@JsonInclude(NON_NULL)
public class DeleteInvoiceImagesRequest extends BaseRequest {
  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("deleteType")
  private Integer deleteType = null;

  @JsonProperty("isContinue")
  private Integer isContinue = null;

  @JsonProperty("deleteMessage")
  private String deleteMessage = null;

  @JsonIgnore
  public DeleteInvoiceImagesRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public DeleteInvoiceImagesRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public DeleteInvoiceImagesRequest deleteType(Integer deleteType) {
    this.deleteType = deleteType;
    return this;
  }

   /**
   * 删除类型1、发票类型开错2、无纸化附件里含有敏感内容，需作废3、公司名称开错4、产值被驳回5、产值单缺少附件6、产值单含敏感信息需作废7、与预制发票不一致8、其他
   * @return deleteType
  **/
  @ApiModelProperty(value = "删除类型1、发票类型开错2、无纸化附件里含有敏感内容，需作废3、公司名称开错4、产值被驳回5、产值单缺少附件6、产值单含敏感信息需作废7、与预制发票不一致8、其他")
  public Integer getDeleteType() {
    return deleteType;
  }

  public void setDeleteType(Integer deleteType) {
    this.deleteType = deleteType;
  }

  @JsonIgnore
  public DeleteInvoiceImagesRequest isContinue(Integer isContinue) {
    this.isContinue = isContinue;
    return this;
  }

   /**
   * 是否继续 0-是 1-否
   * @return isContinue
  **/
  @ApiModelProperty(value = "是否继续 0-是 1-否")
  public Integer getIsContinue() {
    return isContinue;
  }

  public void setIsContinue(Integer isContinue) {
    this.isContinue = isContinue;
  }

  @JsonIgnore
  public DeleteInvoiceImagesRequest deleteMessage(String deleteMessage) {
    this.deleteMessage = deleteMessage;
    return this;
  }

   /**
   * 其他-异常原因
   * @return deleteMessage
  **/
  @ApiModelProperty(value = "其他-异常原因")
  public String getDeleteMessage() {
    return deleteMessage;
  }

  public void setDeleteMessage(String deleteMessage) {
    this.deleteMessage = deleteMessage;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeleteInvoiceImagesRequest deleteInvoiceImagesRequest = (DeleteInvoiceImagesRequest) o;
    return Objects.equals(this.invoiceIds, deleteInvoiceImagesRequest.invoiceIds) &&
        Objects.equals(this.deleteType, deleteInvoiceImagesRequest.deleteType) &&
        Objects.equals(this.isContinue, deleteInvoiceImagesRequest.isContinue) &&
        Objects.equals(this.deleteMessage, deleteInvoiceImagesRequest.deleteMessage) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, deleteType, isContinue, deleteMessage, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeleteInvoiceImagesRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    deleteType: ").append(toIndentedString(deleteType)).append("\n");
    sb.append("    isContinue: ").append(toIndentedString(isContinue)).append("\n");
    sb.append("    deleteMessage: ").append(toIndentedString(deleteMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
