package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * DoJobRequest
 */
@ApiModel(description = "DoJobRequest")

@JsonInclude(NON_NULL)
public class DoJobRequest extends BaseRequest {
  @JsonProperty("job")
  private String job = null;

  @JsonProperty("noOrIds")
  private List<String> noOrIds = new ArrayList<String>();

  @JsonIgnore
  public DoJobRequest job(String job) {
    this.job = job;
    return this;
  }

   /**
   * null
   * @return job
  **/
  @ApiModelProperty(value = "null")
  public String getJob() {
    return job;
  }

  public void setJob(String job) {
    this.job = job;
  }

  @JsonIgnore
  public DoJobRequest noOrIds(List<String> noOrIds) {
    this.noOrIds = noOrIds;
    return this;
  }

  public DoJobRequest addNoOrIdsItem(String noOrIdsItem) {
    this.noOrIds.add(noOrIdsItem);
    return this;
  }

   /**
   * 业务单no或发票id
   * @return noOrIds
  **/
  @ApiModelProperty(value = "业务单no或发票id")
  public List<String> getNoOrIds() {
    return noOrIds;
  }

  public void setNoOrIds(List<String> noOrIds) {
    this.noOrIds = noOrIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DoJobRequest doJobRequest = (DoJobRequest) o;
    return Objects.equals(this.job, doJobRequest.job) &&
        Objects.equals(this.noOrIds, doJobRequest.noOrIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(job, noOrIds, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DoJobRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    job: ").append(toIndentedString(job)).append("\n");
    sb.append("    noOrIds: ").append(toIndentedString(noOrIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
