package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 下载影像
 */
@ApiModel(description = "下载影像")

@JsonInclude(NON_NULL)
public class DownloadInvoiceImagesRequest extends BaseRequest {
  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("downloadType")
  private Integer downloadType = null;

  @JsonIgnore
  public DownloadInvoiceImagesRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public DownloadInvoiceImagesRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public DownloadInvoiceImagesRequest downloadType(Integer downloadType) {
    this.downloadType = downloadType;
    return this;
  }

   /**
   * 下载页面：1-发票池，2-发票认证
   * @return downloadType
  **/
  @ApiModelProperty(value = "下载页面：1-发票池，2-发票认证")
  public Integer getDownloadType() {
    return downloadType;
  }

  public void setDownloadType(Integer downloadType) {
    this.downloadType = downloadType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DownloadInvoiceImagesRequest downloadInvoiceImagesRequest = (DownloadInvoiceImagesRequest) o;
    return Objects.equals(this.invoiceIds, downloadInvoiceImagesRequest.invoiceIds) &&
        Objects.equals(this.downloadType, downloadInvoiceImagesRequest.downloadType) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, downloadType, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DownloadInvoiceImagesRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    downloadType: ").append(toIndentedString(downloadType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
