package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取国信影像地址
 */
@ApiModel(description = "获取国信影像地址")

@JsonInclude(NON_NULL)
public class GetImageUrlForGxRequest extends BaseRequest {
  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonIgnore
  public GetImageUrlForGxRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetImageUrlForGxRequest getImageUrlForGxRequest = (GetImageUrlForGxRequest) o;
    return Objects.equals(this.salesbillNo, getImageUrlForGxRequest.salesbillNo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillNo, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetImageUrlForGxRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
