package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票详情表Request
 */
@ApiModel(description = "发票详情表Request")

@JsonInclude(NON_NULL)
public class GetInvoiceDetailRequest extends BaseRequest {
  @JsonProperty("showDetail")
  private Integer showDetail = null;

  @JsonIgnore
  public GetInvoiceDetailRequest showDetail(Integer showDetail) {
    this.showDetail = showDetail;
    return this;
  }

   /**
   * 是否展示明细：0-否，1-是
   * @return showDetail
  **/
  @ApiModelProperty(value = "是否展示明细：0-否，1-是")
  public Integer getShowDetail() {
    return showDetail;
  }

  public void setShowDetail(Integer showDetail) {
    this.showDetail = showDetail;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetInvoiceDetailRequest getInvoiceDetailRequest = (GetInvoiceDetailRequest) o;
    return Objects.equals(this.showDetail, getInvoiceDetailRequest.showDetail) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(showDetail, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetInvoiceDetailRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    showDetail: ").append(toIndentedString(showDetail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
