package com.xforceplus.vanke.in.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xforceplus.landedestate.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票主表Request
 */
@ApiModel(description = "发票主表Request")

@JsonInclude(NON_NULL)
public class GetInvoiceListRequest extends PageRequest {
  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("recogUserName")
  private String recogUserName = null;

  @JsonProperty("authTaxPeriod")
  private Long authTaxPeriod = null;

  @JsonProperty("paperDrewDate")
  private List<Long> paperDrewDate = new ArrayList<Long>();

  @JsonProperty("amountWithoutTax")
  private List<BigDecimal> amountWithoutTax = new ArrayList<BigDecimal>();

  @JsonProperty("taxAmount")
  private List<BigDecimal> taxAmount = new ArrayList<BigDecimal>();

  @JsonProperty("amountWithTax")
  private List<BigDecimal> amountWithTax = new ArrayList<BigDecimal>();

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("status")
  private List<Integer> status = new ArrayList<Integer>();

  @JsonProperty("auditStatus")
  private List<Integer> auditStatus = new ArrayList<Integer>();

  @JsonProperty("authSyncStatus")
  private List<Integer> authSyncStatus = new ArrayList<Integer>();

  @JsonProperty("recogImageStatus")
  private List<Integer> recogImageStatus = new ArrayList<Integer>();

  @JsonProperty("authStatus")
  private List<Integer> authStatus = new ArrayList<Integer>();

  @JsonProperty("ifAuthFlag")
  private List<Integer> ifAuthFlag = new ArrayList<Integer>();

  @JsonProperty("isLegalSynergetics")
  private List<Integer> isLegalSynergetics = new ArrayList<Integer>();

  @JsonProperty("veriStatus")
  private List<String> veriStatus = new ArrayList<String>();

  @JsonProperty("auditUpdateTime")
  private List<Long> auditUpdateTime = new ArrayList<Long>();

  @JsonProperty("authSyncTime")
  private List<Long> authSyncTime = new ArrayList<Long>();

  @JsonProperty("recogResponseTime")
  private List<Long> recogResponseTime = new ArrayList<Long>();

  @JsonProperty("authRequestTime")
  private List<Long> authRequestTime = new ArrayList<Long>();

  @JsonProperty("authBussiDate")
  private List<String> authBussiDate = new ArrayList<String>();

  @JsonProperty("authResponseTime")
  private List<Long> authResponseTime = new ArrayList<Long>();

  @JsonProperty("authStyle")
  private List<Integer> authStyle = new ArrayList<Integer>();

  @JsonProperty("warnType")
  private List<Integer> warnType = new ArrayList<Integer>();

  @JsonProperty("retreatStatus")
  private List<Integer> retreatStatus = new ArrayList<Integer>();

  @JsonProperty("signStatus")
  private List<Integer> signStatus = new ArrayList<Integer>();

  @JsonProperty("recogStatus")
  private List<Integer> recogStatus = new ArrayList<Integer>();

  @JsonProperty("downloadType")
  private Integer downloadType = 0;

  @JsonProperty("signTime")
  private List<Long> signTime = new ArrayList<Long>();

  @JsonProperty("authPurposes")
  private List<Integer> authPurposes = new ArrayList<Integer>();

  @JsonProperty("ifSendException")
  private List<Integer> ifSendException = new ArrayList<Integer>();

  @JsonProperty("sellerSyncStatus")
  private List<Integer> sellerSyncStatus = new ArrayList<Integer>();

  @JsonProperty("dataFromSystem")
  private List<String> dataFromSystem = new ArrayList<String>();

  @JsonProperty("authCheckResponseTime")
  private List<Long> authCheckResponseTime = new ArrayList<Long>();

  @JsonProperty("cooperateFlag")
  private List<Integer> cooperateFlag = new ArrayList<Integer>();

  @JsonProperty("authExceType")
  private List<Integer> authExceType = new ArrayList<Integer>();

  @JsonProperty("ifRepeat")
  private Integer ifRepeat = null;

  @JsonIgnore
  public GetInvoiceListRequest sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public GetInvoiceListRequest purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public GetInvoiceListRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public GetInvoiceListRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public GetInvoiceListRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public GetInvoiceListRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public GetInvoiceListRequest salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 业务单号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public GetInvoiceListRequest recogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
    return this;
  }

   /**
   * 识别操作人姓名
   * @return recogUserName
  **/
  @ApiModelProperty(value = "识别操作人姓名")
  public String getRecogUserName() {
    return recogUserName;
  }

  public void setRecogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
  }

  @JsonIgnore
  public GetInvoiceListRequest authTaxPeriod(Long authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
    return this;
  }

   /**
   * 认证所属期
   * @return authTaxPeriod
  **/
  @ApiModelProperty(value = "认证所属期")
  public Long getAuthTaxPeriod() {
    return authTaxPeriod;
  }

  public void setAuthTaxPeriod(Long authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
  }

  @JsonIgnore
  public GetInvoiceListRequest paperDrewDate(List<Long> paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

  public GetInvoiceListRequest addPaperDrewDateItem(Long paperDrewDateItem) {
    this.paperDrewDate.add(paperDrewDateItem);
    return this;
  }

   /**
   * 发票开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期")
  public List<Long> getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(List<Long> paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public GetInvoiceListRequest amountWithoutTax(List<BigDecimal> amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

  public GetInvoiceListRequest addAmountWithoutTaxItem(BigDecimal amountWithoutTaxItem) {
    this.amountWithoutTax.add(amountWithoutTaxItem);
    return this;
  }

   /**
   * 金额范围
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "金额范围")
  public List<BigDecimal> getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(List<BigDecimal> amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public GetInvoiceListRequest taxAmount(List<BigDecimal> taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

  public GetInvoiceListRequest addTaxAmountItem(BigDecimal taxAmountItem) {
    this.taxAmount.add(taxAmountItem);
    return this;
  }

   /**
   * 税额范围
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额范围")
  public List<BigDecimal> getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(List<BigDecimal> taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public GetInvoiceListRequest amountWithTax(List<BigDecimal> amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

  public GetInvoiceListRequest addAmountWithTaxItem(BigDecimal amountWithTaxItem) {
    this.amountWithTax.add(amountWithTaxItem);
    return this;
  }

   /**
   * 价税合计范围
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "价税合计范围")
  public List<BigDecimal> getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(List<BigDecimal> amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public GetInvoiceListRequest invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public GetInvoiceListRequest addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型：s-增值税专用发票 c-增值税普通发票ce-增值税电子普通发票ju-增值税普通发票（卷票）ct-通行费增值税电子普通发票v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型：s-增值税专用发票 c-增值税普通发票ce-增值税电子普通发票ju-增值税普通发票（卷票）ct-通行费增值税电子普通发票v-机动车统一销售发票")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public GetInvoiceListRequest status(List<Integer> status) {
    this.status = status;
    return this;
  }

  public GetInvoiceListRequest addStatusItem(Integer statusItem) {
    this.status.add(statusItem);
    return this;
  }

   /**
   * 发票状态 (0-默认；1-正常；2-作废；3-被红冲；7-异常；8-失控；9-删除)
   * @return status
  **/
  @ApiModelProperty(value = "发票状态 (0-默认；1-正常；2-作废；3-被红冲；7-异常；8-失控；9-删除)")
  public List<Integer> getStatus() {
    return status;
  }

  public void setStatus(List<Integer> status) {
    this.status = status;
  }

  @JsonIgnore
  public GetInvoiceListRequest auditStatus(List<Integer> auditStatus) {
    this.auditStatus = auditStatus;
    return this;
  }

  public GetInvoiceListRequest addAuditStatusItem(Integer auditStatusItem) {
    this.auditStatus.add(auditStatusItem);
    return this;
  }

   /**
   * 审核状态：0-未审核  1-审核成功 2-审核不通过
   * @return auditStatus
  **/
  @ApiModelProperty(value = "审核状态：0-未审核  1-审核成功 2-审核不通过")
  public List<Integer> getAuditStatus() {
    return auditStatus;
  }

  public void setAuditStatus(List<Integer> auditStatus) {
    this.auditStatus = auditStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest authSyncStatus(List<Integer> authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
    return this;
  }

  public GetInvoiceListRequest addAuthSyncStatusItem(Integer authSyncStatusItem) {
    this.authSyncStatus.add(authSyncStatusItem);
    return this;
  }

   /**
   * 电子底账状态：0-未获取(默认)；1-已获取
   * @return authSyncStatus
  **/
  @ApiModelProperty(value = "电子底账状态：0-未获取(默认)；1-已获取")
  public List<Integer> getAuthSyncStatus() {
    return authSyncStatus;
  }

  public void setAuthSyncStatus(List<Integer> authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest recogImageStatus(List<Integer> recogImageStatus) {
    this.recogImageStatus = recogImageStatus;
    return this;
  }

  public GetInvoiceListRequest addRecogImageStatusItem(Integer recogImageStatusItem) {
    this.recogImageStatus.add(recogImageStatusItem);
    return this;
  }

   /**
   * 识别影像状态：0-无影像(默认)；1-仅有抵扣联；2-仅有发票联；3-两联均有
   * @return recogImageStatus
  **/
  @ApiModelProperty(value = "识别影像状态：0-无影像(默认)；1-仅有抵扣联；2-仅有发票联；3-两联均有")
  public List<Integer> getRecogImageStatus() {
    return recogImageStatus;
  }

  public void setRecogImageStatus(List<Integer> recogImageStatus) {
    this.recogImageStatus = recogImageStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest authStatus(List<Integer> authStatus) {
    this.authStatus = authStatus;
    return this;
  }

  public GetInvoiceListRequest addAuthStatusItem(Integer authStatusItem) {
    this.authStatus.add(authStatusItem);
    return this;
  }

   /**
   * 抵扣状态：0-默认；1-不可勾选；2-未勾选；3-勾选中；4-已确认抵扣；5-勾选失败；6-抵扣异常；7-已勾选；8-撤销勾选中；9-勾选异常
   * @return authStatus
  **/
  @ApiModelProperty(value = "抵扣状态：0-默认；1-不可勾选；2-未勾选；3-勾选中；4-已确认抵扣；5-勾选失败；6-抵扣异常；7-已勾选；8-撤销勾选中；9-勾选异常")
  public List<Integer> getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(List<Integer> authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest ifAuthFlag(List<Integer> ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
    return this;
  }

  public GetInvoiceListRequest addIfAuthFlagItem(Integer ifAuthFlagItem) {
    this.ifAuthFlag.add(ifAuthFlagItem);
    return this;
  }

   /**
   * 是否需要抵扣状态 1：是  0：否
   * @return ifAuthFlag
  **/
  @ApiModelProperty(value = "是否需要抵扣状态 1：是  0：否")
  public List<Integer> getIfAuthFlag() {
    return ifAuthFlag;
  }

  public void setIfAuthFlag(List<Integer> ifAuthFlag) {
    this.ifAuthFlag = ifAuthFlag;
  }

  @JsonIgnore
  public GetInvoiceListRequest isLegalSynergetics(List<Integer> isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
    return this;
  }

  public GetInvoiceListRequest addIsLegalSynergeticsItem(Integer isLegalSynergeticsItem) {
    this.isLegalSynergetics.add(isLegalSynergeticsItem);
    return this;
  }

   /**
   * 是否法人协同 1.是 0.否
   * @return isLegalSynergetics
  **/
  @ApiModelProperty(value = "是否法人协同 1.是 0.否")
  public List<Integer> getIsLegalSynergetics() {
    return isLegalSynergetics;
  }

  public void setIsLegalSynergetics(List<Integer> isLegalSynergetics) {
    this.isLegalSynergetics = isLegalSynergetics;
  }

  @JsonIgnore
  public GetInvoiceListRequest veriStatus(List<String> veriStatus) {
    this.veriStatus = veriStatus;
    return this;
  }

  public GetInvoiceListRequest addVeriStatusItem(String veriStatusItem) {
    this.veriStatus.add(veriStatusItem);
    return this;
  }

   /**
   * 查验状态：0-未查验(默认)；1-待查验；2-查验中；3-查验成功；4-查验失败
   * @return veriStatus
  **/
  @ApiModelProperty(value = "查验状态：0-未查验(默认)；1-待查验；2-查验中；3-查验成功；4-查验失败")
  public List<String> getVeriStatus() {
    return veriStatus;
  }

  public void setVeriStatus(List<String> veriStatus) {
    this.veriStatus = veriStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest auditUpdateTime(List<Long> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
    return this;
  }

  public GetInvoiceListRequest addAuditUpdateTimeItem(Long auditUpdateTimeItem) {
    this.auditUpdateTime.add(auditUpdateTimeItem);
    return this;
  }

   /**
   * 发票审核时间(秒)
   * @return auditUpdateTime
  **/
  @ApiModelProperty(value = "发票审核时间(秒)")
  public List<Long> getAuditUpdateTime() {
    return auditUpdateTime;
  }

  public void setAuditUpdateTime(List<Long> auditUpdateTime) {
    this.auditUpdateTime = auditUpdateTime;
  }

  @JsonIgnore
  public GetInvoiceListRequest authSyncTime(List<Long> authSyncTime) {
    this.authSyncTime = authSyncTime;
    return this;
  }

  public GetInvoiceListRequest addAuthSyncTimeItem(Long authSyncTimeItem) {
    this.authSyncTime.add(authSyncTimeItem);
    return this;
  }

   /**
   * 电子底帐获取时间(秒)
   * @return authSyncTime
  **/
  @ApiModelProperty(value = "电子底帐获取时间(秒)")
  public List<Long> getAuthSyncTime() {
    return authSyncTime;
  }

  public void setAuthSyncTime(List<Long> authSyncTime) {
    this.authSyncTime = authSyncTime;
  }

  @JsonIgnore
  public GetInvoiceListRequest recogResponseTime(List<Long> recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
    return this;
  }

  public GetInvoiceListRequest addRecogResponseTimeItem(Long recogResponseTimeItem) {
    this.recogResponseTime.add(recogResponseTimeItem);
    return this;
  }

   /**
   * 识别完成时间(秒)
   * @return recogResponseTime
  **/
  @ApiModelProperty(value = "识别完成时间(秒)")
  public List<Long> getRecogResponseTime() {
    return recogResponseTime;
  }

  public void setRecogResponseTime(List<Long> recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
  }

  @JsonIgnore
  public GetInvoiceListRequest authRequestTime(List<Long> authRequestTime) {
    this.authRequestTime = authRequestTime;
    return this;
  }

  public GetInvoiceListRequest addAuthRequestTimeItem(Long authRequestTimeItem) {
    this.authRequestTime.add(authRequestTimeItem);
    return this;
  }

   /**
   * 认证发送时间(秒)
   * @return authRequestTime
  **/
  @ApiModelProperty(value = "认证发送时间(秒)")
  public List<Long> getAuthRequestTime() {
    return authRequestTime;
  }

  public void setAuthRequestTime(List<Long> authRequestTime) {
    this.authRequestTime = authRequestTime;
  }

  @JsonIgnore
  public GetInvoiceListRequest authBussiDate(List<String> authBussiDate) {
    this.authBussiDate = authBussiDate;
    return this;
  }

  public GetInvoiceListRequest addAuthBussiDateItem(String authBussiDateItem) {
    this.authBussiDate.add(authBussiDateItem);
    return this;
  }

   /**
   * 认证业务日期(年月日)
   * @return authBussiDate
  **/
  @ApiModelProperty(value = "认证业务日期(年月日)")
  public List<String> getAuthBussiDate() {
    return authBussiDate;
  }

  public void setAuthBussiDate(List<String> authBussiDate) {
    this.authBussiDate = authBussiDate;
  }

  @JsonIgnore
  public GetInvoiceListRequest authResponseTime(List<Long> authResponseTime) {
    this.authResponseTime = authResponseTime;
    return this;
  }

  public GetInvoiceListRequest addAuthResponseTimeItem(Long authResponseTimeItem) {
    this.authResponseTime.add(authResponseTimeItem);
    return this;
  }

   /**
   * 认证完成时间(秒)
   * @return authResponseTime
  **/
  @ApiModelProperty(value = "认证完成时间(秒)")
  public List<Long> getAuthResponseTime() {
    return authResponseTime;
  }

  public void setAuthResponseTime(List<Long> authResponseTime) {
    this.authResponseTime = authResponseTime;
  }

  @JsonIgnore
  public GetInvoiceListRequest authStyle(List<Integer> authStyle) {
    this.authStyle = authStyle;
    return this;
  }

  public GetInvoiceListRequest addAuthStyleItem(Integer authStyleItem) {
    this.authStyle.add(authStyleItem);
    return this;
  }

   /**
   * 抵扣方式：0-默认;10-底账抵扣；20-扫描抵扣;11-底账抵扣导入；21-扫描抵扣导入;12-国税底账抵扣；22-国税扫描抵扣
   * @return authStyle
  **/
  @ApiModelProperty(value = "抵扣方式：0-默认;10-底账抵扣；20-扫描抵扣;11-底账抵扣导入；21-扫描抵扣导入;12-国税底账抵扣；22-国税扫描抵扣")
  public List<Integer> getAuthStyle() {
    return authStyle;
  }

  public void setAuthStyle(List<Integer> authStyle) {
    this.authStyle = authStyle;
  }

  @JsonIgnore
  public GetInvoiceListRequest warnType(List<Integer> warnType) {
    this.warnType = warnType;
    return this;
  }

  public GetInvoiceListRequest addWarnTypeItem(Integer warnTypeItem) {
    this.warnType.add(warnTypeItem);
    return this;
  }

   /**
   * 预警类型
   * @return warnType
  **/
  @ApiModelProperty(value = "预警类型")
  public List<Integer> getWarnType() {
    return warnType;
  }

  public void setWarnType(List<Integer> warnType) {
    this.warnType = warnType;
  }

  @JsonIgnore
  public GetInvoiceListRequest retreatStatus(List<Integer> retreatStatus) {
    this.retreatStatus = retreatStatus;
    return this;
  }

  public GetInvoiceListRequest addRetreatStatusItem(Integer retreatStatusItem) {
    this.retreatStatus.add(retreatStatusItem);
    return this;
  }

   /**
   * 退票状态：0-未退(默认)；1-已退
   * @return retreatStatus
  **/
  @ApiModelProperty(value = "退票状态：0-未退(默认)；1-已退")
  public List<Integer> getRetreatStatus() {
    return retreatStatus;
  }

  public void setRetreatStatus(List<Integer> retreatStatus) {
    this.retreatStatus = retreatStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest signStatus(List<Integer> signStatus) {
    this.signStatus = signStatus;
    return this;
  }

  public GetInvoiceListRequest addSignStatusItem(Integer signStatusItem) {
    this.signStatus.add(signStatusItem);
    return this;
  }

   /**
   * 签收状态 ：0-默认 10-成功 20-失败
   * @return signStatus
  **/
  @ApiModelProperty(value = "签收状态 ：0-默认 10-成功 20-失败")
  public List<Integer> getSignStatus() {
    return signStatus;
  }

  public void setSignStatus(List<Integer> signStatus) {
    this.signStatus = signStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest recogStatus(List<Integer> recogStatus) {
    this.recogStatus = recogStatus;
    return this;
  }

  public GetInvoiceListRequest addRecogStatusItem(Integer recogStatusItem) {
    this.recogStatus.add(recogStatusItem);
    return this;
  }

   /**
   * 识别状态：0-未识别（默认）；1-已识别
   * @return recogStatus
  **/
  @ApiModelProperty(value = "识别状态：0-未识别（默认）；1-已识别")
  public List<Integer> getRecogStatus() {
    return recogStatus;
  }

  public void setRecogStatus(List<Integer> recogStatus) {
    this.recogStatus = recogStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest downloadType(Integer downloadType) {
    this.downloadType = downloadType;
    return this;
  }

   /**
   * 下载内容：0-发票主信息，1-发票主信息及明细
   * @return downloadType
  **/
  @ApiModelProperty(value = "下载内容：0-发票主信息，1-发票主信息及明细")
  public Integer getDownloadType() {
    return downloadType;
  }

  public void setDownloadType(Integer downloadType) {
    this.downloadType = downloadType;
  }

  @JsonIgnore
  public GetInvoiceListRequest signTime(List<Long> signTime) {
    this.signTime = signTime;
    return this;
  }

  public GetInvoiceListRequest addSignTimeItem(Long signTimeItem) {
    this.signTime.add(signTimeItem);
    return this;
  }

   /**
   * 签收时间
   * @return signTime
  **/
  @ApiModelProperty(value = "签收时间")
  public List<Long> getSignTime() {
    return signTime;
  }

  public void setSignTime(List<Long> signTime) {
    this.signTime = signTime;
  }

  @JsonIgnore
  public GetInvoiceListRequest authPurposes(List<Integer> authPurposes) {
    this.authPurposes = authPurposes;
    return this;
  }

  public GetInvoiceListRequest addAuthPurposesItem(Integer authPurposesItem) {
    this.authPurposes.add(authPurposesItem);
    return this;
  }

   /**
   * 抵扣用途：1-抵扣，2-不抵扣
   * @return authPurposes
  **/
  @ApiModelProperty(value = "抵扣用途：1-抵扣，2-不抵扣")
  public List<Integer> getAuthPurposes() {
    return authPurposes;
  }

  public void setAuthPurposes(List<Integer> authPurposes) {
    this.authPurposes = authPurposes;
  }

  @JsonIgnore
  public GetInvoiceListRequest ifSendException(List<Integer> ifSendException) {
    this.ifSendException = ifSendException;
    return this;
  }

  public GetInvoiceListRequest addIfSendExceptionItem(Integer ifSendExceptionItem) {
    this.ifSendException.add(ifSendExceptionItem);
    return this;
  }

   /**
   * 是否转交异常 0-否，1-是
   * @return ifSendException
  **/
  @ApiModelProperty(value = "是否转交异常 0-否，1-是")
  public List<Integer> getIfSendException() {
    return ifSendException;
  }

  public void setIfSendException(List<Integer> ifSendException) {
    this.ifSendException = ifSendException;
  }

  @JsonIgnore
  public GetInvoiceListRequest sellerSyncStatus(List<Integer> sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
    return this;
  }

  public GetInvoiceListRequest addSellerSyncStatusItem(Integer sellerSyncStatusItem) {
    this.sellerSyncStatus.add(sellerSyncStatusItem);
    return this;
  }

   /**
   * 销方开具状态：0-默认；1-无销方信息（非协同）；2-销方信息未到（协同）；3-销方信息已到（协同）
   * @return sellerSyncStatus
  **/
  @ApiModelProperty(value = "销方开具状态：0-默认；1-无销方信息（非协同）；2-销方信息未到（协同）；3-销方信息已到（协同）")
  public List<Integer> getSellerSyncStatus() {
    return sellerSyncStatus;
  }

  public void setSellerSyncStatus(List<Integer> sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
  }

  @JsonIgnore
  public GetInvoiceListRequest dataFromSystem(List<String> dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
    return this;
  }

  public GetInvoiceListRequest addDataFromSystemItem(String dataFromSystemItem) {
    this.dataFromSystem.add(dataFromSystemItem);
    return this;
  }

   /**
   * 系统来源(所属业务系统)
   * @return dataFromSystem
  **/
  @ApiModelProperty(value = "系统来源(所属业务系统)")
  public List<String> getDataFromSystem() {
    return dataFromSystem;
  }

  public void setDataFromSystem(List<String> dataFromSystem) {
    this.dataFromSystem = dataFromSystem;
  }

  @JsonIgnore
  public GetInvoiceListRequest authCheckResponseTime(List<Long> authCheckResponseTime) {
    this.authCheckResponseTime = authCheckResponseTime;
    return this;
  }

  public GetInvoiceListRequest addAuthCheckResponseTimeItem(Long authCheckResponseTimeItem) {
    this.authCheckResponseTime.add(authCheckResponseTimeItem);
    return this;
  }

   /**
   * 勾选完成时间(秒)
   * @return authCheckResponseTime
  **/
  @ApiModelProperty(value = "勾选完成时间(秒)")
  public List<Long> getAuthCheckResponseTime() {
    return authCheckResponseTime;
  }

  public void setAuthCheckResponseTime(List<Long> authCheckResponseTime) {
    this.authCheckResponseTime = authCheckResponseTime;
  }

  @JsonIgnore
  public GetInvoiceListRequest cooperateFlag(List<Integer> cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
    return this;
  }

  public GetInvoiceListRequest addCooperateFlagItem(Integer cooperateFlagItem) {
    this.cooperateFlag.add(cooperateFlagItem);
    return this;
  }

   /**
   * 是否协同 1.是 0.否
   * @return cooperateFlag
  **/
  @ApiModelProperty(value = "是否协同 1.是 0.否")
  public List<Integer> getCooperateFlag() {
    return cooperateFlag;
  }

  public void setCooperateFlag(List<Integer> cooperateFlag) {
    this.cooperateFlag = cooperateFlag;
  }

  @JsonIgnore
  public GetInvoiceListRequest authExceType(List<Integer> authExceType) {
    this.authExceType = authExceType;
    return this;
  }

  public GetInvoiceListRequest addAuthExceTypeItem(Integer authExceTypeItem) {
    this.authExceType.add(authExceTypeItem);
    return this;
  }

   /**
   * 勾选异常类型0-默认，1-网络超时，2-密码错误，3-其他
   * @return authExceType
  **/
  @ApiModelProperty(value = "勾选异常类型0-默认，1-网络超时，2-密码错误，3-其他")
  public List<Integer> getAuthExceType() {
    return authExceType;
  }

  public void setAuthExceType(List<Integer> authExceType) {
    this.authExceType = authExceType;
  }

  @JsonIgnore
  public GetInvoiceListRequest ifRepeat(Integer ifRepeat) {
    this.ifRepeat = ifRepeat;
    return this;
  }

   /**
   * 是否重复标识
   * @return ifRepeat
  **/
  @ApiModelProperty(value = "是否重复标识")
  public Integer getIfRepeat() {
    return ifRepeat;
  }

  public void setIfRepeat(Integer ifRepeat) {
    this.ifRepeat = ifRepeat;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetInvoiceListRequest getInvoiceListRequest = (GetInvoiceListRequest) o;
    return Objects.equals(this.sellerName, getInvoiceListRequest.sellerName) &&
        Objects.equals(this.purchaserName, getInvoiceListRequest.purchaserName) &&
        Objects.equals(this.sellerTaxNo, getInvoiceListRequest.sellerTaxNo) &&
        Objects.equals(this.purchaserTaxNo, getInvoiceListRequest.purchaserTaxNo) &&
        Objects.equals(this.invoiceCode, getInvoiceListRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, getInvoiceListRequest.invoiceNo) &&
        Objects.equals(this.salesbillNo, getInvoiceListRequest.salesbillNo) &&
        Objects.equals(this.recogUserName, getInvoiceListRequest.recogUserName) &&
        Objects.equals(this.authTaxPeriod, getInvoiceListRequest.authTaxPeriod) &&
        Objects.equals(this.paperDrewDate, getInvoiceListRequest.paperDrewDate) &&
        Objects.equals(this.amountWithoutTax, getInvoiceListRequest.amountWithoutTax) &&
        Objects.equals(this.taxAmount, getInvoiceListRequest.taxAmount) &&
        Objects.equals(this.amountWithTax, getInvoiceListRequest.amountWithTax) &&
        Objects.equals(this.invoiceType, getInvoiceListRequest.invoiceType) &&
        Objects.equals(this.status, getInvoiceListRequest.status) &&
        Objects.equals(this.auditStatus, getInvoiceListRequest.auditStatus) &&
        Objects.equals(this.authSyncStatus, getInvoiceListRequest.authSyncStatus) &&
        Objects.equals(this.recogImageStatus, getInvoiceListRequest.recogImageStatus) &&
        Objects.equals(this.authStatus, getInvoiceListRequest.authStatus) &&
        Objects.equals(this.ifAuthFlag, getInvoiceListRequest.ifAuthFlag) &&
        Objects.equals(this.isLegalSynergetics, getInvoiceListRequest.isLegalSynergetics) &&
        Objects.equals(this.veriStatus, getInvoiceListRequest.veriStatus) &&
        Objects.equals(this.auditUpdateTime, getInvoiceListRequest.auditUpdateTime) &&
        Objects.equals(this.authSyncTime, getInvoiceListRequest.authSyncTime) &&
        Objects.equals(this.recogResponseTime, getInvoiceListRequest.recogResponseTime) &&
        Objects.equals(this.authRequestTime, getInvoiceListRequest.authRequestTime) &&
        Objects.equals(this.authBussiDate, getInvoiceListRequest.authBussiDate) &&
        Objects.equals(this.authResponseTime, getInvoiceListRequest.authResponseTime) &&
        Objects.equals(this.authStyle, getInvoiceListRequest.authStyle) &&
        Objects.equals(this.warnType, getInvoiceListRequest.warnType) &&
        Objects.equals(this.retreatStatus, getInvoiceListRequest.retreatStatus) &&
        Objects.equals(this.signStatus, getInvoiceListRequest.signStatus) &&
        Objects.equals(this.recogStatus, getInvoiceListRequest.recogStatus) &&
        Objects.equals(this.downloadType, getInvoiceListRequest.downloadType) &&
        Objects.equals(this.signTime, getInvoiceListRequest.signTime) &&
        Objects.equals(this.authPurposes, getInvoiceListRequest.authPurposes) &&
        Objects.equals(this.ifSendException, getInvoiceListRequest.ifSendException) &&
        Objects.equals(this.sellerSyncStatus, getInvoiceListRequest.sellerSyncStatus) &&
        Objects.equals(this.dataFromSystem, getInvoiceListRequest.dataFromSystem) &&
        Objects.equals(this.authCheckResponseTime, getInvoiceListRequest.authCheckResponseTime) &&
        Objects.equals(this.cooperateFlag, getInvoiceListRequest.cooperateFlag) &&
        Objects.equals(this.authExceType, getInvoiceListRequest.authExceType) &&
        Objects.equals(this.ifRepeat, getInvoiceListRequest.ifRepeat) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerName, purchaserName, sellerTaxNo, purchaserTaxNo, invoiceCode, invoiceNo, salesbillNo, recogUserName, authTaxPeriod, paperDrewDate, amountWithoutTax, taxAmount, amountWithTax, invoiceType, status, auditStatus, authSyncStatus, recogImageStatus, authStatus, ifAuthFlag, isLegalSynergetics, veriStatus, auditUpdateTime, authSyncTime, recogResponseTime, authRequestTime, authBussiDate, authResponseTime, authStyle, warnType, retreatStatus, signStatus, recogStatus, downloadType, signTime, authPurposes, ifSendException, sellerSyncStatus, dataFromSystem, authCheckResponseTime, cooperateFlag, authExceType, ifRepeat, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetInvoiceListRequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    recogUserName: ").append(toIndentedString(recogUserName)).append("\n");
    sb.append("    authTaxPeriod: ").append(toIndentedString(authTaxPeriod)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    auditStatus: ").append(toIndentedString(auditStatus)).append("\n");
    sb.append("    authSyncStatus: ").append(toIndentedString(authSyncStatus)).append("\n");
    sb.append("    recogImageStatus: ").append(toIndentedString(recogImageStatus)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    ifAuthFlag: ").append(toIndentedString(ifAuthFlag)).append("\n");
    sb.append("    isLegalSynergetics: ").append(toIndentedString(isLegalSynergetics)).append("\n");
    sb.append("    veriStatus: ").append(toIndentedString(veriStatus)).append("\n");
    sb.append("    auditUpdateTime: ").append(toIndentedString(auditUpdateTime)).append("\n");
    sb.append("    authSyncTime: ").append(toIndentedString(authSyncTime)).append("\n");
    sb.append("    recogResponseTime: ").append(toIndentedString(recogResponseTime)).append("\n");
    sb.append("    authRequestTime: ").append(toIndentedString(authRequestTime)).append("\n");
    sb.append("    authBussiDate: ").append(toIndentedString(authBussiDate)).append("\n");
    sb.append("    authResponseTime: ").append(toIndentedString(authResponseTime)).append("\n");
    sb.append("    authStyle: ").append(toIndentedString(authStyle)).append("\n");
    sb.append("    warnType: ").append(toIndentedString(warnType)).append("\n");
    sb.append("    retreatStatus: ").append(toIndentedString(retreatStatus)).append("\n");
    sb.append("    signStatus: ").append(toIndentedString(signStatus)).append("\n");
    sb.append("    recogStatus: ").append(toIndentedString(recogStatus)).append("\n");
    sb.append("    downloadType: ").append(toIndentedString(downloadType)).append("\n");
    sb.append("    signTime: ").append(toIndentedString(signTime)).append("\n");
    sb.append("    authPurposes: ").append(toIndentedString(authPurposes)).append("\n");
    sb.append("    ifSendException: ").append(toIndentedString(ifSendException)).append("\n");
    sb.append("    sellerSyncStatus: ").append(toIndentedString(sellerSyncStatus)).append("\n");
    sb.append("    dataFromSystem: ").append(toIndentedString(dataFromSystem)).append("\n");
    sb.append("    authCheckResponseTime: ").append(toIndentedString(authCheckResponseTime)).append("\n");
    sb.append("    cooperateFlag: ").append(toIndentedString(cooperateFlag)).append("\n");
    sb.append("    authExceType: ").append(toIndentedString(authExceType)).append("\n");
    sb.append("    ifRepeat: ").append(toIndentedString(ifRepeat)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
